/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.job.AbstractJobProcessor;
import ch.javasoft.job.ExecJob;
import ch.javasoft.job.ExecJobMonitor;
import ch.javasoft.job.ExitValueException;
import ch.javasoft.job.JobResult;
import ch.javasoft.job.JobResultFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecJobProcessor
extends AbstractJobProcessor<ExecJobMonitor, Void, ExecJob> {
    public static final ExecJobProcessor INSTANCE = new ExecJobProcessor();

    public ExecJobMonitor exec(final ExecJob job) {
        ExecJobMonitor handle;
        try {
            handle = job.run();
        }
        catch (Throwable th) {
            return ExecJobMonitor.createForException(th);
        }
        new Thread(){

            public void run() {
                ExecJobProcessor.this.waitFor(handle, job);
            }
        }.start();
        return handle;
    }

    @Override
    public JobResult<Void> execAndWait(ExecJob job) throws InterruptedException {
        ExecJobMonitor hdl;
        try {
            hdl = job.run();
        }
        catch (Throwable th) {
            return JobResultFactory.createJobResultForException(th);
        }
        this.waitFor(hdl, job);
        return hdl.getJobResult();
    }

    private void waitFor(ExecJobMonitor handle, ExecJob job) {
        JobResult<Void> result;
        try {
            int exitValue = handle.getProcess().waitFor();
            if (exitValue != 0) {
                throw new ExitValueException(handle, exitValue);
            }
            result = JobResultFactory.createJobResult(null);
        }
        catch (Throwable th) {
            result = JobResultFactory.createJobResultForException(th);
        }
        handle.setResult(result);
        if (result.isException()) {
            this.invokeTerminationExceptionHandlers(job, result.getException());
        } else {
            this.invokeTerminationHandlers(job, result.getResult());
        }
    }
}

