/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase;

import ch.javasoft.jbase.RandomAccessFilePersistor;
import ch.javasoft.jbase.RandomAccessPersister;
import ch.javasoft.jbase.util.AbstractDataInput;
import ch.javasoft.jbase.util.AbstractDataOutput;
import ch.javasoft.jbase.util.UnsupportedOperationException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedRandomAccessPersister
implements RandomAccessPersister {
    private final RandomAccessPersister delegate;
    private final int tableSize;
    private final int entrySize;
    private final DataInput dataInput;
    private final DataOutput dataOutput;
    private final ReadWriteLock lock;
    private final AtomicReferenceArray<TableEntry> cache;
    private final ThreadLocal<long[]> pos = new ThreadLocal<long[]>(){

        @Override
        protected long[] initialValue() {
            return new long[1];
        }
    };

    public BufferedRandomAccessPersister(File file, int tableSize, int entrySize) throws FileNotFoundException {
        this(new RandomAccessFilePersistor(file), tableSize, entrySize);
    }

    public BufferedRandomAccessPersister(RandomAccessPersister delegate, int tableSize, int entrySize) {
        this(delegate, tableSize, entrySize, false, new AtomicReferenceArray<TableEntry>(tableSize), new ReentrantReadWriteLock());
    }

    private BufferedRandomAccessPersister(RandomAccessPersister delegate, int tableSize, int entrySize, boolean readCopy, AtomicReferenceArray<TableEntry> cache, ReadWriteLock lock) {
        if (delegate == null) {
            throw new NullPointerException("delegate cannot be null");
        }
        if (tableSize <= 0) {
            throw new IllegalArgumentException("table size must be positive: " + tableSize);
        }
        if (entrySize <= 0) {
            throw new IllegalArgumentException("entry size must be positive: " + entrySize);
        }
        this.delegate = delegate;
        this.tableSize = tableSize;
        this.entrySize = entrySize;
        this.cache = cache;
        this.dataInput = new BufferedDataInput();
        this.dataOutput = readCopy ? null : new BufferedDataOutput();
        this.lock = lock;
    }

    @Override
    public DataInput getInput() throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        return this.dataInput;
    }

    @Override
    public DataOutput getOutput() throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        return this.dataOutput;
    }

    @Override
    public long getPosition() throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        return this.pos.get()[0];
    }

    @Override
    public void setPosition(long bytePos) throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        this.pos.get()[0] = bytePos;
    }

    @Override
    public void setLength(long byteLength) throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        this.lock.writeLock().lock();
        try {
            int i = 0;
            while (i < this.cache.length()) {
                TableEntry e = this.cache.get(i);
                if (e != null) {
                    if (e.start >= byteLength) {
                        this.cache.set(i, null);
                    } else {
                        long newlen = byteLength - e.start;
                        if (newlen < (long)e.length) {
                            e.length = (int)newlen;
                            e.dirty = true;
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.delegate.setLength(byteLength);
    }

    @Override
    public void flush() throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        this.lock.readLock().lock();
        try {
            int i = 0;
            while (i < this.cache.length()) {
                TableEntry e = this.cache.get(i);
                if (e != null && e.dirty) {
                    this.flushDirtyEntry(this.delegate, e);
                }
                ++i;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.delegate.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushDirtyEntry(RandomAccessPersister delegate, TableEntry entry) throws IOException {
        RandomAccessPersister randomAccessPersister = delegate;
        synchronized (randomAccessPersister) {
            if (entry.dirty) {
                delegate.setPosition(entry.start);
                delegate.getOutput().write(entry.buffer, 0, entry.length);
                entry.dirty = false;
            }
        }
    }

    @Override
    public void close(boolean erase) throws IOException {
        if (erase && this.dataOutput == null) {
            throw new UnsupportedOperationException("unmodifyable read copy");
        }
        if (this.pos.get() != null) {
            this.pos.set(null);
            this.lock.readLock().lock();
            try {
                int i = 0;
                while (i < this.cache.length()) {
                    TableEntry e = this.dataOutput != null ? (TableEntry)this.cache.getAndSet(i, null) : this.cache.get(i);
                    if (e != null && e.dirty) {
                        this.flushDirtyEntry(this.delegate, e);
                    }
                    ++i;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.delegate.close(erase);
        }
    }

    @Override
    public RandomAccessPersister createReadCopy(ReadWriteLock lock) throws IOException {
        this.flush();
        BufferedRandomAccessPersister copy = new BufferedRandomAccessPersister(this.delegate.createReadCopy(lock), this.tableSize, this.entrySize, true, this.cache, this.lock){

            public DataOutput getOutput() throws IOException {
                throw new UnsupportedOperationException("read only copy, data output not supported");
            }

            public void setLength(long byteLength) throws IOException {
                throw new UnsupportedOperationException("read only copy, setting length not supported");
            }

            public void flush() throws IOException {
                throw new UnsupportedOperationException("read only copy, flush not supported");
            }

            protected void flushDirtyEntry(RandomAccessPersister copyDelegate, TableEntry entry) throws IOException {
                super.flushDirtyEntry(BufferedRandomAccessPersister.this.delegate, entry);
            }
        };
        copy.setPosition(this.getPosition());
        return copy;
    }

    /*
     * Unable to fully structure code
     */
    private TableEntry loadEntry(long start, int tInd, boolean forWrite) throws IOException {
        block6: {
            e = new TableEntry(start, this.entrySize);
            this.delegate.setPosition(start);
            try {
                this.delegate.getInput().readFully(e.buffer);
                break block6;
            }
            catch (EOFException ex) {
                this.delegate.setPosition(start);
                i = 0;
                ** while (i < this.entrySize)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    e.buffer[i] = this.delegate.getInput().readByte();
                }
                catch (EOFException ex2) {
                    e.length = i;
                    break;
                }
                ++i;
                continue;
            }
        }
        if ((e.length > 0 || forWrite) && (old = this.cache.getAndSet(tInd, e)) != null && old.dirty) {
            this.flushDirtyEntry(this.delegate, old);
        }
        return e;
    }

    private TableEntry getEntryForRead() throws IOException {
        long index = this.pos.get()[0] / (long)this.entrySize;
        long start = index * (long)this.entrySize;
        int tInd = BufferedRandomAccessPersister.hash(index) % this.tableSize;
        TableEntry e = this.cache.get(tInd);
        if (e != null && e.start == start) {
            return e;
        }
        return this.loadEntry(start, tInd, false);
    }

    private TableEntry getEntryForWrite() throws IOException {
        long index = this.pos.get()[0] / (long)this.entrySize;
        long start = index * (long)this.entrySize;
        int tInd = BufferedRandomAccessPersister.hash(index) % this.tableSize;
        TableEntry e = this.cache.get(tInd);
        if (e != null && e.start == start) {
            return e;
        }
        return this.loadEntry(start, tInd, true);
    }

    private int read(boolean inc) throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        long[] apos = this.pos.get();
        int eInd = (int)(apos[0] % (long)this.entrySize);
        this.lock.readLock().lock();
        try {
            TableEntry e = this.getEntryForRead();
            if (eInd < e.length) {
                int v = 0xFF & e.buffer[eInd];
                if (inc) {
                    apos[0] = apos[0] + 1L;
                }
                int n = v;
                return n;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return -1;
    }

    private int read(byte[] buf, int off, int len) throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        long[] apos = this.pos.get();
        int eInd = (int)(apos[0] % (long)this.entrySize);
        this.lock.readLock().lock();
        try {
            TableEntry e = this.getEntryForRead();
            int count = Math.min(e.length - eInd, len);
            if (count > 0) {
                System.arraycopy(e.buffer, eInd, buf, off, count);
                apos[0] = apos[0] + (long)count;
                int n = count;
                return n;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return -1;
    }

    private void write(int b) throws IOException {
        block5: {
            if (this.pos.get() == null) {
                throw new IOException("persister already closed");
            }
            long[] apos = this.pos.get();
            int eInd = (int)(apos[0] % (long)this.entrySize);
            this.lock.writeLock().lock();
            try {
                TableEntry e = this.getEntryForWrite();
                if (eInd < e.buffer.length) {
                    e.buffer[eInd] = (byte)b;
                    e.dirty = true;
                    e.length = Math.max(e.length, eInd + 1);
                    apos[0] = apos[0] + 1L;
                    break block5;
                }
                throw new IOException("internal error, write after buffer length: " + eInd + " >= " + e.buffer.length);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private int write(byte[] buf, int off, int len) throws IOException {
        if (this.pos.get() == null) {
            throw new IOException("persister already closed");
        }
        long[] apos = this.pos.get();
        int eInd = (int)(apos[0] % (long)this.entrySize);
        this.lock.writeLock().lock();
        try {
            TableEntry e = this.getEntryForWrite();
            int count = Math.min(e.buffer.length - eInd, len);
            if (count > 0) {
                System.arraycopy(buf, off, e.buffer, eInd, count);
                e.dirty = true;
                e.length = Math.max(e.length, eInd + count);
                apos[0] = apos[0] + (long)count;
                int n = count;
                return n;
            }
            throw new IOException("internal error, write after buffer length: " + eInd + " >= " + e.buffer.length);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static int hash(long value) {
        int h = (int)(value ^ value >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    /* synthetic */ BufferedRandomAccessPersister(RandomAccessPersister randomAccessPersister, int n, int n2, boolean bl, AtomicReferenceArray atomicReferenceArray, ReadWriteLock readWriteLock, BufferedRandomAccessPersister bufferedRandomAccessPersister) {
        this(randomAccessPersister, n, n2, bl, atomicReferenceArray, readWriteLock);
    }

    private class BufferedDataInput
    extends AbstractDataInput {
        private BufferedDataInput() {
        }

        protected int peek() throws IOException {
            return BufferedRandomAccessPersister.this.read(false);
        }

        protected int read() throws IOException {
            return BufferedRandomAccessPersister.this.read(true);
        }

        protected int read(byte[] b, int off, int len) throws IOException {
            return BufferedRandomAccessPersister.this.read(b, off, len);
        }

        public int skipBytes(int n) throws IOException {
            int count = 0;
            while (count < n) {
                int b = this.read();
                if (b < 0) {
                    return count;
                }
                ++count;
            }
            return count;
        }
    }

    private class BufferedDataOutput
    extends AbstractDataOutput {
        private BufferedDataOutput() {
        }

        public void write(int b) throws IOException {
            BufferedRandomAccessPersister.this.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int count;
            int n = 0;
            do {
                if ((count = BufferedRandomAccessPersister.this.write(b, off + n, len - n)) >= 0) continue;
                throw new EOFException();
            } while ((n += count) < len);
        }
    }

    private static final class TableEntry {
        public final long start;
        public final byte[] buffer;
        public volatile int length;
        public volatile boolean dirty;

        public TableEntry(long start, int size) {
            this.start = start;
            this.buffer = new byte[size];
            this.length = size;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[" + this.start + ".." + (this.start + (long)this.length - 1L) + "={" + (this.length == 0 ? "" : String.valueOf(this.buffer[0]) + ".." + this.buffer[this.length - 1] + "}]");
        }
    }
}

