/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ReaderInputStream
extends InputStream {
    private static final byte[] EMPTY_BYTE_BUF = new byte[0];
    private final Reader mReader;
    private final String mCharsetName;
    private final char[] mCharBuf = this.allocateBuffer();
    private byte[] mByteBuf = EMPTY_BYTE_BUF;
    private int mByteBufIndex = 0;

    public ReaderInputStream(Reader reader) {
        this.mReader = reader;
        this.mCharsetName = null;
    }

    public ReaderInputStream(Reader reader, String charsetName) throws UnsupportedEncodingException {
        new String(EMPTY_BYTE_BUF, charsetName);
        this.mReader = reader;
        this.mCharsetName = charsetName;
    }

    public String getCharsetName() {
        return this.mCharsetName;
    }

    protected char[] allocateBuffer() {
        return new char[1024];
    }

    public int read() throws IOException {
        if (this.mByteBufIndex == -1) {
            return -1;
        }
        if (this.mByteBufIndex >= this.mByteBuf.length) {
            this.mByteBuf = this.fillBuffer();
            if (this.mByteBuf.length == 0) {
                this.mByteBufIndex = -1;
                return -1;
            }
            this.mByteBufIndex = 0;
        }
        return this.mByteBuf[this.mByteBufIndex++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.mByteBufIndex == -1) {
            return -1;
        }
        int got = 0;
        while (got < len) {
            if (this.mByteBufIndex >= this.mByteBuf.length) {
                this.mByteBuf = this.fillBuffer();
                if (this.mByteBuf.length == 0) {
                    this.mByteBufIndex = -1;
                    return got == 0 ? -1 : got;
                }
                this.mByteBufIndex = 0;
            }
            int now = Math.min(len - got, this.mByteBuf.length - this.mByteBufIndex);
            System.arraycopy(this.mByteBuf, this.mByteBufIndex, b, off + got, now);
            got += now;
            this.mByteBufIndex += now;
        }
        return got;
    }

    private byte[] fillBuffer() throws IOException {
        int chars = this.mReader.read(this.mCharBuf);
        if (chars == -1) {
            return EMPTY_BYTE_BUF;
        }
        String str = new String(this.mCharBuf, 0, chars);
        return this.mCharsetName == null ? str.getBytes() : str.getBytes(this.mCharsetName);
    }

    public void close() throws IOException {
        this.mReader.close();
    }
}

