/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.io;

import java.io.File;
import java.io.FileFilter;

public class FileEndingFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final String mDesc;
    private final String[] mEndings;
    private final boolean mHideSubdirs;

    public FileEndingFileFilter(String desc, String ... ending) {
        this(false, desc, ending);
    }

    public FileEndingFileFilter(boolean hideSubdirs, String desc, String ... endings) {
        if (desc == null || endings == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < endings.length) {
            if (endings[i] == null) {
                throw new NullPointerException();
            }
            ++i;
        }
        this.mDesc = desc;
        this.mEndings = endings;
        this.mHideSubdirs = hideSubdirs;
    }

    public boolean accept(File f) {
        if (!this.mHideSubdirs && f.isDirectory()) {
            return true;
        }
        int i = 0;
        while (i < this.mEndings.length) {
            if (f.getName().endsWith(this.mEndings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDescription() {
        return this.mDesc;
    }

    public String[] getEndings() {
        return this.mEndings;
    }

    public int hashCode() {
        return this.mEndings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileEndingFileFilter) {
            FileEndingFileFilter filter = (FileEndingFileFilter)obj;
            return this.mDesc.equals(filter.mDesc) && this.mEndings.equals(filter.mEndings);
        }
        return false;
    }
}

