/* kitty: C++ truth table library
 * Copyright (C) 2017-2018  EPFL
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*!
  \file kitty.hpp
  \brief Main header for kitty

  \author Mathias Soeken
*/

#pragma once

#include "static_truth_table.hpp"
#include "dynamic_truth_table.hpp"

#include "affine.hpp"
#include "algorithm.hpp"
#include "bit_operations.hpp"
#include "cnf.hpp"
#include "constructors.hpp"
#include "cube.hpp"
#include "esop.hpp"
#include "hash.hpp"
#include "implicant.hpp"
#include "isop.hpp"
#include "npn.hpp"
#include "operations.hpp"
#include "operators.hpp"
#include "permutation.hpp"
#include "print.hpp"
#include "properties.hpp"
#include "spectral.hpp"
#include "traits.hpp"

/*
         /\___/\
        (  o o  )
        /   *   \
        \__\_/__/
          /   \
         / ___ \
         \/___\/
*/
