/* kitty: C++ truth table library
 * Copyright (C) 2017-2018  EPFL
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*!
  \file linear_constants.hpp
  \brief Collects several constants for permutation and linear classification

  \author Mathias Soeken
*/

/*! \cond PRIVATE */
#pragma once

#include <cstdint>

namespace kitty
{

namespace detail
{
const uint64_t linear_masks[] = {0x4, 0x2, 0x4, 0x0, 0x2, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x2, 0x0, 0x4, 0x2, 0x0, 0x50, 0x0, 0xa, 0x0, 0x50, 0x0, 0x0, 0xa, 0x0, 0x50, 0x50, 0x0, 0x6, 0x0, 0x14, 0x0, 0x0, 0x6, 0x0, 0x14, 0x50, 0x0, 0xa, 0x12, 0x50, 0x0, 0x0, 0xa, 0x12, 0x50, 0x50, 0x30, 0x6, 0x0, 0x14, 0x0, 0x30, 0x6, 0x0, 0x14, 0x50, 0x30, 0xc, 0x12, 0x44, 0x0, 0x30, 0xc, 0x12, 0x44, 0x50, 0x30, 0xc, 0x22, 0x14, 0x0, 0x30, 0xc, 0x22, 0x14, 0x50, 0x0, 0xc, 0x12, 0x44, 0x0, 0x0, 0xc, 0x12, 0x44, 0x50, 0x0, 0xc, 0x22, 0x14, 0x0, 0x0, 0xc, 0x22, 0x14, 0x50, 0x0, 0x6, 0x30, 0x44, 0x0, 0x0, 0x6, 0x30, 0x44, 0x50, 0x0, 0xa, 0x30, 0x50, 0x0, 0x0, 0xa, 0x30, 0x50, 0x50, 0x30, 0x6, 0x30, 0x44, 0x0, 0x30, 0x6, 0x30, 0x44, 0x50, 0x0, 0xa, 0x22, 0x50, 0x0, 0x0, 0xa, 0x22, 0x50, 0x44, 0x30, 0x6, 0x12, 0x50, 0x0, 0x30, 0x6, 0x12, 0x50, 0x44, 0x0, 0x6, 0x12, 0x14, 0x0, 0x0, 0x6, 0x12, 0x14, 0x44, 0x30, 0x6, 0x12, 0x14, 0x0, 0x0, 0x6, 0x12, 0x50, 0x44, 0x0, 0x6, 0x12, 0x50, 0x0, 0x30, 0x6, 0x12, 0x14, 0x0, 0x30, 0xc, 0x30, 0x0, 0x0, 0x30, 0xc, 0x30, 0x44, 0x0, 0x30, 0xc, 0x30, 0x50, 0x0, 0x30, 0xc, 0x30, 0x14, 0x0, 0x30, 0x6, 0x12, 0x0, 0x0, 0x0, 0x6, 0x12, 0x44, 0x44, 0x30, 0x6, 0x12, 0x0, 0x44, 0x0, 0x6, 0x12, 0x44, 0x0, 0x0, 0xc, 0x30, 0x0, 0x0, 0x0, 0xc, 0x30, 0x44, 0x0, 0x0, 0xc, 0x30, 0x50, 0x0, 0x0, 0xc, 0x30, 0x14, 0x0, 0x0, 0x6, 0x12, 0x0, 0x0, 0x30, 0x6, 0x12, 0x44, 0x44, 0x30, 0x6, 0x12, 0x44, 0x44, 0x0, 0x6, 0x12, 0x0, 0x50, 0x0, 0xa, 0x12, 0x14, 0x0, 0x30, 0x6, 0x0, 0x50, 0x50, 0x30, 0x6, 0x0, 0x50, 0x0, 0x0, 0xa, 0x12, 0x14, 0x50, 0x0, 0xa, 0x0, 0x14, 0x0, 0x0, 0x6, 0x0, 0x50, 0x50, 0x0, 0x6, 0x0, 0x50, 0x0, 0x0, 0xa, 0x0, 0x14, 0x0, 0x30, 0xc, 0x12, 0x0, 0x50, 0x30, 0xc, 0x12, 0x0, 0x0, 0x30, 0xc, 0x22, 0x50, 0x50, 0x30, 0xc, 0x22, 0x50, 0x0, 0x30, 0x6, 0x30, 0x0, 0x50, 0x30, 0x6, 0x30, 0x0, 0x50, 0x0, 0xa, 0x22, 0x14, 0x0, 0x0, 0xa, 0x22, 0x14, 0x0, 0x0, 0x6, 0x30, 0x0, 0x50, 0x0, 0x6, 0x30, 0x0, 0x50, 0x0, 0xa, 0x30, 0x14, 0x0, 0x0, 0xa, 0x30, 0x14, 0x0, 0x0, 0xc, 0x12, 0x0, 0x50, 0x0, 0xc, 0x12, 0x0, 0x0, 0x0, 0xc, 0x22, 0x50, 0x50, 0x0, 0xc, 0x22, 0x50, 0x44, 0x0, 0x0, 0x22, 0x44, 0x0, 0x0, 0x0, 0x22, 0x44, 0x44, 0x0, 0x0, 0x12, 0x14, 0x0, 0x0, 0x0, 0x12, 0x14, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x0, 0x0, 0x0, 0x0, 0x50, 0x0, 0x0, 0x0, 0x0, 0x14, 0x0, 0x0, 0x0, 0x22, 0x0, 0x44, 0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0x0, 0x12, 0x50, 0x44, 0x0, 0x0, 0x12, 0x50, 0x44, 0x0, 0x0, 0x22, 0x14, 0x0, 0x0, 0x0, 0x12, 0x44, 0x44, 0x0, 0x0, 0x12, 0x44, 0x0, 0x0, 0x0, 0x22, 0x14, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x30, 0x44, 0x0, 0x0, 0x0, 0x30, 0x50, 0x0, 0x0, 0x0, 0x30, 0x14, 0x0, 0x0, 0x0, 0x12, 0x0, 0x44, 0x0, 0x0, 0x22, 0x50, 0x0, 0x0, 0x0, 0x22, 0x50, 0x44, 0x0, 0x0, 0x12, 0x0, 0x50, 0x0, 0xc, 0x12, 0x14, 0x0, 0x0, 0xc, 0x22, 0x44, 0x50, 0x0, 0xc, 0x22, 0x44, 0x0, 0x0, 0xc, 0x12, 0x14, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x44, 0x50, 0x0, 0xa, 0x0, 0x0, 0x50, 0x0, 0x6, 0x0, 0x44, 0x0, 0x0, 0xa, 0x22, 0x0, 0x50, 0x30, 0x6, 0x30, 0x14, 0x50, 0x0, 0xa, 0x22, 0x0, 0x0, 0x30, 0x6, 0x30, 0x14, 0x50, 0x30, 0xc, 0x12, 0x14, 0x0, 0x30, 0xc, 0x22, 0x44, 0x50, 0x30, 0xc, 0x22, 0x44, 0x0, 0x30, 0xc, 0x12, 0x14, 0x0, 0x0, 0xa, 0x30, 0x0, 0x50, 0x0, 0x6, 0x30, 0x14, 0x50, 0x0, 0xa, 0x30, 0x0, 0x0, 0x0, 0x6, 0x30, 0x14, 0x0, 0x0, 0xa, 0x12, 0x0, 0x0, 0x30, 0x6, 0x0, 0x44, 0x50, 0x0, 0xa, 0x12, 0x0, 0x50, 0x30, 0x6, 0x0, 0x44, 0x44, 0x0, 0x6, 0x22, 0x44, 0x0, 0x0, 0x6, 0x22, 0x44, 0x44, 0x30, 0x6, 0x22, 0x50, 0x0, 0x30, 0x6, 0x22, 0x50, 0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x44, 0x0, 0x0, 0xc, 0x0, 0x50, 0x0, 0x0, 0xc, 0x0, 0x14, 0x0, 0x0, 0x6, 0x22, 0x0, 0x44, 0x0, 0x6, 0x22, 0x0, 0x44, 0x30, 0x6, 0x22, 0x14, 0x0, 0x30, 0x6, 0x22, 0x14, 0x0, 0x30, 0xc, 0x0, 0x0, 0x0, 0x30, 0xc, 0x0, 0x44, 0x0, 0x30, 0xc, 0x0, 0x50, 0x0, 0x30, 0xc, 0x0, 0x14, 0x0, 0x30, 0x6, 0x22, 0x0, 0x44, 0x0, 0x6, 0x22, 0x14, 0x44, 0x30, 0x6, 0x22, 0x0, 0x0, 0x0, 0x6, 0x22, 0x14, 0x44, 0x0, 0x6, 0x22, 0x50, 0x0, 0x30, 0x6, 0x22, 0x44, 0x44, 0x30, 0x6, 0x22, 0x44, 0x0, 0x0, 0x6, 0x22, 0x50, 0x50, 0x30, 0x6, 0x30, 0x50, 0x0, 0x0, 0xa, 0x22, 0x44, 0x50, 0x0, 0xa, 0x22, 0x44, 0x0, 0x30, 0x6, 0x30, 0x50, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0x44, 0x50, 0x0, 0xa, 0x0, 0x44, 0x50, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0xc, 0x22, 0x0, 0x50, 0x0, 0xc, 0x12, 0x50, 0x0, 0x0, 0xc, 0x12, 0x50, 0x50, 0x0, 0xc, 0x22, 0x0, 0x0, 0x30, 0xc, 0x22, 0x0, 0x50, 0x30, 0xc, 0x12, 0x50, 0x0, 0x30, 0xc, 0x12, 0x50, 0x50, 0x30, 0xc, 0x22, 0x0, 0x0, 0x30, 0x6, 0x0, 0x0, 0x0, 0x0, 0xa, 0x12, 0x44, 0x50, 0x0, 0xa, 0x12, 0x44, 0x50, 0x30, 0x6, 0x0, 0x0, 0x50, 0x0, 0x6, 0x30, 0x50, 0x0, 0x0, 0xa, 0x30, 0x44, 0x50, 0x0, 0xa, 0x30, 0x44, 0x0, 0x0, 0x6, 0x30, 0x50,
                                 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x4114, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x4114, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x906, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x4114, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x1414, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x4114, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x4114, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x606, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x1144, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x550, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x1144, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x550, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x1144, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x1144, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x0, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x330, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1122, 0x1414, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1122, 0x5050, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2112, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x4444, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x4444, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x0, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x1414, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x1414, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1122, 0x1414, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1122, 0x5050, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2112, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x4444, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x4444, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x1144, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x5500, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x4114, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3030, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3030, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3030, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x5500, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x4114, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2112, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x4114, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x5500, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x550, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x4114, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x550, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x1414, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x5050, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x0, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x550, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x1414, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3030, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3030, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3030, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x0, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x550, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x4114, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3030, 0x1414, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3030, 0x5050, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3030, 0x4444, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x1144, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1212, 0x4444, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3030, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1212, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2112, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2112, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1122, 0x0, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x330, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x4114, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x4114, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x0, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x0, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x0, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x0, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x0, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x906, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x0, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x0, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x0, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x4114, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x0, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x606, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x4114, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x4444, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x1414, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x1144, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x4444, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x4444, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x550, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3300, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3300, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3300, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3300, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3300, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3300, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3300, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3300, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x0, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x330, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x330, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x330, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x1414, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1122, 0x1414, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1122, 0x5050, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x0, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x5050, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x5500, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x550, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x5050, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x5500, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x4114, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x4444, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x1414, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x1144, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x4444, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x4444, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x550, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x330, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x330, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x330, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x330, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x330, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x330, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x330, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x330, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x0, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x1414, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3300, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3300, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3300, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x1414, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1122, 0x5050, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1122, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x0, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x5050, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x5500, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x550, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x5050, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x0, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x5050, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x5500, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x1414, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x1414, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x1414, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x1414, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x330, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0xf00, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x4114, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x4444, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x1414, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x1144, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x1414, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x5500, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x5500, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x0, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x0, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x0, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x0, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x0, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x0, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x0, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x0, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x0, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x5500, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3030, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3030, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3030, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3030, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3030, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x3030, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x1144, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x906, 0x1212, 0x5500, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x2222, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x4444, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x4444, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x0, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x5050, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x5500, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x550, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x4444, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x1414, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x5050, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x5500, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x4444, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x1414, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x1414, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x1414, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x1414, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0xf00, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x4114, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x4444, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x1414, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x1144, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x5500, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x5500, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x0, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3030, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3030, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3030, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3030, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3030, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3030, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3030, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x5500, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x0, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x0, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x0, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x0, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x0, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x1144, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x1212, 0x5500, 0x4444, 0x3030, 0x0, 0x96, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x2222, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x4444, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1212, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2222, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x30c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x3c, 0x30c, 0x2222, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3030, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x2112, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x30c, 0x1122, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x30c, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x0, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x5050, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x2112, 0x5500, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x30c, 0x1122, 0x550, 0x5050, 0x3030, 0xf00, 0x3c, 0x30c, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x2112, 0x1414, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x1122, 0x4444, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x906, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x0, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x1122, 0x5500, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x30c, 0x2112, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0x30c, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x1122, 0x1414, 0x5050, 0x3030, 0xf00, 0x96, 0x906, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x2112, 0x4444, 0x5050, 0x3030, 0x0, 0x96, 0x906, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x906, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x906, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x0, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x0, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x4114, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x1414, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x4114, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x1144, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x1414, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x4114, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x1144, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x1144, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x4114, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x4114, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x550, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x0, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x1414, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3300, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2112, 0x1414, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1122, 0x5050, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x0, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x0, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x0, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x550, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x0, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x1414, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x330, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1122, 0x5050, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2112, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x1414, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x4114, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x4114, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x0, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x5500, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x0, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x0, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x0, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x4114, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x4114, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x5500, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x0, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3300, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x4114, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x4114, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2222, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x0, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x0, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x0, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x0, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x1144, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x1414, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x550, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x4444, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x0, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x1414, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x4114, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x0, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x550, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x1414, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x4114, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x0, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x5500, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x4114, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x5500, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x0, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x4114, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2222, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2112, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1122, 0x1414, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2112, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x906, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x0, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x0, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x4114, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x1414, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x4114, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x1414, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x906, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x606, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x550, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x4114, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3030, 0x0, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3030, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3030, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3030, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3030, 0x550, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3030, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x5500, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x4114, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x330, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x330, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x330, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x1414, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x1414, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x1414, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x330, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x0, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x4114, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x1414, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x4114, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x1414, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x330, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x0, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x5500, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x0, 0x0, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x0, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x0, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x0, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x0, 0x550, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x4114, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x4114, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x5500, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x0, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3300, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3300, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3300, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x4114, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2222, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x906, 0x330, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x606, 0x330, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x0, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x4114, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x1414, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x4114, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x1414, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x550, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x4114, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x330, 0x0, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x330, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x330, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x5500, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x4114, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3030, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3030, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3030, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3030, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3030, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x3030, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x2112, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x1414, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x1414, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x1414, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x1144, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x0, 0xf00, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x4114, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x4114, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x1414, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x330, 0x4114, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x4444, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x0, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x5500, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3300, 0x0, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3300, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3300, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x4114, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x4114, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x5500, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x0, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x0, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x0, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x0, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x0, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x0, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x4114, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x1414, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x4444, 0x4444, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x0, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x0, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x906, 0x2222, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2222, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x0, 0x30c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x0, 0x30c, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x2222, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0xc0c, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0xc0c, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3300, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3030, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xc0c, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0x0, 0xc0c, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x0, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x1122, 0x5500, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x0, 0x30c, 0x2112, 0x550, 0x5050, 0x3030, 0x0, 0x0, 0x30c, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x1144, 0x5050, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0x0, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x2112, 0x4444, 0x5050, 0x3030, 0x0, 0x0, 0x906, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x0, 0x606, 0x330, 0x5050, 0x5050, 0x0, 0x0, 0x0, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x0, 0xa0a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x0, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x0, 0x906, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x4114, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x550, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x4114, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x4114, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x1414, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x4114, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x1414, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x550, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x4114, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x4114, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x4444, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x550, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x4114, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x330, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x5500, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x2112, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x5500, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x5500, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x0, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x5500, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x0, 0x1212, 0x5500, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x4444, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x1414, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x0, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x1414, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x550, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x4444, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x1144, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x5500, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x4114, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x330, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x330, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x330, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x5500, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x4114, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3030, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3030, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3030, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x330, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x2112, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x4444, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x0, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x330, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x550, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x5050, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x5050, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x1144, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x1144, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x5500, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x5500, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x0, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x5500, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3030, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3030, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3030, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3030, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x1212, 0x5500, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x2222, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x4444, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x330, 0x5500, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x550, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x2112, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x2112, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x550, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x1144, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x2112, 0x4444, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x1414, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x0, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x0, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x5500, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x5500, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x0, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x5500, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x1414, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x5500, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x0, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x0, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x0, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x5500, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x5500, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x0, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x0, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x5500, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x0, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x5500, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x0, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x550, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x550, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x906, 0x330, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x4114, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x4114, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x4444, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x1144, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x4114, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3030, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3030, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3030, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3030, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3030, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3030, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x4444, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x0, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3300, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3300, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3300, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3300, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3300, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3300, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3300, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x550, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x4114, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x606, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x5050, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x5500, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x0, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x5050, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x5500, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x550, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x1414, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x1414, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x4444, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x1414, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x1144, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x330, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x0, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x4114, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x4444, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x1414, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x1144, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x1144, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x0, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x0, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x0, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x0, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x0, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x0, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x0, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x1414, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x1144, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x330, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x330, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x330, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x330, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x330, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x330, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x330, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x330, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x1414, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x550, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x0, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x550, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x0, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x5050, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x5500, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x4114, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x0, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x5050, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x5500, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x550, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x4444, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x4114, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x4114, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x4114, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x1414, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x1414, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x1414, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x4444, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x1414, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x1144, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x330, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x0, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x0, 0x2112, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x4114, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x4444, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x1414, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x1144, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x1414, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x0, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x330, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x330, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x330, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x330, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x1414, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x1144, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x0, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x0, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x0, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x0, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x0, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x0, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x0, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x0, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x1414, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x5050, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x550, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x2112, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x4114, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x0, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x0, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x5050, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x5500, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x4114, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x4444, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x0, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x5050, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x5500, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x550, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x4114, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x4444, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x4114, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x606, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x4444, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x1414, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x1144, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x4444, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x1144, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x4114, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x4114, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x4444, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x1414, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x1144, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x4114, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3300, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3300, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3300, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3300, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x4444, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x0, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3030, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3030, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3030, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3030, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3030, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3030, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3030, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x4114, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x4444, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x550, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x4114, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x1144, 0x4444, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x5500, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x1414, 0x4444, 0x3030, 0xf00, 0x96, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x5050, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1212, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x330, 0x5500, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x606, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x0, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x0, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x5050, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x2222, 0x5500, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0xc0c, 0x1212, 0x550, 0x5050, 0x3030, 0x0, 0x3c, 0xc0c, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x0, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3300, 0x550, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x2112, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xc0c, 0x1122, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0xc0c, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x0, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x5050, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2112, 0x5500, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1122, 0x550, 0x5050, 0x3030, 0xf00, 0x3c, 0xc0c, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x0, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x3030, 0x550, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x5050, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xc0c, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0x3c, 0xc0c, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x1144, 0x0, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x5050, 0x5050, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x1122, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x606, 0x0, 0x5500, 0x5050, 0x3030, 0xf00, 0x96, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x606, 0x330, 0x5050, 0x5050, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x606, 0x330, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x606, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xa0a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x606, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x4114, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x4114, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x1414, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x4114, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x4114, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x4114, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x4114, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x1414, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x1414, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x1414, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x4114, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x5050, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x4114, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x1414, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x4114, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x4114, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x4114, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x4114, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x4114, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x4114, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x1414, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x4114, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x4114, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x4114, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x4114, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x1144, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x4444, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x1144, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x4444, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x4444, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x4444, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x1144, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x550, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3300, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x0, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x4444, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x550, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x4444, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x4114, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x606, 0x1212, 0x5500, 0x4444, 0x0, 0xf00, 0x96, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x0, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x1144, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x5500, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x5500, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x0, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x5500, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x0, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x0, 0x1212, 0x5500, 0x4444, 0x3300, 0x0, 0x96, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x2222, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x4114, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x4444, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x550, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x0, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x4444, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x550, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x4114, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x0, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x5500, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x4114, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x5500, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x0, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x0, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x0, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x4114, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x4114, 0x4444, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x4444, 0x4444, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0xf0, 0x906, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0xf0, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x2222, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x5050, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x0, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x4114, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x550, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x4114, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x0, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x0, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x5500, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3300, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3300, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x4114, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x4114, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x550, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3300, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x5500, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x0, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x0, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x0, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x0, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x4114, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x5500, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x1414, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x4114, 0x4444, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x4444, 0x4444, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x5050, 0x4444, 0x0, 0xf00, 0xf0, 0x906, 0x1122, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x1122, 0x1144, 0x4444, 0x3300, 0xf00, 0xf0, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x2222, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x0, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x4114, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x550, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x4114, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x4114, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x550, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x5500, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x0, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x0, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x0, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x5050, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x5500, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x0, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x5500, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x0, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x0, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x0, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x0, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x0, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x1144, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x4114, 0x4444, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x906, 0x1212, 0x5500, 0x4444, 0x3300, 0xf00, 0x96, 0x0, 0x2222, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x2222, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x4444, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x550, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x4114, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x1414, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x0, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x4114, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x4114, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x550, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x550, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x4114, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x4444, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x4114, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x550, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x4444, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x4114, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x0, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x4114, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x550, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3300, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3300, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3300, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x0, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x550, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x4444, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x0, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x4114, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x550, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x4114, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x0, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x4444, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x4114, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x550, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x4444, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x4114, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x1144, 0x4444, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x5050, 0x4444, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x5500, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x1414, 0x4444, 0x3300, 0x0, 0x66, 0xf00, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x1212, 0x5500, 0x4444, 0x0, 0x0, 0x96, 0xf00, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x1122, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x0, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x1144, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x1144, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x4114, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x0, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x5500, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x1414, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x4114, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x0, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x4114, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x5500, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x1414, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x4114, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x0, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x0, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x4114, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x1414, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x5500, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x1414, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x4114, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x0, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x4114, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x1144, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x4114, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x0, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x4114, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x0, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x4114, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x5500, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x1414, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x4114, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x1144, 0x5050, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x606, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x0, 0x5500, 0x5050, 0x0, 0xf00, 0x96, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x0, 0x1144, 0x5050, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x5050, 0x5050, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x30c, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x1122, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x30c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x1212, 0x1144, 0x5050, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x906, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x3300, 0x5500, 0x5050, 0x3300, 0x0, 0x96, 0x50a, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x3300, 0x550, 0x5050, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x4444, 0x5050, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x2222, 0x5500, 0x5050, 0x0, 0x0, 0x66, 0x50a, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x1212, 0x550, 0x5050, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x4444, 0x5050, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x5050, 0x5050, 0x0, 0x0, 0xcc, 0x906, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x3030, 0x1144, 0x5050, 0x0, 0x0, 0xcc, 0x50a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x3030, 0x550, 0x5050, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x4444, 0x5050, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x5050, 0x5050, 0x0, 0xf00, 0x3c, 0xa0a, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x2222, 0x1144, 0x5050, 0x3300, 0x0, 0x3c, 0x50a, 0x1122, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x1122, 0x550, 0x5050, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x4444, 0x5050, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x5050, 0x5050, 0x3300, 0x0, 0xcc, 0x906, 0x3030, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x3030, 0x1144, 0x5050, 0x3300, 0x0, 0xcc, 0x50a, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x3030, 0x550, 0x5050, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x4444, 0x5050, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x5050, 0x5050, 0x3300, 0xf00, 0x3c, 0xa0a, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x2222, 0x1144, 0x5050, 0x0, 0x0, 0x3c, 0x50a, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x1122, 0x550, 0x5050, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x3300, 0x5500, 0x5050, 0x0, 0x0, 0x96, 0x50a, 0x3300, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x3300, 0x550, 0x5050, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x4444, 0x5050, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0xc0c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x2222, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x50a, 0x1212, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x1212, 0x550, 0x5050, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x1414, 0x5050, 0x3300, 0xf00, 0x5a, 0x606, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x0, 0x5500, 0x5050, 0x3300, 0xf00, 0x96, 0xa0a, 0x0, 0x5050, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x0, 0x1144, 0x5050, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x5050, 0x5050, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x1414, 0x5050, 0x0, 0xf00, 0x5a, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x1122, 0x5500, 0x5050, 0x3300, 0x0, 0x66, 0x30c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x0, 0x1144, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3030, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1212, 0x550, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3030, 0x1414, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3030, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3300, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3300, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2112, 0x5050, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x330, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x0, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0xf00, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xc0c, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xc0c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xc0c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x606, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0xf00, 0x1212, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0xf00, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x5050, 0x5500, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x1122, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0xf00, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x606, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0x606, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xa0a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x606, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x5a, 0xf00, 0x330, 0x1144, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0x0, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x0, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x0, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x0, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x2112, 0x1414, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x0, 0x3300, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0x0, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0x0, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x66, 0x0, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x0, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x96, 0x0, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x0, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x0, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x0, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x5a, 0x0, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x0, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x550, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3030, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3030, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x0, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3030, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x550, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2112, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x550, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2222, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x0, 0x1414, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x0, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2222, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x330, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1122, 0x550, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1122, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2112, 0x5050, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x550, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3300, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3300, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x1122, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x1212, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0xc0c, 0x2112, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0x30c, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2112, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x1122, 0x4444, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x30c, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0xf0, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x550, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x1122, 0x5500, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0x0, 0xf0, 0xc0c, 0x2112, 0x550, 0x5500, 0x3300, 0x0, 0xf0, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x1144, 0x5500, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x5500, 0x0, 0x3300, 0x0, 0xf0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x2112, 0x4444, 0x5500, 0x3300, 0x0, 0xf0, 0x606, 0x0, 0x0, 0x5500, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x550, 0x0, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0xf0, 0x906, 0x330, 0x5050, 0x0, 0x0, 0x0, 0xf0, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0xf0, 0xa0a, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xf0, 0x606, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0xc0c, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x2222, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x2112, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0x30c, 0x1212, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3300, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3030, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x2222, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x3300, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x2222, 0x5500, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x2112, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x30c, 0x1212, 0x550, 0x5500, 0x0, 0xf00, 0xf0, 0x30c, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0xf0, 0xc0c, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x0, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0xf0, 0x906, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x1212, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0xf0, 0x606, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x550, 0x0, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x4444, 0x5500, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x5050, 0x5500, 0x0, 0xf00, 0xf0, 0x906, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0xf0, 0x50a, 0x330, 0x1144, 0x5500, 0x0, 0xf00, 0xf0, 0xa0a, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0xf0, 0x606, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x550, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x3300, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x3300, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x330, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x330, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x1122, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x2112, 0x5050, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x1122, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x550, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x2222, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x330, 0x550, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x2222, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x550, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x2112, 0x1414, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x330, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x330, 0x4444, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x1212, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x0, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x2112, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x1212, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x2222, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x1212, 0x550, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x550, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x1144, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x3030, 0x1414, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x0, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x0, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x330, 0x4444, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x330, 0x550, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2222, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x0, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x0, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x1212, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x0, 0x2112, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x0, 0x2222, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2222, 0x1414, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0x30c, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0x30c, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x30c, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x4444, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x3300, 0x1414, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0x906, 0x3300, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x0, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x550, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x5500, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x1212, 0x5050, 0x0, 0x3300, 0xf00, 0x3c, 0x0, 0x2112, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x0, 0x2222, 0x0, 0x0, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x1122, 0x1414, 0x5500, 0x3300, 0x0, 0x66, 0x906, 0x0, 0x5050, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x2112, 0x4444, 0x5500, 0x3300, 0xf00, 0x96, 0x0, 0x0, 0x0, 0x5500, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x550, 0x0, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x906, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x50a, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0x906, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x0, 0x330, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x0, 0x330, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x330, 0x5500, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1122, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x0, 0x1144, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x0, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x550, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x5050, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x2222, 0x5500, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x2112, 0x5050, 0x0, 0x3300, 0x0, 0x3c, 0xf00, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x3c, 0xf00, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x0, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2112, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3300, 0x550, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x0, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3030, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3030, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x0, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x550, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x2112, 0x5500, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x2222, 0x5050, 0x0, 0x0, 0x0, 0xcc, 0xf00, 0x1122, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x0, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x550, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x2112, 0x5500, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x2222, 0x5050, 0x0, 0x3300, 0x0, 0xcc, 0xf00, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0xf00, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x0, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x2112, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x2222, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x3030, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x0, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x3300, 0x1144, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x3300, 0x550, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x550, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x5050, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x2222, 0x5500, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x2112, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0xf00, 0x1212, 0x550, 0x5500, 0x0, 0x0, 0x3c, 0xf00, 0x1122, 0x0, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xf00, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0xf00, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x1212, 0x1144, 0x5500, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x1144, 0x0, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xf00, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xf00, 0x330, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xf00, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x5a, 0xf00, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x5050, 0x5500, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x66, 0xa0a, 0x330, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x1122, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x96, 0xa0a, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x330, 0x1144, 0x0, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x0, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0x5a, 0x906, 0x2112, 0x5050, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x96, 0x50a, 0x1122, 0x0, 0x0, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x5500, 0x0, 0x3300, 0x0, 0x3c, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x2112, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x3c, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0xc0c, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x66, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x0, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x5500, 0x0, 0x0, 0x0, 0xcc, 0xa0a, 0x2112, 0x5500, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x3300, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0xcc, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x0, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x1144, 0x5500, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x5500, 0x0, 0x3300, 0x0, 0xcc, 0xa0a, 0x2112, 0x5500, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x2112, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0xcc, 0x50a, 0x1212, 0x0, 0x0, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x2112, 0x1414, 0x5500, 0x3300, 0xf00, 0x5a, 0xc0c, 0x3030, 0x5050, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x1122, 0x4444, 0x5500, 0x3300, 0x0, 0x66, 0x50a, 0x3030, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0xa0a, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x3300, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x50a, 0x3300, 0x0, 0x0, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x0, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x5050, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x3030, 0x1414, 0x5500, 0x0, 0xf00, 0x5a, 0x906, 0x2112, 0x5050, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x3030, 0x4444, 0x5500, 0x0, 0x0, 0x96, 0x50a, 0x1122, 0x0, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x1144, 0x0, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x1212, 0x1414, 0x0, 0x3300, 0x0, 0x96, 0xa0a, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x5a, 0x606, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x1122, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x1144, 0x0, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x5050, 0x5500, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x330, 0x1414, 0x0, 0x0, 0x0, 0x66, 0xa0a, 0x330, 0x5500, 0x5500, 0x0, 0xf00, 0x5a, 0x30c, 0x330, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x330, 0x1144, 0x5500, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x1144, 0x0, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x30c, 0x0, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x30c, 0x0, 0x5500, 0x5500, 0x0, 0x0, 0x66, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0x0, 0x96, 0x30c, 0x0, 0x1144, 0x5500, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x1144, 0x0, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x5050, 0x5500, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x606, 0x1122, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x606, 0x1122, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xa0a, 0x1212, 0x5050, 0x0, 0x3030, 0xf00, 0x96, 0x30c, 0x1212, 0x1144, 0x5500, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x550, 0x0, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0xc0c, 0x3300, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x906, 0x2222, 0x5500, 0x5500, 0x3030, 0x0, 0x96, 0xc0c, 0x3300, 0x4444, 0x0, 0x3300, 0xf00, 0x96, 0x50a, 0x1212, 0x550, 0x5500, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x4444, 0x5500, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x906, 0x2222, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0xf00, 0x96, 0xc0c, 0x1212, 0x4444, 0x0, 0x3300, 0x0, 0x66, 0xc0c, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x4444, 0x5500, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x1144, 0x0, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x5050, 0x5500, 0x0, 0xf00, 0x3c, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0xf00, 0x3c, 0x906, 0x3030, 0x1144, 0x5500, 0x0, 0xf00, 0x3c, 0x606, 0x3030, 0x4444, 0x0, 0x0, 0xf00, 0x3c, 0x50a, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x4444, 0x5500, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x1144, 0x0, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x5050, 0x5500, 0x0, 0x0, 0xcc, 0x906, 0x2222, 0x5050, 0x0, 0x3030, 0x0, 0x3c, 0x906, 0x2222, 0x1144, 0x5500, 0x3030, 0x0, 0x3c, 0x606, 0x1122, 0x4444, 0x0, 0x0, 0x0, 0xcc, 0x606, 0x1122, 0x550, 0x5500, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x550, 0x0, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x4444, 0x5500, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x1144, 0x0, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x5050, 0x5500, 0x3300, 0x0, 0xcc, 0x906, 0x2222, 0x5050, 0x0, 0x3030, 0xf00, 0x3c, 0x906, 0x3030, 0x1144, 0x5500, 0x3030, 0xf00, 0x3c, 0x606, 0x3030, 0x4444, 0x0, 0x3300, 0x0, 0xcc, 0x606, 0x1122, 0x550, 0x5500, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x550, 0x0, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x4444, 0x5500, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x1144, 0x0, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x5050, 0x5500, 0x3300, 0xf00, 0x3c, 0xa0a, 0x3030, 0x5050, 0x0, 0x0, 0x0, 0x3c, 0x906, 0x2222, 0x1144, 0x5500, 0x0, 0x0, 0x3c, 0x606, 0x1122, 0x4444, 0x0, 0x3300, 0xf00, 0x3c, 0x50a, 0x3030, 0x550, 0x5500, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x550, 0x0, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0xc0c, 0x3300, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0xc0c, 0x3300, 0x5500, 0x5500, 0x0, 0x0, 0x96, 0xc0c, 0x3300, 0x4444, 0x0, 0x0, 0x0, 0x66, 0xc0c, 0x3300, 0x550, 0x5500, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x550, 0x0, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x4444, 0x5500, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x906, 0x2222, 0x1414, 0x0, 0x0, 0x0, 0x5a, 0x906, 0x2222, 0x5500, 0x5500, 0x3030, 0xf00, 0x96, 0xc0c, 0x1212, 0x4444, 0x0, 0x0, 0xf00, 0x96, 0x50a, 0x1212, 0x550, 0x5500, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x1144, 0x0, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x5500, 0x0, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x1414, 0x5500, 0x3030, 0x0, 0xaa, 0x30c, 0x0, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x606, 0x1122, 0x5500, 0x5500, 0x3300, 0xf00, 0x96, 0xa0a, 0x1212, 0x5050, 0x0, 0x3030, 0x0, 0x96, 0x30c, 0x0, 0x1144, 0x5500, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x1144, 0x0, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x5050, 0x5500, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x5500, 0x0, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x1414, 0x5500, 0x0, 0x0, 0xaa, 0x606, 0x1122, 0x1414, 0x0, 0x3300, 0x0, 0x5a, 0x30c, 0x0, 0x5500, 0x5500, 0x3300, 0x0, 0x66, 0x30c, 0x0, 0x5050, 0x0, 0x0, 0xf00, 0x96, 0x30c, 0x1212, 0x1144};

const unsigned masks_start[] = {0u, 18u, 858u};

const unsigned masks_end[] = {18u, 858u, 141978u};
} // namespace detail
} // namespace kitty
/*! \endcond */
