"""This file defines the default units for each element in the setting class."""


SETTINGS_UNITS_TBL = {
    "OffsetVoltage": "V",
    "TraceDelay": "FPGA_cycles",
    "FastPeaks": "counts",
    "RealTime": "FPGA_cycles",
    "LiveTime": "FPGA_cycles",
    "RunTime": "FPGA_cycles",
    "ExternDelayLen": "FPGA_cycles",
    "ModNum": "unknown",
    "ModCSRA": "bits",
    "ModCSRB": "bits",
    "ModFormat": "unknown",
    "RunTask": "unknown",
    "ControlTask": "unknown",
    "MaxEvents": "unknown",
    "CoincPattern": "unknown",
    "CoincWait": "unknown",
    "SynchWait": "bits",
    "InSynch": "bits",
    "Resume": "unknown",
    "SlowFilterRange": "unknown",
    "FastFilterRange": "unknown",
    "ChanNum": "unknown",
    "HostIO": "unknown",
    "UserIn": "unknown",
    "FastTrigBackplaneEna": "unknown",
    "CrateID": "unknown",
    "SlotID": "unknown",
    "ModID": "unknown",
    "TrigConfig": "bits",
    "U00": "unknown",
    "HostRunTimePreset": "unknown",
    "PowerUpInitDone": "flag",
    "ChanCSRa": "bits",
    "ChanCSRb": "bits",
    "GainDAC": "unknown",
    "OffsetDAC": "unknown",
    "DigGain": "unknown",
    "SlowLength": "slow_filter_cycles",
    "SlowGap": "slow_filter_cycles",
    "FastLength": "fast_filter_cycles",
    "FastGap": "fast_filter_cycles",
    "PeakSample": "slow_filter_cycles",
    "PeakSep": "FPGA_cycles",
    "CFDThresh": "CDF_filter_amplitude",
    "FastThresh": "fast_filter_amplitude",
    "ThreshWidth": "unknown",
    "PAFlength": "FPGA_cycles",
    "TriggerDelay": "FPGA_cycles",
    "ResetDelay": "unknown",
    "ChanTrigStretch": "FPGA_cycles",
    "TraceLength": "ADC_cycles",
    "Xwait": "unknown",
    "TrigOutLen": "unknown",
    "EnergyLow": "slow_filter_amplitude",
    "Log2Ebin": "unknown",
    "MultiplicityMaskL": "bits",
    "PSAoffset": "unknown",
    "PSAlength": "unknown",
    "Integrator": "unknown",
    "BLcut": "ADC_amplitude",
    "BaselinePercent": "unknown",
    "FtrigoutDelay": "unknown",
    "Log2Bweight": "unknown",
    "PreampTau": "us",
    "Xavg": "unknown",
    "MultiplicityMaskH": "bits",
    "FastTrigBackLen": "FPGA_cycles",
    "CFDDelay": "FPGA_cycles",
    "CFDScale": "unknown",
    "ExtTrigStretch": "FPGA_cycles",
    "VetoStretch": "FPGA_cycles",
    "ExternDelayLen": "FPGA_cycles",
    "QDCLen0": "unknown",  # FPGA or ADC cycles
    "QDCLen1": "unknown",
    "QDCLen2": "unknown",
    "QDCLen3": "unknown",
    "QDCLen4": "unknown",
    "QDCLen5": "unknown",
    "QDCLen6": "unknown",
    "QDCLen7": "unknown",
    "GSLTtime": "unknown",
    "NumEventsA": "unknown",
    "NumEventsB": "unknown",
    "DSPerror": "unknown",
    "SynchDone": "unknown",
    "BufHeadLen": "unknown",
    "EventHeadLen": "unknown",
    "ChanHeadLen": "unknown",
    "UserOut": "unknown",
    "AOutBuffer": "unknown",
    "LOutBuffer": "unknown",
    "AECorr": "unknown",
    "LECorr": "unknown",
    "HardwareID": "unknown",
    "HardVariant": "unknown",
    "FIFOLength": "unknown",
    "FippiID": "unknown",
    "FippiVariant": "unknown",
    "DSPrelease": "unknown",
    "DSPbuild": "unknown",
    "DSPVariant": "unknown",
    "U20": "unknown",
    "OverflowA": "unknown",
    "OverflowB": "unknown",
    "InSpecA": "unknown",
    "InSpecB": "unknown",
    "UnderflowA": "unknown",
    "UnderflowB": "unknown",
    "ChanEventsA": "unknown",
    "ChanEventsB": "unknown",
    "AutoTau": "unknown",
    "U30": "unknown",
}
