"""This file defines the binary layout of a setting file."""

SETTINGS_FILE_FORMAT = {
    "ModNum": (0, "<1L"),
    "ModCSRA": (4, "<1L"),
    "ModCSRB": (8, "<1L"),
    "ModFormat": (12, "<1L"),
    "RunTask": (16, "<1L"),
    "ControlTask": (20, "<1L"),
    "MaxEvents": (24, "<1L"),
    "CoincPattern": (28, "<1L"),
    "CoincWait": (32, "<1L"),
    "SynchWait": (36, "<1L"),
    "InSynch": (40, "<1L"),
    "Resume": (44, "<1L"),
    "SlowFilterRange": (48, "<1L"),
    "FastFilterRange": (52, "<1L"),
    "ChanNum": (56, "<1L"),
    "HostIO": (60, "<16L"),
    "UserIn": (124, "<16L"),
    "FastTrigBackplaneEna": (188, "<1L"),
    "CrateID": (192, "<1L"),
    "SlotID": (196, "<1L"),
    "ModID": (200, "<1L"),
    "TrigConfig": (204, "<4L"),
    "U00": (220, "<7L"),
    "HostRunTimePreset": (248, "<1f"),
    "PowerUpInitDone": (252, "<1L"),
    "ChanCSRa": (256, "<16L"),
    "ChanCSRb": (320, "<16L"),
    "GainDAC": (384, "<16L"),
    "OffsetDAC": (448, "<16L"),
    "DigGain": (512, "<16L"),
    "SlowLength": (576, "<16L"),
    "SlowGap": (640, "<16L"),
    "FastLength": (704, "<16L"),
    "FastGap": (768, "<16L"),
    "PeakSample": (832, "<16L"),
    "PeakSep": (896, "<16L"),
    "CFDThresh": (960, "<16L"),
    "FastThresh": (1024, "<16L"),
    "ThreshWidth": (1088, "<16L"),
    "PAFlength": (1152, "<16L"),
    "TriggerDelay": (1216, "<16L"),
    "ResetDelay": (1280, "<16L"),
    "ChanTrigStretch": (1344, "<16L"),
    "TraceLength": (1408, "<16L"),
    "Xwait": (1472, "<16L"),
    "TrigOutLen": (1536, "<16L"),
    "EnergyLow": (1600, "<16L"),
    "Log2Ebin": (1664, "<16L"),
    "MultiplicityMaskL": (1728, "<16L"),
    "PSAoffset": (1792, "<16L"),
    "PSAlength": (1856, "<16L"),
    "Integrator": (1920, "<16L"),
    "BLcut": (1984, "<16L"),
    "BaselinePercent": (2048, "<16L"),
    "FtrigoutDelay": (2112, "<16L"),
    "Log2Bweight": (2176, "<16L"),
    "PreampTau": (2240, "<16f"),
    "Xavg": (2304, "<16L"),
    "MultiplicityMaskH": (2368, "<16L"),
    "FastTrigBackLen": (2432, "<16L"),
    "CFDDelay": (2496, "<16L"),
    "CFDScale": (2560, "<16L"),
    "ExtTrigStretch": (2624, "<16L"),
    "VetoStretch": (2688, "<16L"),
    "ExternDelayLen": (2752, "<16L"),
    "QDCLen0": (2816, "<16L"),
    "QDCLen1": (2880, "<16L"),
    "QDCLen2": (2944, "<16L"),
    "QDCLen3": (3008, "<16L"),
    "QDCLen4": (3072, "<16L"),
    "QDCLen5": (3136, "<16L"),
    "QDCLen6": (3200, "<16L"),
    "QDCLen7": (3264, "<16L"),
    "RealTimeA": (3328, "<1L"),
    "RealTimeB": (3332, "<1L"),
    "RunTimeA": (3336, "<1L"),
    "RunTimeB": (3340, "<1L"),
    "GSLTtime": (3344, "<1L"),
    "NumEventsA": (3348, "<1L"),
    "NumEventsB": (3352, "<1L"),
    "DSPerror": (3356, "<1L"),
    "SynchDone": (3360, "<1L"),
    "BufHeadLen": (3364, "<1L"),
    "EventHeadLen": (3368, "<1L"),
    "ChanHeadLen": (3372, "<1L"),
    "UserOut": (3376, "<16L"),
    "AOutBuffer": (3440, "<1L"),
    "LOutBuffer": (3444, "<1L"),
    "AECorr": (3448, "<1L"),
    "LECorr": (3452, "<1L"),
    "HardwareID": (3456, "<1L"),
    "HardVariant": (3460, "<1L"),
    "FIFOLength": (3464, "<1L"),
    "FippiID": (3468, "<1L"),
    "FippiVariant": (3472, "<1L"),
    "DSPrelease": (3476, "<1L"),
    "DSPbuild": (3480, "<1L"),
    "DSPVariant": (3484, "<1L"),
    "U20": (3488, "<23L"),
    "LiveTimeA": (3580, "<16L"),
    "LiveTimeB": (3644, "<16L"),
    "FastPeaksA": (3708, "<16L"),
    "FastPeaksB": (3772, "<16L"),
    "OverflowA": (3836, "<16L"),
    "OverflowB": (3900, "<16L"),
    "InSpecA": (3964, "<16L"),
    "InSpecB": (4028, "<16L"),
    "UnderflowA": (4092, "<16L"),
    "UnderflowB": (4156, "<16L"),
    "ChanEventsA": (4220, "<16L"),
    "ChanEventsB": (4284, "<16L"),
    "AutoTau": (4348, "<16L"),
    "U30": (4412, "<16L"),
}
