# coding: utf-8

"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.26.124
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class PaymentV3(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'payment_id': 'str',
        'remote_id': 'str',
        'currency': 'str',
        'amount': 'int',
        'source_account_name': 'str',
        'payor_payment_id': 'str',
        'payment_memo': 'str',
        'payee': 'PayoutPayeeV3',
        'withdrawable': 'bool',
        'status': 'str',
        'transmission_type': 'TransmissionType',
        'remote_system_id': 'str',
        'payment_metadata': 'str'
    }

    attribute_map = {
        'payment_id': 'paymentId',
        'remote_id': 'remoteId',
        'currency': 'currency',
        'amount': 'amount',
        'source_account_name': 'sourceAccountName',
        'payor_payment_id': 'payorPaymentId',
        'payment_memo': 'paymentMemo',
        'payee': 'payee',
        'withdrawable': 'withdrawable',
        'status': 'status',
        'transmission_type': 'transmissionType',
        'remote_system_id': 'remoteSystemId',
        'payment_metadata': 'paymentMetadata'
    }

    def __init__(self, payment_id=None, remote_id=None, currency=None, amount=None, source_account_name=None, payor_payment_id=None, payment_memo=None, payee=None, withdrawable=None, status=None, transmission_type=None, remote_system_id=None, payment_metadata=None):  # noqa: E501
        """PaymentV3 - a model defined in OpenAPI"""  # noqa: E501

        self._payment_id = None
        self._remote_id = None
        self._currency = None
        self._amount = None
        self._source_account_name = None
        self._payor_payment_id = None
        self._payment_memo = None
        self._payee = None
        self._withdrawable = None
        self._status = None
        self._transmission_type = None
        self._remote_system_id = None
        self._payment_metadata = None
        self.discriminator = None

        self.payment_id = payment_id
        if remote_id is not None:
            self.remote_id = remote_id
        if currency is not None:
            self.currency = currency
        if amount is not None:
            self.amount = amount
        if source_account_name is not None:
            self.source_account_name = source_account_name
        if payor_payment_id is not None:
            self.payor_payment_id = payor_payment_id
        if payment_memo is not None:
            self.payment_memo = payment_memo
        if payee is not None:
            self.payee = payee
        if withdrawable is not None:
            self.withdrawable = withdrawable
        if status is not None:
            self.status = status
        if transmission_type is not None:
            self.transmission_type = transmission_type
        if remote_system_id is not None:
            self.remote_system_id = remote_system_id
        if payment_metadata is not None:
            self.payment_metadata = payment_metadata

    @property
    def payment_id(self):
        """Gets the payment_id of this PaymentV3.  # noqa: E501


        :return: The payment_id of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._payment_id

    @payment_id.setter
    def payment_id(self, payment_id):
        """Sets the payment_id of this PaymentV3.


        :param payment_id: The payment_id of this PaymentV3.  # noqa: E501
        :type: str
        """
        if payment_id is None:
            raise ValueError("Invalid value for `payment_id`, must not be `None`")  # noqa: E501

        self._payment_id = payment_id

    @property
    def remote_id(self):
        """Gets the remote_id of this PaymentV3.  # noqa: E501


        :return: The remote_id of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._remote_id

    @remote_id.setter
    def remote_id(self, remote_id):
        """Sets the remote_id of this PaymentV3.


        :param remote_id: The remote_id of this PaymentV3.  # noqa: E501
        :type: str
        """

        self._remote_id = remote_id

    @property
    def currency(self):
        """Gets the currency of this PaymentV3.  # noqa: E501


        :return: The currency of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this PaymentV3.


        :param currency: The currency of this PaymentV3.  # noqa: E501
        :type: str
        """
        if currency is not None and len(currency) > 3:
            raise ValueError("Invalid value for `currency`, length must be less than or equal to `3`")  # noqa: E501
        if currency is not None and len(currency) < 3:
            raise ValueError("Invalid value for `currency`, length must be greater than or equal to `3`")  # noqa: E501

        self._currency = currency

    @property
    def amount(self):
        """Gets the amount of this PaymentV3.  # noqa: E501


        :return: The amount of this PaymentV3.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this PaymentV3.


        :param amount: The amount of this PaymentV3.  # noqa: E501
        :type: int
        """

        self._amount = amount

    @property
    def source_account_name(self):
        """Gets the source_account_name of this PaymentV3.  # noqa: E501


        :return: The source_account_name of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._source_account_name

    @source_account_name.setter
    def source_account_name(self, source_account_name):
        """Sets the source_account_name of this PaymentV3.


        :param source_account_name: The source_account_name of this PaymentV3.  # noqa: E501
        :type: str
        """

        self._source_account_name = source_account_name

    @property
    def payor_payment_id(self):
        """Gets the payor_payment_id of this PaymentV3.  # noqa: E501


        :return: The payor_payment_id of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._payor_payment_id

    @payor_payment_id.setter
    def payor_payment_id(self, payor_payment_id):
        """Sets the payor_payment_id of this PaymentV3.


        :param payor_payment_id: The payor_payment_id of this PaymentV3.  # noqa: E501
        :type: str
        """

        self._payor_payment_id = payor_payment_id

    @property
    def payment_memo(self):
        """Gets the payment_memo of this PaymentV3.  # noqa: E501


        :return: The payment_memo of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._payment_memo

    @payment_memo.setter
    def payment_memo(self, payment_memo):
        """Sets the payment_memo of this PaymentV3.


        :param payment_memo: The payment_memo of this PaymentV3.  # noqa: E501
        :type: str
        """

        self._payment_memo = payment_memo

    @property
    def payee(self):
        """Gets the payee of this PaymentV3.  # noqa: E501


        :return: The payee of this PaymentV3.  # noqa: E501
        :rtype: PayoutPayeeV3
        """
        return self._payee

    @payee.setter
    def payee(self, payee):
        """Sets the payee of this PaymentV3.


        :param payee: The payee of this PaymentV3.  # noqa: E501
        :type: PayoutPayeeV3
        """

        self._payee = payee

    @property
    def withdrawable(self):
        """Gets the withdrawable of this PaymentV3.  # noqa: E501


        :return: The withdrawable of this PaymentV3.  # noqa: E501
        :rtype: bool
        """
        return self._withdrawable

    @withdrawable.setter
    def withdrawable(self, withdrawable):
        """Sets the withdrawable of this PaymentV3.


        :param withdrawable: The withdrawable of this PaymentV3.  # noqa: E501
        :type: bool
        """

        self._withdrawable = withdrawable

    @property
    def status(self):
        """Gets the status of this PaymentV3.  # noqa: E501


        :return: The status of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PaymentV3.


        :param status: The status of this PaymentV3.  # noqa: E501
        :type: str
        """
        allowed_values = ["SUBMITTED", "ACCEPTED", "REJECTED", "WITHDRAWN", "RETURNED", "AWAITING_FUNDS", "FUNDED", "UNFUNDED", "CANCELLED", "REQUESTED"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def transmission_type(self):
        """Gets the transmission_type of this PaymentV3.  # noqa: E501


        :return: The transmission_type of this PaymentV3.  # noqa: E501
        :rtype: TransmissionType
        """
        return self._transmission_type

    @transmission_type.setter
    def transmission_type(self, transmission_type):
        """Sets the transmission_type of this PaymentV3.


        :param transmission_type: The transmission_type of this PaymentV3.  # noqa: E501
        :type: TransmissionType
        """

        self._transmission_type = transmission_type

    @property
    def remote_system_id(self):
        """Gets the remote_system_id of this PaymentV3.  # noqa: E501


        :return: The remote_system_id of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._remote_system_id

    @remote_system_id.setter
    def remote_system_id(self, remote_system_id):
        """Sets the remote_system_id of this PaymentV3.


        :param remote_system_id: The remote_system_id of this PaymentV3.  # noqa: E501
        :type: str
        """

        self._remote_system_id = remote_system_id

    @property
    def payment_metadata(self):
        """Gets the payment_metadata of this PaymentV3.  # noqa: E501


        :return: The payment_metadata of this PaymentV3.  # noqa: E501
        :rtype: str
        """
        return self._payment_metadata

    @payment_metadata.setter
    def payment_metadata(self, payment_metadata):
        """Sets the payment_metadata of this PaymentV3.


        :param payment_metadata: The payment_metadata of this PaymentV3.  # noqa: E501
        :type: str
        """

        self._payment_metadata = payment_metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentV3):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
