# coding: utf-8

"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.26.124
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class FundingAccountResponse2(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'payor_id': 'str',
        'account_name': 'str',
        'account_number': 'str',
        'routing_number': 'str',
        'name': 'str',
        'currency': 'str',
        'country': 'str',
        'type': 'str',
        'archived': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'payor_id': 'payorId',
        'account_name': 'accountName',
        'account_number': 'accountNumber',
        'routing_number': 'routingNumber',
        'name': 'name',
        'currency': 'currency',
        'country': 'country',
        'type': 'type',
        'archived': 'archived'
    }

    def __init__(self, id=None, payor_id=None, account_name=None, account_number=None, routing_number=None, name=None, currency=None, country=None, type=None, archived=None):  # noqa: E501
        """FundingAccountResponse2 - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._payor_id = None
        self._account_name = None
        self._account_number = None
        self._routing_number = None
        self._name = None
        self._currency = None
        self._country = None
        self._type = None
        self._archived = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if payor_id is not None:
            self.payor_id = payor_id
        if account_name is not None:
            self.account_name = account_name
        if account_number is not None:
            self.account_number = account_number
        if routing_number is not None:
            self.routing_number = routing_number
        if name is not None:
            self.name = name
        if currency is not None:
            self.currency = currency
        if country is not None:
            self.country = country
        if type is not None:
            self.type = type
        if archived is not None:
            self.archived = archived

    @property
    def id(self):
        """Gets the id of this FundingAccountResponse2.  # noqa: E501

        Funding Account Id  # noqa: E501

        :return: The id of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this FundingAccountResponse2.

        Funding Account Id  # noqa: E501

        :param id: The id of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def payor_id(self):
        """Gets the payor_id of this FundingAccountResponse2.  # noqa: E501


        :return: The payor_id of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._payor_id

    @payor_id.setter
    def payor_id(self, payor_id):
        """Sets the payor_id of this FundingAccountResponse2.


        :param payor_id: The payor_id of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """

        self._payor_id = payor_id

    @property
    def account_name(self):
        """Gets the account_name of this FundingAccountResponse2.  # noqa: E501

        name on the bank account  # noqa: E501

        :return: The account_name of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._account_name

    @account_name.setter
    def account_name(self, account_name):
        """Sets the account_name of this FundingAccountResponse2.

        name on the bank account  # noqa: E501

        :param account_name: The account_name of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """

        self._account_name = account_name

    @property
    def account_number(self):
        """Gets the account_number of this FundingAccountResponse2.  # noqa: E501

        bank account number  # noqa: E501

        :return: The account_number of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """Sets the account_number of this FundingAccountResponse2.

        bank account number  # noqa: E501

        :param account_number: The account_number of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """

        self._account_number = account_number

    @property
    def routing_number(self):
        """Gets the routing_number of this FundingAccountResponse2.  # noqa: E501

        bank account routing number  # noqa: E501

        :return: The routing_number of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._routing_number

    @routing_number.setter
    def routing_number(self, routing_number):
        """Sets the routing_number of this FundingAccountResponse2.

        bank account routing number  # noqa: E501

        :param routing_number: The routing_number of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """

        self._routing_number = routing_number

    @property
    def name(self):
        """Gets the name of this FundingAccountResponse2.  # noqa: E501

        name of funding account  # noqa: E501

        :return: The name of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FundingAccountResponse2.

        name of funding account  # noqa: E501

        :param name: The name of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def currency(self):
        """Gets the currency of this FundingAccountResponse2.  # noqa: E501

        ISO 4217 currency code  # noqa: E501

        :return: The currency of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this FundingAccountResponse2.

        ISO 4217 currency code  # noqa: E501

        :param currency: The currency of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """
        if currency is not None and len(currency) > 3:
            raise ValueError("Invalid value for `currency`, length must be less than or equal to `3`")  # noqa: E501
        if currency is not None and len(currency) < 3:
            raise ValueError("Invalid value for `currency`, length must be greater than or equal to `3`")  # noqa: E501

        self._currency = currency

    @property
    def country(self):
        """Gets the country of this FundingAccountResponse2.  # noqa: E501

        ISO 3166-1 2 letter country code (upper case)  # noqa: E501

        :return: The country of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this FundingAccountResponse2.

        ISO 3166-1 2 letter country code (upper case)  # noqa: E501

        :param country: The country of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """
        if country is not None and len(country) > 2:
            raise ValueError("Invalid value for `country`, length must be less than or equal to `2`")  # noqa: E501
        if country is not None and len(country) < 2:
            raise ValueError("Invalid value for `country`, length must be greater than or equal to `2`")  # noqa: E501

        self._country = country

    @property
    def type(self):
        """Gets the type of this FundingAccountResponse2.  # noqa: E501

        Funding account type  # noqa: E501

        :return: The type of this FundingAccountResponse2.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this FundingAccountResponse2.

        Funding account type  # noqa: E501

        :param type: The type of this FundingAccountResponse2.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def archived(self):
        """Gets the archived of this FundingAccountResponse2.  # noqa: E501

        A flag for whether the funding account has been archived.  Only present in the response if true.  # noqa: E501

        :return: The archived of this FundingAccountResponse2.  # noqa: E501
        :rtype: bool
        """
        return self._archived

    @archived.setter
    def archived(self, archived):
        """Sets the archived of this FundingAccountResponse2.

        A flag for whether the funding account has been archived.  Only present in the response if true.  # noqa: E501

        :param archived: The archived of this FundingAccountResponse2.  # noqa: E501
        :type: bool
        """

        self._archived = archived

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FundingAccountResponse2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
