# coding: utf-8

"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.26.124
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class AccessTokenResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'access_token': 'str',
        'token_type': 'str',
        'refresh_token': 'str',
        'expires_in': 'int',
        'scope': 'str',
        'user_info': 'UserInfo',
        'entity_ids': 'list[str]'
    }

    attribute_map = {
        'access_token': 'access_token',
        'token_type': 'token_type',
        'refresh_token': 'refresh_token',
        'expires_in': 'expires_in',
        'scope': 'scope',
        'user_info': 'user_info',
        'entity_ids': 'entityIds'
    }

    def __init__(self, access_token=None, token_type='bearer', refresh_token=None, expires_in=None, scope=None, user_info=None, entity_ids=None):  # noqa: E501
        """AccessTokenResponse - a model defined in OpenAPI"""  # noqa: E501

        self._access_token = None
        self._token_type = None
        self._refresh_token = None
        self._expires_in = None
        self._scope = None
        self._user_info = None
        self._entity_ids = None
        self.discriminator = None

        if access_token is not None:
            self.access_token = access_token
        if token_type is not None:
            self.token_type = token_type
        if refresh_token is not None:
            self.refresh_token = refresh_token
        if expires_in is not None:
            self.expires_in = expires_in
        if scope is not None:
            self.scope = scope
        if user_info is not None:
            self.user_info = user_info
        if entity_ids is not None:
            self.entity_ids = entity_ids

    @property
    def access_token(self):
        """Gets the access_token of this AccessTokenResponse.  # noqa: E501

        Bearer token used in headers to access secure endpoints   # noqa: E501

        :return: The access_token of this AccessTokenResponse.  # noqa: E501
        :rtype: str
        """
        return self._access_token

    @access_token.setter
    def access_token(self, access_token):
        """Sets the access_token of this AccessTokenResponse.

        Bearer token used in headers to access secure endpoints   # noqa: E501

        :param access_token: The access_token of this AccessTokenResponse.  # noqa: E501
        :type: str
        """

        self._access_token = access_token

    @property
    def token_type(self):
        """Gets the token_type of this AccessTokenResponse.  # noqa: E501

        the type of the token  # noqa: E501

        :return: The token_type of this AccessTokenResponse.  # noqa: E501
        :rtype: str
        """
        return self._token_type

    @token_type.setter
    def token_type(self, token_type):
        """Sets the token_type of this AccessTokenResponse.

        the type of the token  # noqa: E501

        :param token_type: The token_type of this AccessTokenResponse.  # noqa: E501
        :type: str
        """

        self._token_type = token_type

    @property
    def refresh_token(self):
        """Gets the refresh_token of this AccessTokenResponse.  # noqa: E501

        can be used to obtain a new access token  # noqa: E501

        :return: The refresh_token of this AccessTokenResponse.  # noqa: E501
        :rtype: str
        """
        return self._refresh_token

    @refresh_token.setter
    def refresh_token(self, refresh_token):
        """Sets the refresh_token of this AccessTokenResponse.

        can be used to obtain a new access token  # noqa: E501

        :param refresh_token: The refresh_token of this AccessTokenResponse.  # noqa: E501
        :type: str
        """

        self._refresh_token = refresh_token

    @property
    def expires_in(self):
        """Gets the expires_in of this AccessTokenResponse.  # noqa: E501

        The lifetime in seconds of the access token  # noqa: E501

        :return: The expires_in of this AccessTokenResponse.  # noqa: E501
        :rtype: int
        """
        return self._expires_in

    @expires_in.setter
    def expires_in(self, expires_in):
        """Sets the expires_in of this AccessTokenResponse.

        The lifetime in seconds of the access token  # noqa: E501

        :param expires_in: The expires_in of this AccessTokenResponse.  # noqa: E501
        :type: int
        """

        self._expires_in = expires_in

    @property
    def scope(self):
        """Gets the scope of this AccessTokenResponse.  # noqa: E501

        the scope of the access token  # noqa: E501

        :return: The scope of this AccessTokenResponse.  # noqa: E501
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this AccessTokenResponse.

        the scope of the access token  # noqa: E501

        :param scope: The scope of this AccessTokenResponse.  # noqa: E501
        :type: str
        """

        self._scope = scope

    @property
    def user_info(self):
        """Gets the user_info of this AccessTokenResponse.  # noqa: E501


        :return: The user_info of this AccessTokenResponse.  # noqa: E501
        :rtype: UserInfo
        """
        return self._user_info

    @user_info.setter
    def user_info(self, user_info):
        """Sets the user_info of this AccessTokenResponse.


        :param user_info: The user_info of this AccessTokenResponse.  # noqa: E501
        :type: UserInfo
        """

        self._user_info = user_info

    @property
    def entity_ids(self):
        """Gets the entity_ids of this AccessTokenResponse.  # noqa: E501

        If the user is a payee then the payeeId<P> If the user is a payor then the payorId   # noqa: E501

        :return: The entity_ids of this AccessTokenResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._entity_ids

    @entity_ids.setter
    def entity_ids(self, entity_ids):
        """Sets the entity_ids of this AccessTokenResponse.

        If the user is a payee then the payeeId<P> If the user is a payor then the payorId   # noqa: E501

        :param entity_ids: The entity_ids of this AccessTokenResponse.  # noqa: E501
        :type: list[str]
        """

        self._entity_ids = entity_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccessTokenResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
