# coding: utf-8

# flake8: noqa
"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.26.124
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

# import models into model package
from velo_payments.models.accepted_payment_v3 import AcceptedPaymentV3
from velo_payments.models.access_token_response import AccessTokenResponse
from velo_payments.models.access_token_validation_request import AccessTokenValidationRequest
from velo_payments.models.auth_response import AuthResponse
from velo_payments.models.auto_top_up_config import AutoTopUpConfig
from velo_payments.models.auto_top_up_config2 import AutoTopUpConfig2
from velo_payments.models.category import Category
from velo_payments.models.challenge import Challenge
from velo_payments.models.challenge2 import Challenge2
from velo_payments.models.company import Company
from velo_payments.models.company2 import Company2
from velo_payments.models.create_funding_account_request_v2 import CreateFundingAccountRequestV2
from velo_payments.models.create_individual import CreateIndividual
from velo_payments.models.create_individual2 import CreateIndividual2
from velo_payments.models.create_individual_name import CreateIndividualName
from velo_payments.models.create_payee import CreatePayee
from velo_payments.models.create_payee2 import CreatePayee2
from velo_payments.models.create_payee_address import CreatePayeeAddress
from velo_payments.models.create_payee_address2 import CreatePayeeAddress2
from velo_payments.models.create_payees_csv_request import CreatePayeesCSVRequest
from velo_payments.models.create_payees_csv_request2 import CreatePayeesCSVRequest2
from velo_payments.models.create_payees_csv_response import CreatePayeesCSVResponse
from velo_payments.models.create_payees_csv_response2 import CreatePayeesCSVResponse2
from velo_payments.models.create_payees_csv_response_rejected_csv_rows import CreatePayeesCSVResponseRejectedCsvRows
from velo_payments.models.create_payees_request import CreatePayeesRequest
from velo_payments.models.create_payees_request2 import CreatePayeesRequest2
from velo_payments.models.create_payment_channel import CreatePaymentChannel
from velo_payments.models.create_payment_channel2 import CreatePaymentChannel2
from velo_payments.models.create_payor_link_request import CreatePayorLinkRequest
from velo_payments.models.create_payout_request_v3 import CreatePayoutRequestV3
from velo_payments.models.create_webhook_request import CreateWebhookRequest
from velo_payments.models.debit_event import DebitEvent
from velo_payments.models.debit_event_all_of import DebitEventAllOf
from velo_payments.models.debit_status_changed import DebitStatusChanged
from velo_payments.models.debit_status_changed_all_of import DebitStatusChangedAllOf
from velo_payments.models.error import Error
from velo_payments.models.error_data import ErrorData
from velo_payments.models.error_response import ErrorResponse
from velo_payments.models.failed_payee import FailedPayee
from velo_payments.models.failed_payee2 import FailedPayee2
from velo_payments.models.failed_submission import FailedSubmission
from velo_payments.models.failed_submission2 import FailedSubmission2
from velo_payments.models.funding_account_response import FundingAccountResponse
from velo_payments.models.funding_account_response2 import FundingAccountResponse2
from velo_payments.models.funding_account_type import FundingAccountType
from velo_payments.models.funding_audit import FundingAudit
from velo_payments.models.funding_event import FundingEvent
from velo_payments.models.funding_event_type import FundingEventType
from velo_payments.models.funding_payor_status_audit_response import FundingPayorStatusAuditResponse
from velo_payments.models.funding_request_v1 import FundingRequestV1
from velo_payments.models.funding_request_v2 import FundingRequestV2
from velo_payments.models.funding_request_v3 import FundingRequestV3
from velo_payments.models.fx_summary import FxSummary
from velo_payments.models.fx_summary_v3 import FxSummaryV3
from velo_payments.models.get_fundings_response import GetFundingsResponse
from velo_payments.models.get_fundings_response_links import GetFundingsResponseLinks
from velo_payments.models.get_payee_list_response import GetPayeeListResponse
from velo_payments.models.get_payee_list_response2 import GetPayeeListResponse2
from velo_payments.models.get_payee_list_response_company import GetPayeeListResponseCompany
from velo_payments.models.get_payee_list_response_company2 import GetPayeeListResponseCompany2
from velo_payments.models.get_payee_list_response_individual import GetPayeeListResponseIndividual
from velo_payments.models.get_payee_list_response_individual2 import GetPayeeListResponseIndividual2
from velo_payments.models.get_payments_for_payout_response_v3 import GetPaymentsForPayoutResponseV3
from velo_payments.models.get_payments_for_payout_response_v3_page import GetPaymentsForPayoutResponseV3Page
from velo_payments.models.get_payments_for_payout_response_v3_summary import GetPaymentsForPayoutResponseV3Summary
from velo_payments.models.get_payments_for_payout_response_v4 import GetPaymentsForPayoutResponseV4
from velo_payments.models.get_payments_for_payout_response_v4_summary import GetPaymentsForPayoutResponseV4Summary
from velo_payments.models.get_payout_statistics import GetPayoutStatistics
from velo_payments.models.get_payouts_response import GetPayoutsResponse
from velo_payments.models.get_payouts_response_v3 import GetPayoutsResponseV3
from velo_payments.models.get_payouts_response_v3_links import GetPayoutsResponseV3Links
from velo_payments.models.get_payouts_response_v3_page import GetPayoutsResponseV3Page
from velo_payments.models.individual import Individual
from velo_payments.models.individual2 import Individual2
from velo_payments.models.individual_name import IndividualName
from velo_payments.models.inline_response400 import InlineResponse400
from velo_payments.models.inline_response401 import InlineResponse401
from velo_payments.models.inline_response403 import InlineResponse403
from velo_payments.models.inline_response404 import InlineResponse404
from velo_payments.models.inline_response409 import InlineResponse409
from velo_payments.models.inline_response412 import InlineResponse412
from velo_payments.models.invitation_status import InvitationStatus
from velo_payments.models.invitation_status2 import InvitationStatus2
from velo_payments.models.invite_payee_request import InvitePayeeRequest
from velo_payments.models.invite_payee_request2 import InvitePayeeRequest2
from velo_payments.models.invite_user_request import InviteUserRequest
from velo_payments.models.kyc_state import KycState
from velo_payments.models.link_for_response import LinkForResponse
from velo_payments.models.list_funding_accounts_response import ListFundingAccountsResponse
from velo_payments.models.list_funding_accounts_response2 import ListFundingAccountsResponse2
from velo_payments.models.list_payments_response_v3 import ListPaymentsResponseV3
from velo_payments.models.list_payments_response_v3_page import ListPaymentsResponseV3Page
from velo_payments.models.list_payments_response_v4 import ListPaymentsResponseV4
from velo_payments.models.list_source_account_response import ListSourceAccountResponse
from velo_payments.models.list_source_account_response_links import ListSourceAccountResponseLinks
from velo_payments.models.list_source_account_response_page import ListSourceAccountResponsePage
from velo_payments.models.list_source_account_response_v2 import ListSourceAccountResponseV2
from velo_payments.models.list_source_account_response_v2_links import ListSourceAccountResponseV2Links
from velo_payments.models.list_source_account_response_v3 import ListSourceAccountResponseV3
from velo_payments.models.list_source_account_response_v3_links import ListSourceAccountResponseV3Links
from velo_payments.models.localisation_details import LocalisationDetails
from velo_payments.models.mfa_details import MFADetails
from velo_payments.models.mfa_type import MFAType
from velo_payments.models.name import Name
from velo_payments.models.name2 import Name2
from velo_payments.models.notification import Notification
from velo_payments.models.notifications import Notifications
from velo_payments.models.notifications2 import Notifications2
from velo_payments.models.ofac_status import OfacStatus
from velo_payments.models.onboarded_status import OnboardedStatus
from velo_payments.models.onboarded_status2 import OnboardedStatus2
from velo_payments.models.onboarding_status_changed import OnboardingStatusChanged
from velo_payments.models.page_for_response import PageForResponse
from velo_payments.models.page_resource_funding_payor_status_audit_response_funding_payor_status_audit_response import PageResourceFundingPayorStatusAuditResponseFundingPayorStatusAuditResponse
from velo_payments.models.paged_payee_invitation_status_response import PagedPayeeInvitationStatusResponse
from velo_payments.models.paged_payee_invitation_status_response2 import PagedPayeeInvitationStatusResponse2
from velo_payments.models.paged_payee_invitation_status_response_page import PagedPayeeInvitationStatusResponsePage
from velo_payments.models.paged_payee_response import PagedPayeeResponse
from velo_payments.models.paged_payee_response2 import PagedPayeeResponse2
from velo_payments.models.paged_payee_response_links import PagedPayeeResponseLinks
from velo_payments.models.paged_payee_response_page import PagedPayeeResponsePage
from velo_payments.models.paged_payee_response_summary import PagedPayeeResponseSummary
from velo_payments.models.paged_payments_response_v3 import PagedPaymentsResponseV3
from velo_payments.models.paged_user_response import PagedUserResponse
from velo_payments.models.paged_user_response_links import PagedUserResponseLinks
from velo_payments.models.paged_user_response_page import PagedUserResponsePage
from velo_payments.models.password_request import PasswordRequest
from velo_payments.models.payable_issue import PayableIssue
from velo_payments.models.payable_issue2 import PayableIssue2
from velo_payments.models.payable_status_changed import PayableStatusChanged
from velo_payments.models.payee_address import PayeeAddress
from velo_payments.models.payee_address2 import PayeeAddress2
from velo_payments.models.payee_delta import PayeeDelta
from velo_payments.models.payee_delta2 import PayeeDelta2
from velo_payments.models.payee_delta_response import PayeeDeltaResponse
from velo_payments.models.payee_delta_response2 import PayeeDeltaResponse2
from velo_payments.models.payee_delta_response2_links import PayeeDeltaResponse2Links
from velo_payments.models.payee_delta_response_links import PayeeDeltaResponseLinks
from velo_payments.models.payee_delta_response_page import PayeeDeltaResponsePage
from velo_payments.models.payee_detail_response import PayeeDetailResponse
from velo_payments.models.payee_detail_response2 import PayeeDetailResponse2
from velo_payments.models.payee_details_changed import PayeeDetailsChanged
from velo_payments.models.payee_event import PayeeEvent
from velo_payments.models.payee_event_all_of import PayeeEventAllOf
from velo_payments.models.payee_event_all_of_reasons import PayeeEventAllOfReasons
from velo_payments.models.payee_invitation_status_response import PayeeInvitationStatusResponse
from velo_payments.models.payee_invitation_status_response2 import PayeeInvitationStatusResponse2
from velo_payments.models.payee_payor_ref import PayeePayorRef
from velo_payments.models.payee_payor_ref_v3 import PayeePayorRefV3
from velo_payments.models.payee_type import PayeeType
from velo_payments.models.payee_user_self_update_request import PayeeUserSelfUpdateRequest
from velo_payments.models.payment_audit_currency import PaymentAuditCurrency
from velo_payments.models.payment_audit_currency_v3 import PaymentAuditCurrencyV3
from velo_payments.models.payment_channel_country import PaymentChannelCountry
from velo_payments.models.payment_channel_rule import PaymentChannelRule
from velo_payments.models.payment_channel_rules_response import PaymentChannelRulesResponse
from velo_payments.models.payment_delta import PaymentDelta
from velo_payments.models.payment_delta_response import PaymentDeltaResponse
from velo_payments.models.payment_delta_response_v1 import PaymentDeltaResponseV1
from velo_payments.models.payment_delta_v1 import PaymentDeltaV1
from velo_payments.models.payment_event import PaymentEvent
from velo_payments.models.payment_event_all_of import PaymentEventAllOf
from velo_payments.models.payment_event_response import PaymentEventResponse
from velo_payments.models.payment_event_response_v3 import PaymentEventResponseV3
from velo_payments.models.payment_instruction_v3 import PaymentInstructionV3
from velo_payments.models.payment_rails import PaymentRails
from velo_payments.models.payment_rejected_or_returned import PaymentRejectedOrReturned
from velo_payments.models.payment_rejected_or_returned_all_of import PaymentRejectedOrReturnedAllOf
from velo_payments.models.payment_response_v3 import PaymentResponseV3
from velo_payments.models.payment_response_v4 import PaymentResponseV4
from velo_payments.models.payment_response_v4_payout import PaymentResponseV4Payout
from velo_payments.models.payment_status_changed import PaymentStatusChanged
from velo_payments.models.payment_status_changed_all_of import PaymentStatusChangedAllOf
from velo_payments.models.payment_v3 import PaymentV3
from velo_payments.models.payor_address import PayorAddress
from velo_payments.models.payor_address_v2 import PayorAddressV2
from velo_payments.models.payor_aml_transaction import PayorAmlTransaction
from velo_payments.models.payor_aml_transaction_v3 import PayorAmlTransactionV3
from velo_payments.models.payor_branding_response import PayorBrandingResponse
from velo_payments.models.payor_create_api_key_request import PayorCreateApiKeyRequest
from velo_payments.models.payor_create_api_key_response import PayorCreateApiKeyResponse
from velo_payments.models.payor_create_application_request import PayorCreateApplicationRequest
from velo_payments.models.payor_email_opt_out_request import PayorEmailOptOutRequest
from velo_payments.models.payor_links_response import PayorLinksResponse
from velo_payments.models.payor_links_response_links import PayorLinksResponseLinks
from velo_payments.models.payor_links_response_payors import PayorLinksResponsePayors
from velo_payments.models.payor_logo_request import PayorLogoRequest
from velo_payments.models.payor_v1 import PayorV1
from velo_payments.models.payor_v2 import PayorV2
from velo_payments.models.payout_company_v3 import PayoutCompanyV3
from velo_payments.models.payout_individual_v3 import PayoutIndividualV3
from velo_payments.models.payout_name_v3 import PayoutNameV3
from velo_payments.models.payout_payee_v3 import PayoutPayeeV3
from velo_payments.models.payout_payor import PayoutPayor
from velo_payments.models.payout_payor_ids import PayoutPayorIds
from velo_payments.models.payout_principal import PayoutPrincipal
from velo_payments.models.payout_status import PayoutStatus
from velo_payments.models.payout_status_v3 import PayoutStatusV3
from velo_payments.models.payout_summary_audit import PayoutSummaryAudit
from velo_payments.models.payout_summary_audit_v3 import PayoutSummaryAuditV3
from velo_payments.models.payout_summary_response_v3 import PayoutSummaryResponseV3
from velo_payments.models.payout_type import PayoutType
from velo_payments.models.ping import Ping
from velo_payments.models.query_batch_response import QueryBatchResponse
from velo_payments.models.query_batch_response2 import QueryBatchResponse2
from velo_payments.models.quote_fx_summary_v3 import QuoteFxSummaryV3
from velo_payments.models.quote_response_v3 import QuoteResponseV3
from velo_payments.models.region_v2 import RegionV2
from velo_payments.models.register_sms_request import RegisterSmsRequest
from velo_payments.models.rejected_payment_v3 import RejectedPaymentV3
from velo_payments.models.resend_token_request import ResendTokenRequest
from velo_payments.models.reset_password_request import ResetPasswordRequest
from velo_payments.models.role import Role
from velo_payments.models.role_update_request import RoleUpdateRequest
from velo_payments.models.self_mfa_type_unregister_request import SelfMFATypeUnregisterRequest
from velo_payments.models.self_update_password_request import SelfUpdatePasswordRequest
from velo_payments.models.set_notifications_request import SetNotificationsRequest
from velo_payments.models.source_account_response import SourceAccountResponse
from velo_payments.models.source_account_response_v2 import SourceAccountResponseV2
from velo_payments.models.source_account_response_v3 import SourceAccountResponseV3
from velo_payments.models.source_account_summary import SourceAccountSummary
from velo_payments.models.source_account_summary_v3 import SourceAccountSummaryV3
from velo_payments.models.source_account_type import SourceAccountType
from velo_payments.models.source_account_v3 import SourceAccountV3
from velo_payments.models.source_event import SourceEvent
from velo_payments.models.supported_countries_response import SupportedCountriesResponse
from velo_payments.models.supported_countries_response_v2 import SupportedCountriesResponseV2
from velo_payments.models.supported_country import SupportedCountry
from velo_payments.models.supported_country_v2 import SupportedCountryV2
from velo_payments.models.supported_currency_response_v2 import SupportedCurrencyResponseV2
from velo_payments.models.supported_currency_v2 import SupportedCurrencyV2
from velo_payments.models.transfer_request import TransferRequest
from velo_payments.models.transfer_request2 import TransferRequest2
from velo_payments.models.transmission_type import TransmissionType
from velo_payments.models.transmission_types import TransmissionTypes
from velo_payments.models.transmission_types2 import TransmissionTypes2
from velo_payments.models.unregister_mfa_request import UnregisterMFARequest
from velo_payments.models.update_payee_details_request import UpdatePayeeDetailsRequest
from velo_payments.models.update_payee_details_request2 import UpdatePayeeDetailsRequest2
from velo_payments.models.update_remote_id_request import UpdateRemoteIdRequest
from velo_payments.models.update_remote_id_request2 import UpdateRemoteIdRequest2
from velo_payments.models.update_webhook_request import UpdateWebhookRequest
from velo_payments.models.user_details_update_request import UserDetailsUpdateRequest
from velo_payments.models.user_info import UserInfo
from velo_payments.models.user_response import UserResponse
from velo_payments.models.user_status import UserStatus
from velo_payments.models.user_type import UserType
from velo_payments.models.user_type2 import UserType2
from velo_payments.models.validate_password_response import ValidatePasswordResponse
from velo_payments.models.watchlist_status import WatchlistStatus
from velo_payments.models.watchlist_status2 import WatchlistStatus2
from velo_payments.models.webhook_response import WebhookResponse
from velo_payments.models.webhooks_response import WebhooksResponse
from velo_payments.models.withdraw_payment_request import WithdrawPaymentRequest
