"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaybackKeyPair = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("@aws-cdk/core");
const ivs_generated_1 = require("./ivs.generated");
/**
 * Reference to a new or existing IVS Playback Key Pair
 */
class PlaybackKeyPairBase extends core.Resource {
}
/**
  A new IVS Playback Key Pair
*/
class PlaybackKeyPair extends PlaybackKeyPairBase {
    constructor(scope, id, props) {
        super(scope, id, {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ivs_PlaybackKeyPairProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PlaybackKeyPair);
            }
            throw error;
        }
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new ivs_generated_1.CfnPlaybackKeyPair(this, 'Resource', {
            publicKeyMaterial: props.publicKeyMaterial,
            name: props.name,
        });
        this.playbackKeyPairArn = resource.attrArn;
        this.playbackKeyPairFingerprint = resource.attrFingerprint;
    }
}
exports.PlaybackKeyPair = PlaybackKeyPair;
_a = JSII_RTTI_SYMBOL_1;
PlaybackKeyPair[_a] = { fqn: "@aws-cdk/aws-ivs.PlaybackKeyPair", version: "1.190.0" };
//# sourceMappingURL=data:application/json;base64,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