#include <stdio.h>

int error = 0;

void dbl(double x, unsigned long long bits)
{
  union { double d; unsigned long long i; } u;
  u.d = x;
  if (u.i != bits) {
    printf("Error: expected 0x%016llx, got 0x%016llx\n", bits, u.i);
    error = 1;
  }
}

void sng(float x, unsigned int bits)
{
  union { float f; unsigned int i; } u;
  u.f = x;
  if (u.i != bits) {
    printf("Error: expected 0x%08x, got 0x%08x\n", bits, u.i);
    error = 1;
  }
}

void testdbl(void)
{
  printf("--- Double-precision test\n");
  dbl(0.0, 0ULL);
  dbl((-0.0), 0x8000000000000000ULL);
  // The following are the "fmov immediate" of aarch64
  // They include +1.0 and -1.0
  dbl(0x1p-3, 0x3fc0000000000000ULL);
  dbl(0x1.1p-3, 0x3fc1000000000000ULL);
  dbl(0x1.2p-3, 0x3fc2000000000000ULL);
  dbl(0x1.3p-3, 0x3fc3000000000000ULL);
  dbl(0x1.4p-3, 0x3fc4000000000000ULL);
  dbl(0x1.5p-3, 0x3fc5000000000000ULL);
  dbl(0x1.6p-3, 0x3fc6000000000000ULL);
  dbl(0x1.7p-3, 0x3fc7000000000000ULL);
  dbl(0x1.8p-3, 0x3fc8000000000000ULL);
  dbl(0x1.9p-3, 0x3fc9000000000000ULL);
  dbl(0x1.ap-3, 0x3fca000000000000ULL);
  dbl(0x1.bp-3, 0x3fcb000000000000ULL);
  dbl(0x1.cp-3, 0x3fcc000000000000ULL);
  dbl(0x1.dp-3, 0x3fcd000000000000ULL);
  dbl(0x1.ep-3, 0x3fce000000000000ULL);
  dbl(0x1.fp-3, 0x3fcf000000000000ULL);
  dbl(0x1p-2, 0x3fd0000000000000ULL);
  dbl(0x1.1p-2, 0x3fd1000000000000ULL);
  dbl(0x1.2p-2, 0x3fd2000000000000ULL);
  dbl(0x1.3p-2, 0x3fd3000000000000ULL);
  dbl(0x1.4p-2, 0x3fd4000000000000ULL);
  dbl(0x1.5p-2, 0x3fd5000000000000ULL);
  dbl(0x1.6p-2, 0x3fd6000000000000ULL);
  dbl(0x1.7p-2, 0x3fd7000000000000ULL);
  dbl(0x1.8p-2, 0x3fd8000000000000ULL);
  dbl(0x1.9p-2, 0x3fd9000000000000ULL);
  dbl(0x1.ap-2, 0x3fda000000000000ULL);
  dbl(0x1.bp-2, 0x3fdb000000000000ULL);
  dbl(0x1.cp-2, 0x3fdc000000000000ULL);
  dbl(0x1.dp-2, 0x3fdd000000000000ULL);
  dbl(0x1.ep-2, 0x3fde000000000000ULL);
  dbl(0x1.fp-2, 0x3fdf000000000000ULL);
  dbl(0x1p-1, 0x3fe0000000000000ULL);
  dbl(0x1.1p-1, 0x3fe1000000000000ULL);
  dbl(0x1.2p-1, 0x3fe2000000000000ULL);
  dbl(0x1.3p-1, 0x3fe3000000000000ULL);
  dbl(0x1.4p-1, 0x3fe4000000000000ULL);
  dbl(0x1.5p-1, 0x3fe5000000000000ULL);
  dbl(0x1.6p-1, 0x3fe6000000000000ULL);
  dbl(0x1.7p-1, 0x3fe7000000000000ULL);
  dbl(0x1.8p-1, 0x3fe8000000000000ULL);
  dbl(0x1.9p-1, 0x3fe9000000000000ULL);
  dbl(0x1.ap-1, 0x3fea000000000000ULL);
  dbl(0x1.bp-1, 0x3feb000000000000ULL);
  dbl(0x1.cp-1, 0x3fec000000000000ULL);
  dbl(0x1.dp-1, 0x3fed000000000000ULL);
  dbl(0x1.ep-1, 0x3fee000000000000ULL);
  dbl(0x1.fp-1, 0x3fef000000000000ULL);
  dbl(0x1p+0, 0x3ff0000000000000ULL);
  dbl(0x1.1p+0, 0x3ff1000000000000ULL);
  dbl(0x1.2p+0, 0x3ff2000000000000ULL);
  dbl(0x1.3p+0, 0x3ff3000000000000ULL);
  dbl(0x1.4p+0, 0x3ff4000000000000ULL);
  dbl(0x1.5p+0, 0x3ff5000000000000ULL);
  dbl(0x1.6p+0, 0x3ff6000000000000ULL);
  dbl(0x1.7p+0, 0x3ff7000000000000ULL);
  dbl(0x1.8p+0, 0x3ff8000000000000ULL);
  dbl(0x1.9p+0, 0x3ff9000000000000ULL);
  dbl(0x1.ap+0, 0x3ffa000000000000ULL);
  dbl(0x1.bp+0, 0x3ffb000000000000ULL);
  dbl(0x1.cp+0, 0x3ffc000000000000ULL);
  dbl(0x1.dp+0, 0x3ffd000000000000ULL);
  dbl(0x1.ep+0, 0x3ffe000000000000ULL);
  dbl(0x1.fp+0, 0x3fff000000000000ULL);
  dbl(0x1p+1, 0x4000000000000000ULL);
  dbl(0x1.1p+1, 0x4001000000000000ULL);
  dbl(0x1.2p+1, 0x4002000000000000ULL);
  dbl(0x1.3p+1, 0x4003000000000000ULL);
  dbl(0x1.4p+1, 0x4004000000000000ULL);
  dbl(0x1.5p+1, 0x4005000000000000ULL);
  dbl(0x1.6p+1, 0x4006000000000000ULL);
  dbl(0x1.7p+1, 0x4007000000000000ULL);
  dbl(0x1.8p+1, 0x4008000000000000ULL);
  dbl(0x1.9p+1, 0x4009000000000000ULL);
  dbl(0x1.ap+1, 0x400a000000000000ULL);
  dbl(0x1.bp+1, 0x400b000000000000ULL);
  dbl(0x1.cp+1, 0x400c000000000000ULL);
  dbl(0x1.dp+1, 0x400d000000000000ULL);
  dbl(0x1.ep+1, 0x400e000000000000ULL);
  dbl(0x1.fp+1, 0x400f000000000000ULL);
  dbl(0x1p+2, 0x4010000000000000ULL);
  dbl(0x1.1p+2, 0x4011000000000000ULL);
  dbl(0x1.2p+2, 0x4012000000000000ULL);
  dbl(0x1.3p+2, 0x4013000000000000ULL);
  dbl(0x1.4p+2, 0x4014000000000000ULL);
  dbl(0x1.5p+2, 0x4015000000000000ULL);
  dbl(0x1.6p+2, 0x4016000000000000ULL);
  dbl(0x1.7p+2, 0x4017000000000000ULL);
  dbl(0x1.8p+2, 0x4018000000000000ULL);
  dbl(0x1.9p+2, 0x4019000000000000ULL);
  dbl(0x1.ap+2, 0x401a000000000000ULL);
  dbl(0x1.bp+2, 0x401b000000000000ULL);
  dbl(0x1.cp+2, 0x401c000000000000ULL);
  dbl(0x1.dp+2, 0x401d000000000000ULL);
  dbl(0x1.ep+2, 0x401e000000000000ULL);
  dbl(0x1.fp+2, 0x401f000000000000ULL);
  dbl(0x1p+3, 0x4020000000000000ULL);
  dbl(0x1.1p+3, 0x4021000000000000ULL);
  dbl(0x1.2p+3, 0x4022000000000000ULL);
  dbl(0x1.3p+3, 0x4023000000000000ULL);
  dbl(0x1.4p+3, 0x4024000000000000ULL);
  dbl(0x1.5p+3, 0x4025000000000000ULL);
  dbl(0x1.6p+3, 0x4026000000000000ULL);
  dbl(0x1.7p+3, 0x4027000000000000ULL);
  dbl(0x1.8p+3, 0x4028000000000000ULL);
  dbl(0x1.9p+3, 0x4029000000000000ULL);
  dbl(0x1.ap+3, 0x402a000000000000ULL);
  dbl(0x1.bp+3, 0x402b000000000000ULL);
  dbl(0x1.cp+3, 0x402c000000000000ULL);
  dbl(0x1.dp+3, 0x402d000000000000ULL);
  dbl(0x1.ep+3, 0x402e000000000000ULL);
  dbl(0x1.fp+3, 0x402f000000000000ULL);
  dbl(0x1p+4, 0x4030000000000000ULL);
  dbl(0x1.1p+4, 0x4031000000000000ULL);
  dbl(0x1.2p+4, 0x4032000000000000ULL);
  dbl(0x1.3p+4, 0x4033000000000000ULL);
  dbl(0x1.4p+4, 0x4034000000000000ULL);
  dbl(0x1.5p+4, 0x4035000000000000ULL);
  dbl(0x1.6p+4, 0x4036000000000000ULL);
  dbl(0x1.7p+4, 0x4037000000000000ULL);
  dbl(0x1.8p+4, 0x4038000000000000ULL);
  dbl(0x1.9p+4, 0x4039000000000000ULL);
  dbl(0x1.ap+4, 0x403a000000000000ULL);
  dbl(0x1.bp+4, 0x403b000000000000ULL);
  dbl(0x1.cp+4, 0x403c000000000000ULL);
  dbl(0x1.dp+4, 0x403d000000000000ULL);
  dbl(0x1.ep+4, 0x403e000000000000ULL);
  dbl(0x1.fp+4, 0x403f000000000000ULL);
  dbl((-0x1p-3), 0xbfc0000000000000ULL);
  dbl((-0x1.1p-3), 0xbfc1000000000000ULL);
  dbl((-0x1.2p-3), 0xbfc2000000000000ULL);
  dbl((-0x1.3p-3), 0xbfc3000000000000ULL);
  dbl((-0x1.4p-3), 0xbfc4000000000000ULL);
  dbl((-0x1.5p-3), 0xbfc5000000000000ULL);
  dbl((-0x1.6p-3), 0xbfc6000000000000ULL);
  dbl((-0x1.7p-3), 0xbfc7000000000000ULL);
  dbl((-0x1.8p-3), 0xbfc8000000000000ULL);
  dbl((-0x1.9p-3), 0xbfc9000000000000ULL);
  dbl((-0x1.ap-3), 0xbfca000000000000ULL);
  dbl((-0x1.bp-3), 0xbfcb000000000000ULL);
  dbl((-0x1.cp-3), 0xbfcc000000000000ULL);
  dbl((-0x1.dp-3), 0xbfcd000000000000ULL);
  dbl((-0x1.ep-3), 0xbfce000000000000ULL);
  dbl((-0x1.fp-3), 0xbfcf000000000000ULL);
  dbl((-0x1p-2), 0xbfd0000000000000ULL);
  dbl((-0x1.1p-2), 0xbfd1000000000000ULL);
  dbl((-0x1.2p-2), 0xbfd2000000000000ULL);
  dbl((-0x1.3p-2), 0xbfd3000000000000ULL);
  dbl((-0x1.4p-2), 0xbfd4000000000000ULL);
  dbl((-0x1.5p-2), 0xbfd5000000000000ULL);
  dbl((-0x1.6p-2), 0xbfd6000000000000ULL);
  dbl((-0x1.7p-2), 0xbfd7000000000000ULL);
  dbl((-0x1.8p-2), 0xbfd8000000000000ULL);
  dbl((-0x1.9p-2), 0xbfd9000000000000ULL);
  dbl((-0x1.ap-2), 0xbfda000000000000ULL);
  dbl((-0x1.bp-2), 0xbfdb000000000000ULL);
  dbl((-0x1.cp-2), 0xbfdc000000000000ULL);
  dbl((-0x1.dp-2), 0xbfdd000000000000ULL);
  dbl((-0x1.ep-2), 0xbfde000000000000ULL);
  dbl((-0x1.fp-2), 0xbfdf000000000000ULL);
  dbl((-0x1p-1), 0xbfe0000000000000ULL);
  dbl((-0x1.1p-1), 0xbfe1000000000000ULL);
  dbl((-0x1.2p-1), 0xbfe2000000000000ULL);
  dbl((-0x1.3p-1), 0xbfe3000000000000ULL);
  dbl((-0x1.4p-1), 0xbfe4000000000000ULL);
  dbl((-0x1.5p-1), 0xbfe5000000000000ULL);
  dbl((-0x1.6p-1), 0xbfe6000000000000ULL);
  dbl((-0x1.7p-1), 0xbfe7000000000000ULL);
  dbl((-0x1.8p-1), 0xbfe8000000000000ULL);
  dbl((-0x1.9p-1), 0xbfe9000000000000ULL);
  dbl((-0x1.ap-1), 0xbfea000000000000ULL);
  dbl((-0x1.bp-1), 0xbfeb000000000000ULL);
  dbl((-0x1.cp-1), 0xbfec000000000000ULL);
  dbl((-0x1.dp-1), 0xbfed000000000000ULL);
  dbl((-0x1.ep-1), 0xbfee000000000000ULL);
  dbl((-0x1.fp-1), 0xbfef000000000000ULL);
  dbl((-0x1p+0), 0xbff0000000000000ULL);
  dbl((-0x1.1p+0), 0xbff1000000000000ULL);
  dbl((-0x1.2p+0), 0xbff2000000000000ULL);
  dbl((-0x1.3p+0), 0xbff3000000000000ULL);
  dbl((-0x1.4p+0), 0xbff4000000000000ULL);
  dbl((-0x1.5p+0), 0xbff5000000000000ULL);
  dbl((-0x1.6p+0), 0xbff6000000000000ULL);
  dbl((-0x1.7p+0), 0xbff7000000000000ULL);
  dbl((-0x1.8p+0), 0xbff8000000000000ULL);
  dbl((-0x1.9p+0), 0xbff9000000000000ULL);
  dbl((-0x1.ap+0), 0xbffa000000000000ULL);
  dbl((-0x1.bp+0), 0xbffb000000000000ULL);
  dbl((-0x1.cp+0), 0xbffc000000000000ULL);
  dbl((-0x1.dp+0), 0xbffd000000000000ULL);
  dbl((-0x1.ep+0), 0xbffe000000000000ULL);
  dbl((-0x1.fp+0), 0xbfff000000000000ULL);
  dbl((-0x1p+1), 0xc000000000000000ULL);
  dbl((-0x1.1p+1), 0xc001000000000000ULL);
  dbl((-0x1.2p+1), 0xc002000000000000ULL);
  dbl((-0x1.3p+1), 0xc003000000000000ULL);
  dbl((-0x1.4p+1), 0xc004000000000000ULL);
  dbl((-0x1.5p+1), 0xc005000000000000ULL);
  dbl((-0x1.6p+1), 0xc006000000000000ULL);
  dbl((-0x1.7p+1), 0xc007000000000000ULL);
  dbl((-0x1.8p+1), 0xc008000000000000ULL);
  dbl((-0x1.9p+1), 0xc009000000000000ULL);
  dbl((-0x1.ap+1), 0xc00a000000000000ULL);
  dbl((-0x1.bp+1), 0xc00b000000000000ULL);
  dbl((-0x1.cp+1), 0xc00c000000000000ULL);
  dbl((-0x1.dp+1), 0xc00d000000000000ULL);
  dbl((-0x1.ep+1), 0xc00e000000000000ULL);
  dbl((-0x1.fp+1), 0xc00f000000000000ULL);
  dbl((-0x1p+2), 0xc010000000000000ULL);
  dbl((-0x1.1p+2), 0xc011000000000000ULL);
  dbl((-0x1.2p+2), 0xc012000000000000ULL);
  dbl((-0x1.3p+2), 0xc013000000000000ULL);
  dbl((-0x1.4p+2), 0xc014000000000000ULL);
  dbl((-0x1.5p+2), 0xc015000000000000ULL);
  dbl((-0x1.6p+2), 0xc016000000000000ULL);
  dbl((-0x1.7p+2), 0xc017000000000000ULL);
  dbl((-0x1.8p+2), 0xc018000000000000ULL);
  dbl((-0x1.9p+2), 0xc019000000000000ULL);
  dbl((-0x1.ap+2), 0xc01a000000000000ULL);
  dbl((-0x1.bp+2), 0xc01b000000000000ULL);
  dbl((-0x1.cp+2), 0xc01c000000000000ULL);
  dbl((-0x1.dp+2), 0xc01d000000000000ULL);
  dbl((-0x1.ep+2), 0xc01e000000000000ULL);
  dbl((-0x1.fp+2), 0xc01f000000000000ULL);
  dbl((-0x1p+3), 0xc020000000000000ULL);
  dbl((-0x1.1p+3), 0xc021000000000000ULL);
  dbl((-0x1.2p+3), 0xc022000000000000ULL);
  dbl((-0x1.3p+3), 0xc023000000000000ULL);
  dbl((-0x1.4p+3), 0xc024000000000000ULL);
  dbl((-0x1.5p+3), 0xc025000000000000ULL);
  dbl((-0x1.6p+3), 0xc026000000000000ULL);
  dbl((-0x1.7p+3), 0xc027000000000000ULL);
  dbl((-0x1.8p+3), 0xc028000000000000ULL);
  dbl((-0x1.9p+3), 0xc029000000000000ULL);
  dbl((-0x1.ap+3), 0xc02a000000000000ULL);
  dbl((-0x1.bp+3), 0xc02b000000000000ULL);
  dbl((-0x1.cp+3), 0xc02c000000000000ULL);
  dbl((-0x1.dp+3), 0xc02d000000000000ULL);
  dbl((-0x1.ep+3), 0xc02e000000000000ULL);
  dbl((-0x1.fp+3), 0xc02f000000000000ULL);
  dbl((-0x1p+4), 0xc030000000000000ULL);
  dbl((-0x1.1p+4), 0xc031000000000000ULL);
  dbl((-0x1.2p+4), 0xc032000000000000ULL);
  dbl((-0x1.3p+4), 0xc033000000000000ULL);
  dbl((-0x1.4p+4), 0xc034000000000000ULL);
  dbl((-0x1.5p+4), 0xc035000000000000ULL);
  dbl((-0x1.6p+4), 0xc036000000000000ULL);
  dbl((-0x1.7p+4), 0xc037000000000000ULL);
  dbl((-0x1.8p+4), 0xc038000000000000ULL);
  dbl((-0x1.9p+4), 0xc039000000000000ULL);
  dbl((-0x1.ap+4), 0xc03a000000000000ULL);
  dbl((-0x1.bp+4), 0xc03b000000000000ULL);
  dbl((-0x1.cp+4), 0xc03c000000000000ULL);
  dbl((-0x1.dp+4), 0xc03d000000000000ULL);
  dbl((-0x1.ep+4), 0xc03e000000000000ULL);
  dbl((-0x1.fp+4), 0xc03f000000000000ULL);
}

void testsng(void)
{
  printf("--- Single-precision test\n");
  sng(0x0p+0, 0x0U);
  sng(-0x0p+0, 0x80000000U);
  sng(0x1p-3, 0x3e000000U);
  sng(0x1.1p-3, 0x3e080000U);
  sng(0x1.2p-3, 0x3e100000U);
  sng(0x1.3p-3, 0x3e180000U);
  sng(0x1.4p-3, 0x3e200000U);
  sng(0x1.5p-3, 0x3e280000U);
  sng(0x1.6p-3, 0x3e300000U);
  sng(0x1.7p-3, 0x3e380000U);
  sng(0x1.8p-3, 0x3e400000U);
  sng(0x1.9p-3, 0x3e480000U);
  sng(0x1.ap-3, 0x3e500000U);
  sng(0x1.bp-3, 0x3e580000U);
  sng(0x1.cp-3, 0x3e600000U);
  sng(0x1.dp-3, 0x3e680000U);
  sng(0x1.ep-3, 0x3e700000U);
  sng(0x1.fp-3, 0x3e780000U);
  sng(0x1p-2, 0x3e800000U);
  sng(0x1.1p-2, 0x3e880000U);
  sng(0x1.2p-2, 0x3e900000U);
  sng(0x1.3p-2, 0x3e980000U);
  sng(0x1.4p-2, 0x3ea00000U);
  sng(0x1.5p-2, 0x3ea80000U);
  sng(0x1.6p-2, 0x3eb00000U);
  sng(0x1.7p-2, 0x3eb80000U);
  sng(0x1.8p-2, 0x3ec00000U);
  sng(0x1.9p-2, 0x3ec80000U);
  sng(0x1.ap-2, 0x3ed00000U);
  sng(0x1.bp-2, 0x3ed80000U);
  sng(0x1.cp-2, 0x3ee00000U);
  sng(0x1.dp-2, 0x3ee80000U);
  sng(0x1.ep-2, 0x3ef00000U);
  sng(0x1.fp-2, 0x3ef80000U);
  sng(0x1p-1, 0x3f000000U);
  sng(0x1.1p-1, 0x3f080000U);
  sng(0x1.2p-1, 0x3f100000U);
  sng(0x1.3p-1, 0x3f180000U);
  sng(0x1.4p-1, 0x3f200000U);
  sng(0x1.5p-1, 0x3f280000U);
  sng(0x1.6p-1, 0x3f300000U);
  sng(0x1.7p-1, 0x3f380000U);
  sng(0x1.8p-1, 0x3f400000U);
  sng(0x1.9p-1, 0x3f480000U);
  sng(0x1.ap-1, 0x3f500000U);
  sng(0x1.bp-1, 0x3f580000U);
  sng(0x1.cp-1, 0x3f600000U);
  sng(0x1.dp-1, 0x3f680000U);
  sng(0x1.ep-1, 0x3f700000U);
  sng(0x1.fp-1, 0x3f780000U);
  sng(0x1p+0, 0x3f800000U);
  sng(0x1.1p+0, 0x3f880000U);
  sng(0x1.2p+0, 0x3f900000U);
  sng(0x1.3p+0, 0x3f980000U);
  sng(0x1.4p+0, 0x3fa00000U);
  sng(0x1.5p+0, 0x3fa80000U);
  sng(0x1.6p+0, 0x3fb00000U);
  sng(0x1.7p+0, 0x3fb80000U);
  sng(0x1.8p+0, 0x3fc00000U);
  sng(0x1.9p+0, 0x3fc80000U);
  sng(0x1.ap+0, 0x3fd00000U);
  sng(0x1.bp+0, 0x3fd80000U);
  sng(0x1.cp+0, 0x3fe00000U);
  sng(0x1.dp+0, 0x3fe80000U);
  sng(0x1.ep+0, 0x3ff00000U);
  sng(0x1.fp+0, 0x3ff80000U);
  sng(0x1p+1, 0x40000000U);
  sng(0x1.1p+1, 0x40080000U);
  sng(0x1.2p+1, 0x40100000U);
  sng(0x1.3p+1, 0x40180000U);
  sng(0x1.4p+1, 0x40200000U);
  sng(0x1.5p+1, 0x40280000U);
  sng(0x1.6p+1, 0x40300000U);
  sng(0x1.7p+1, 0x40380000U);
  sng(0x1.8p+1, 0x40400000U);
  sng(0x1.9p+1, 0x40480000U);
  sng(0x1.ap+1, 0x40500000U);
  sng(0x1.bp+1, 0x40580000U);
  sng(0x1.cp+1, 0x40600000U);
  sng(0x1.dp+1, 0x40680000U);
  sng(0x1.ep+1, 0x40700000U);
  sng(0x1.fp+1, 0x40780000U);
  sng(0x1p+2, 0x40800000U);
  sng(0x1.1p+2, 0x40880000U);
  sng(0x1.2p+2, 0x40900000U);
  sng(0x1.3p+2, 0x40980000U);
  sng(0x1.4p+2, 0x40a00000U);
  sng(0x1.5p+2, 0x40a80000U);
  sng(0x1.6p+2, 0x40b00000U);
  sng(0x1.7p+2, 0x40b80000U);
  sng(0x1.8p+2, 0x40c00000U);
  sng(0x1.9p+2, 0x40c80000U);
  sng(0x1.ap+2, 0x40d00000U);
  sng(0x1.bp+2, 0x40d80000U);
  sng(0x1.cp+2, 0x40e00000U);
  sng(0x1.dp+2, 0x40e80000U);
  sng(0x1.ep+2, 0x40f00000U);
  sng(0x1.fp+2, 0x40f80000U);
  sng(0x1p+3, 0x41000000U);
  sng(0x1.1p+3, 0x41080000U);
  sng(0x1.2p+3, 0x41100000U);
  sng(0x1.3p+3, 0x41180000U);
  sng(0x1.4p+3, 0x41200000U);
  sng(0x1.5p+3, 0x41280000U);
  sng(0x1.6p+3, 0x41300000U);
  sng(0x1.7p+3, 0x41380000U);
  sng(0x1.8p+3, 0x41400000U);
  sng(0x1.9p+3, 0x41480000U);
  sng(0x1.ap+3, 0x41500000U);
  sng(0x1.bp+3, 0x41580000U);
  sng(0x1.cp+3, 0x41600000U);
  sng(0x1.dp+3, 0x41680000U);
  sng(0x1.ep+3, 0x41700000U);
  sng(0x1.fp+3, 0x41780000U);
  sng(0x1p+4, 0x41800000U);
  sng(0x1.1p+4, 0x41880000U);
  sng(0x1.2p+4, 0x41900000U);
  sng(0x1.3p+4, 0x41980000U);
  sng(0x1.4p+4, 0x41a00000U);
  sng(0x1.5p+4, 0x41a80000U);
  sng(0x1.6p+4, 0x41b00000U);
  sng(0x1.7p+4, 0x41b80000U);
  sng(0x1.8p+4, 0x41c00000U);
  sng(0x1.9p+4, 0x41c80000U);
  sng(0x1.ap+4, 0x41d00000U);
  sng(0x1.bp+4, 0x41d80000U);
  sng(0x1.cp+4, 0x41e00000U);
  sng(0x1.dp+4, 0x41e80000U);
  sng(0x1.ep+4, 0x41f00000U);
  sng(0x1.fp+4, 0x41f80000U);
  sng(-0x1p-3, 0xbe000000U);
  sng(-0x1.1p-3, 0xbe080000U);
  sng(-0x1.2p-3, 0xbe100000U);
  sng(-0x1.3p-3, 0xbe180000U);
  sng(-0x1.4p-3, 0xbe200000U);
  sng(-0x1.5p-3, 0xbe280000U);
  sng(-0x1.6p-3, 0xbe300000U);
  sng(-0x1.7p-3, 0xbe380000U);
  sng(-0x1.8p-3, 0xbe400000U);
  sng(-0x1.9p-3, 0xbe480000U);
  sng(-0x1.ap-3, 0xbe500000U);
  sng(-0x1.bp-3, 0xbe580000U);
  sng(-0x1.cp-3, 0xbe600000U);
  sng(-0x1.dp-3, 0xbe680000U);
  sng(-0x1.ep-3, 0xbe700000U);
  sng(-0x1.fp-3, 0xbe780000U);
  sng(-0x1p-2, 0xbe800000U);
  sng(-0x1.1p-2, 0xbe880000U);
  sng(-0x1.2p-2, 0xbe900000U);
  sng(-0x1.3p-2, 0xbe980000U);
  sng(-0x1.4p-2, 0xbea00000U);
  sng(-0x1.5p-2, 0xbea80000U);
  sng(-0x1.6p-2, 0xbeb00000U);
  sng(-0x1.7p-2, 0xbeb80000U);
  sng(-0x1.8p-2, 0xbec00000U);
  sng(-0x1.9p-2, 0xbec80000U);
  sng(-0x1.ap-2, 0xbed00000U);
  sng(-0x1.bp-2, 0xbed80000U);
  sng(-0x1.cp-2, 0xbee00000U);
  sng(-0x1.dp-2, 0xbee80000U);
  sng(-0x1.ep-2, 0xbef00000U);
  sng(-0x1.fp-2, 0xbef80000U);
  sng(-0x1p-1, 0xbf000000U);
  sng(-0x1.1p-1, 0xbf080000U);
  sng(-0x1.2p-1, 0xbf100000U);
  sng(-0x1.3p-1, 0xbf180000U);
  sng(-0x1.4p-1, 0xbf200000U);
  sng(-0x1.5p-1, 0xbf280000U);
  sng(-0x1.6p-1, 0xbf300000U);
  sng(-0x1.7p-1, 0xbf380000U);
  sng(-0x1.8p-1, 0xbf400000U);
  sng(-0x1.9p-1, 0xbf480000U);
  sng(-0x1.ap-1, 0xbf500000U);
  sng(-0x1.bp-1, 0xbf580000U);
  sng(-0x1.cp-1, 0xbf600000U);
  sng(-0x1.dp-1, 0xbf680000U);
  sng(-0x1.ep-1, 0xbf700000U);
  sng(-0x1.fp-1, 0xbf780000U);
  sng(-0x1p+0, 0xbf800000U);
  sng(-0x1.1p+0, 0xbf880000U);
  sng(-0x1.2p+0, 0xbf900000U);
  sng(-0x1.3p+0, 0xbf980000U);
  sng(-0x1.4p+0, 0xbfa00000U);
  sng(-0x1.5p+0, 0xbfa80000U);
  sng(-0x1.6p+0, 0xbfb00000U);
  sng(-0x1.7p+0, 0xbfb80000U);
  sng(-0x1.8p+0, 0xbfc00000U);
  sng(-0x1.9p+0, 0xbfc80000U);
  sng(-0x1.ap+0, 0xbfd00000U);
  sng(-0x1.bp+0, 0xbfd80000U);
  sng(-0x1.cp+0, 0xbfe00000U);
  sng(-0x1.dp+0, 0xbfe80000U);
  sng(-0x1.ep+0, 0xbff00000U);
  sng(-0x1.fp+0, 0xbff80000U);
  sng(-0x1p+1, 0xc0000000U);
  sng(-0x1.1p+1, 0xc0080000U);
  sng(-0x1.2p+1, 0xc0100000U);
  sng(-0x1.3p+1, 0xc0180000U);
  sng(-0x1.4p+1, 0xc0200000U);
  sng(-0x1.5p+1, 0xc0280000U);
  sng(-0x1.6p+1, 0xc0300000U);
  sng(-0x1.7p+1, 0xc0380000U);
  sng(-0x1.8p+1, 0xc0400000U);
  sng(-0x1.9p+1, 0xc0480000U);
  sng(-0x1.ap+1, 0xc0500000U);
  sng(-0x1.bp+1, 0xc0580000U);
  sng(-0x1.cp+1, 0xc0600000U);
  sng(-0x1.dp+1, 0xc0680000U);
  sng(-0x1.ep+1, 0xc0700000U);
  sng(-0x1.fp+1, 0xc0780000U);
  sng(-0x1p+2, 0xc0800000U);
  sng(-0x1.1p+2, 0xc0880000U);
  sng(-0x1.2p+2, 0xc0900000U);
  sng(-0x1.3p+2, 0xc0980000U);
  sng(-0x1.4p+2, 0xc0a00000U);
  sng(-0x1.5p+2, 0xc0a80000U);
  sng(-0x1.6p+2, 0xc0b00000U);
  sng(-0x1.7p+2, 0xc0b80000U);
  sng(-0x1.8p+2, 0xc0c00000U);
  sng(-0x1.9p+2, 0xc0c80000U);
  sng(-0x1.ap+2, 0xc0d00000U);
  sng(-0x1.bp+2, 0xc0d80000U);
  sng(-0x1.cp+2, 0xc0e00000U);
  sng(-0x1.dp+2, 0xc0e80000U);
  sng(-0x1.ep+2, 0xc0f00000U);
  sng(-0x1.fp+2, 0xc0f80000U);
  sng(-0x1p+3, 0xc1000000U);
  sng(-0x1.1p+3, 0xc1080000U);
  sng(-0x1.2p+3, 0xc1100000U);
  sng(-0x1.3p+3, 0xc1180000U);
  sng(-0x1.4p+3, 0xc1200000U);
  sng(-0x1.5p+3, 0xc1280000U);
  sng(-0x1.6p+3, 0xc1300000U);
  sng(-0x1.7p+3, 0xc1380000U);
  sng(-0x1.8p+3, 0xc1400000U);
  sng(-0x1.9p+3, 0xc1480000U);
  sng(-0x1.ap+3, 0xc1500000U);
  sng(-0x1.bp+3, 0xc1580000U);
  sng(-0x1.cp+3, 0xc1600000U);
  sng(-0x1.dp+3, 0xc1680000U);
  sng(-0x1.ep+3, 0xc1700000U);
  sng(-0x1.fp+3, 0xc1780000U);
  sng(-0x1p+4, 0xc1800000U);
  sng(-0x1.1p+4, 0xc1880000U);
  sng(-0x1.2p+4, 0xc1900000U);
  sng(-0x1.3p+4, 0xc1980000U);
  sng(-0x1.4p+4, 0xc1a00000U);
  sng(-0x1.5p+4, 0xc1a80000U);
  sng(-0x1.6p+4, 0xc1b00000U);
  sng(-0x1.7p+4, 0xc1b80000U);
  sng(-0x1.8p+4, 0xc1c00000U);
  sng(-0x1.9p+4, 0xc1c80000U);
  sng(-0x1.ap+4, 0xc1d00000U);
  sng(-0x1.bp+4, 0xc1d80000U);
  sng(-0x1.cp+4, 0xc1e00000U);
  sng(-0x1.dp+4, 0xc1e80000U);
  sng(-0x1.ep+4, 0xc1f00000U);
  sng(-0x1.fp+4, 0xc1f80000U);
}


int main()
{
  testdbl();
  testsng();
  return error;
}
