#
# setup.py
#
# Copyright (C) 2017-2020 frnmst (Franco Masotti) <franco.masotti@live.com>
#
# This file is part of md-toc.
#
# md-toc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# md-toc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with md-toc.  If not, see <http://www.gnu.org/licenses/>.
#
r"""setup.py."""

from setuptools import setup, find_packages

setup(
    name='md_toc',
    version='7.0.4',
    packages=find_packages(exclude=['*tests*']),
    license='GPL',
    description='A utility that is able to generate a table of contents for a markdown file.',
    long_description=open('README.rst').read(),
    long_description_content_type='text/x-rst',
    package_data={
        '': ['*.txt', '*.rst'],
    },
    author='Franco Masotti',
    author_email='franco.masotti@live.com',
    keywords='markdown toc',
    url='https://github.com/frnmst/md-toc',
    python_requires='>=3.5, <4',
    entry_points={
        'console_scripts': [
            'md_toc=md_toc.__main__:main',
        ],
    },
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Topic :: Utilities',
        'Intended Audience :: End Users/Desktop',
        'Environment :: Console',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        'Programming Language :: Python :: 3',
    ],
    install_requires=[
        'fpyutils>=1.2,<1.3'
    ],
)
