Description
-----------

Web server that displays an RTSP video stream using ffmpeg as backend.

Sound is not supported.

Use as a Docker container
-------------------------

This section explains how to use this repository with Docker.

1. Build Docker container: 

   ```bash
   $ git clone https://github.com/luiscarlosgph/rtspwebviewer-ffmpeg.git
   $ cd rtspwebviewer-ffmpeg/docker
   $ docker build -t rtspwebviewer-ffmpeg .
   ```

2. Launch Docker container:

   ```bash
   $ docker run --name rtspwebviewer-ffmpeg --net=host -e RTSP=<rtsp_stream_address> -e PORT=<port> -e WEB_TITLE=<web_title> -e WEB_PWD=<password> rtspwebviewer-ffmpeg:latest &
   ```
   
   Options:
      * `RTSP`: RTSP stream address.
      * `PORT`: listening port for the web server that will play the camera video.
      * `WEB_TITLE`: the name of the website that will be displayed by your web browser.
      * `WEB_PWD`: the URL-based password to access the web player.

3. Access the web player: `http://127.0.0.1:<port>/<password>`.

   
Use as a standalone program
---------------------------

This sections explains how to use this repository without Docker, as a standalone Python program.

1. Install dependencies:
   ```bash
   $ sudo apt update
   $ sudo apt install ffmpeg
   ```
   
2. Install `rtspwebviewer-ffmpeg`:
   ```bash
   $ git clone https://github.com/luiscarlosgph/rtspwebviewer-ffmpeg.git
   $ cd rtspwebviewer-ffmpeg
   $ python3 setup.py install
   ```

2. Run `ffmpeg` to convert the [RTSP](https://en.wikipedia.org/wiki/Real_Time_Streaming_Protocol) stream into  [HLS](https://en.wikipedia.org/wiki/HTTP_Live_Streaming):
   ```bash
   $ ffmpeg -fflags nobuffer -rtsp_transport tcp -i <rtsp_stream_address> -c copy -hls_time 2 -hls_wrap 10 <path_to_m3u8_file>
   ```

3. Run the web server:
   ```bash
   $ python3 -m rtspwebviewer_ffmpeg.run --address <listening_ip_address> --port <port> --title <web_title> --password <password> --m3u8 <path_to_m3u8_file>
   ```

   Options:
      * `--address`: Listening address, use `0.0.0.0` to listen in all interfaces (required).
      * `--port`: TCP port to listen on (required).
      * `--title`: website title (required).
      * `--password`: password to append to the URL of the web server to access the web player (optional).
      * `---m3u8`: path to the `m3u8` file generated by `ffmpeg` in the previous step (required).

4. Access the web viewer: `http://<address>:<port>/<password>`, e.g. for address `0.0.0.0`, port `11931`, and no password, access [http://127.0.0.1:11931](http://127.0.0.1:11931).


Author
------

Luis C. Garcia-Peraza Herrera (luiscarlos.gph@gmail.com).


License
-------

This repository is shared under an [MIT License](https://github.com/luiscarlosgph/rtspwebviewer-ffmpeg/blob/main/LICENSE).
