"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourceWithDeadLetterTarget = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_sns_1 = require("aws-cdk-lib/aws-sns");
const aws_sqs_1 = require("aws-cdk-lib/aws-sqs");
/**
 * Sources that support a dead-letter target.
 */
class SourceWithDeadLetterTarget {
    /**
     * Determines if the source is an instance of SourceWithDeadLetterTarget.
     */
    static isSourceWithDeadLetterTarget(source) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_pipes_alpha_ISource(source);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.isSourceWithDeadLetterTarget);
            }
            throw error;
        }
        return source.deadLetterTarget !== undefined;
    }
    constructor(sourceArn, deadLetterTarget) {
        this.sourceArn = sourceArn;
        this.deadLetterTarget = deadLetterTarget;
    }
    /**
     * Grants the pipe role permission to publish to the dead-letter target.
     */
    grantPush(grantee, deadLetterTarget) {
        if (deadLetterTarget instanceof aws_sqs_1.Queue) {
            deadLetterTarget.grantSendMessages(grantee);
        }
        else if (deadLetterTarget instanceof aws_sns_1.Topic) {
            deadLetterTarget.grantPublish(grantee);
        }
    }
    /**
     * Retrieves the ARN from the dead-letter SQS queue or SNS topic.
     */
    getDeadLetterTargetArn(deadLetterTarget) {
        if (deadLetterTarget instanceof aws_sqs_1.Queue) {
            return deadLetterTarget.queueArn;
        }
        else if (deadLetterTarget instanceof aws_sns_1.Topic) {
            return deadLetterTarget.topicArn;
        }
        return undefined;
    }
}
exports.SourceWithDeadLetterTarget = SourceWithDeadLetterTarget;
_a = JSII_RTTI_SYMBOL_1;
SourceWithDeadLetterTarget[_a] = { fqn: "@aws-cdk/aws-pipes-alpha.SourceWithDeadLetterTarget", version: "2.174.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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