"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3LogDestination = exports.FirehoseLogDestination = exports.CloudwatchLogsLogDestination = exports.S3OutputFormat = exports.LogLevel = exports.IncludeExecutionData = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Log data configuration for a pipe.
 */
var IncludeExecutionData;
(function (IncludeExecutionData) {
    /**
     * Specify ALL to include the execution data (specifically, the payload, awsRequest, and awsResponse fields) in the log messages for this pipe.
     */
    IncludeExecutionData["ALL"] = "ALL";
})(IncludeExecutionData || (exports.IncludeExecutionData = IncludeExecutionData = {}));
/**
 * Log configuration for a pipe.
 *
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-level
 */
var LogLevel;
(function (LogLevel) {
    /**
     * No logging
     */
    LogLevel["OFF"] = "OFF";
    /**
     * Log only errors
     */
    LogLevel["ERROR"] = "ERROR";
    /**
     * Log errors, warnings, and info
     */
    LogLevel["INFO"] = "INFO";
    /**
     * Log everything
     */
    LogLevel["TRACE"] = "TRACE";
})(LogLevel || (exports.LogLevel = LogLevel = {}));
/**
 * Log format for `S3LogDestination` logging configuration.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pipes-pipe-s3logdestination.html#cfn-pipes-pipe-s3logdestination-outputformat
 */
var S3OutputFormat;
(function (S3OutputFormat) {
    /**
    * Plain text
    */
    S3OutputFormat["PLAIN"] = "plain";
    /**
    * JSON
    */
    S3OutputFormat["JSON"] = "json";
    /**
    * W3C extended log file format
    * @see https://www.w3.org/TR/WD-logfile
    */
    S3OutputFormat["W3C"] = "w3c";
})(S3OutputFormat || (exports.S3OutputFormat = S3OutputFormat = {}));
/**
 * CloudWatch Logs log group for delivery of pipe logs.
 */
class CloudwatchLogsLogDestination {
    constructor(logGroup) {
        this.logGroup = logGroup;
    }
    bind(_pipe) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_pipes_alpha_IPipe(_pipe);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            parameters: {
                cloudwatchLogsLogDestination: {
                    logGroupArn: this.logGroup.logGroupArn,
                },
            },
        };
    }
    grantPush(pipeRole) {
        this.logGroup.grantWrite(pipeRole);
    }
}
exports.CloudwatchLogsLogDestination = CloudwatchLogsLogDestination;
_a = JSII_RTTI_SYMBOL_1;
CloudwatchLogsLogDestination[_a] = { fqn: "@aws-cdk/aws-pipes-alpha.CloudwatchLogsLogDestination", version: "2.174.1-alpha.0" };
/**
 * Firehose stream for delivery of pipe logs.
 */
class FirehoseLogDestination {
    constructor(deliveryStream) {
        this.deliveryStream = deliveryStream;
    }
    bind(_pipe) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_pipes_alpha_IPipe(_pipe);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            parameters: {
                firehoseLogDestination: {
                    deliveryStreamArn: this.deliveryStream.deliveryStreamArn,
                },
            },
        };
    }
    grantPush(pipeRole) {
        this.deliveryStream.grantPutRecords(pipeRole);
    }
}
exports.FirehoseLogDestination = FirehoseLogDestination;
_b = JSII_RTTI_SYMBOL_1;
FirehoseLogDestination[_b] = { fqn: "@aws-cdk/aws-pipes-alpha.FirehoseLogDestination", version: "2.174.1-alpha.0" };
/**
 * S3 bucket for delivery of pipe logs.
 */
class S3LogDestination {
    constructor(parameters) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_pipes_alpha_S3LogDestinationProps(parameters);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3LogDestination);
            }
            throw error;
        }
        this.parameters = parameters;
    }
    bind(_pipe) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_pipes_alpha_IPipe(_pipe);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            parameters: {
                s3LogDestination: {
                    bucketName: this.parameters.bucket.bucketName,
                    bucketOwner: this.parameters.bucketOwner || this.parameters.bucket.env.account,
                    outputFormat: this.parameters.outputFormat,
                    prefix: this.parameters.prefix,
                },
            },
        };
    }
    grantPush(pipeRole) {
        this.parameters.bucket.grantPut(pipeRole);
    }
}
exports.S3LogDestination = S3LogDestination;
_c = JSII_RTTI_SYMBOL_1;
S3LogDestination[_c] = { fqn: "@aws-cdk/aws-pipes-alpha.S3LogDestination", version: "2.174.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9ncy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxvZ3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBT0E7O0dBRUc7QUFDSCxJQUFZLG9CQUtYO0FBTEQsV0FBWSxvQkFBb0I7SUFDOUI7O09BRUc7SUFDSCxtQ0FBVyxDQUFBO0FBQ2IsQ0FBQyxFQUxXLG9CQUFvQixvQ0FBcEIsb0JBQW9CLFFBSy9CO0FBRUQ7Ozs7R0FJRztBQUNILElBQVksUUFpQlg7QUFqQkQsV0FBWSxRQUFRO0lBQ2xCOztPQUVHO0lBQ0gsdUJBQVcsQ0FBQTtJQUNYOztPQUVHO0lBQ0gsMkJBQWUsQ0FBQTtJQUNmOztPQUVHO0lBQ0gseUJBQWEsQ0FBQTtJQUNiOztPQUVHO0lBQ0gsMkJBQWUsQ0FBQTtBQUNqQixDQUFDLEVBakJXLFFBQVEsd0JBQVIsUUFBUSxRQWlCbkI7QUFFRDs7OztHQUlHO0FBQ0gsSUFBWSxjQWNYO0FBZEQsV0FBWSxjQUFjO0lBQ3hCOztNQUVFO0lBQ0YsaUNBQWUsQ0FBQTtJQUNmOztNQUVFO0lBQ0YsK0JBQWEsQ0FBQTtJQUNiOzs7TUFHRTtJQUNGLDZCQUFXLENBQUE7QUFDYixDQUFDLEVBZFcsY0FBYyw4QkFBZCxjQUFjLFFBY3pCO0FBZ0dEOztHQUVHO0FBQ0gsTUFBYSw0QkFBNEI7SUFHdkMsWUFBWSxRQUFtQjtRQUM3QixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztLQUMxQjtJQUVELElBQUksQ0FBQyxLQUFZOzs7Ozs7Ozs7O1FBQ2YsT0FBTztZQUNMLFVBQVUsRUFBRTtnQkFDViw0QkFBNEIsRUFBRTtvQkFDNUIsV0FBVyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVztpQkFDdkM7YUFDRjtTQUNGLENBQUM7S0FDSDtJQUVELFNBQVMsQ0FBQyxRQUFlO1FBQ3ZCLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0tBQ3BDOztBQW5CSCxvRUFvQkM7OztBQUVEOztHQUVHO0FBQ0gsTUFBYSxzQkFBc0I7SUFHakMsWUFBWSxjQUErQjtRQUN6QyxJQUFJLENBQUMsY0FBYyxHQUFHLGNBQWMsQ0FBQztLQUN0QztJQUVELElBQUksQ0FBQyxLQUFZOzs7Ozs7Ozs7O1FBQ2YsT0FBTztZQUNMLFVBQVUsRUFBRTtnQkFDVixzQkFBc0IsRUFBRTtvQkFDdEIsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxpQkFBaUI7aUJBQ3pEO2FBQ0Y7U0FDRixDQUFDO0tBQ0g7SUFFRCxTQUFTLENBQUMsUUFBZTtRQUN2QixJQUFJLENBQUMsY0FBYyxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQztLQUMvQzs7QUFuQkgsd0RBb0JDOzs7QUFFRDs7R0FFRztBQUNILE1BQWEsZ0JBQWdCO0lBRzNCLFlBQVksVUFBaUM7Ozs7OzsrQ0FIbEMsZ0JBQWdCOzs7O1FBSXpCLElBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxDQUFDO0tBQzlCO0lBRUQsSUFBSSxDQUFDLEtBQVk7Ozs7Ozs7Ozs7UUFDZixPQUFPO1lBQ0wsVUFBVSxFQUFFO2dCQUNWLGdCQUFnQixFQUFFO29CQUNoQixVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsVUFBVTtvQkFDN0MsV0FBVyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxPQUFPO29CQUM5RSxZQUFZLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZO29CQUMxQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNO2lCQUMvQjthQUNGO1NBQ0YsQ0FBQztLQUNIO0lBRUQsU0FBUyxDQUFDLFFBQWU7UUFDdkIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0tBQzNDOztBQXRCSCw0Q0F1QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJRGVsaXZlcnlTdHJlYW0gfSBmcm9tICdAYXdzLWNkay9hd3Mta2luZXNpc2ZpcmVob3NlLWFscGhhJztcbmltcG9ydCB7IElSb2xlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBJTG9nR3JvdXAgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbG9ncyc7XG5pbXBvcnQgeyBDZm5QaXBlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLXBpcGVzJztcbmltcG9ydCB7IElCdWNrZXQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtczMnO1xuaW1wb3J0IHsgSVBpcGUgfSBmcm9tICcuL3BpcGUnO1xuXG4vKipcbiAqIExvZyBkYXRhIGNvbmZpZ3VyYXRpb24gZm9yIGEgcGlwZS5cbiAqL1xuZXhwb3J0IGVudW0gSW5jbHVkZUV4ZWN1dGlvbkRhdGEge1xuICAvKipcbiAgICogU3BlY2lmeSBBTEwgdG8gaW5jbHVkZSB0aGUgZXhlY3V0aW9uIGRhdGEgKHNwZWNpZmljYWxseSwgdGhlIHBheWxvYWQsIGF3c1JlcXVlc3QsIGFuZCBhd3NSZXNwb25zZSBmaWVsZHMpIGluIHRoZSBsb2cgbWVzc2FnZXMgZm9yIHRoaXMgcGlwZS5cbiAgICovXG4gIEFMTCA9ICdBTEwnLFxufVxuXG4vKipcbiAqIExvZyBjb25maWd1cmF0aW9uIGZvciBhIHBpcGUuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZlbnRicmlkZ2UvbGF0ZXN0L3VzZXJndWlkZS9lYi1waXBlcy1sb2dzLmh0bWwjZWItcGlwZXMtbG9ncy1sZXZlbFxuICovXG5leHBvcnQgZW51bSBMb2dMZXZlbCB7XG4gIC8qKlxuICAgKiBObyBsb2dnaW5nXG4gICAqL1xuICBPRkYgPSAnT0ZGJyxcbiAgLyoqXG4gICAqIExvZyBvbmx5IGVycm9yc1xuICAgKi9cbiAgRVJST1IgPSAnRVJST1InLFxuICAvKipcbiAgICogTG9nIGVycm9ycywgd2FybmluZ3MsIGFuZCBpbmZvXG4gICAqL1xuICBJTkZPID0gJ0lORk8nLFxuICAvKipcbiAgICogTG9nIGV2ZXJ5dGhpbmdcbiAgICovXG4gIFRSQUNFID0gJ1RSQUNFJyxcbn1cblxuLyoqXG4gKiBMb2cgZm9ybWF0IGZvciBgUzNMb2dEZXN0aW5hdGlvbmAgbG9nZ2luZyBjb25maWd1cmF0aW9uLlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlwZXMtcGlwZS1zM2xvZ2Rlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpcGVzLXBpcGUtczNsb2dkZXN0aW5hdGlvbi1vdXRwdXRmb3JtYXRcbiAqL1xuZXhwb3J0IGVudW0gUzNPdXRwdXRGb3JtYXQge1xuICAvKipcbiAgKiBQbGFpbiB0ZXh0XG4gICovXG4gIFBMQUlOID0gJ3BsYWluJyxcbiAgLyoqXG4gICogSlNPTlxuICAqL1xuICBKU09OID0gJ2pzb24nLFxuICAvKipcbiAgKiBXM0MgZXh0ZW5kZWQgbG9nIGZpbGUgZm9ybWF0XG4gICogQHNlZSBodHRwczovL3d3dy53My5vcmcvVFIvV0QtbG9nZmlsZVxuICAqL1xuICBXM0MgPSAndzNjJyxcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBgUzNMb2dEZXN0aW5hdGlvbmAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUzNMb2dEZXN0aW5hdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBTMyBidWNrZXQgdG8gZGVsaXZlciB0aGUgbG9nIHJlY29yZHMgZm9yIHRoZSBwaXBlLlxuICAgKlxuICAgKiBUaGUgYnVja2V0IGNhbiBiZSBpbiB0aGUgc2FtZSBvciBhIGRpZmZlcmVudCBBV1MgQWNjb3VudC4gSWYgdGhlIGJ1Y2tldCBpcyBpblxuICAgKiBhIGRpZmZlcmVudCBhY2Njb3VudCwgc3BlY2lmeSBgYnVja2V0T3duZXJgLiBZb3UgbXVzdCBhbHNvIGFsbG93IGFjY2VzcyB0byB0aGVcbiAgICogUGlwZXMgcm9sZSBpbiB0aGUgYnVja2V0IHBvbGljeSBvZiB0aGUgY3Jvc3MtYWNjb3VudCBidWNrZXQuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlwZXMtcGlwZS1zM2xvZ2Rlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpcGVzLXBpcGUtczNsb2dkZXN0aW5hdGlvbi1idWNrZXRuYW1lXG4gICAqL1xuICByZWFkb25seSBidWNrZXQ6IElCdWNrZXQ7XG4gIC8qKlxuICAgKiBUaGUgQVdTIEFjY291bnQgdGhhdCBvd25zIHRoZSBBbWF6b24gUzMgYnVja2V0IHRvIHdoaWNoIEV2ZW50QnJpZGdlIGRlbGl2ZXJzIHRoZSBsb2cgcmVjb3JkcyBmb3IgdGhlIHBpcGUuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlwZXMtcGlwZS1zM2xvZ2Rlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpcGVzLXBpcGUtczNsb2dkZXN0aW5hdGlvbi1idWNrZXRvd25lclxuICAgKiBAZGVmYXVsdCAtIGFjY291bnQgSUQgZGVyaXZlZCBmcm9tIGBidWNrZXRgXG4gICAqL1xuICByZWFkb25seSBidWNrZXRPd25lcj86IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBmb3JtYXQgZm9yIHRoZSBsb2cgcmVjb3Jkcy5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waXBlcy1waXBlLXMzbG9nZGVzdGluYXRpb24uaHRtbCNjZm4tcGlwZXMtcGlwZS1zM2xvZ2Rlc3RpbmF0aW9uLW91dHB1dGZvcm1hdFxuICAgKiBAZGVmYXVsdCBgUzNPdXRwdXRGb3JtYXQuSlNPTmBcbiAgICovXG4gIHJlYWRvbmx5IG91dHB1dEZvcm1hdD86IFMzT3V0cHV0Rm9ybWF0O1xuICAvKipcbiAgICogVGhlIHByZWZpeCB0ZXh0IHdpdGggd2hpY2ggdG8gYmVnaW4gQW1hem9uIFMzIGxvZyBvYmplY3QgbmFtZXMuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlwZXMtcGlwZS1zM2xvZ2Rlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpcGVzLXBpcGUtczNsb2dkZXN0aW5hdGlvbi1wcmVmaXhcbiAgICogQGRlZmF1bHQgLSBubyBwcmVmaXhcbiAgICovXG4gIHJlYWRvbmx5IHByZWZpeD86IHN0cmluZztcbn1cblxuLyoqXG4gKiBMb2cgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBwYXJhbWV0ZXJzLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIExvZ0Rlc3RpbmF0aW9uUGFyYW1ldGVycyB7XG4gIC8qKlxuICAgKiBUaGUgbG9nZ2luZyBjb25maWd1cmF0aW9uIHNldHRpbmdzIGZvciB0aGUgcGlwZS5cbiAgICpcbiAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpcGVzLXBpcGUtcGlwZWxvZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tcGlwZXMtcGlwZS1waXBlbG9nY29uZmlndXJhdGlvbi1jbG91ZHdhdGNobG9nc2xvZ2Rlc3RpbmF0aW9uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgY2xvdWR3YXRjaExvZ3NMb2dEZXN0aW5hdGlvbj86IENmblBpcGUuQ2xvdWR3YXRjaExvZ3NMb2dEZXN0aW5hdGlvblByb3BlcnR5O1xuXG4gIC8qKlxuICAgKiBUaGUgQW1hem9uIEtpbmVzaXMgRGF0YSBGaXJlaG9zZSBsb2dnaW5nIGNvbmZpZ3VyYXRpb24gc2V0dGluZ3MgZm9yIHRoZSBwaXBlLlxuICAgKlxuICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlwZXMtcGlwZS1waXBlbG9nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1waXBlcy1waXBlLXBpcGVsb2djb25maWd1cmF0aW9uLWZpcmVob3NlbG9nZGVzdGluYXRpb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBmaXJlaG9zZUxvZ0Rlc3RpbmF0aW9uPzogQ2ZuUGlwZS5GaXJlaG9zZUxvZ0Rlc3RpbmF0aW9uUHJvcGVydHk7XG5cbiAgLyoqXG4gICAqIFRoZSBBbWF6b24gUzMgbG9nZ2luZyBjb25maWd1cmF0aW9uIHNldHRpbmdzIGZvciB0aGUgcGlwZS5cbiAgICpcbiAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpcGVzLXBpcGUtcGlwZWxvZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tcGlwZXMtcGlwZS1waXBlbG9nY29uZmlndXJhdGlvbi1zM2xvZ2Rlc3RpbmF0aW9uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgczNMb2dEZXN0aW5hdGlvbj86IENmblBpcGUuUzNMb2dEZXN0aW5hdGlvblByb3BlcnR5O1xufVxuXG4vKipcbiAqIExvZyBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIExvZ0Rlc3RpbmF0aW9uQ29uZmlnIHtcbiAgLyoqXG4gICAqIEdldCB0aGUgbG9nIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb24gcGFyYW1ldGVycy5cbiAgICovXG4gIHJlYWRvbmx5IHBhcmFtZXRlcnM6IExvZ0Rlc3RpbmF0aW9uUGFyYW1ldGVycztcbn1cblxuLyoqXG4gKiBMb2cgZGVzdGluYXRpb24gYmFzZSBjbGFzcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJTG9nRGVzdGluYXRpb24ge1xuICAvKipcbiAgICogQmluZCB0aGUgbG9nIGRlc3RpbmF0aW9uIHRvIHRoZSBwaXBlLlxuICAgKi9cbiAgYmluZChwaXBlOiBJUGlwZSk6IExvZ0Rlc3RpbmF0aW9uQ29uZmlnO1xuXG4gIC8qKlxuICAgKiBHcmFudCB0aGUgcGlwZSByb2xlIHRvIHB1c2ggdG8gdGhlIGxvZyBkZXN0aW5hdGlvbi5cbiAgICovXG4gIGdyYW50UHVzaChncmFudGVlOiBJUm9sZSk6IHZvaWQ7XG59XG5cbi8qKlxuICogQ2xvdWRXYXRjaCBMb2dzIGxvZyBncm91cCBmb3IgZGVsaXZlcnkgb2YgcGlwZSBsb2dzLlxuICovXG5leHBvcnQgY2xhc3MgQ2xvdWR3YXRjaExvZ3NMb2dEZXN0aW5hdGlvbiBpbXBsZW1lbnRzIElMb2dEZXN0aW5hdGlvbiB7XG4gIHByaXZhdGUgbG9nR3JvdXA6IElMb2dHcm91cDtcblxuICBjb25zdHJ1Y3Rvcihsb2dHcm91cDogSUxvZ0dyb3VwKSB7XG4gICAgdGhpcy5sb2dHcm91cCA9IGxvZ0dyb3VwO1xuICB9XG5cbiAgYmluZChfcGlwZTogSVBpcGUpOiBMb2dEZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgY2xvdWR3YXRjaExvZ3NMb2dEZXN0aW5hdGlvbjoge1xuICAgICAgICAgIGxvZ0dyb3VwQXJuOiB0aGlzLmxvZ0dyb3VwLmxvZ0dyb3VwQXJuLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgZ3JhbnRQdXNoKHBpcGVSb2xlOiBJUm9sZSk6IHZvaWQge1xuICAgIHRoaXMubG9nR3JvdXAuZ3JhbnRXcml0ZShwaXBlUm9sZSk7XG4gIH1cbn1cblxuLyoqXG4gKiBGaXJlaG9zZSBzdHJlYW0gZm9yIGRlbGl2ZXJ5IG9mIHBpcGUgbG9ncy5cbiAqL1xuZXhwb3J0IGNsYXNzIEZpcmVob3NlTG9nRGVzdGluYXRpb24gaW1wbGVtZW50cyBJTG9nRGVzdGluYXRpb24ge1xuICBwcml2YXRlIGRlbGl2ZXJ5U3RyZWFtOiBJRGVsaXZlcnlTdHJlYW07XG5cbiAgY29uc3RydWN0b3IoZGVsaXZlcnlTdHJlYW06IElEZWxpdmVyeVN0cmVhbSkge1xuICAgIHRoaXMuZGVsaXZlcnlTdHJlYW0gPSBkZWxpdmVyeVN0cmVhbTtcbiAgfVxuXG4gIGJpbmQoX3BpcGU6IElQaXBlKTogTG9nRGVzdGluYXRpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBwYXJhbWV0ZXJzOiB7XG4gICAgICAgIGZpcmVob3NlTG9nRGVzdGluYXRpb246IHtcbiAgICAgICAgICBkZWxpdmVyeVN0cmVhbUFybjogdGhpcy5kZWxpdmVyeVN0cmVhbS5kZWxpdmVyeVN0cmVhbUFybixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIGdyYW50UHVzaChwaXBlUm9sZTogSVJvbGUpOiB2b2lkIHtcbiAgICB0aGlzLmRlbGl2ZXJ5U3RyZWFtLmdyYW50UHV0UmVjb3JkcyhwaXBlUm9sZSk7XG4gIH1cbn1cblxuLyoqXG4gKiBTMyBidWNrZXQgZm9yIGRlbGl2ZXJ5IG9mIHBpcGUgbG9ncy5cbiAqL1xuZXhwb3J0IGNsYXNzIFMzTG9nRGVzdGluYXRpb24gaW1wbGVtZW50cyBJTG9nRGVzdGluYXRpb24ge1xuICBwcml2YXRlIHBhcmFtZXRlcnM6IFMzTG9nRGVzdGluYXRpb25Qcm9wcztcblxuICBjb25zdHJ1Y3RvcihwYXJhbWV0ZXJzOiBTM0xvZ0Rlc3RpbmF0aW9uUHJvcHMpIHtcbiAgICB0aGlzLnBhcmFtZXRlcnMgPSBwYXJhbWV0ZXJzO1xuICB9XG5cbiAgYmluZChfcGlwZTogSVBpcGUpOiBMb2dEZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgczNMb2dEZXN0aW5hdGlvbjoge1xuICAgICAgICAgIGJ1Y2tldE5hbWU6IHRoaXMucGFyYW1ldGVycy5idWNrZXQuYnVja2V0TmFtZSxcbiAgICAgICAgICBidWNrZXRPd25lcjogdGhpcy5wYXJhbWV0ZXJzLmJ1Y2tldE93bmVyIHx8IHRoaXMucGFyYW1ldGVycy5idWNrZXQuZW52LmFjY291bnQsXG4gICAgICAgICAgb3V0cHV0Rm9ybWF0OiB0aGlzLnBhcmFtZXRlcnMub3V0cHV0Rm9ybWF0LFxuICAgICAgICAgIHByZWZpeDogdGhpcy5wYXJhbWV0ZXJzLnByZWZpeCxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIGdyYW50UHVzaChwaXBlUm9sZTogSVJvbGUpOiB2b2lkIHtcbiAgICB0aGlzLnBhcmFtZXRlcnMuYnVja2V0LmdyYW50UHV0KHBpcGVSb2xlKTtcbiAgfVxufVxuIl19