# coding: utf-8

"""
    SIGNATE API

    API for Public  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_competition_files(self, competition_id, **kwargs):  # noqa: E501
        """Return a list of the competition files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_competition_files(competition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: (required)
        :return: Files
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_competition_files_with_http_info(competition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_competition_files_with_http_info(competition_id, **kwargs)  # noqa: E501
            return data

    def get_competition_files_with_http_info(self, competition_id, **kwargs):  # noqa: E501
        """Return a list of the competition files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_competition_files_with_http_info(competition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: (required)
        :return: Files
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['competition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_competition_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'competition_id' is set
        if ('competition_id' not in params or
                params['competition_id'] is None):
            raise ValueError("Missing the required parameter `competition_id` when calling `get_competition_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'competition_id' in params:
            path_params['competitionId'] = params['competition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/competitions/{competitionId}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Files',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_competitions(self, **kwargs):  # noqa: E501
        """Return a list of competitions  # noqa: E501

        Every inactive competion has been filtered   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_competitions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Competitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_competitions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_competitions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_competitions_with_http_info(self, **kwargs):  # noqa: E501
        """Return a list of competitions  # noqa: E501

        Every inactive competion has been filtered   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_competitions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Competitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_competitions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/competitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Competitions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_competition_agreement(self, competition_id, **kwargs):  # noqa: E501
        """Accept the competition terms of use  # noqa: E501

        User must accept each competition terms of use   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_competition_agreement(competition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_competition_agreement_with_http_info(competition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_competition_agreement_with_http_info(competition_id, **kwargs)  # noqa: E501
            return data

    def post_competition_agreement_with_http_info(self, competition_id, **kwargs):  # noqa: E501
        """Accept the competition terms of use  # noqa: E501

        User must accept each competition terms of use   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_competition_agreement_with_http_info(competition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: (required)
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['competition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_competition_agreement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'competition_id' is set
        if ('competition_id' not in params or
                params['competition_id'] is None):
            raise ValueError("Missing the required parameter `competition_id` when calling `post_competition_agreement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'competition_id' in params:
            path_params['competitionId'] = params['competition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/competitions/{competitionId}/agreement', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_competition_file(self, competition_id, file_id, **kwargs):  # noqa: E501
        """Return a file url  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_competition_file(competition_id, file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: (required)
        :param int file_id: (required)
        :return: Downloads
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_competition_file_with_http_info(competition_id, file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_competition_file_with_http_info(competition_id, file_id, **kwargs)  # noqa: E501
            return data

    def post_competition_file_with_http_info(self, competition_id, file_id, **kwargs):  # noqa: E501
        """Return a file url  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_competition_file_with_http_info(competition_id, file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: (required)
        :param int file_id: (required)
        :return: Downloads
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['competition_id', 'file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_competition_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'competition_id' is set
        if ('competition_id' not in params or
                params['competition_id'] is None):
            raise ValueError("Missing the required parameter `competition_id` when calling `post_competition_file`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params or
                params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `post_competition_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'competition_id' in params:
            path_params['competitionId'] = params['competition_id']  # noqa: E501
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/competitions/{competitionId}/files/{fileId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Downloads',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_competition_files(self, competition_id, **kwargs):  # noqa: E501
        """Return a list of file urls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_competition_files(competition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: Competition Identifier (required)
        :return: Downloads
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_competition_files_with_http_info(competition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_competition_files_with_http_info(competition_id, **kwargs)  # noqa: E501
            return data

    def post_competition_files_with_http_info(self, competition_id, **kwargs):  # noqa: E501
        """Return a list of file urls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_competition_files_with_http_info(competition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: Competition Identifier (required)
        :return: Downloads
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['competition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_competition_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'competition_id' is set
        if ('competition_id' not in params or
                params['competition_id'] is None):
            raise ValueError("Missing the required parameter `competition_id` when calling `post_competition_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'competition_id' in params:
            path_params['competitionId'] = params['competition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/competitions/{competitionId}/files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Downloads',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_competition_submit(self, competition_id, submission_file, **kwargs):  # noqa: E501
        """Submit file to the competition  # noqa: E501

        Submit file relative to competition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_competition_submit(competition_id, submission_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: (required)
        :param file submission_file: (required)
        :param str submission_note:
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_competition_submit_with_http_info(competition_id, submission_file, **kwargs)  # noqa: E501
        else:
            (data) = self.post_competition_submit_with_http_info(competition_id, submission_file, **kwargs)  # noqa: E501
            return data

    def post_competition_submit_with_http_info(self, competition_id, submission_file, **kwargs):  # noqa: E501
        """Submit file to the competition  # noqa: E501

        Submit file relative to competition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_competition_submit_with_http_info(competition_id, submission_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int competition_id: (required)
        :param file submission_file: (required)
        :param str submission_note:
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['competition_id', 'submission_file', 'submission_note']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_competition_submit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'competition_id' is set
        if ('competition_id' not in params or
                params['competition_id'] is None):
            raise ValueError("Missing the required parameter `competition_id` when calling `post_competition_submit`")  # noqa: E501
        # verify the required parameter 'submission_file' is set
        if ('submission_file' not in params or
                params['submission_file'] is None):
            raise ValueError("Missing the required parameter `submission_file` when calling `post_competition_submit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'competition_id' in params:
            path_params['competitionId'] = params['competition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'submission_file' in params:
            local_var_files['submission-file'] = params['submission_file']  # noqa: E501
        if 'submission_note' in params:
            form_params.append(('submission-note', params['submission_note']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/competitions/{competitionId}/submission', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
