"""
Quillow Core Module
===================

Core quantum error correction functionality including:
- Surface code implementations (d=3, 5, 7)
- Syndrome extraction
- Pauli frame tracking
- Noise models
"""

from .surface_code import (
    SurfaceCode,
    SurfaceCodeSimulator,
    RotatedSurfaceCode,
)

from .syndrome import (
    SyndromeExtractor,
    DetectorErrorModel,
    SyndromeGraph,
)

from .pauli_frame import (
    PauliFrame,
    PauliFrameTracker,
    LogicalOperator,
)

from .noise_models import (
    NoiseModel,
    DepolarizingNoise,
    BitFlipNoise,
    PhaseFlipNoise,
    AmplitudeDampingNoise,
    CoherenceNoise,
)

__all__ = [
    # Surface codes
    'SurfaceCode',
    'SurfaceCodeSimulator',
    'RotatedSurfaceCode',

    # Syndrome extraction
    'SyndromeExtractor',
    'DetectorErrorModel',
    'SyndromeGraph',

    # Pauli frames
    'PauliFrame',
    'PauliFrameTracker',
    'LogicalOperator',

    # Noise models
    'NoiseModel',
    'DepolarizingNoise',
    'BitFlipNoise',
    'PhaseFlipNoise',
    'AmplitudeDampingNoise',
    'CoherenceNoise',
]

__version__ = '1.0.0'
