"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An Origin that represents a group.
 *
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 *
 * @stability stable
 */
class OriginGroup {
    /**
     * @stability stable
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_OriginGroupProps(props);
    }
    /**
     * The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @stability stable
     */
    bind(scope, options) {
        const primaryOriginConfig = this.props.primaryOrigin.bind(scope, options);
        if (primaryOriginConfig.failoverConfig) {
            throw new Error('An OriginGroup cannot use an Origin with its own failover configuration as its primary origin!');
        }
        return {
            originProperty: primaryOriginConfig.originProperty,
            failoverConfig: {
                failoverOrigin: this.props.fallbackOrigin,
                statusCodes: this.props.fallbackStatusCodes,
            },
        };
    }
}
exports.OriginGroup = OriginGroup;
_a = JSII_RTTI_SYMBOL_1;
OriginGroup[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.OriginGroup", version: "1.138.2" };
//# sourceMappingURL=data:application/json;base64,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