"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpOrigin = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront = require("@aws-cdk/aws-cloudfront");
/**
 * An Origin for an HTTP server or S3 bucket configured for website hosting.
 *
 * @stability stable
 */
class HttpOrigin extends cloudfront.OriginBase {
    /**
     * @stability stable
     */
    constructor(domainName, props = {}) {
        super(domainName, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_HttpOriginProps(props);
        validateSecondsInRangeOrUndefined('readTimeout', 1, 60, props.readTimeout);
        validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 60, props.keepaliveTimeout);
    }
    /**
     * @stability stable
     */
    renderCustomOriginConfig() {
        var _b, _c, _d, _e;
        return {
            originSslProtocols: (_b = this.props.originSslProtocols) !== null && _b !== void 0 ? _b : [cloudfront.OriginSslPolicy.TLS_V1_2],
            originProtocolPolicy: (_c = this.props.protocolPolicy) !== null && _c !== void 0 ? _c : cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            httpPort: this.props.httpPort,
            httpsPort: this.props.httpsPort,
            originReadTimeout: (_d = this.props.readTimeout) === null || _d === void 0 ? void 0 : _d.toSeconds(),
            originKeepaliveTimeout: (_e = this.props.keepaliveTimeout) === null || _e === void 0 ? void 0 : _e.toSeconds(),
        };
    }
}
exports.HttpOrigin = HttpOrigin;
_a = JSII_RTTI_SYMBOL_1;
HttpOrigin[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.HttpOrigin", version: "1.138.2" };
/**
 * Throws an error if a duration is defined and not an integer number of seconds within a range.
 */
function validateSecondsInRangeOrUndefined(name, min, max, duration) {
    if (duration === undefined) {
        return;
    }
    const value = duration.toSeconds();
    if (!Number.isInteger(value) || value < min || value > max) {
        throw new Error(`${name}: Must be an int between ${min} and ${max} seconds (inclusive); received ${value}.`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC1vcmlnaW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJodHRwLW9yaWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxzREFBc0Q7Ozs7OztBQXlCdEQsTUFBYSxVQUFXLFNBQVEsVUFBVSxDQUFDLFVBQVU7Ozs7SUFFbkQsWUFBWSxVQUFrQixFQUFtQixRQUF5QixFQUFFO1FBQzFFLEtBQUssQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFEc0IsVUFBSyxHQUFMLEtBQUssQ0FBc0I7O1FBRzFFLGlDQUFpQyxDQUFDLGFBQWEsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUMzRSxpQ0FBaUMsQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0tBQ3RGOzs7O0lBRVMsd0JBQXdCOztRQUNoQyxPQUFPO1lBQ0wsa0JBQWtCLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsbUNBQUksQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQztZQUMxRixvQkFBb0IsUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGNBQWMsbUNBQUksVUFBVSxDQUFDLG9CQUFvQixDQUFDLFVBQVU7WUFDN0YsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtZQUM3QixTQUFTLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTO1lBQy9CLGlCQUFpQixRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVywwQ0FBRSxTQUFTLEVBQUU7WUFDdEQsc0JBQXNCLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsMENBQUUsU0FBUyxFQUFFO1NBQ2pFLENBQUM7S0FDSDs7QUFsQkgsZ0NBbUJDOzs7QUFFRDs7R0FFRztBQUNILFNBQVMsaUNBQWlDLENBQUMsSUFBWSxFQUFFLEdBQVcsRUFBRSxHQUFXLEVBQUUsUUFBdUI7SUFDeEcsSUFBSSxRQUFRLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTztLQUFFO0lBQ3ZDLE1BQU0sS0FBSyxHQUFHLFFBQVEsQ0FBQyxTQUFTLEVBQUUsQ0FBQztJQUNuQyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLEdBQUcsR0FBRyxJQUFJLEtBQUssR0FBRyxHQUFHLEVBQUU7UUFDMUQsTUFBTSxJQUFJLEtBQUssQ0FBQyxHQUFHLElBQUksNEJBQTRCLEdBQUcsUUFBUSxHQUFHLGtDQUFrQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO0tBQzlHO0FBQ0gsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNsb3VkZnJvbnQgZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBIdHRwT3JpZ2luUHJvcHMgZXh0ZW5kcyBjbG91ZGZyb250Lk9yaWdpblByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcm90b2NvbFBvbGljeT86IGNsb3VkZnJvbnQuT3JpZ2luUHJvdG9jb2xQb2xpY3k7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgb3JpZ2luU3NsUHJvdG9jb2xzPzogY2xvdWRmcm9udC5PcmlnaW5Tc2xQb2xpY3lbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGh0dHBQb3J0PzogbnVtYmVyO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBodHRwc1BvcnQ/OiBudW1iZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWFkVGltZW91dD86IGNkay5EdXJhdGlvbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkga2VlcGFsaXZlVGltZW91dD86IGNkay5EdXJhdGlvbjtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgSHR0cE9yaWdpbiBleHRlbmRzIGNsb3VkZnJvbnQuT3JpZ2luQmFzZSB7XG5cbiAgY29uc3RydWN0b3IoZG9tYWluTmFtZTogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBIdHRwT3JpZ2luUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKGRvbWFpbk5hbWUsIHByb3BzKTtcblxuICAgIHZhbGlkYXRlU2Vjb25kc0luUmFuZ2VPclVuZGVmaW5lZCgncmVhZFRpbWVvdXQnLCAxLCA2MCwgcHJvcHMucmVhZFRpbWVvdXQpO1xuICAgIHZhbGlkYXRlU2Vjb25kc0luUmFuZ2VPclVuZGVmaW5lZCgna2VlcGFsaXZlVGltZW91dCcsIDEsIDYwLCBwcm9wcy5rZWVwYWxpdmVUaW1lb3V0KTtcbiAgfVxuXG4gIHByb3RlY3RlZCByZW5kZXJDdXN0b21PcmlnaW5Db25maWcoKTogY2xvdWRmcm9udC5DZm5EaXN0cmlidXRpb24uQ3VzdG9tT3JpZ2luQ29uZmlnUHJvcGVydHkgfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB7XG4gICAgICBvcmlnaW5Tc2xQcm90b2NvbHM6IHRoaXMucHJvcHMub3JpZ2luU3NsUHJvdG9jb2xzID8/IFtjbG91ZGZyb250Lk9yaWdpblNzbFBvbGljeS5UTFNfVjFfMl0sXG4gICAgICBvcmlnaW5Qcm90b2NvbFBvbGljeTogdGhpcy5wcm9wcy5wcm90b2NvbFBvbGljeSA/PyBjbG91ZGZyb250Lk9yaWdpblByb3RvY29sUG9saWN5LkhUVFBTX09OTFksXG4gICAgICBodHRwUG9ydDogdGhpcy5wcm9wcy5odHRwUG9ydCxcbiAgICAgIGh0dHBzUG9ydDogdGhpcy5wcm9wcy5odHRwc1BvcnQsXG4gICAgICBvcmlnaW5SZWFkVGltZW91dDogdGhpcy5wcm9wcy5yZWFkVGltZW91dD8udG9TZWNvbmRzKCksXG4gICAgICBvcmlnaW5LZWVwYWxpdmVUaW1lb3V0OiB0aGlzLnByb3BzLmtlZXBhbGl2ZVRpbWVvdXQ/LnRvU2Vjb25kcygpLFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBUaHJvd3MgYW4gZXJyb3IgaWYgYSBkdXJhdGlvbiBpcyBkZWZpbmVkIGFuZCBub3QgYW4gaW50ZWdlciBudW1iZXIgb2Ygc2Vjb25kcyB3aXRoaW4gYSByYW5nZS5cbiAqL1xuZnVuY3Rpb24gdmFsaWRhdGVTZWNvbmRzSW5SYW5nZU9yVW5kZWZpbmVkKG5hbWU6IHN0cmluZywgbWluOiBudW1iZXIsIG1heDogbnVtYmVyLCBkdXJhdGlvbj86IGNkay5EdXJhdGlvbikge1xuICBpZiAoZHVyYXRpb24gPT09IHVuZGVmaW5lZCkgeyByZXR1cm47IH1cbiAgY29uc3QgdmFsdWUgPSBkdXJhdGlvbi50b1NlY29uZHMoKTtcbiAgaWYgKCFOdW1iZXIuaXNJbnRlZ2VyKHZhbHVlKSB8fCB2YWx1ZSA8IG1pbiB8fCB2YWx1ZSA+IG1heCkge1xuICAgIHRocm93IG5ldyBFcnJvcihgJHtuYW1lfTogTXVzdCBiZSBhbiBpbnQgYmV0d2VlbiAke21pbn0gYW5kICR7bWF4fSBzZWNvbmRzIChpbmNsdXNpdmUpOyByZWNlaXZlZCAke3ZhbHVlfS5gKTtcbiAgfVxufVxuIl19