# CodeMapper

[![Pylint](https://github.com/shaneholloman/codemapper/actions/workflows/pylint.yml/badge.svg)](https://github.com/shaneholloman/codemapper/actions/workflows/pylint.yml)
[![PyTest](https://github.com/shaneholloman/codemapper/actions/workflows/pytest.yml/badge.svg)](https://github.com/shaneholloman/codemapper/actions/workflows/pytest.yml)
[![TODO](https://img.shields.io/badge/✔%20RoadMap-45-blue)](notes/todo.md)
![logo](codemapper-outlined.webp)

- [CodeMapper](#codemapper)
  - [Overview](#overview)
  - [Features](#features)
  - [Roadmap](#roadmap)
  - [Requirements](#requirements)
  - [Installation](#installation)
    - [From PyPI](#from-pypi)
    - [From Source](#from-source)
  - [Usage](#usage)
    - [Options](#options)
  - [Output](#output)
  - [Use Cases](#use-cases)
  - [Contributing](#contributing)
  - [License](#license)
  - [Acknowledgments](#acknowledgments)
  - [Version History](#version-history)

## Overview

CodeMapper is a powerful Python tool designed to generate comprehensive Markdown (pdf, xml, and json outputs are on the way) representations of codebases. It bridges the gap between human developers and AI systems by providing a clear, structured view of project architectures and their complete contents. Whether you're working with local directories or GitHub repositories, CodeMapper creates a single, navigable document that encapsulates the full structure and content of a project.

This tool is invaluable for rapid codebase comprehension, whether you're a developer onboarding to a new project or an AI system analyzing code structure.

For audio explanations of this project, see:

- [podcasts](audio) (Auto-generated by Gemini using NotebookLLM)

## Features

- **Dual-Purpose Output**: Generates content optimized for both human readers and AI analysis
- **Intelligent Content Parsing**:
  - Respects `.gitignore` rules
  - Handles various file types appropriately
- **Comprehensive Structure Representation**:
  - Creates an accurate, hierarchical file tree
  - Generates a smart table of contents for easy navigation
- **Code-Aware Processing**:
  - Applies appropriate syntax highlighting for different file types
  - Intelligently handles large or binary files without bloating the output
- **Flexible Input Handling**: Works with local directories and GitHub repositories
- **Encoding Detection**: Ensures accurate content reading across various file encodings
- **Customizable Ignore Rules**: Option to include files normally ignored by `.gitignore`
- **Efficient Output Management**: Organizes generated documents in a '_codemaps' directory

## [Roadmap](./notes/todo.md)

## Requirements

- Python 3.6+
- `pathspec` library (for handling `.gitignore` rules)
- `chardet` library (for file encoding detection)

## Installation

### From PyPI

Install CodeMapper directly from PyPI:

```sh
pip install codemapper
```

### From Source

1. Clone this repository:

    ```sh
    git clone https://github.com/shaneholloman/codemapper.git
    ```

2. Navigate to the cloned directory and install the package:

    ```sh
    cd codemapper
    pip install .
    ```

## Building the Package

To build the package using `pyproject.toml`:

```sh
python -m build
```

This will create distribution files in the `dist` directory.

## Usage

Run CodeMapper from the command line, providing the path to the directory or GitHub repository URL you want to analyze:

```sh
codemapper <path_to_directory_or_github_url> [--include-ignored]
```

### Options

- `<path_to_directory_or_github_url>`: The path to the directory or GitHub repository URL to analyze (required)
- `--include-ignored`: Include files that are normally ignored by `.gitignore` (optional)

## Output

CodeMapper generates a Markdown file named `<directory_name>_codemap.md` in the '_codemaps' directory. This file contains:

1. A comprehensive table of contents for easy navigation
2. An accurate file tree representation of the directory structure
3. The contents of each file, formatted with appropriate syntax highlighting
4. Information about large and binary files (type and size) without their contents

Example usage and output:

```sh
codemapper https://github.com/shaneholloman/ansible-role-apache
```

[View example output here](_example/ansible-role-apache_codemap.md)

## Use Cases

- Rapidly understand the structure and content of new or unfamiliar projects
- Generate comprehensive documentation for code-based AI prompts
- Facilitate thorough code reviews by providing a complete one-page overview
- Assist AI systems in analyzing and understanding complex codebases
- Analyze GitHub repositories without manual cloning

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Acknowledgments

- Thanks to the `pathspec` and `chardet` libraries for enhancing CodeMapper's functionality.

## Version History

For a detailed version history, please refer to the [changelog.md](changelog.md).

---

If you find CodeMapper useful, don't forget to star this repository!
