# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aussiebb', 'aussiebb.asyncio']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.1,<4.0.0', 'pydantic>=1.9.0,<2.0.0', 'requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'pyaussiebb',
    'version': '0.0.15',
    'description': 'Aussie Broadband API module',
    'long_description': '# pyAussieBB\n\nThis is a very simple module for interacting with the Aussie Broadband APIs.\n\n![Python Checks](https://github.com/yaleman/aussiebb/actions/workflows/python_linting.yml/badge.svg)\n![Shellcheck](https://github.com/yaleman/aussiebb/actions/workflows/shellcheck.yml/badge.svg)\n\n# Usage\n\n```\npip install --user pyaussiebb\npython\n>>> from aussiebb import AussieBB\n>>> account = AussieBB(username, password)\n>>> account.get_services()\n[{allyourservicedetails}]\n```\n\nFor more, check out the docs.\n\n# AsyncIO version\n\nYou can replace `from aussiebb import AussieBB` with `from aussiebb.asyncio import AussieBB` and you\'ll get an `aiohttp`-powered version. The only difference in this case is that you have to explicitly call `login()` for reasons.\n\nIf you hit the rate limit it\'ll raise a `RateLimit` exception. I haven\'t put that functionality into the blocking version yet, since ... that tends not to hit it. 🤣\n\n# Development\n\n\n## Example service tests I\'ve seen\n\nAll the "endpoints" below should be tacked onto `aussiebb.const.BASEURL[\'api\']`.\n\n**Warning:** `/nbn/{service_id}/connection` seems to have both a GET and POST method endpoint - tests on other endpoints may be similar.\n\nThese can be run by using `AussieBB.run_test()` with the string after the last forward-slash as the "test" - ie, `connection` or `linestate`.\n\n### HFC \n\nThese are entirely untested so far.\n\n| Endpoint | Method | Name | Description |\n| --- | --- | --- | --- |\n| `/nbn/{service_id}/connection` | Probably GET | Check Connection | Check to see if your service is currently connected |\n| `/nbn/{service_id}/connection` | Probably POST | Kick Connection | Kick your current session and force your device to reauthenticate |\n| `/tests/{service_id}/loopback` | Probably POST | Loopback Test | This will test the connectivity between the point NBN’s network transitions to ours and to the closest point to your property. Usually either the Network Termination Device or Node. |\n| `/tests/{service_id}/ntdstatus` | Probably POST | NTD Status | An NTD Status will show you the operational state of the Network Termination Device (NTD). The test will also show if the NTD is detecting the wired connection from your router. |\n\n### FTTC\n\n| Endpoint | Method | Name | Description |\n| --- | --- | --- | --- |\n| `/nbn/{service_id}/connection` | GET |Check Connection | Check to see if your service is currently connected |\n| `/nbn/{service_id}/connection`  | Probably POST |Kick Connection | Kick your current session and force your device to reauthenticate |\n| `/tests/{service_id}/dpuportreset` | Probably POST |DPU Port Reset | Reset the Port on the DPU (Distribution Point Unit) along with clearing any errors that maybe causing issues with connectivity.  |\n| `/tests/{service_id}/dpuportstatus` | POST |DPU Port Status | A DPU (Distribution Point Unit) port status will show if the NCD (Network Connection Device) is providing power to the DPU. It will also state if the NCD (Network Connection Device) is in sync. |\n| `/tests/{service_id}/dpustatus` | POST |DPU Status | This will provide if the DPU (Distribution Point Unit) is currently being powered. |\n| `/tests/{service_id}/loopback` | POST |Loopback Test | This will test the connectivity between the point NBN’s network transitions to ours and to the closest point to your property. Usually either the Network Termination Device or Node. |\n| `/tests/{service_id}/ncdportreset` | Probably POST |NCD Port Reset | Reset the gateway port on your NCD (Network Connection Device). |\n| `/tests/{service_id}/ncdreset` | Probably POST |NCD Reset | This will remotely restart your Network Termination Device. |\n\n## FTTN\n\n| Endpoint | Method | Name | Description |\n|  --- | --- | --- | --- |\n| `/nbn/{service_id}/connection` | GET | Check Connection | Check to see if your service is currently connected |\n| `/nbn/{service_id}/connection` | Probably POST | Kick Connection | Kick your current session and force your device to reauthenticate |\n| `/tests/{service_id}/linestate` | POST | Line State | A line state test will determine if you have “sync” (connection) to the node. If the service is in sync this test will also return your maximum and current attainable transfer rate. |\n| `/tests/{service_id}/loopback` | POST | Loopback Test | This will test the connectivity between the point NBN’s network transitions to ours and to the closest point to your property. Usually either the Network Termination Device or Node. |\n| `/tests/{service_id}/portreset` | Probably POST | Port Reset | This will reset the connection from the Node and also clear errors that may be causing issues with gaining sync. |\n| `/tests/{service_id}/stabilityprofile` | Probably POST | Stability Profile | This will apply changes to your FTTN service including allowing increased noise to occur before making the connection unstable. This will cause your speeds to degrade as a result, but in turn making the service more stable. For NBN to investigate a fault this profile needs to be applied and a minimum of 5 dropouts recorded over a 24hr period on NBN\'s systems before a dropout fault can be raised |\n\n## FTTP\n\nThese are as-yet untested.\n\n| Endpoint | Method | Name | Description |\n|  --- | --- | --- | --- |\n| `/nbn/{service_id}/connection` | Probably GET | Check Connection | Check to see if your service is currently connected |\n| `/nbn/{service_id}/connection` | Probably POST | Kick Connection | Kick your current session and force your device to reauthenticate |\n| `/tests/{service_id}/loopback` | Probably POST | Loopback Test | This will test the connectivity between the point NBN’s network transitions to ours and to the closest point to your property. Usually either the Network Termination Device or Node. |\n| `/tests/{service_id}/portreset` | Probably POST | Port Reset | This will reset the connection from the Node and also clear errors that may be causing issues with gaining sync. |\n| `/tests/{service_id}/unidstatus` | Probably POST | UNI-D Status | UNI-D Status will show if the UNI-D port you are currently using has a router connected to it. This will also provide the Link speed your router and UNI-D port are connected at Eg, 100mbit or 1gbit. You will also see the MAC address of the currently connected router. |\n\n# Changelog\n\nSee [CHANGELOG.md](CHANGELOG.md)\n',
    'author': 'James Hodgkinson',
    'author_email': 'james@terminaloutcomes.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/yaleman/pyaussiebb',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
