cargparse
Namespace
q )q}q(X
   input_fileqX   ../../data/atesa.configqX   linesq]q(Xt   # This is an example configuration file for ATESA containing the default values for every possible setting, grouped
qXw   # together based on type or use case. Lines are interpreted as if they were python code (which means comments starting
qXt   # with '#' and blank lines are ignored, and strings must be delimited by quotes) with the packages numpy and pytraj
q	XA   # supported. See documentation for descriptions of each setting.
q
X   #
qXV   # setting_name = setting_value      # [<list of supported options, where applicable>]
qX   
q
X&   # Core settings required for all jobs
qXv   job_type = 'aimless_shooting'       # ['aimless_shooting', 'committor_analysis', 'equilibrium_path_sampling', 'isee']
qX7   batch_system = 'slurm'              # ['slurm', 'pbs']
qX4   restart = False                     # [True, False]
qX0   md_engine = 'amber'                 # ['amber']
qX1   task_manager = 'simple'             # ['simple']
qX   topology = 'topology.prmtop'
qX>   working_directory = sys.path[0] + '/atesa_v2/tests/test_temp'
qX4   overwrite = False                   # [True, False]
qh
Xo   # Batch template settings, required if the corresponding template slot (minus the step type prefix) appears in
qXx   # <md_engine>_<batch_system>.tpl, and ignored otherwise. For instance, if {{ ppn }} appears in a batch file to be used,
qXy   # the options corresponding to each step type within the chosen job_type followed by '_ppn' (e.g., for aimless shooting,
qX+   # 'init_ppn' and 'prod_ppn') are required.
qXc   init_nodes = 1          # 'init' is a step type for aimless_shooting and equilibrium_path_sampling
qX
   init_ppn = 1
qX   init_mem = '4000mb'
qX   init_walltime = '00:30:00'
qX   init_solver = 'sander'
qXx   prod_nodes = 1          # 'prod' is a step type for aimless_shooting, committor_analysis, and equilibrium_path_sampling
q X
   prod_ppn = 8
q!X   prod_mem = '4000mb'
q"X   prod_walltime = '02:00:00'
q#X   prod_solver = 'pmemd'
q$h
X7   # Optional settings (defaults will be used if omitted)
q%Xz   path_to_input_files = sys.path[0] + '/atesa_v2/data/input_files'    # default: sys.path[0] + '/atesa_v2/data/input_files'
q&Xx   path_to_templates = sys.path[0] + '/atesa_v2/data/templates'        # default: sys.path[0] + '/atesa_v2/data/templates'
q'h
XX   # Required only for aimless shooting, equilibrium path sampling, and committor analysis
q(XU   cvs = ['pytraj.distance(traj, \'@1 @2\')[0]', 'pytraj.angle(traj, \'@2 @3 @4\')[0]']
q)h
XC   # Required only for aimless shooting and equilibrium path sampling
q*X$   initial_coordinates = ['init.rst7']
q+h
X<   # Required only for aimless shooting and committor analysis
q,X8   commit_fwd = [[1, 2], [3, 4], [1.5, 2.0], ['lt', 'gt']]
q-X8   commit_bwd = [[1, 2], [3, 4], [2.0, 1.5], ['gt', 'lt']]
q.h
XE   # Required only for committor analysis and equilibrium path sampling
q/X-   rc_definition = '1.00 + 2.34*CV1 - 5.67*CV2'
q0X   as_out_file = 'as.out'
q1h
X%   # Required only for aimless shooting
q2X   include_qdot = True
q3X   min_dt = 1
q4X   max_dt = 10
q5X   always_new = True
q6X   resample = False
q7h
X'   # Required only for committor analysis
q8X   committor_analysis_n = 10
q9X   committor_analysis_use_rc_out = True    # [True, False]; path_to_rc_out and rc_threshold required only if True; initial_coordinates required if False
q:XB   path_to_rc_out = sys.path[0] + '/atesa_v2/tests/test_data/rc.out'
q;X   rc_threshold = 0.05
q<h
X"   # Required only if restart = True
q=X#   restart_terminated_threads = False
q>h
X    # ... (this file is unfinished)
q?eX
   line_indexq@KCX   lineqAh?X   job_typeqBX   aimless_shootingqCX   batch_systemqDX   slurmqEX   restartqFX	   md_engineqGX   amberqHX   task_managerqIX   simpleqJX   topologyqKX   ../test_data/test.prmtopqLX   working_directoryqMXJ   /Users/tburgin/Documents/PycharmProjects/atesa_v2/atesa_v2/tests/test_tempqNX	   overwriteqOX
   init_nodesqPKX   init_ppnqQKX   init_memqRX   4000mbqSX
   init_walltimeqTX   00:30:00qUX   init_solverqVX   sanderqWX
   prod_nodesqXKX   prod_ppnqYKX   prod_memqZhSX
   prod_walltimeq[X   02:00:00q\X   prod_solverq]X   pmemdq^X   path_to_input_filesq_XK   /Users/tburgin/Documents/PycharmProjects/atesa_v2/atesa_v2/data/input_filesq`X   path_to_templatesqaXI   /Users/tburgin/Documents/PycharmProjects/atesa_v2/atesa_v2/data/templatesqbX   cvsqc]qd(X!   pytraj.distance(traj, '@1 @2')[0]qeX!   pytraj.angle(traj, '@2 @3 @4')[0]qfeX   initial_coordinatesqg]qhX	   init.rst7qiaX
   commit_fwdqj]qk(]ql(KKe]qm(KKe]qn(G?      G@       e]qo(X   ltqpX   gtqqeeX
   commit_bwdqr]qs(]qt(KKe]qu(KKe]qv(G@       G?      e]qw(hqhpeeX
   rc_definitionqxX   1.00 + 2.34*CV1 - 5.67*CV2qyX   as_out_fileqzX   as.outq{X   include_qdotq|X   min_dtq}KX   max_dtq~K
X
   always_newqX   resampleqX   committor_analysis_nqK
X   committor_analysis_use_rc_outqX   path_to_rc_outqXQ   /Users/tburgin/Documents/PycharmProjects/atesa_v2/atesa_v2/tests/test_data/rc.outqX   rc_thresholdqG?X   restart_terminated_threadsqX   settingsqhX   DEBUGqub.