/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.Credential;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import com.sas.services.connection.RB;
import com.sas.services.connection.WrongCredentialsException;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@SASScope
public class AuthServer {
    private PuddleEnvelope[] envs;
    private boolean cacheUsers;
    private List domains;

    protected AuthServer(PuddleEnvelope[] envs, boolean findDomain) {
        this(envs, findDomain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthServer(PuddleEnvelope[] envs, boolean findDomain, boolean cacheUsers) {
        if (findDomain) {
            HashSet<String> domainSet = new HashSet<String>();
            for (int i = 0; i < envs.length; ++i) {
                Set userCache = envs[i].getUserCache();
                if (userCache == null) continue;
                Set set = userCache;
                synchronized (set) {
                    for (Credential login : userCache) {
                        domainSet.add(login.getDomain());
                    }
                    continue;
                }
            }
            this.domains = new ArrayList(domainSet.size());
            this.domains.addAll(domainSet);
        }
        this.envs = envs;
        this.cacheUsers = cacheUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int[] authorizeUser(Credential userLogin) throws ConnectionFactoryException {
        userLogin = this.normalize(userLogin);
        boolean cached = false;
        boolean[] scoreCard = new boolean[this.envs.length];
        for (int i = 0; i < this.envs.length; ++i) {
            PuddleEnvelope env = this.envs[i];
            Set userCache = env.getUserCache();
            if (userCache == null) {
                scoreCard[i] = true;
                cached = true;
                continue;
            }
            Set set = userCache;
            synchronized (set) {
                if (userCache.contains(userLogin)) {
                    scoreCard[i] = true;
                    cached = true;
                } else {
                    scoreCard[i] = false;
                }
                continue;
            }
        }
        if (!cached) {
            String domain = userLogin.getDomain();
            List domainList = this.getDomains(userLogin);
            if (!domainList.contains(domain)) {
                String messageIndex = "cxf.102.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (Object)messageIndex, (Object)domain);
                throw new WrongCredentialsException(message, userLogin, domainList);
            }
            Object identity = this.authenticate(userLogin);
            if (identity == null) {
                String messageIndex = "cxf.100.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (Object)messageIndex, (Object)userLogin.getDomain());
                throw new InvalidCredentialsException(message, null, userLogin);
            }
            boolean authorized = false;
            try {
                for (int i = 0; i < this.envs.length; ++i) {
                    PuddleEnvelope env = this.envs[i];
                    Puddle puddle = env.getPuddle();
                    if (!this.authorizeUser(identity, puddle)) continue;
                    if (this.cacheUsers) {
                        env.addUserToCache(userLogin);
                    }
                    scoreCard[i] = true;
                    authorized = true;
                }
            }
            finally {
                this.closeIdentity(identity);
            }
            if (!authorized) {
                String messageIndex = "cxf.101.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (Object)messageIndex);
                throw new LoginException(message);
            }
        }
        int authPuddleCount = 0;
        for (int i = 0; i < this.envs.length; ++i) {
            if (!scoreCard[i]) continue;
            ++authPuddleCount;
        }
        int[] authPuddles = new int[authPuddleCount];
        int j = 0;
        for (int i = 0; i < this.envs.length; ++i) {
            if (!scoreCard[i]) continue;
            authPuddles[j++] = i;
        }
        return authPuddles;
    }

    protected void authorizeAdmin(Credential adminLogin) throws ConnectionFactoryException {
    }

    protected Credential normalize(Credential login) {
        return login;
    }

    protected Object authenticate(Credential login) throws ConnectionFactoryException {
        return this;
    }

    protected boolean authorizeUser(Object identity, Puddle puddle) throws ConnectionFactoryException {
        return false;
    }

    protected void closeIdentity(Object identity) {
    }

    protected List getDomains() {
        return this.domains;
    }

    protected List getDomains(Credential login) {
        return this.domains;
    }

    protected final PuddleEnvelope[] getPuddleEnvelopes() {
        return this.envs;
    }

    protected final int findBestPuddle(int[] authPuddles) {
        double bestLoad = Double.POSITIVE_INFINITY;
        int bestIndex = 0;
        for (int i = 0; i < authPuddles.length; ++i) {
            PuddleEnvelope env = this.envs[authPuddles[i]];
            double load = env.getLoad();
            if (!(load < bestLoad)) continue;
            bestLoad = load;
            bestIndex = authPuddles[i];
        }
        return bestIndex;
    }

    protected void removeUserFromCache(Credential user) {
        Credential login = this.normalize(user);
        for (int i = 0; i < this.envs.length; ++i) {
            PuddleEnvelope env = this.envs[i];
            env.removeUserFromCache(login);
        }
    }

    protected void setDomains(List domains) {
        this.domains = domains;
    }
}

