# ![epi-spot](https://i.ibb.co/hXMjrCV/epi-spot.png)

A tool for creating and testing epidemiological models faster than ever for the mathematical modelling of infectious 
diseases. An idea from https://github.com/henrifroese/infectious_disease_modelling

 - SIR-based models
    - Susceptible
    - Infected
    - Recovered
    - Exposed
    - Dead
    - Critical
    - Hospitalized
    
 - Custom-defined compartmental models
    - Create custom models using the `Model` class
 
 - Graphing Capabilities
    - Plot real data from a `.csv` file
    - Plot model predictions interactively
    - Compare different model predictions

## Compile your model at the speed of light
### and get insights that match
Documentation can easily be accessed from function, class, and file docstrings.
Doc strings provide additional documentation on a certain function.
They can be accessed by the built-in Python `help()` command.
These strings are formatted in Github-flavored markdown.
Additionally, all files will have a 'STRUCTURE' label.