/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParseWord;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.StringTools;

class WordTools {
    WordTools() {
    }

    static List<ParseWord> splitIntoParseWords(List<ParseTokens> parseTokensList, String chemicalName) {
        ArrayList<ParseTokens> wellFormedParseTokens = new ArrayList<ParseTokens>();
        ArrayList splitParseTokensForEachParseTokens = new ArrayList();
        int leastWordsInOmmittedSpaceParse = Integer.MAX_VALUE;
        int longestFunctionalTermEncountered = 0;
        for (ParseTokens parseTokens : parseTokensList) {
            List<Character> annotations = parseTokens.getAnnotations();
            List<List<Character>> chunkedAnnotations = WordTools.chunkAnnotations(annotations);
            if (WordTools.containsOmittedSpace(chunkedAnnotations)) {
                ArrayList<ParseTokens> arrayList = new ArrayList<ParseTokens>();
                List<String> tokens = parseTokens.getTokens();
                ArrayList<Character> newAnnotations = new ArrayList<Character>();
                ArrayList<String> newTokens = new ArrayList<String>();
                int currentFunctionalTermLength = 0;
                int annotPos = 0;
                for (List<Character> annotationList : chunkedAnnotations) {
                    Character finalAnnotationInList = annotationList.get(annotationList.size() - 1);
                    if (finalAnnotationInList.equals(Character.valueOf('\u00fb')) && newAnnotations.size() > 0) {
                        arrayList.add(new ParseTokens(newTokens, newAnnotations));
                        newAnnotations = new ArrayList();
                        newTokens = new ArrayList();
                    }
                    for (Character annotation : annotationList) {
                        newAnnotations.add(annotation);
                        newTokens.add(tokens.get(annotPos++));
                    }
                    if (!finalAnnotationInList.equals(Character.valueOf('\u00fb')) && !finalAnnotationInList.equals(Character.valueOf('\u00e2')) && annotPos != tokens.size()) continue;
                    arrayList.add(new ParseTokens(newTokens, newAnnotations));
                    if (finalAnnotationInList.equals(Character.valueOf('\u00fb'))) {
                        currentFunctionalTermLength = StringTools.stringListToString(newTokens, "").length();
                    }
                    newAnnotations = new ArrayList();
                    newTokens = new ArrayList();
                }
                if (arrayList.size() > leastWordsInOmmittedSpaceParse) continue;
                if (arrayList.size() < leastWordsInOmmittedSpaceParse) {
                    splitParseTokensForEachParseTokens.clear();
                    leastWordsInOmmittedSpaceParse = arrayList.size();
                    longestFunctionalTermEncountered = 0;
                }
                if (currentFunctionalTermLength < longestFunctionalTermEncountered) continue;
                if (currentFunctionalTermLength > longestFunctionalTermEncountered) {
                    splitParseTokensForEachParseTokens.clear();
                    longestFunctionalTermEncountered = currentFunctionalTermLength;
                }
                splitParseTokensForEachParseTokens.add(arrayList);
                continue;
            }
            wellFormedParseTokens.add(parseTokens);
        }
        ArrayList<ParseWord> parseWords = new ArrayList<ParseWord>();
        if (!wellFormedParseTokens.isEmpty()) {
            parseWords.add(new ParseWord(chemicalName, wellFormedParseTokens));
        } else {
            for (int i = 0; i < leastWordsInOmmittedSpaceParse; ++i) {
                ArrayList<ParseTokens> parseTokensForWord = new ArrayList<ParseTokens>();
                for (List list : splitParseTokensForEachParseTokens) {
                    if (parseTokensForWord.contains(list.get(i))) continue;
                    parseTokensForWord.add((ParseTokens)list.get(i));
                }
                parseWords.add(new ParseWord(StringTools.stringListToString(((ParseTokens)parseTokensForWord.get(0)).getTokens(), ""), parseTokensForWord));
            }
        }
        return parseWords;
    }

    private static boolean containsOmittedSpace(List<List<Character>> chunkedAnnotations) {
        if (chunkedAnnotations.size() > 1) {
            for (List<Character> annotationList : chunkedAnnotations) {
                if (!annotationList.contains(Character.valueOf('\u00fb'))) continue;
                return true;
            }
        }
        return false;
    }

    static List<List<Character>> chunkAnnotations(List<Character> annots) {
        ArrayList<List<Character>> chunkList = new ArrayList<List<Character>>();
        ArrayList<Character> currentTerm = new ArrayList<Character>();
        for (Character annot : annots) {
            currentTerm.add(annot);
            char ch = annot.charValue();
            if (ch != '\u00e9' && ch != '\u00e2' && ch != '\u00fb') continue;
            chunkList.add(currentTerm);
            currentTerm = new ArrayList();
        }
        return chunkList;
    }

    static String removeWhiteSpaceIfBracketsAreUnbalanced(String name) throws ParsingException {
        int bracketLevel = 0;
        int stringLength = name.length();
        for (int i = 0; i < stringLength; ++i) {
            char c = name.charAt(i);
            if (c == '(' || c == '[' || c == '{') {
                ++bracketLevel;
                continue;
            }
            if (c == ')' || c == ']' || c == '}') {
                --bracketLevel;
                continue;
            }
            if (c != ' ' || bracketLevel <= 0) continue;
            name = name.substring(0, i) + name.substring(i + 1);
            stringLength = name.length();
            --i;
        }
        if (bracketLevel > 0) {
            throw new ParsingException("Unmatched opening bracket found in :" + name);
        }
        if (bracketLevel < 0) {
            throw new ParsingException("Unmatched closing bracket found in :" + name);
        }
        return name;
    }
}

