/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.GroupingEl;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureConfig;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.TokenEl;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class WordRules {
    private final List<WordRuleDescription> wordRuleList;
    private static final Pattern icOrOusAcid = Pattern.compile("(ic|ous)([ ]?acid)?$");
    private static final Pattern ateOrIteOrAmide = Pattern.compile("(at|it|amid)e?$");

    WordRules(ResourceGetter resourceGetter) throws IOException {
        ArrayList<WordRuleDescription> wordRuleList = new ArrayList<WordRuleDescription>();
        XMLStreamReader reader = resourceGetter.getXMLStreamReader("wordRules.xml");
        try {
            while (reader.hasNext()) {
                if (reader.next() != 1 || !reader.getLocalName().equals("wordRule")) continue;
                wordRuleList.add(new WordRuleDescription(reader));
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Parsing exception occurred while reading wordRules.xml", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException("Parsing exception occurred while reading wordRules.xml", e);
            }
        }
        this.wordRuleList = Collections.unmodifiableList(wordRuleList);
    }

    void groupWordsIntoWordRules(Element moleculeEl, NameToStructureConfig n2sConfig, boolean allowSpaceRemoval, Integer[] componentRatios) throws ParsingException {
        WordRulesInstance instance = new WordRulesInstance(moleculeEl, n2sConfig, allowSpaceRemoval, componentRatios);
        List<Element> wordEls = moleculeEl.getChildElements("word");
        for (int i = 0; i < wordEls.size(); ++i) {
            if (!instance.matchWordRule(wordEls, i)) continue;
            i = -1;
        }
        List<Element> wordRuleEls = moleculeEl.getChildElements();
        for (Element wordRuleEl : wordRuleEls) {
            if (wordRuleEl.getName().equals("wordRule")) continue;
            throw new ParsingException("Unable to assign wordRule to: " + wordRuleEl.getAttributeValue("value"));
        }
    }

    private class WordRulesInstance {
        private final Element moleculeEl;
        private final boolean allowRadicals;
        private final boolean allowSpaceRemoval;
        private final Integer expectedNumOfComponents;

        WordRulesInstance(Element moleculeEl, NameToStructureConfig n2sConfig, boolean allowSpaceRemoval, Integer[] componentRatios) {
            this.moleculeEl = moleculeEl;
            this.allowRadicals = n2sConfig.isAllowRadicals();
            this.allowSpaceRemoval = allowSpaceRemoval;
            this.expectedNumOfComponents = componentRatios != null ? Integer.valueOf(componentRatios.length) : null;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean matchWordRule(List<Element> wordEls, int indexOfFirstWord) throws ParsingException {
            GroupingEl wordRuleEl;
            int wordsInWordRule;
            int i;
            Iterator iterator = WordRules.this.wordRuleList.iterator();
            block16: while (true) {
                List<WordDescription> wordDescriptions;
                WordRuleDescription wordRuleDesc;
                if (iterator.hasNext()) {
                    i = indexOfFirstWord;
                    wordRuleDesc = (WordRuleDescription)iterator.next();
                    wordDescriptions = wordRuleDesc.getWordDescriptions();
                    wordsInWordRule = wordDescriptions.size();
                    if (i + wordsInWordRule > wordEls.size()) continue;
                } else {
                    Element firstWord = wordEls.get(indexOfFirstWord);
                    if (firstWord.getName().equals("word") && WordType.full.toString().equals(firstWord.getAttributeValue("type"))) {
                        this.applySimpleWordRule(wordEls, indexOfFirstWord, firstWord);
                        return false;
                    }
                    if (this.allowSpaceRemoval && WordType.substituent.toString().equals(firstWord.getAttributeValue("type"))) {
                        if (indexOfFirstWord + 1 < wordEls.size()) {
                            Element wordToPotentiallyCombineWith = wordEls.get(indexOfFirstWord + 1);
                            if (WordType.full.toString().equals(wordToPotentiallyCombineWith.getAttributeValue("type")) || WordType.substituent.toString().equals(wordToPotentiallyCombineWith.getAttributeValue("type"))) {
                                this.joinWords(wordEls, firstWord, wordToPotentiallyCombineWith);
                                return true;
                            }
                        }
                    } else if (WordType.functionalTerm.toString().equals(firstWord.getAttributeValue("type")) && firstWord.getAttributeValue("value").equalsIgnoreCase("salt")) {
                        if (indexOfFirstWord == 0) {
                            throw new ParsingException("The word salt appeared in an unexpected location");
                        }
                        Element previousWord = wordEls.get(indexOfFirstWord - 1);
                        if (previousWord.getAttribute("isSalt") == null) {
                            previousWord.addAttribute("isSalt", "yes");
                        }
                        wordEls.remove(indexOfFirstWord);
                        firstWord.detach();
                        if (this.moleculeEl.getAttribute("isSalt") == null) {
                            this.moleculeEl.addAttribute("isSalt", "yes");
                        }
                        return true;
                    }
                    if (wordEls.size() == 1 && indexOfFirstWord == 0 && firstWord.getName().equals("word") && WordType.substituent.toString().equals(firstWord.getAttributeValue("type"))) {
                        if (firstWord.getAttributeValue("value").equalsIgnoreCase("dihydrogen")) {
                            this.convertToDihydrogenMolecule(firstWord);
                            return true;
                        }
                        if (this.allowRadicals) {
                            this.applySubstituentWordRule(wordEls, indexOfFirstWord, firstWord);
                        }
                    }
                    return false;
                }
                for (int j = 0; j < wordsInWordRule; ++j) {
                    Element lastGroupInWordRule;
                    String endsWithSubGroupTypePredicate;
                    Element lastGroupInWordRule2;
                    String endsWithGroupTypePredicate;
                    Pattern endsWithPatternPredicate;
                    String valuePredicate;
                    EndsWithGroup endsWithGroupPredicate;
                    Element wordEl = wordEls.get(i + j);
                    WordDescription wd = wordDescriptions.get(j);
                    if (!wd.getType().toString().equals(wordEl.getAttributeValue("type"))) continue block16;
                    String functionalGroupTypePredicate = wd.getFunctionalGroupType();
                    String functionalGroupSubTypePredicate = wd.getFunctionalGroupSubType();
                    if (functionalGroupTypePredicate != null || functionalGroupSubTypePredicate != null) {
                        if (!WordType.functionalTerm.toString().equals(wordEl.getAttributeValue("type"))) continue block16;
                        Element lastEl = this.getLastElementInWord(wordEl);
                        if (lastEl == null) {
                            throw new ParsingException("OPSIN Bug: Cannot find the functional element in a functionalTerm");
                        }
                        while (lastEl.getName().equals("closebracket") || lastEl.getName().equals("structuralCloseBracket")) {
                            if ((lastEl = OpsinTools.getPreviousSibling(lastEl)) != null) continue;
                            throw new ParsingException("OPSIN Bug: Cannot find the functional element in a functionalTerm");
                        }
                        if (functionalGroupTypePredicate != null && !functionalGroupTypePredicate.equals(lastEl.getAttributeValue("type")) || functionalGroupSubTypePredicate != null && !functionalGroupSubTypePredicate.equals(lastEl.getAttributeValue("subType"))) continue block16;
                    }
                    if ((endsWithGroupPredicate = wd.getEndsWithGroup()) != null && !this.endsWithGroupPredicateSatisfied(wordEl, endsWithGroupPredicate) || (valuePredicate = wd.getValue()) != null && !wordEl.getAttributeValue("value").toLowerCase(Locale.ROOT).equals(valuePredicate) || (endsWithPatternPredicate = wd.getEndsWithPattern()) != null && !endsWithPatternPredicate.matcher(wordEl.getAttributeValue("value")).find() || (endsWithGroupTypePredicate = wd.getEndsWithGroupType()) != null && ((lastGroupInWordRule2 = this.getLastGroupInWordRule(wordEl)) == null || !endsWithGroupTypePredicate.equals(lastGroupInWordRule2.getAttributeValue("type"))) || (endsWithSubGroupTypePredicate = wd.getEndsWithGroupSubType()) != null && ((lastGroupInWordRule = this.getLastGroupInWordRule(wordEl)) == null || !endsWithSubGroupTypePredicate.equals(lastGroupInWordRule.getAttributeValue("subType")))) continue block16;
                }
                wordRuleEl = new GroupingEl("wordRule");
                WordRule wordRule = wordRuleDesc.getRuleName();
                wordRuleEl.addAttribute(new Attribute("type", wordRuleDesc.getRuleType().toString()));
                wordRuleEl.addAttribute(new Attribute("wordRule", wordRule.toString()));
                switch (wordRule) {
                    case functionGroupAsGroup: {
                        Element functionalWord = wordEls.get(i + wordsInWordRule - 1);
                        if (!functionalWord.getAttributeValue("type").equals("functionalTerm") || wordsInWordRule > 2) {
                            throw new ParsingException("OPSIN bug: Problem with functionGroupAsGroup wordRule");
                        }
                        this.convertFunctionalGroupIntoGroup(functionalWord);
                        if (wordsInWordRule == 2) {
                            this.joinWords(wordEls, wordEls.get(i), functionalWord);
                            wordsInWordRule = 1;
                        }
                        wordRuleEl.getAttribute("wordRule").setValue(WordRule.simple.toString());
                        break block16;
                    }
                    case carbonylDerivative: 
                    case acidReplacingFunctionalGroup: {
                        for (int j = 1; j < wordsInWordRule - 1; ++j) {
                            Element wordEl = wordEls.get(i + j);
                            if (!WordType.substituent.toString().equals(wordEl.getAttributeValue("type"))) continue;
                            this.joinWords(wordEls, wordEls.get(i + j), wordEls.get(i + j + 1));
                            --wordsInWordRule;
                            List<Element> functionalTerm = OpsinTools.getDescendantElementsWithTagName(wordEls.get(i + j), "functionalTerm");
                            if (functionalTerm.size() != 1) {
                                throw new ParsingException("OPSIN bug: Problem with " + (Object)((Object)wordRule) + " wordRule");
                            }
                            functionalTerm.get(0).setName("root");
                            List<Element> functionalGroups = OpsinTools.getDescendantElementsWithTagName(functionalTerm.get(0), "functionalGroup");
                            if (functionalGroups.size() != 1) {
                                throw new ParsingException("OPSIN bug: Problem with " + (Object)((Object)wordRule) + " wordRule");
                            }
                            functionalGroups.get(0).setName("group");
                            wordEls.get(i + j).getAttribute("type").setValue(WordType.full.toString());
                        }
                        break block16;
                    }
                    case additionCompound: 
                    case oxide: {
                        Element possibleElementaryAtomContainingWord = wordEls.get(i);
                        List<Element> elementaryAtoms = OpsinTools.getDescendantElementsWithTagNameAndAttribute(possibleElementaryAtomContainingWord, "group", "type", "elementaryAtom");
                        if (elementaryAtoms.size() != 1) break block16;
                        Element elementaryAtom = elementaryAtoms.get(0);
                        ChemEl chemEl1 = this.getChemElFromElementaryAtomEl(elementaryAtom);
                        if (wordRule == WordRule.oxide) {
                            if (wordsInWordRule != 2) {
                                throw new ParsingException("OPSIN bug: Problem with " + (Object)((Object)wordRule) + " wordRule");
                            }
                            Element oxideWord = wordEls.get(i + 1);
                            ChemEl chemEl2 = this.getChemElFromWordWithFunctionalGroup(oxideWord);
                            if (FragmentTools.isCovalent(chemEl1, chemEl2) && chemEl1 != ChemEl.Ag) break block16;
                            Element oxideGroup = this.convertFunctionalGroupIntoGroup(oxideWord);
                            this.setOxideStructureAppropriately(oxideGroup, elementaryAtom);
                            this.applySimpleWordRule(wordEls, indexOfFirstWord, possibleElementaryAtomContainingWord);
                            continue block16;
                        }
                        for (int j = 1; j < wordsInWordRule; ++j) {
                            Element functionalGroup = wordEls.get(i + j);
                            ChemEl chemEl2 = this.getChemElFromWordWithFunctionalGroup(functionalGroup);
                            if (FragmentTools.isCovalent(chemEl1, chemEl2)) continue;
                            boolean specialCaseCovalency = false;
                            if (chemEl2.isHalogen() && wordsInWordRule == 2) {
                                switch (chemEl1) {
                                    case Mg: {
                                        if (possibleElementaryAtomContainingWord.getChildCount() <= 1) break;
                                        specialCaseCovalency = true;
                                        break;
                                    }
                                    case Al: {
                                        if (chemEl2 != ChemEl.Cl && chemEl2 != ChemEl.Br && chemEl2 != ChemEl.I) break;
                                        specialCaseCovalency = true;
                                        break;
                                    }
                                    case Ti: {
                                        if (!this.oxidationNumberOrMultiplierIs(elementaryAtom, functionalGroup, 4) || chemEl2 != ChemEl.Cl && chemEl2 != ChemEl.Br && chemEl2 != ChemEl.I) break;
                                        specialCaseCovalency = true;
                                        break;
                                    }
                                    case V: {
                                        if (!this.oxidationNumberOrMultiplierIs(elementaryAtom, functionalGroup, 4) || chemEl2 != ChemEl.Cl) break;
                                        specialCaseCovalency = true;
                                        break;
                                    }
                                    case Zr: 
                                    case Hf: {
                                        if (!this.oxidationNumberOrMultiplierIs(elementaryAtom, functionalGroup, 4) || chemEl2 != ChemEl.Br) break;
                                        specialCaseCovalency = true;
                                        break;
                                    }
                                    case U: {
                                        if (!this.oxidationNumberOrMultiplierIs(elementaryAtom, functionalGroup, 6) || chemEl2 != ChemEl.F && chemEl2 != ChemEl.Cl) break;
                                        specialCaseCovalency = true;
                                        break;
                                    }
                                    case Np: 
                                    case Pu: {
                                        if (!this.oxidationNumberOrMultiplierIs(elementaryAtom, functionalGroup, 6) || chemEl2 != ChemEl.F) break;
                                        specialCaseCovalency = true;
                                        break;
                                    }
                                }
                            } else if ((chemEl2 == ChemEl.H || chemEl2 == ChemEl.C) && wordsInWordRule == 2 && chemEl1 == ChemEl.Al) {
                                specialCaseCovalency = true;
                            }
                            if (!specialCaseCovalency) continue block16;
                        }
                        break block16;
                    }
                    case potentialAlcoholEster: {
                        int lastWordIndex;
                        if (this.expectedNumOfComponents != null && this.expectedNumOfComponents.intValue() == this.moleculeEl.getChildCount() || wordEls.get(lastWordIndex = indexOfFirstWord + wordsInWordRule - 1).getAttribute("isSalt") != null) continue block16;
                        if (lastWordIndex + 1 >= wordEls.size()) break block16;
                        Element nextWord = wordEls.get(lastWordIndex + 1);
                        if (!WordType.functionalTerm.toString().equals(nextWord.getAttributeValue("type")) || !nextWord.getAttributeValue("value").equalsIgnoreCase("salt")) break block16;
                        continue block16;
                    }
                    case monovalentFunctionalGroup: {
                        Element potentialOxy = this.getLastElementInWord(wordEls.get(0));
                        String val = potentialOxy.getValue();
                        if (!val.equals("oxy") && !val.equals("oxo")) break block16;
                        throw new ParsingException(wordEls.get(0).getValue() + wordEls.get(1).getValue() + " is unlikely to be intended to be a molecule");
                    }
                }
                break;
            }
            ArrayList<String> wordValues = new ArrayList<String>();
            Element parentEl = wordEls.get(i).getParent();
            int indexToInsertAt = parentEl.indexOf(wordEls.get(i));
            int j = 0;
            while (true) {
                if (j >= wordsInWordRule) {
                    wordRuleEl.addAttribute(new Attribute("value", StringTools.stringListToString(wordValues, " ")));
                    parentEl.insertChild(wordRuleEl, indexToInsertAt);
                    wordEls.add(i, wordRuleEl);
                    return true;
                }
                Element wordEl = wordEls.remove(i);
                wordEl.detach();
                ((Element)wordRuleEl).addChild(wordEl);
                wordValues.add(wordEl.getAttributeValue("value"));
                ++j;
            }
        }

        private boolean endsWithGroupPredicateSatisfied(Element wordEl, EndsWithGroup endsWithGroupPredicate) throws ParsingException {
            Element lastEl = this.getLastElementInWord(wordEl);
            if (lastEl == null) {
                return false;
            }
            String elName = lastEl.getName();
            while (elName.equals("closebracket") || elName.equals("structuralCloseBracket") || elName.equals("isotopeSpecification")) {
                if ((lastEl = OpsinTools.getPreviousSibling(lastEl)) == null) {
                    return false;
                }
                elName = lastEl.getName();
            }
            if (endsWithGroupPredicate == EndsWithGroup.acid) {
                if (elName.equals("suffix") ? icOrOusAcid.matcher(lastEl.getAttributeValue("value")).find() : elName.equals("group") && lastEl.getAttribute("functionalIDs") != null && (icOrOusAcid.matcher(lastEl.getValue()).find() || "aminoAcid".equals(lastEl.getAttributeValue("type")))) {
                    return true;
                }
            } else if (endsWithGroupPredicate == EndsWithGroup.ateGroup) {
                if (elName.equals("group")) {
                    if (lastEl.getAttribute("functionalIDs") != null && ateOrIteOrAmide.matcher(lastEl.getValue()).find()) {
                        return true;
                    }
                } else {
                    while (lastEl != null && elName.equals("suffix")) {
                        String suffixValAtr = lastEl.getAttributeValue("value");
                        if (ateOrIteOrAmide.matcher(suffixValAtr).find() || suffixValAtr.equals("glycoside")) {
                            return true;
                        }
                        lastEl = OpsinTools.getPreviousSibling(lastEl, "suffix");
                    }
                }
            }
            return false;
        }

        private boolean oxidationNumberOrMultiplierIs(Element elementaryAtomEl, Element functionalGroupWord, int expectedVal) throws ParsingException {
            List<Element> functionalGroups = OpsinTools.getDescendantElementsWithTagName(functionalGroupWord, "functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new ParsingException("OPSIN bug: Unable to find functional group in oxide or addition compound rule");
            }
            Element possibleMultiplier = OpsinTools.getPreviousSibling(functionalGroups.get(0));
            if (possibleMultiplier != null && possibleMultiplier.getName().equals("multiplier")) {
                return Integer.parseInt(possibleMultiplier.getAttributeValue("value")) == expectedVal;
            }
            Element possibleOxidationNumber = OpsinTools.getNextSibling(elementaryAtomEl);
            if (possibleOxidationNumber != null && possibleOxidationNumber.getName().equals("oxidationNumberSpecifier")) {
                return Integer.parseInt(possibleOxidationNumber.getAttributeValue("value")) == expectedVal;
            }
            return false;
        }

        private Element getLastGroupInWordRule(Element wordEl) {
            Element lastEl = this.getLastElementInWord(wordEl);
            if (lastEl.getName().equals("group")) {
                return lastEl;
            }
            List<Element> groups = lastEl.getParent().getChildElements("group");
            if (groups.size() > 0) {
                return groups.get(groups.size() - 1);
            }
            return null;
        }

        private Element getLastElementInWord(Element wordEl) {
            List<Element> children = wordEl.getChildElements();
            Element lastChild = children.get(children.size() - 1);
            while (lastChild.getChildCount() != 0) {
                children = lastChild.getChildElements();
                lastChild = children.get(children.size() - 1);
            }
            return lastChild;
        }

        private void applySimpleWordRule(List<Element> wordEls, int indexOfFirstWord, Element firstWord) {
            Element parentEl = firstWord.getParent();
            int indexToInsertAt = parentEl.indexOf(firstWord);
            GroupingEl wordRuleEl = new GroupingEl("wordRule");
            wordRuleEl.addAttribute(new Attribute("wordRule", WordRule.simple.toString()));
            wordRuleEl.addAttribute(new Attribute("type", WordType.full.toString()));
            wordRuleEl.addAttribute(new Attribute("value", firstWord.getAttributeValue("value")));
            firstWord.detach();
            ((Element)wordRuleEl).addChild(firstWord);
            wordEls.set(indexOfFirstWord, wordRuleEl);
            parentEl.insertChild(wordRuleEl, indexToInsertAt);
        }

        private void applySubstituentWordRule(List<Element> wordEls, int indexOfFirstWord, Element firstWord) {
            Element parentEl = firstWord.getParent();
            int indexToInsertAt = parentEl.indexOf(firstWord);
            GroupingEl wordRuleEl = new GroupingEl("wordRule");
            wordRuleEl.addAttribute(new Attribute("wordRule", WordRule.substituent.toString()));
            wordRuleEl.addAttribute(new Attribute("type", WordType.full.toString()));
            wordRuleEl.addAttribute(new Attribute("value", firstWord.getAttributeValue("value")));
            firstWord.detach();
            ((Element)wordRuleEl).addChild(firstWord);
            wordEls.set(indexOfFirstWord, wordRuleEl);
            parentEl.insertChild(wordRuleEl, indexToInsertAt);
        }

        private void joinWords(List<Element> wordEls, Element firstWord, Element wordToPotentiallyCombineWith) throws ParsingException {
            wordEls.remove(wordToPotentiallyCombineWith);
            wordToPotentiallyCombineWith.detach();
            List<Element> substituentEls = firstWord.getChildElements("substituent");
            if (substituentEls.isEmpty()) {
                throw new ParsingException("OPSIN Bug: Substituent element not found where substituent element expected");
            }
            Element finalSubstituent = substituentEls.get(substituentEls.size() - 1);
            List<Element> finalSubstituentChildren = finalSubstituent.getChildElements();
            if (!finalSubstituentChildren.get(finalSubstituentChildren.size() - 1).getName().equals("hyphen")) {
                TokenEl implicitHyphen = new TokenEl("hyphen", "-");
                finalSubstituent.addChild(implicitHyphen);
            }
            List<Element> elementsToMergeIntoSubstituent = wordToPotentiallyCombineWith.getChildElements();
            for (int j = elementsToMergeIntoSubstituent.size() - 1; j >= 0; --j) {
                Element el = elementsToMergeIntoSubstituent.get(j);
                el.detach();
                OpsinTools.insertAfter(finalSubstituent, el);
            }
            if (WordType.full.toString().equals(wordToPotentiallyCombineWith.getAttributeValue("type"))) {
                firstWord.getAttribute("type").setValue(WordType.full.toString());
            }
            firstWord.getAttribute("value").setValue(firstWord.getAttributeValue("value") + wordToPotentiallyCombineWith.getAttributeValue("value"));
        }

        private Element convertFunctionalGroupIntoGroup(Element word) throws ParsingException {
            word.getAttribute("type").setValue(WordType.full.toString());
            List<Element> functionalTerms = OpsinTools.getDescendantElementsWithTagName(word, "functionalTerm");
            if (functionalTerms.size() != 1) {
                throw new ParsingException("OPSIN Bug: Exactly 1 functionalTerm expected in functionalGroupAsGroup wordRule");
            }
            Element functionalTerm = functionalTerms.get(0);
            functionalTerm.setName("root");
            List<Element> functionalGroups = functionalTerm.getChildElements("functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new ParsingException("OPSIN Bug: Exactly 1 functionalGroup expected in functionalGroupAsGroup wordRule");
            }
            Element functionalGroup = functionalGroups.get(0);
            functionalGroup.setName("group");
            functionalGroup.getAttribute("type").setValue("simpleGroup");
            functionalGroup.addAttribute(new Attribute("subType", "simpleGroup"));
            return functionalGroup;
        }

        private void convertToDihydrogenMolecule(Element word) {
            word.getAttribute("type").setValue(WordType.full.toString());
            for (int i = word.getChildCount() - 1; i >= 0; --i) {
                word.removeChild(i);
            }
            GroupingEl root = new GroupingEl("root");
            TokenEl group = new TokenEl("group");
            group.addAttribute("type", "simpleGroup");
            group.addAttribute("subType", "simpleGroup");
            group.addAttribute("value", "[H][H]");
            ((Element)group).setValue("dihydrogen");
            ((Element)root).addChild(group);
            word.addChild(root);
        }

        private void setOxideStructureAppropriately(Element oxideGroup, Element elementaryAtom) {
            String element;
            Attribute value;
            String smiles;
            String commonOxidationStatesAndMax;
            boolean chainInterpretation = false;
            Integer multiplierVal = null;
            Element possibleMultiplier = OpsinTools.getPreviousSibling(oxideGroup);
            if (possibleMultiplier != null && possibleMultiplier.getName().equals("multiplier") && (multiplierVal = Integer.valueOf(Integer.parseInt(possibleMultiplier.getAttributeValue("value")))) > 1 && ((commonOxidationStatesAndMax = elementaryAtom.getAttributeValue("commonOxidationStatesAndMax")) == null || Integer.parseInt(commonOxidationStatesAndMax.split(":")[1]) <= 2)) {
                chainInterpretation = true;
            }
            if ((smiles = (value = oxideGroup.getAttribute("value")).getValue()).equals("O")) {
                element = "O";
            } else if (smiles.equals("S")) {
                element = "S";
            } else if (smiles.startsWith("[Se")) {
                element = "Se";
            } else if (smiles.startsWith("[Te")) {
                element = "Te";
            } else {
                throw new RuntimeException("OPSIN Bug: Unexpected smiles for oxideGroup: " + smiles);
            }
            if (chainInterpretation) {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                sb.append(element);
                sb.append("-]");
                for (int i = 2; i < multiplierVal; ++i) {
                    sb.append('[');
                    sb.append(element);
                    sb.append(']');
                }
                sb.append('[');
                sb.append(element);
                sb.append("-]");
                value.setValue(sb.toString());
                possibleMultiplier.detach();
            } else {
                value.setValue("[" + element + "-2]");
            }
        }

        private ChemEl getChemElFromElementaryAtomEl(Element elementaryAtomEl) {
            String elementStr = elementaryAtomEl.getAttributeValue("value");
            if (elementStr.startsWith("[")) {
                int len = elementStr.length() - 1;
                for (int i = 1; i < len; ++i) {
                    char ch2;
                    char ch = elementStr.charAt(i);
                    if ((ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
                    if (i + 1 < len && ((ch2 = elementStr.charAt(i + 1)) >= 'A' && ch2 <= 'Z' || ch2 >= 'a' && ch2 <= 'z')) {
                        elementStr = elementStr.substring(i, i + 2);
                        break;
                    }
                    elementStr = elementStr.substring(i, i + 1);
                    break;
                }
            }
            return ChemEl.valueOf(elementStr);
        }

        private ChemEl getChemElFromWordWithFunctionalGroup(Element functionalWord) throws ParsingException {
            List<Element> functionalGroups = OpsinTools.getDescendantElementsWithTagName(functionalWord, "functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new ParsingException("OPSIN bug: Unable to find functional group in oxide or addition compound rule");
            }
            String smiles = functionalGroups.get(0).getAttributeValue("value");
            String elementStr = "";
            for (int i = 0; i < smiles.length(); ++i) {
                if (!Character.isUpperCase(smiles.charAt(i))) continue;
                elementStr = elementStr + smiles.charAt(i);
                if (i + 1 >= smiles.length() || !Character.isLowerCase(smiles.charAt(i + 1))) break;
                elementStr = elementStr + smiles.charAt(i + 1);
                break;
            }
            return ChemEl.valueOf(elementStr);
        }
    }

    private static class WordRuleDescription {
        private final List<WordDescription> wordDescriptions;
        private final WordRule ruleName;
        private final WordType ruleType;

        List<WordDescription> getWordDescriptions() {
            return this.wordDescriptions;
        }

        WordRule getRuleName() {
            return this.ruleName;
        }

        WordType getRuleType() {
            return this.ruleType;
        }

        WordRuleDescription(XMLStreamReader reader) throws XMLStreamException {
            ArrayList<WordDescription> wordDescriptions = new ArrayList<WordDescription>();
            this.ruleName = WordRule.valueOf(reader.getAttributeValue(null, "name"));
            this.ruleType = WordType.valueOf(reader.getAttributeValue(null, "type"));
            while (reader.hasNext()) {
                int event = reader.next();
                if (event == 1) {
                    if (!reader.getLocalName().equals("word")) continue;
                    wordDescriptions.add(new WordDescription(reader));
                    continue;
                }
                if (event != 2 || !reader.getLocalName().equals("wordRule")) continue;
                break;
            }
            this.wordDescriptions = Collections.unmodifiableList(wordDescriptions);
        }
    }

    private static class WordDescription {
        private final WordType type;
        private final EndsWithGroup endsWithGroup;
        private final Pattern endsWithPattern;
        private final String value;
        private final String functionalGroupType;
        private final String functionalGroupSubType;
        private final String endsWithGroupType;
        private final String endsWithGroupSubType;

        WordDescription(XMLStreamReader reader) {
            WordType type = null;
            String value = null;
            EndsWithGroup endsWithGroup = null;
            Pattern endsWithPattern = null;
            String functionalGroupType = null;
            String functionalGroupSubType = null;
            String endsWithGroupType = null;
            String endsWithGroupSubType = null;
            int l = reader.getAttributeCount();
            block20: for (int i = 0; i < l; ++i) {
                String atrValue = reader.getAttributeValue(i);
                switch (reader.getAttributeLocalName(i)) {
                    case "type": {
                        type = WordType.valueOf(atrValue);
                        continue block20;
                    }
                    case "value": {
                        value = atrValue;
                        continue block20;
                    }
                    case "functionalGroupType": {
                        functionalGroupType = atrValue;
                        continue block20;
                    }
                    case "functionalGroupSubType": {
                        functionalGroupSubType = atrValue;
                        continue block20;
                    }
                    case "endsWith": {
                        endsWithGroup = EndsWithGroup.valueOf(atrValue);
                        continue block20;
                    }
                    case "endsWithRegex": {
                        endsWithPattern = Pattern.compile(atrValue + "$", 2);
                        continue block20;
                    }
                    case "endsWithGroupType": {
                        endsWithGroupType = atrValue;
                        continue block20;
                    }
                    case "endsWithGroupSubType": {
                        endsWithGroupSubType = atrValue;
                        continue block20;
                    }
                }
            }
            if (type == null) {
                throw new RuntimeException("Malformed wordRule, no type specified");
            }
            this.type = type;
            this.endsWithGroup = endsWithGroup;
            this.endsWithPattern = endsWithPattern;
            this.value = value;
            this.functionalGroupType = functionalGroupType;
            this.functionalGroupSubType = functionalGroupSubType;
            this.endsWithGroupType = endsWithGroupType;
            this.endsWithGroupSubType = endsWithGroupSubType;
        }

        WordType getType() {
            return this.type;
        }

        EndsWithGroup getEndsWithGroup() {
            return this.endsWithGroup;
        }

        Pattern getEndsWithPattern() {
            return this.endsWithPattern;
        }

        String getValue() {
            return this.value;
        }

        String getFunctionalGroupType() {
            return this.functionalGroupType;
        }

        String getFunctionalGroupSubType() {
            return this.functionalGroupSubType;
        }

        String getEndsWithGroupType() {
            return this.endsWithGroupType;
        }

        String getEndsWithGroupSubType() {
            return this.endsWithGroupSubType;
        }
    }

    static enum EndsWithGroup {
        acid,
        ateGroup;

    }
}

