/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.AmbiguityChecker;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.IsotopeSpecificationParser;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.SuffixRule;
import uk.ac.cam.ch.wwmm.opsin.SuffixRules;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;

class SuffixApplier {
    private final BuildState state;
    private final SuffixRules suffixRules;

    SuffixApplier(BuildState state, SuffixRules suffixRules) {
        this.state = state;
        this.suffixRules = suffixRules;
    }

    boolean isGroupTypeWithSpecificSuffixRules(String groupType) {
        return this.suffixRules.isGroupTypeWithSpecificSuffixRules(groupType);
    }

    void resolveSuffixes(Element group, List<Element> suffixes) throws StructureBuildingException, ComponentGenerationException {
        Fragment frag = group.getFrag();
        List<Atom> atomList = frag.getAtomList();
        String groupType = frag.getType();
        String subgroupType = frag.getSubType();
        String suffixTypeToUse = this.isGroupTypeWithSpecificSuffixRules(groupType) ? groupType : "standardGroup";
        List<Fragment> associatedSuffixFrags = this.state.xmlSuffixMap.get(group);
        if (associatedSuffixFrags != null) {
            associatedSuffixFrags.clear();
        }
        LinkedHashMap<String, ArrayList<Element>> suffixValToSuffixes = new LinkedHashMap<String, ArrayList<Element>>();
        for (Element suffix : suffixes) {
            String suffixValue = suffix.getAttributeValue("value");
            ArrayList<Element> suffixesWithThisVal = (ArrayList<Element>)suffixValToSuffixes.get(suffixValue);
            if (suffixesWithThisVal == null) {
                suffixesWithThisVal = new ArrayList<Element>();
                suffixValToSuffixes.put(suffixValue, suffixesWithThisVal);
            }
            suffixesWithThisVal.add(suffix);
            if (suffix.getFrag() == null) continue;
            Element boughtonIsotopeSpecification = OpsinTools.getNextSibling(suffix);
            if (boughtonIsotopeSpecification != null && boughtonIsotopeSpecification.getName().equals("isotopeSpecification")) {
                if ("boughtonSystem".equals(boughtonIsotopeSpecification.getAttributeValue("type"))) {
                    this.applyIsotopeToSuffix(suffix.getFrag(), boughtonIsotopeSpecification, false);
                } else {
                    throw new RuntimeException("Unexpected isotope specification after suffix");
                }
            }
            Element iupacIsotopeSpecification = OpsinTools.getPreviousSibling(suffix);
            while (iupacIsotopeSpecification != null && iupacIsotopeSpecification.getName().equals("isotopeSpecification") && "iupacSystem".equals(iupacIsotopeSpecification.getAttributeValue("type"))) {
                Element next = OpsinTools.getPreviousSibling(iupacIsotopeSpecification);
                this.applyIsotopeToSuffix(suffix.getFrag(), iupacIsotopeSpecification, true);
                iupacIsotopeSpecification = next;
            }
        }
        boolean reDetectCycles = false;
        ArrayList<Fragment> fragsToMerge = new ArrayList<Fragment>();
        for (Map.Entry entry : suffixValToSuffixes.entrySet()) {
            String suffixValue = (String)entry.getKey();
            List suffixesWithThisVal = (List)entry.getValue();
            List<Atom> possibleAtomsToAttachSuffixTo = null;
            List<SuffixRule> rulesToApply = this.suffixRules.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
            for (int suffixIndex = 0; suffixIndex < suffixesWithThisVal.size(); ++suffixIndex) {
                Element suffix = (Element)suffixesWithThisVal.get(suffixIndex);
                Fragment suffixFrag = null;
                block10: for (SuffixRule suffixRule : rulesToApply) {
                    switch (suffixRule.getType()) {
                        case addgroup: {
                            Atom fragAtomToUse;
                            if (suffixFrag == null) {
                                Object proKetoneAtoms;
                                suffixFrag = suffix.getFrag();
                                if (suffixFrag == null) {
                                    throw new RuntimeException("OPSIN Bug: Suffix was expected to have an associated fragment but it wasn't found");
                                }
                                Atom firstAtomInSuffix = suffixFrag.getFirstAtom();
                                if (firstAtomInSuffix.getBondCount() <= 0) {
                                    throw new ComponentGenerationException("OPSIN Bug: Dummy atom in suffix should have at least one bond to it");
                                }
                                if ("cycleformer".equals(suffix.getAttributeValue("subType"))) {
                                    this.processCycleFormingSuffix(suffixFrag, frag, suffix);
                                    reDetectCycles = true;
                                    break;
                                }
                                int bondOrderRequired = firstAtomInSuffix.getIncomingValency();
                                fragAtomToUse = this.getFragAtomToUse(frag, suffix, suffixTypeToUse);
                                if (fragAtomToUse == null) {
                                    if (possibleAtomsToAttachSuffixTo == null) {
                                        int substitutionsRequired = suffixesWithThisVal.size();
                                        possibleAtomsToAttachSuffixTo = FragmentTools.findnAtomsForSubstitution(frag, atomList.get(0), substitutionsRequired, bondOrderRequired, true);
                                        if (possibleAtomsToAttachSuffixTo == null) {
                                            throw new StructureBuildingException("No suitable atom found to attach " + suffixValue + " suffix");
                                        }
                                        for (Atom atom : possibleAtomsToAttachSuffixTo) {
                                            if (!FragmentTools.isCharacteristicAtom(atom)) continue;
                                            throw new StructureBuildingException("No suitable atom found to attach suffix");
                                        }
                                        if ("yes".equals(suffixRule.getAttributeValue("ketoneLocant")) && !atomList.get(0).getAtomIsInACycle() && (proKetoneAtoms = this.getProKetonePositions(possibleAtomsToAttachSuffixTo)).size() >= substitutionsRequired) {
                                            possibleAtomsToAttachSuffixTo = proKetoneAtoms;
                                        }
                                        if ((substitutionsRequired != 1 || !"alkaneStem".equals(frag.getSubType()) && !"heteroStem".equals(frag.getSubType()) || !possibleAtomsToAttachSuffixTo.get(0).equals(frag.getFirstAtom())) && AmbiguityChecker.isSubstitutionAmbiguous(possibleAtomsToAttachSuffixTo, substitutionsRequired)) {
                                            this.state.addIsAmbiguous("Addition of " + suffixValue + " suffix to: " + group.getValue());
                                        }
                                    }
                                    fragAtomToUse = (Atom)possibleAtomsToAttachSuffixTo.get(suffixIndex);
                                }
                                ArrayList<Bond> bonds = new ArrayList<Bond>(firstAtomInSuffix.getBonds());
                                proKetoneAtoms = bonds.iterator();
                                while (proKetoneAtoms.hasNext()) {
                                    Bond bondToSuffix = (Bond)proKetoneAtoms.next();
                                    Atom suffixAtom = bondToSuffix.getOtherAtom(firstAtomInSuffix);
                                    this.state.fragManager.createBond(fragAtomToUse, suffixAtom, bondToSuffix.getOrder());
                                    this.state.fragManager.removeBond(bondToSuffix);
                                    if (fragAtomToUse.getIncomingValency() <= 2 || !suffixValue.equals("aldehyde") && !suffixValue.equals("al") && !suffixValue.equals("aldoxime")) continue;
                                    if ("X".equals(suffixAtom.getFirstLocant())) {
                                        suffixAtom.setProperty(Atom.ISALDEHYDE, true);
                                        continue;
                                    }
                                    fragAtomToUse.setProperty(Atom.ISALDEHYDE, true);
                                }
                                continue block10;
                            }
                            throw new ComponentGenerationException("OPSIN bug: Suffix may only have one addgroup rule: " + suffix.getValue());
                        }
                        case changecharge: {
                            Atom fragAtomToUse;
                            int chargeChange = Integer.parseInt(suffixRule.getAttributeValue("charge"));
                            int protonChange = Integer.parseInt(suffixRule.getAttributeValue("protons"));
                            if (suffix.getAttribute("suffixPrefix") == null) {
                                fragAtomToUse = this.getFragAtomToUse(frag, suffix, suffixTypeToUse);
                                if (fragAtomToUse != null) {
                                    fragAtomToUse.addChargeAndProtons(chargeChange, protonChange);
                                    break;
                                }
                                this.applyUnlocantedChargeModification(atomList, chargeChange, protonChange);
                                break;
                            }
                            if (suffixFrag == null) {
                                throw new StructureBuildingException("OPSIN bug: ordering of elements in suffixRules.xml wrong; changeCharge found before addGroup");
                            }
                            Set<Bond> bonds = this.state.fragManager.getInterFragmentBonds(suffixFrag);
                            if (bonds.size() != 1) {
                                throw new StructureBuildingException("OPSIN bug: Wrong number of bonds between suffix and group");
                            }
                            for (Bond bond : bonds) {
                                if (bond.getFromAtom().getFrag() == suffixFrag) {
                                    bond.getFromAtom().addChargeAndProtons(chargeChange, protonChange);
                                    continue;
                                }
                                bond.getToAtom().addChargeAndProtons(chargeChange, protonChange);
                            }
                            continue block10;
                        }
                        case setOutAtom: {
                            int outValency;
                            String outValencyAtr = suffixRule.getAttributeValue("outValency");
                            int n = outValency = outValencyAtr != null ? Integer.parseInt(outValencyAtr) : 1;
                            if (suffix.getAttribute("suffixPrefix") == null) {
                                Atom fragAtomToUse = this.getFragAtomToUse(frag, suffix, suffixTypeToUse);
                                if (fragAtomToUse != null) {
                                    frag.addOutAtom(fragAtomToUse, outValency, (Boolean)true);
                                    break;
                                }
                                frag.addOutAtom(frag.getFirstAtom(), outValency, (Boolean)false);
                                break;
                            }
                            if (suffixFrag == null) {
                                throw new StructureBuildingException("OPSIN bug: ordering of elements in suffixRules.xml wrong; setOutAtom found before addGroup");
                            }
                            Set<Bond> bonds = this.state.fragManager.getInterFragmentBonds(suffixFrag);
                            if (bonds.size() != 1) {
                                throw new StructureBuildingException("OPSIN bug: Wrong number of bonds between suffix and group");
                            }
                            for (Bond bond : bonds) {
                                if (bond.getFromAtom().getFrag() == suffixFrag) {
                                    suffixFrag.addOutAtom(bond.getFromAtom(), outValency, (Boolean)true);
                                    continue;
                                }
                                suffixFrag.addOutAtom(bond.getToAtom(), outValency, (Boolean)true);
                            }
                            continue block10;
                        }
                        case setAcidicElement: {
                            ChemEl chemEl = ChemEl.valueOf(suffixRule.getAttributeValue("element"));
                            this.swapElementsSuchThatThisElementIsAcidic(suffixFrag, chemEl);
                            break;
                        }
                    }
                }
                if (suffixFrag == null) continue;
                fragsToMerge.add(suffixFrag);
                suffix.setFrag(null);
            }
        }
        for (Fragment suffixFrag : fragsToMerge) {
            this.state.fragManager.removeAtomAndAssociatedBonds(suffixFrag.getFirstAtom());
            HashSet<String> suffixLocants = new HashSet<String>(suffixFrag.getLocants());
            for (String suffixLocant : suffixLocants) {
                if (!Character.isDigit(suffixLocant.charAt(0)) || !frag.hasLocant(suffixLocant)) continue;
                suffixFrag.getAtomByLocant(suffixLocant).removeLocant(suffixLocant);
            }
            this.state.fragManager.incorporateFragment(suffixFrag, frag);
        }
        if (reDetectCycles) {
            CycleDetector.assignWhetherAtomsAreInCycles(frag);
        }
    }

    private void applyIsotopeToSuffix(Fragment frag, Element isotopeSpecification, boolean mustBeApplied) throws StructureBuildingException {
        IsotopeSpecificationParser.IsotopeSpecification isotopeSpec = IsotopeSpecificationParser.parseIsotopeSpecification(isotopeSpecification);
        ChemEl chemEl = isotopeSpec.getChemEl();
        int isotope = isotopeSpec.getIsotope();
        int multiplier = isotopeSpec.getMultiplier();
        String[] locants = isotopeSpec.getLocants();
        if (locants != null && !mustBeApplied) {
            return;
        }
        if (locants == null) {
            List<Atom> atoms = frag.getAtomList();
            atoms.remove(0);
            if (chemEl == ChemEl.H) {
                List<Atom> parentAtomsToApplyTo = FragmentTools.findnAtomsForSubstitution(atoms, null, multiplier, 1, true);
                if (parentAtomsToApplyTo == null) {
                    if (mustBeApplied) {
                        throw new StructureBuildingException("Failed to find sufficient hydrogen atoms for unlocanted hydrogen isotope replacement");
                    }
                    return;
                }
                if (AmbiguityChecker.isSubstitutionAmbiguous(parentAtomsToApplyTo, multiplier)) {
                    this.state.addIsAmbiguous("Position of hydrogen isotope on " + frag.getTokenEl().getValue());
                }
                for (int j = 0; j < multiplier; ++j) {
                    Atom atomWithHydrogenIsotope = parentAtomsToApplyTo.get(j);
                    Atom hydrogen = this.state.fragManager.createAtom(isotopeSpec.getChemEl(), frag);
                    hydrogen.setIsotope(isotope);
                    this.state.fragManager.createBond(atomWithHydrogenIsotope, hydrogen, 1);
                }
            } else {
                ArrayList<Atom> parentAtomsToApplyTo = new ArrayList<Atom>();
                for (Atom atom : atoms) {
                    if (atom.getElement() != chemEl) continue;
                    parentAtomsToApplyTo.add(atom);
                }
                if (parentAtomsToApplyTo.size() < multiplier) {
                    if (mustBeApplied) {
                        throw new StructureBuildingException("Failed to find sufficient atoms for " + chemEl.toString() + " isotope replacement");
                    }
                    return;
                }
                if (AmbiguityChecker.isSubstitutionAmbiguous(parentAtomsToApplyTo, multiplier)) {
                    this.state.addIsAmbiguous("Position of isotope on " + frag.getTokenEl().getValue());
                }
                for (int j = 0; j < multiplier; ++j) {
                    ((Atom)parentAtomsToApplyTo.get(j)).setIsotope(isotope);
                }
            }
        } else if (chemEl == ChemEl.H) {
            for (int j = 0; j < locants.length; ++j) {
                Atom atomWithHydrogenIsotope = frag.getAtomByLocantOrThrow(locants[j]);
                Atom hydrogen = this.state.fragManager.createAtom(isotopeSpec.getChemEl(), frag);
                hydrogen.setIsotope(isotope);
                this.state.fragManager.createBond(atomWithHydrogenIsotope, hydrogen, 1);
            }
        } else {
            for (int j = 0; j < locants.length; ++j) {
                Atom atom = frag.getAtomByLocantOrThrow(locants[j]);
                if (chemEl != atom.getElement()) {
                    throw new StructureBuildingException("The atom at locant: " + locants[j] + " was not a " + chemEl.toString());
                }
                atom.setIsotope(isotope);
            }
        }
        isotopeSpecification.detach();
    }

    private List<Atom> getProKetonePositions(List<Atom> atoms) {
        ArrayList<Atom> proKetonePositions = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            List<Bond> bonds = atom.getBonds();
            if (bonds.size() != 2 || bonds.get(0).getOrder() != 1 || bonds.get(1).getOrder() != 1 || bonds.get(0).getOtherAtom(atom).getElement() != ChemEl.C || bonds.get(1).getOtherAtom(atom).getElement() != ChemEl.C) continue;
            proKetonePositions.add(atom);
        }
        return proKetonePositions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCycleFormingSuffix(Fragment suffixFrag, Fragment suffixableFragment, Element suffix) throws StructureBuildingException, ComponentGenerationException {
        List<Atom> suffixNeighbours;
        List<Atom> neighbours;
        Atom parentAtom2;
        Atom parentAtom1;
        ArrayList<Atom> rAtoms = new ArrayList<Atom>();
        for (Atom a : suffixFrag) {
            if (a.getElement() != ChemEl.R) continue;
            rAtoms.add(a);
        }
        if (rAtoms.size() != 2) {
            throw new ComponentGenerationException("OPSIN bug: Incorrect number of R atoms associated with cyclic suffix");
        }
        if (((Atom)rAtoms.get(0)).getBondCount() <= 0 || ((Atom)rAtoms.get(1)).getBondCount() <= 0) {
            throw new ComponentGenerationException("OPSIN Bug: Dummy atoms in suffix should have at least one bond to them");
        }
        String locant = suffix.getAttributeValue("locant");
        String locantId = suffix.getAttributeValue("locantID");
        if (locant != null) {
            String[] locants = locant.split(",");
            if (locants.length == 2) {
                parentAtom1 = suffixableFragment.getAtomByLocantOrThrow(locants[0]);
                parentAtom2 = suffixableFragment.getAtomByLocantOrThrow(locants[1]);
            } else {
                if (locants.length != 1) throw new ComponentGenerationException("Incorrect number of locants associated with cycle forming suffix, expected 2 found: " + locants.length);
                parentAtom1 = suffixableFragment.getAtomByLocantOrThrow("1");
                parentAtom2 = suffixableFragment.getAtomByLocantOrThrow(locants[0]);
            }
        } else if (locantId != null) {
            String[] locantIds = locantId.split(",");
            if (locantIds.length != 2) {
                throw new ComponentGenerationException("OPSIN bug: Should be exactly 2 locants associated with a cyclic suffix");
            }
            parentAtom1 = suffixableFragment.getAtomByIDOrThrow(Integer.parseInt(locantIds[0]));
            parentAtom2 = suffixableFragment.getAtomByIDOrThrow(Integer.parseInt(locantIds[1]));
        } else {
            int chainLength = suffixableFragment.getChainLength();
            if (chainLength > 1 && chainLength == suffixableFragment.getAtomCount()) {
                parentAtom1 = suffixableFragment.getAtomByLocantOrThrow("1");
                parentAtom2 = suffixableFragment.getAtomByLocantOrThrow(String.valueOf(chainLength));
            } else {
                List<Atom> hydroxyAtoms = FragmentTools.findHydroxyGroups(suffixableFragment);
                if (hydroxyAtoms.size() != 1 || suffixableFragment.getAtomByLocant("1") == null) throw new ComponentGenerationException("cycle forming suffix: " + suffix.getValue() + " should be locanted!");
                parentAtom1 = suffixableFragment.getAtomByLocantOrThrow("1");
                parentAtom2 = hydroxyAtoms.get(0);
            }
        }
        if (parentAtom1.equals(parentAtom2)) {
            throw new ComponentGenerationException("cycle forming suffix: " + suffix.getValue() + " attempted to form a cycle involving the same atom twice!");
        }
        if (suffixableFragment.getType().equals("carbohydrate")) {
            FragmentTools.removeTerminalOxygen(this.state, parentAtom1, 2);
            FragmentTools.removeTerminalOxygen(this.state, parentAtom1, 1);
            List<Atom> chainHydroxy = FragmentTools.findHydroxyLikeTerminalAtoms(parentAtom2.getAtomNeighbours(), ChemEl.O);
            if (chainHydroxy.size() != 1) throw new ComponentGenerationException("The second locant of a carbohydrate lactone should point to a carbon in the chain with a hydroxyl group");
            FragmentTools.removeTerminalAtom(this.state, chainHydroxy.get(0));
        } else if (parentAtom2.getElement() == ChemEl.O && (neighbours = parentAtom2.getAtomNeighbours()).size() == 1 && (suffixNeighbours = ((Atom)rAtoms.get(1)).getAtomNeighbours()).size() == 1 && suffixNeighbours.get(0).getElement() == ChemEl.O) {
            this.state.fragManager.removeAtomAndAssociatedBonds(parentAtom2);
            parentAtom2 = neighbours.get(0);
        }
        this.makeBondsToSuffix(parentAtom1, (Atom)rAtoms.get(0));
        this.makeBondsToSuffix(parentAtom2, (Atom)rAtoms.get(1));
        this.state.fragManager.removeAtomAndAssociatedBonds((Atom)rAtoms.get(1));
    }

    private Atom getFragAtomToUse(Fragment frag, Element suffix, String suffixTypeToUse) throws StructureBuildingException {
        String locant = suffix.getAttributeValue("locant");
        if (locant != null) {
            return frag.getAtomByLocantOrThrow(locant);
        }
        String locantId = suffix.getAttributeValue("locantID");
        if (locantId != null) {
            return frag.getAtomByIDOrThrow(Integer.parseInt(locantId));
        }
        String defaultLocantId = suffix.getAttributeValue("defaultLocantID");
        if (defaultLocantId != null) {
            return frag.getAtomByIDOrThrow(Integer.parseInt(defaultLocantId));
        }
        if (suffixTypeToUse.equals("acidStem") || suffixTypeToUse.equals("nonCarboxylicAcid") || suffixTypeToUse.equals("chalcogenAcidStem")) {
            return frag.getFirstAtom();
        }
        return null;
    }

    private void applyUnlocantedChargeModification(List<Atom> atomList, int chargeChange, int protonChange) {
        List<Object> listFromWhichToChoose;
        ArrayList<Atom> nitrogens = new ArrayList<Atom>();
        ArrayList<Atom> otherHeteroatoms = new ArrayList<Atom>();
        ArrayList<Atom> carbonsAtoms = new ArrayList<Atom>();
        ArrayList<Atom> chargedAtoms = new ArrayList<Atom>();
        if (atomList.isEmpty()) {
            throw new RuntimeException("OPSIN Bug: List of atoms to add charge suffix to was empty");
        }
        for (Atom a : atomList) {
            ChemEl chemEl = a.getElement();
            Integer[] stableValencies = ValencyChecker.getPossibleValencies(chemEl, a.getCharge() + chargeChange);
            if (stableValencies == null) continue;
            int resultantExpectedValency = (a.getLambdaConventionValency() == null ? ValencyChecker.getDefaultValency(chemEl) : a.getLambdaConventionValency()) + a.getProtonsExplicitlyAddedOrRemoved() + protonChange;
            if (!Arrays.asList(stableValencies).contains(resultantExpectedValency)) continue;
            if (protonChange < 0) {
                int substitableHydrogen = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(a);
                if (a.hasSpareValency() && !a.getFrag().getIndicatedHydrogen().contains(a)) {
                    --substitableHydrogen;
                }
                if (substitableHydrogen < 1) continue;
            }
            if (a.getCharge() == 0) {
                if (chemEl == ChemEl.N) {
                    nitrogens.add(a);
                    continue;
                }
                if (chemEl != ChemEl.C) {
                    otherHeteroatoms.add(a);
                    continue;
                }
                carbonsAtoms.add(a);
                continue;
            }
            chargedAtoms.add(a);
        }
        if (!nitrogens.isEmpty()) {
            listFromWhichToChoose = nitrogens;
            if ("aminoAcid".equals(atomList.get(0).getFrag().getType()) && listFromWhichToChoose.contains(atomList.get(0))) {
                listFromWhichToChoose = new ArrayList();
                listFromWhichToChoose.add(atomList.get(0));
            }
        } else {
            listFromWhichToChoose = !otherHeteroatoms.isEmpty() ? otherHeteroatoms : (!carbonsAtoms.isEmpty() ? carbonsAtoms : (!chargedAtoms.isEmpty() ? chargedAtoms : atomList));
        }
        Atom chosenAtom = (Atom)listFromWhichToChoose.get(0);
        if (!AmbiguityChecker.allAtomsEquivalent(listFromWhichToChoose)) {
            this.state.addIsAmbiguous("Addition of charge suffix to: " + chosenAtom.getFrag().getTokenEl().getValue());
        }
        chosenAtom.addChargeAndProtons(chargeChange, protonChange);
    }

    private void swapElementsSuchThatThisElementIsAcidic(Fragment frag, ChemEl chemEl) throws StructureBuildingException {
        int l = frag.getFunctionalAtomCount();
        for (int i = 0; i < l; ++i) {
            Atom atom = frag.getFunctionalAtom(i).getAtom();
            Set<Atom> ambiguouslyElementedAtoms = atom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT);
            if (ambiguouslyElementedAtoms == null) continue;
            Atom atomToSwapWith = null;
            for (Atom ambiguouslyElementedAtom : ambiguouslyElementedAtoms) {
                if (ambiguouslyElementedAtom.getElement() != chemEl) continue;
                atomToSwapWith = ambiguouslyElementedAtom;
                break;
            }
            if (atomToSwapWith == null) continue;
            if (atomToSwapWith != atom) {
                ArrayList<String> tempLocants1 = new ArrayList<String>(atom.getLocants());
                ArrayList<String> tempLocants2 = new ArrayList<String>(atomToSwapWith.getLocants());
                atom.clearLocants();
                atomToSwapWith.clearLocants();
                for (String locant : tempLocants1) {
                    atomToSwapWith.addLocant(locant);
                }
                for (String locant : tempLocants2) {
                    atom.addLocant(locant);
                }
                ChemEl a2ChemEl = atomToSwapWith.getElement();
                atomToSwapWith.setElement(atom.getElement());
                atom.setElement(a2ChemEl);
                ambiguouslyElementedAtoms.remove(atomToSwapWith);
            }
            ambiguouslyElementedAtoms.remove(atom);
            return;
        }
        throw new StructureBuildingException("Unable to find potential acidic atom with element: " + (Object)((Object)chemEl));
    }

    private void makeBondsToSuffix(Atom parentAtom, Atom suffixRAtom) {
        ArrayList<Bond> bonds = new ArrayList<Bond>(suffixRAtom.getBonds());
        for (Bond bondToSuffix : bonds) {
            Atom suffixAtom = bondToSuffix.getOtherAtom(suffixRAtom);
            this.state.fragManager.createBond(parentAtom, suffixAtom, bondToSuffix.getOrder());
            this.state.fragManager.removeBond(bondToSuffix);
        }
    }

    List<SuffixRule> getSuffixRuleTags(String suffixTypeToUse, String suffixValue, String subgroupType) throws ComponentGenerationException {
        return this.suffixRules.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
    }
}

