/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.AmbiguityChecker;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildResults;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.GroupingEl;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StereoAnalyser;
import uk.ac.cam.ch.wwmm.opsin.StereochemistryHandler;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class StructureBuilder {
    private final BuildState state;
    private final List<Atom> polymerAttachmentPoints = new ArrayList<Atom>();
    private int currentTopLevelWordRuleCount;
    private static final Pattern matchCommonCarboxylicSalt = Pattern.compile("tri-?fluoro-?acetate?$", 2);
    private static final Pattern matchCommonEsterFormingInorganicSalt = Pattern.compile("(ortho-?)?(bor|phosphor|phosphate?|phosphite?)|carbam|carbon|sulfur|sulfate?|sulfite?|diphosphate?|triphosphate?", 2);

    StructureBuilder(BuildState state) {
        this.state = state;
    }

    Fragment buildFragment(Element molecule) throws StructureBuildingException {
        List<Element> wordRules = molecule.getChildElements("wordRule");
        this.currentTopLevelWordRuleCount = wordRules.size();
        if (this.currentTopLevelWordRuleCount == 0) {
            throw new StructureBuildingException("Molecule contains no word rules!?");
        }
        for (Element wordRule : wordRules) {
            this.processWordRuleChildrenThenRule(wordRule);
        }
        if (this.currentTopLevelWordRuleCount != wordRules.size()) {
            wordRules = molecule.getChildElements("wordRule");
        }
        List<Element> groupElements = OpsinTools.getDescendantElementsWithTagName(molecule, "group");
        this.processSpecialCases(groupElements);
        this.processOxidationNumbers(groupElements);
        this.state.fragManager.convertSpareValenciesToDoubleBonds();
        this.state.fragManager.checkValencies();
        this.manipulateStoichiometry(molecule, wordRules);
        this.state.fragManager.makeHydrogensExplicit();
        Fragment uniFrag = this.state.fragManager.getUnifiedFragment();
        this.processStereochemistry(molecule, uniFrag);
        if (uniFrag.getOutAtomCount() > 0) {
            if (!this.state.n2sConfig.isAllowRadicals()) {
                throw new StructureBuildingException("Radicals are currently set to not convert to structures");
            }
            if (this.state.n2sConfig.isOutputRadicalsAsWildCardAtoms()) {
                this.convertOutAtomsToAttachmentAtoms(uniFrag);
            }
        }
        if (this.polymerAttachmentPoints.size() > 0) {
            for (Atom rAtom : this.polymerAttachmentPoints) {
                rAtom.setElement(ChemEl.R);
            }
            uniFrag.setPolymerAttachmentPoints(this.polymerAttachmentPoints);
        }
        return uniFrag;
    }

    private void processWordRuleChildrenThenRule(Element wordRule) throws StructureBuildingException {
        List<Element> wordRuleChildren = wordRule.getChildElements("wordRule");
        for (Element wordRuleChild : wordRuleChildren) {
            this.processWordRuleChildrenThenRule(wordRuleChild);
        }
        this.processWordRule(wordRule);
    }

    private void processWordRule(Element wordRuleEl) throws StructureBuildingException {
        WordRule wordRule = WordRule.valueOf(wordRuleEl.getAttributeValue("wordRule"));
        List<Element> words = OpsinTools.getChildElementsWithTagNames(wordRuleEl, new String[]{"word", "wordRule"});
        this.state.currentWordRule = wordRule;
        switch (wordRule) {
            case simple: {
                for (Element word : words) {
                    if (!word.getName().equals("word") || !word.getAttributeValue("type").equals(WordType.full.toString())) {
                        throw new StructureBuildingException("OPSIN bug: Unexpected contents of 'simple' wordRule");
                    }
                    StructureBuildingMethods.resolveWordOrBracket(this.state, word);
                }
                break;
            }
            case substituent: {
                for (Element word : words) {
                    if (!(word.getName().equals("word") && word.getAttributeValue("type").equals(WordType.substituent.toString()) && this.state.n2sConfig.isAllowRadicals())) {
                        throw new StructureBuildingException("OPSIN bug: Unexpected contents of 'substituent' wordRule");
                    }
                    StructureBuildingMethods.resolveWordOrBracket(this.state, word);
                }
                break;
            }
            case ester: 
            case multiEster: {
                this.buildEster(words);
                break;
            }
            case divalentFunctionalGroup: {
                this.buildDiValentFunctionalGroup(words);
                break;
            }
            case monovalentFunctionalGroup: {
                this.buildMonovalentFunctionalGroup(words);
                break;
            }
            case functionalClassEster: {
                this.buildFunctionalClassEster(words);
                break;
            }
            case acidReplacingFunctionalGroup: {
                for (Element word : words) {
                    StructureBuildingMethods.resolveWordOrBracket(this.state, word);
                }
                break;
            }
            case oxide: {
                this.buildOxide(words);
                break;
            }
            case carbonylDerivative: {
                this.buildCarbonylDerivative(words);
                break;
            }
            case anhydride: {
                this.buildAnhydride(words);
                break;
            }
            case acidHalideOrPseudoHalide: {
                this.buildAcidHalideOrPseudoHalide(words);
                break;
            }
            case additionCompound: {
                this.buildAdditionCompound(words);
                break;
            }
            case glycol: {
                this.buildGlycol(words);
                break;
            }
            case glycolEther: {
                this.buildGlycolEther(words);
                break;
            }
            case acetal: {
                this.buildAcetal(words);
                break;
            }
            case potentialAlcoholEster: {
                if (this.buildAlcoholEster(words, this.currentTopLevelWordRuleCount)) break;
                this.splitAlcoholEsterRuleIntoTwoSimpleWordRules(words);
                ++this.currentTopLevelWordRuleCount;
                break;
            }
            case cyclicPeptide: {
                this.buildCyclicPeptide(words);
                break;
            }
            case amineDiConjunctiveSuffix: {
                this.buildAmineDiConjunctiveSuffix(words);
                break;
            }
            case polymer: {
                this.buildPolymer(words);
                break;
            }
            default: {
                throw new StructureBuildingException("Unexpected Word Rule");
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void buildEster(List<Element> words) throws StructureBuildingException {
        boolean inSubstituents = true;
        BuildResults substituentsBr = new BuildResults();
        ArrayList<Object> ateGroups = new ArrayList<Object>();
        HashMap<Object, String> buildResultsToLocant = new HashMap<Object, String>();
        for (Element word : words) {
            StructureBuildingMethods.resolveWordOrBracket(this.state, word);
            Object br = new BuildResults(word);
            if (inSubstituents && ((BuildResults)br).getFunctionalAtomCount() > 0) {
                inSubstituents = false;
            }
            if (inSubstituents) {
                if (!word.getAttributeValue("type").equals(WordType.substituent.toString())) {
                    if (word.getAttributeValue("type").equals(WordType.full.toString())) {
                        throw new StructureBuildingException("bug? ate group did not have any functional atoms!");
                    }
                    throw new StructureBuildingException("OPSIN bug: Non substituent word found where substituent expected in ester");
                }
                int outAtomCount = ((BuildResults)br).getOutAtomCount();
                boolean traditionalEster = false;
                for (int i = 0; i < outAtomCount; ++i) {
                    OutAtom out = ((BuildResults)br).getOutAtom(i);
                    if (out.getValency() <= 1) continue;
                    FragmentTools.splitOutAtomIntoValency1OutAtoms(out);
                    traditionalEster = true;
                }
                if (traditionalEster) {
                    br = new BuildResults(word);
                    outAtomCount = ((BuildResults)br).getOutAtomCount();
                }
                if (outAtomCount == 1) {
                    String locantForSubstituent = word.getAttributeValue("locant");
                    if (locantForSubstituent != null) {
                        ((BuildResults)br).getFirstOutAtom().setLocant(locantForSubstituent);
                    }
                } else if (outAtomCount == 0) {
                    throw new StructureBuildingException("Substituent was expected to have at least one outAtom");
                }
                substituentsBr.mergeBuildResults((BuildResults)br);
                continue;
            }
            String locant = word.getAttributeValue("locant");
            if (((BuildResults)br).getFunctionalAtomCount() < 1) {
                throw new StructureBuildingException("bug? ate group did not have any functional atoms!");
            }
            ateGroups.add(br);
            buildResultsToLocant.put(br, locant);
        }
        if (ateGroups.isEmpty()) {
            throw new StructureBuildingException("OPSIN bug: Missing ate group in ester");
        }
        int outAtomCount = substituentsBr.getOutAtomCount();
        if (outAtomCount == 0) {
            throw new StructureBuildingException("OPSIN bug: Missing outatom on ester substituents");
        }
        int esterIdCount = 0;
        for (BuildResults br : ateGroups) {
            esterIdCount += br.getFunctionalAtomCount();
        }
        if (outAtomCount > esterIdCount) {
            throw new StructureBuildingException("There are more radicals in the substituents(" + outAtomCount + ") than there are places to form esters(" + esterIdCount + ")");
        }
        if (esterIdCount > outAtomCount && outAtomCount % ateGroups.size() != 0) {
            throw new StructureBuildingException("There are less radicals in the substituents(" + outAtomCount + ") than there are places to form esters(" + esterIdCount + ")");
        }
        for (int i = 0; i < outAtomCount; ++i) {
            Atom ateAtom;
            BuildResults ateBr = (BuildResults)ateGroups.get(i % ateGroups.size());
            if (substituentsBr.getFirstOutAtom().getLocant() != null) {
                ateAtom = this.determineFunctionalAtomToUse(substituentsBr.getFirstOutAtom().getLocant(), ateBr);
            } else {
                ateAtom = ateBr.getFunctionalAtom(0);
                ateBr.removeFunctionalAtom(0);
            }
            String locant = (String)buildResultsToLocant.get(ateBr);
            if (locant == null) {
                Atom atomOnSubstituentToUse = this.getOutAtomTakingIntoAccountWhetherSetExplicitly(substituentsBr, 0);
                this.state.fragManager.createBond(ateAtom, atomOnSubstituentToUse, 1);
                substituentsBr.removeOutAtom(0);
            } else {
                Integer outAtomPosition = null;
                for (int j = 0; j < substituentsBr.getOutAtomCount(); ++j) {
                    if (!substituentsBr.getOutAtom(j).getAtom().hasLocant(locant)) continue;
                    outAtomPosition = j;
                    break;
                }
                if (outAtomPosition == null) {
                    throw new StructureBuildingException("Unable to find substituent with locant: " + locant + " to form ester!");
                }
                Atom atomOnSubstituentToUse = substituentsBr.getOutAtom(outAtomPosition).getAtom();
                this.state.fragManager.createBond(ateAtom, atomOnSubstituentToUse, 1);
                substituentsBr.removeOutAtom(outAtomPosition);
            }
            ateAtom.neutraliseCharge();
        }
    }

    private void buildDiValentFunctionalGroup(List<Element> words) throws StructureBuildingException {
        BuildResults substituent2;
        int wordIndice = 0;
        if (!words.get(wordIndice).getAttributeValue("type").equals(WordType.substituent.toString())) {
            throw new StructureBuildingException("word: " + wordIndice + " was expected to be a substituent");
        }
        StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(wordIndice));
        BuildResults substituent1 = new BuildResults(words.get(wordIndice));
        if (substituent1.getOutAtom(0).getValency() != 1) {
            throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + substituent1.getOutAtom(0).getValency());
        }
        if (substituent1.getOutAtomCount() == 2) {
            if (substituent1.getOutAtom(1).getValency() != 1) {
                throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + substituent1.getOutAtom(1).getValency());
            }
            substituent2 = substituent1;
        } else {
            if (substituent1.getOutAtomCount() != 1) {
                throw new StructureBuildingException("Expected one outAtom. Found " + substituent1.getOutAtomCount());
            }
            if (words.get(++wordIndice).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
                Element clone = this.state.fragManager.cloneElement(this.state, words.get(0));
                OpsinTools.insertAfter(words.get(0), clone);
                words = words.get(0).getParent().getChildElements();
            } else {
                StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(wordIndice));
            }
            substituent2 = new BuildResults(words.get(wordIndice));
            if (substituent2.getOutAtomCount() != 1) {
                throw new StructureBuildingException("Expected one outAtom. Found " + substituent2.getOutAtomCount());
            }
            if (substituent2.getOutAtom(0).getValency() != 1) {
                throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + substituent2.getOutAtom(0).getValency());
            }
        }
        if (words.get(++wordIndice) == null || !words.get(wordIndice).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            throw new StructureBuildingException(words.get(wordIndice).getValue() + " was expected to be a functionalTerm");
        }
        List<Element> functionalGroup = OpsinTools.getDescendantElementsWithTagName(words.get(wordIndice), "functionalGroup");
        if (functionalGroup.size() != 1) {
            throw new StructureBuildingException("Unexpected number of functionalGroups found, could be a bug in OPSIN's grammar");
        }
        String smilesOfGroup = functionalGroup.get(0).getAttributeValue("value");
        Fragment diValentGroup = this.state.fragManager.buildSMILES(smilesOfGroup, "functionalClass", "none");
        Atom outAtom1 = this.getOutAtomTakingIntoAccountWhetherSetExplicitly(substituent1, 0);
        substituent1.removeOutAtom(0);
        Atom outAtom2 = this.getOutAtomTakingIntoAccountWhetherSetExplicitly(substituent2, 0);
        substituent2.removeOutAtom(0);
        if (diValentGroup.getOutAtomCount() == 1) {
            this.state.fragManager.createBond(outAtom1, diValentGroup.getOutAtom(0).getAtom(), 1);
            diValentGroup.removeOutAtom(0);
            this.state.fragManager.createBond(outAtom2, diValentGroup.getFirstAtom(), 1);
        } else if (outAtom1 != outAtom2) {
            this.state.fragManager.createBond(outAtom1, diValentGroup.getFirstAtom(), 1);
            this.state.fragManager.createBond(outAtom2, diValentGroup.getFirstAtom(), 1);
        } else {
            this.state.fragManager.createBond(outAtom1, diValentGroup.getFirstAtom(), 2);
        }
        this.state.fragManager.incorporateFragment(diValentGroup, outAtom1.getFrag());
    }

    private void buildMonovalentFunctionalGroup(List<Element> words) throws StructureBuildingException {
        StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(0));
        List<Element> groups = OpsinTools.getDescendantElementsWithTagName(words.get(0), "group");
        for (Element group : groups) {
            Fragment frag = group.getFrag();
            for (int i = frag.getOutAtomCount() - 1; i >= 0; --i) {
                OutAtom outAtom = frag.getOutAtom(i);
                if (outAtom.getValency() <= 1) continue;
                FragmentTools.splitOutAtomIntoValency1OutAtoms(outAtom);
            }
        }
        BuildResults substituentBR = new BuildResults(words.get(0));
        ArrayList<Fragment> functionalGroupFragments = new ArrayList<Fragment>();
        for (int i = 1; i < words.size(); ++i) {
            Element functionalGroupWord = words.get(i);
            List<Element> functionalGroups = OpsinTools.getDescendantElementsWithTagName(functionalGroupWord, "functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new StructureBuildingException("Expected exactly 1 functionalGroup. Found " + functionalGroups.size());
            }
            Fragment monoValentFunctionGroup = this.state.fragManager.buildSMILES(functionalGroups.get(0).getAttributeValue("value"), "functionalClass", "none");
            if (functionalGroups.get(0).getAttributeValue("type").equals("monoValentStandaloneGroup")) {
                Atom ideAtom = monoValentFunctionGroup.getDefaultInAtomOrFirstAtom();
                ideAtom.addChargeAndProtons(1, 1);
            }
            Element possibleMultiplier = OpsinTools.getPreviousSibling(functionalGroups.get(0));
            functionalGroupFragments.add(monoValentFunctionGroup);
            if (possibleMultiplier == null) continue;
            int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
            for (int j = 1; j < multiplierValue; ++j) {
                functionalGroupFragments.add(this.state.fragManager.copyFragment(monoValentFunctionGroup));
            }
            possibleMultiplier.detach();
        }
        int outAtomCount = substituentBR.getOutAtomCount();
        if (outAtomCount > functionalGroupFragments.size()) {
            if (functionalGroupFragments.size() != 1) {
                throw new StructureBuildingException("Incorrect number of functional groups found to balance outAtoms");
            }
            Fragment monoValentFunctionGroup = (Fragment)functionalGroupFragments.get(0);
            for (int j = 1; j < outAtomCount; ++j) {
                functionalGroupFragments.add(this.state.fragManager.copyFragment(monoValentFunctionGroup));
            }
        } else if (functionalGroupFragments.size() > outAtomCount) {
            throw new StructureBuildingException("There are more function groups to attach than there are positions to attach them to!");
        }
        for (int i = 0; i < outAtomCount; ++i) {
            Fragment ideFrag = (Fragment)functionalGroupFragments.get(i);
            Atom ideAtom = ideFrag.getDefaultInAtomOrFirstAtom();
            Atom subAtom = this.getOutAtomTakingIntoAccountWhetherSetExplicitly(substituentBR, 0);
            this.state.fragManager.createBond(ideAtom, subAtom, 1);
            substituentBR.removeOutAtom(0);
            this.state.fragManager.incorporateFragment(ideFrag, subAtom.getFrag());
        }
    }

    private void buildFunctionalClassEster(List<Element> words) throws StructureBuildingException {
        Element firstWord = words.get(0);
        if (!firstWord.getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("Don't alter wordRules.xml without checking the consequences!");
        }
        StructureBuildingMethods.resolveWordOrBracket(this.state, firstWord);
        BuildResults acidBr = new BuildResults(firstWord);
        if (acidBr.getFunctionalAtomCount() == 0) {
            throw new StructureBuildingException("No functionalAtoms detected!");
        }
        int wordCountMinus1 = words.size() - 1;
        if (wordCountMinus1 < 2 || !words.get(wordCountMinus1).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            throw new StructureBuildingException("OPSIN Bug: Bug in functionalClassEster rule; 'ester' not found where it was expected");
        }
        for (int i = 1; i < wordCountMinus1; ++i) {
            Element currentWord = words.get(i);
            String wordType = currentWord.getAttributeValue("type");
            if (!wordType.equals(WordType.substituent.toString())) {
                if (wordType.equals(WordType.functionalTerm.toString()) && currentWord.getAttributeValue("value").equalsIgnoreCase("ester")) continue;
                throw new StructureBuildingException("OPSIN Bug: Bug in functionalClassEster rule; Encountered: " + currentWord.getAttributeValue("value"));
            }
            StructureBuildingMethods.resolveWordOrBracket(this.state, currentWord);
            BuildResults substituentBr = new BuildResults(currentWord);
            int outAtomCount = substituentBr.getOutAtomCount();
            if (acidBr.getFunctionalAtomCount() < outAtomCount) {
                throw new StructureBuildingException("Insufficient functionalAtoms on acid");
            }
            for (int j = 0; j < outAtomCount; ++j) {
                Atom functionalAtom;
                String locantForSubstituent = currentWord.getAttributeValue("locant");
                if (locantForSubstituent != null) {
                    functionalAtom = this.determineFunctionalAtomToUse(locantForSubstituent, acidBr);
                } else {
                    functionalAtom = acidBr.getFunctionalAtom(0);
                    acidBr.removeFunctionalAtom(0);
                }
                if (substituentBr.getOutAtom(j).getValency() != 1) {
                    throw new StructureBuildingException("Substituent was expected to have only have an outgoing valency of 1");
                }
                this.state.fragManager.createBond(functionalAtom, this.getOutAtomTakingIntoAccountWhetherSetExplicitly(substituentBr, j), 1);
                if (functionalAtom.getCharge() != -1) continue;
                functionalAtom.neutraliseCharge();
            }
            substituentBr.removeAllOutAtoms();
        }
    }

    private void buildOxide(List<Element> words) throws StructureBuildingException {
        Element rightMostGroup;
        StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(0));
        ArrayList<Fragment> oxideFragments = new ArrayList<Fragment>();
        ArrayList<String> locantsForOxide = new ArrayList<String>();
        if (!words.get(1).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            throw new StructureBuildingException("Oxide functional term not found where expected!");
        }
        if (words.get(0).getName().equals("wordRule")) {
            List<Element> fullWords = OpsinTools.getDescendantElementsWithTagNameAndAttribute(words.get(0), "word", "type", WordType.full.toString());
            if (fullWords.isEmpty()) {
                throw new StructureBuildingException("OPSIN is entirely unsure where the oxide goes so has decided not to guess");
            }
            rightMostGroup = StructureBuildingMethods.findRightMostGroupInBracket(fullWords.get(fullWords.size() - 1));
        } else {
            rightMostGroup = StructureBuildingMethods.findRightMostGroupInBracket(words.get(0));
        }
        int numberOfOxygenToAdd = 1;
        List<Element> multipliers = OpsinTools.getDescendantElementsWithTagName(words.get(1), "multiplier");
        if (multipliers.size() > 1) {
            throw new StructureBuildingException("Expected 0 or 1 multiplier found: " + multipliers.size());
        }
        if (multipliers.size() == 1) {
            numberOfOxygenToAdd = Integer.parseInt(multipliers.get(0).getAttributeValue("value"));
            multipliers.get(0).detach();
        } else if ("elementaryAtom".equals(rightMostGroup.getAttributeValue("type"))) {
            int valency;
            Atom elementaryAtom = rightMostGroup.getFrag().getFirstAtom();
            int charge = elementaryAtom.getCharge();
            if (charge > 0 && charge % 2 == 0) {
                numberOfOxygenToAdd = charge / 2;
            } else if (elementaryAtom.getProperty(Atom.OXIDATION_NUMBER) != null && (valency = elementaryAtom.getProperty(Atom.OXIDATION_NUMBER) - elementaryAtom.getIncomingValency()) > 0 && valency % 2 == 0) {
                numberOfOxygenToAdd = valency / 2;
            }
        }
        List<Element> functionalGroup = OpsinTools.getDescendantElementsWithTagName(words.get(1), "functionalGroup");
        if (functionalGroup.size() != 1) {
            throw new StructureBuildingException("Expected 1 group element found: " + functionalGroup.size());
        }
        String smilesReplacement = functionalGroup.get(0).getAttributeValue("value");
        String labels = functionalGroup.get(0).getAttributeValue("labels");
        for (int i = 0; i < numberOfOxygenToAdd; ++i) {
            oxideFragments.add(this.state.fragManager.buildSMILES(smilesReplacement, "functionalClass", labels != null ? labels : "none"));
        }
        List<Element> locantEls = OpsinTools.getDescendantElementsWithTagName(words.get(1), "locant");
        if (locantEls.size() > 1) {
            throw new StructureBuildingException("Expected 0 or 1 locant elements found: " + locantEls.size());
        }
        if (locantEls.size() == 1) {
            String[] locants = StringTools.removeDashIfPresent(locantEls.get(0).getValue()).split(",");
            locantsForOxide.addAll(Arrays.asList(locants));
            locantEls.get(0).detach();
        }
        if (!locantsForOxide.isEmpty() && locantsForOxide.size() != oxideFragments.size()) {
            throw new StructureBuildingException("Mismatch between number of locants and number of oxides specified");
        }
        Fragment groupToModify = rightMostGroup.getFrag();
        block1: for (int i = 0; i < oxideFragments.size(); ++i) {
            Atom oxideAtom = ((Fragment)oxideFragments.get(i)).getFirstAtom();
            if (!locantsForOxide.isEmpty()) {
                Atom atomToAddOxideTo = groupToModify.getAtomByLocantOrThrow((String)locantsForOxide.get(i));
                if (atomToAddOxideTo.getElement() == ChemEl.C && !"elementaryAtom".equals(groupToModify.getType())) {
                    throw new StructureBuildingException("Locant " + (String)locantsForOxide.get(i) + " indicated oxide applied to carbon, but this would lead to hypervalency!");
                }
                this.formAppropriateBondToOxideAndAdjustCharges(atomToAddOxideTo, oxideAtom);
                continue;
            }
            if ("elementaryAtom".equals(groupToModify.getType())) {
                Atom elementaryAtom = groupToModify.getFirstAtom();
                this.formAppropriateBondToOxideAndAdjustCharges(elementaryAtom, oxideAtom);
                int chargeOnAtom = elementaryAtom.getCharge();
                if (chargeOnAtom < 2) continue;
                elementaryAtom.setCharge(chargeOnAtom - 2);
                continue;
            }
            List<Atom> atomList = groupToModify.getAtomList();
            for (Atom atom : atomList) {
                if (!atom.getType().equals("suffix") || atom.getElement() == ChemEl.C || atom.getElement() == ChemEl.O) continue;
                this.formAppropriateBondToOxideAndAdjustCharges(atom, oxideAtom);
                continue block1;
            }
            for (Atom atom : atomList) {
                if (atom.getElement() == ChemEl.C || atom.getElement() == ChemEl.O) continue;
                this.formAppropriateBondToOxideAndAdjustCharges(atom, oxideAtom);
                continue block1;
            }
            Set<Bond> bondSet = groupToModify.getBondSet();
            for (Bond bond : bondSet) {
                if (bond.getOrder() != 2 || bond.getFromAtom().getElement() != ChemEl.C || bond.getToAtom().getElement() != ChemEl.C) continue;
                bond.setOrder(1);
                this.state.fragManager.createBond(bond.getFromAtom(), oxideAtom, 1);
                this.state.fragManager.createBond(bond.getToAtom(), oxideAtom, 1);
                continue block1;
            }
            for (Bond bond : bondSet) {
                Atom fromAtom = bond.getFromAtom();
                Atom toAtom = bond.getToAtom();
                if (!fromAtom.hasSpareValency() || !toAtom.hasSpareValency() || fromAtom.getElement() != ChemEl.C || toAtom.getElement() != ChemEl.C) continue;
                fromAtom.setSpareValency(false);
                toAtom.setSpareValency(false);
                this.state.fragManager.createBond(fromAtom, oxideAtom, 1);
                this.state.fragManager.createBond(toAtom, oxideAtom, 1);
                continue block1;
            }
            List<Atom> atomList2 = groupToModify.getAtomList();
            for (Atom atom : atomList2) {
                if (!atom.getType().equals("suffix") || atom.getElement() == ChemEl.C) continue;
                this.formAppropriateBondToOxideAndAdjustCharges(atom, oxideAtom);
                continue block1;
            }
            for (Atom atom : atomList2) {
                if (atom.getElement() == ChemEl.C) continue;
                this.formAppropriateBondToOxideAndAdjustCharges(atom, oxideAtom);
                continue block1;
            }
            throw new StructureBuildingException("Unable to find suitable atom or a double bond to add oxide to");
        }
        for (Fragment oxide : oxideFragments) {
            this.state.fragManager.incorporateFragment(oxide, groupToModify);
        }
    }

    private void formAppropriateBondToOxideAndAdjustCharges(Atom atomToAddOxideTo, Atom oxideAtom) throws StructureBuildingException {
        Integer maxVal = ValencyChecker.getMaximumValency(atomToAddOxideTo.getElement(), atomToAddOxideTo.getCharge());
        if (maxVal == null || atomToAddOxideTo.getIncomingValency() + atomToAddOxideTo.getOutValency() + 2 <= maxVal) {
            if (atomToAddOxideTo.getLambdaConventionValency() == null || !ValencyChecker.checkValencyAvailableForBond(atomToAddOxideTo, 2)) {
                atomToAddOxideTo.addChargeAndProtons(0, 2);
            }
            this.state.fragManager.createBond(atomToAddOxideTo, oxideAtom, 2);
        } else {
            if (atomToAddOxideTo.getCharge() != 0 || oxideAtom.getCharge() != 0) {
                throw new StructureBuildingException("Oxide appeared to refer to an atom that has insufficent valency to accept the addition of oxygen");
            }
            atomToAddOxideTo.addChargeAndProtons(1, 1);
            oxideAtom.addChargeAndProtons(-1, -1);
            maxVal = ValencyChecker.getMaximumValency(atomToAddOxideTo.getElement(), atomToAddOxideTo.getCharge());
            if (maxVal != null && atomToAddOxideTo.getIncomingValency() + atomToAddOxideTo.getOutValency() + 1 > maxVal) {
                throw new StructureBuildingException("Oxide appeared to refer to an atom that has insufficent valency to accept the addition of oxygen");
            }
            this.state.fragManager.createBond(atomToAddOxideTo, oxideAtom, 1);
        }
    }

    private void buildCarbonylDerivative(List<Element> words) throws StructureBuildingException {
        if (!WordType.full.toString().equals(words.get(0).getAttributeValue("type"))) {
            throw new StructureBuildingException("OPSIN bug: Wrong word type encountered when applying carbonylDerivative wordRule");
        }
        ArrayList<Fragment> replacementFragments = new ArrayList<Fragment>();
        ArrayList<String> locantForFunctionalTerm = new ArrayList<String>();
        if (!words.get(1).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            for (int i = 1; i < words.size(); ++i) {
                Fragment frag = this.findRightMostGroupInWordOrWordRule(words.get(i)).getFrag();
                replacementFragments.add(frag);
                List<Element> children = words.get(i).getChildElements();
                if (children.size() == 1 && children.get(0).getName().equals("bracket") && children.get(0).getAttribute("locant") != null) {
                    locantForFunctionalTerm.add(children.get(0).getAttributeValue("locant"));
                    continue;
                }
                if (children.size() != 2 || children.get(0).getAttribute("locant") == null) continue;
                String locant = children.get(0).getAttributeValue("locant");
                if (!children.get(1).getName().equals("root") || frag.hasLocant(locant) || !OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) continue;
                locantForFunctionalTerm.add(children.get(0).getAttributeValue("locant"));
                children.get(0).removeAttribute(children.get(0).getAttribute("locant"));
            }
        } else {
            List<Element> functionalGroup;
            int numberOfCarbonylReplacements = 1;
            List<Element> multipliers = OpsinTools.getDescendantElementsWithTagName(words.get(1), "multiplier");
            if (multipliers.size() > 1) {
                throw new StructureBuildingException("Expected 0 or 1 multiplier found: " + multipliers.size());
            }
            if (multipliers.size() == 1) {
                numberOfCarbonylReplacements = Integer.parseInt(multipliers.get(0).getAttributeValue("value"));
                multipliers.get(0).detach();
            }
            if ((functionalGroup = OpsinTools.getDescendantElementsWithTagName(words.get(1), "functionalGroup")).size() != 1) {
                throw new StructureBuildingException("Expected 1 functionalGroup element found: " + functionalGroup.size());
            }
            String smilesReplacement = functionalGroup.get(0).getAttributeValue("value");
            String labels = functionalGroup.get(0).getAttributeValue("labels");
            for (int i = 0; i < numberOfCarbonylReplacements; ++i) {
                Fragment replacementFragment = this.state.fragManager.buildSMILES(smilesReplacement, "functionalClass", labels != null ? labels : "none");
                if (i > 0) {
                    FragmentTools.relabelLocants(replacementFragment.getAtomList(), StringTools.multiplyString("'", i));
                }
                List<Atom> atomList = replacementFragment.getAtomList();
                for (Atom atom : atomList) {
                    atom.removeLocantsOtherThanElementSymbolLocants();
                }
                replacementFragments.add(replacementFragment);
            }
            List<Element> locantEls = OpsinTools.getDescendantElementsWithTagName(words.get(1), "locant");
            if (locantEls.size() > 1) {
                throw new StructureBuildingException("Expected 0 or 1 locant elements found: " + locantEls.size());
            }
            if (locantEls.size() == 1) {
                String[] locants = StringTools.removeDashIfPresent(locantEls.get(0).getValue()).split(",");
                locantForFunctionalTerm.addAll(Arrays.asList(locants));
                locantEls.get(0).detach();
            }
        }
        if (!locantForFunctionalTerm.isEmpty() && locantForFunctionalTerm.size() != replacementFragments.size()) {
            throw new StructureBuildingException("Mismatch between number of locants and number of carbonyl replacements");
        }
        Element rightMostGroup = this.findRightMostGroupInWordOrWordRule(words.get(0));
        Element parent = rightMostGroup.getParent();
        boolean multiplied = false;
        while (!parent.equals(words.get(0))) {
            if (parent.getAttribute("multiplier") != null) {
                multiplied = true;
            }
            parent = parent.getParent();
        }
        if (!multiplied) {
            List<Atom> carbonylOxygens = this.findCarbonylOxygens(rightMostGroup.getFrag(), locantForFunctionalTerm);
            int replacementsToPerform = Math.min(replacementFragments.size(), carbonylOxygens.size());
            this.replaceCarbonylOxygenWithReplacementFragments(words, replacementFragments, carbonylOxygens, replacementsToPerform);
        }
        StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(0));
        if (replacementFragments.size() > 0) {
            BuildResults br = new BuildResults(words.get(0));
            ArrayList<Atom> carbonylOxygens = new ArrayList<Atom>();
            ArrayList<Fragment> fragments = new ArrayList<Fragment>(br.getFragments());
            ListIterator iterator = fragments.listIterator(fragments.size());
            while (iterator.hasPrevious()) {
                carbonylOxygens.addAll(this.findCarbonylOxygens((Fragment)iterator.previous(), locantForFunctionalTerm));
            }
            this.replaceCarbonylOxygenWithReplacementFragments(words, replacementFragments, carbonylOxygens, replacementFragments.size());
        }
    }

    private void replaceCarbonylOxygenWithReplacementFragments(List<Element> words, List<Fragment> replacementFragments, List<Atom> carbonylOxygens, int functionalReplacementsToPerform) throws StructureBuildingException {
        if (functionalReplacementsToPerform > carbonylOxygens.size()) {
            throw new StructureBuildingException("Insufficient carbonyl groups found!");
        }
        for (int i = 0; i < functionalReplacementsToPerform; ++i) {
            Object numericLocantAtomConnectedToCarbonyl;
            Atom carbonylOxygen = carbonylOxygens.remove(0);
            Fragment carbonylFrag = carbonylOxygen.getFrag();
            Fragment replacementFrag = replacementFragments.remove(0);
            List<Atom> atomList = replacementFrag.getAtomList();
            if (atomList.size() == 2 && (numericLocantAtomConnectedToCarbonyl = OpsinTools.depthFirstSearchForAtomWithNumericLocant(carbonylOxygen)) != null) {
                Atom lastatom = atomList.get(1);
                lastatom.addLocant(lastatom.getElement().toString() + ((Atom)numericLocantAtomConnectedToCarbonyl).getFirstLocant());
            }
            if (!words.get(1).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
                StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(1 + i));
            }
            numericLocantAtomConnectedToCarbonyl = atomList.iterator();
            while (numericLocantAtomConnectedToCarbonyl.hasNext()) {
                Atom atom = (Atom)numericLocantAtomConnectedToCarbonyl.next();
                atom.removeLocantsOtherThanElementSymbolLocants();
                List<String> locants = atom.getLocants();
                for (int j = locants.size() - 1; j >= 0; --j) {
                    String locant = locants.get(j);
                    if (!carbonylFrag.hasLocant(locant)) continue;
                    atom.removeLocant(locant);
                }
            }
            if (replacementFrag.getOutAtomCount() == 2) {
                Atom carbonylCarbon = carbonylOxygen.getFirstBond().getOtherAtom(carbonylOxygen);
                OutAtom outAtom = replacementFrag.getOutAtom(1);
                replacementFrag.removeOutAtom(outAtom);
                if (carbonylCarbon.getIncomingValency() >= 4) {
                    throw new StructureBuildingException("Insufficient substitutable hydrogen for haloxime");
                }
                this.state.fragManager.createBond(carbonylCarbon, outAtom.getAtom(), outAtom.getValency());
            }
            if (replacementFrag.getOutAtomCount() != 1) {
                throw new RuntimeException("OPSIN Bug: Carbonyl replacement fragment expected to have one outatom");
            }
            Atom atomToReplaceCarbonylOxygen = replacementFrag.getOutAtom(0).getAtom();
            replacementFrag.removeOutAtom(0);
            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(carbonylOxygen, atomToReplaceCarbonylOxygen);
            atomToReplaceCarbonylOxygen.setType(carbonylOxygen.getType());
            if (replacementFrag.getTokenEl().getParent() != null) continue;
            this.state.fragManager.incorporateFragment(replacementFrag, carbonylFrag);
        }
    }

    private List<Atom> findCarbonylOxygens(Fragment fragment, List<String> locantForCarbonylAtom) throws StructureBuildingException {
        ArrayList<Atom> matches = new ArrayList<Atom>();
        List<Atom> rootFragAtomList = fragment.getAtomList();
        for (Atom atom : rootFragAtomList) {
            Bond b;
            List<Atom> neighbours;
            if (atom.getElement() != ChemEl.O || atom.getCharge() != 0 || (neighbours = atom.getAtomNeighbours()).size() != 1 || neighbours.get(0).getElement() != ChemEl.C) continue;
            if (!locantForCarbonylAtom.isEmpty()) {
                Atom numericLocantAtomConnectedToCarbonyl = OpsinTools.depthFirstSearchForAtomWithNumericLocant(atom);
                if (numericLocantAtomConnectedToCarbonyl == null) continue;
                boolean matchesLocant = false;
                for (String locant : locantForCarbonylAtom) {
                    if (!numericLocantAtomConnectedToCarbonyl.hasLocant(locant)) continue;
                    matchesLocant = true;
                }
                if (!matchesLocant) continue;
            }
            if ((b = atom.getBondToAtomOrThrow(neighbours.get(0))).getOrder() != 2) continue;
            matches.add(atom);
        }
        return matches;
    }

    private void buildAnhydride(List<Element> words) throws StructureBuildingException {
        if (words.size() != 2 && words.size() != 3) {
            throw new StructureBuildingException("Unexpected number of words in anhydride. Check wordRules.xml, this is probably a bug");
        }
        Element anhydrideWord = words.get(words.size() - 1);
        List<Element> functionalClass = OpsinTools.getDescendantElementsWithTagName(anhydrideWord, "functionalGroup");
        if (functionalClass.size() != 1) {
            throw new StructureBuildingException("Expected 1 group element found: " + functionalClass.size());
        }
        String anhydrideSmiles = functionalClass.get(0).getAttributeValue("value");
        int numberOfAnhydrideLinkages = 1;
        List<Element> multipliers = OpsinTools.getDescendantElementsWithTagName(anhydrideWord, "multiplier");
        if (multipliers.size() > 1) {
            throw new StructureBuildingException("Expected 0 or 1 multiplier found: " + multipliers.size());
        }
        if (multipliers.size() == 1) {
            numberOfAnhydrideLinkages = Integer.parseInt(multipliers.get(0).getAttributeValue("value"));
            multipliers.get(0).detach();
        }
        String anhydrideLocant = null;
        List<Element> anhydrideLocants = OpsinTools.getDescendantElementsWithTagNames(anhydrideWord, new String[]{"locant", "colonOrSemiColonDelimitedLocant"});
        if (anhydrideLocants.size() > 1) {
            throw new StructureBuildingException("Expected 0 or 1 anhydrideLocants found: " + anhydrideLocants.size());
        }
        if (anhydrideLocants.size() == 1) {
            anhydrideLocant = anhydrideLocants.get(0).getValue();
            anhydrideLocants.get(0).detach();
        }
        StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(0));
        BuildResults br1 = new BuildResults(words.get(0));
        if (br1.getFunctionalAtomCount() == 0) {
            throw new StructureBuildingException("Cannot find functionalAtom to form anhydride");
        }
        if (words.size() == 3) {
            if (anhydrideLocant != null) {
                throw new StructureBuildingException("Unsupported or invalid anhydride");
            }
            StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(1));
            BuildResults br2 = new BuildResults(words.get(1));
            if (br2.getFunctionalAtomCount() == 0) {
                throw new StructureBuildingException("Cannot find functionalAtom to form anhydride");
            }
            if (numberOfAnhydrideLinkages > 1) {
                for (int i = numberOfAnhydrideLinkages - 1; i >= 0; --i) {
                    BuildResults newAcidBr;
                    if (br2.getFunctionalAtomCount() == 0) {
                        throw new StructureBuildingException("Cannot find functionalAtom to form anhydride");
                    }
                    if (i != 0) {
                        Element newAcid = this.state.fragManager.cloneElement(this.state, words.get(0));
                        OpsinTools.insertAfter(words.get(0), newAcid);
                        newAcidBr = new BuildResults(newAcid);
                    } else {
                        newAcidBr = br1;
                    }
                    this.formAnhydrideLink(anhydrideSmiles, newAcidBr, br2);
                }
            } else {
                if (br1.getFunctionalAtomCount() != 1 && br2.getFunctionalAtomCount() != 1) {
                    throw new StructureBuildingException("Invalid anhydride description");
                }
                this.formAnhydrideLink(anhydrideSmiles, br1, br2);
            }
        } else if (br1.getFunctionalAtomCount() > 1) {
            if (br1.getFunctionalAtomCount() == 2) {
                if (numberOfAnhydrideLinkages != 1 || anhydrideLocant != null) {
                    throw new StructureBuildingException("Unsupported or invalid anhydride");
                }
                this.formAnhydrideLink(anhydrideSmiles, br1, br1);
            } else {
                int i;
                if (anhydrideLocant == null) {
                    throw new StructureBuildingException("Anhydride formation appears to be ambiguous; More than 2 acids, no locants");
                }
                String[] acidLocants = OpsinTools.MATCH_COLONORSEMICOLON.split(StringTools.removeDashIfPresent(anhydrideLocant));
                if (acidLocants.length != numberOfAnhydrideLinkages) {
                    throw new StructureBuildingException("Mismatch between number of locants and number of anhydride linkages to form");
                }
                if (br1.getFunctionalAtomCount() < numberOfAnhydrideLinkages * 2) {
                    throw new StructureBuildingException("Mismatch between number of acid atoms and number of anhydride linkages to form");
                }
                ArrayList<Atom> functionalAtoms = new ArrayList<Atom>();
                for (i = 0; i < br1.getFunctionalAtomCount(); ++i) {
                    functionalAtoms.add(br1.getFunctionalAtom(i));
                }
                for (i = 0; i < numberOfAnhydrideLinkages; ++i) {
                    String[] locants = acidLocants[i].split(",");
                    Atom oxygen1 = null;
                    for (int j = functionalAtoms.size() - 1; j >= 0; --j) {
                        Atom functionalAtom = (Atom)functionalAtoms.get(j);
                        Atom numericLocantAtomConnectedToFunctionalAtom = OpsinTools.depthFirstSearchForAtomWithNumericLocant(functionalAtom);
                        if (!numericLocantAtomConnectedToFunctionalAtom.hasLocant(locants[0])) continue;
                        oxygen1 = functionalAtom;
                        functionalAtoms.remove(j);
                        break;
                    }
                    Atom oxygen2 = null;
                    for (int j = functionalAtoms.size() - 1; j >= 0; --j) {
                        Atom functionalAtom = (Atom)functionalAtoms.get(j);
                        Atom numericLocantAtomConnectedToFunctionalAtom = OpsinTools.depthFirstSearchForAtomWithNumericLocant(functionalAtom);
                        if (!numericLocantAtomConnectedToFunctionalAtom.hasLocant(locants[1])) continue;
                        oxygen2 = functionalAtom;
                        functionalAtoms.remove(j);
                        break;
                    }
                    if (oxygen1 == null || oxygen2 == null) {
                        throw new StructureBuildingException("Unable to find locanted atom for anhydride formation");
                    }
                    this.formAnhydrideLink(anhydrideSmiles, oxygen1, oxygen2);
                }
            }
        } else {
            if (numberOfAnhydrideLinkages != 1 || anhydrideLocant != null) {
                throw new StructureBuildingException("Unsupported or invalid anhydride");
            }
            Element newAcid = this.state.fragManager.cloneElement(this.state, words.get(0));
            OpsinTools.insertAfter(words.get(0), newAcid);
            BuildResults br2 = new BuildResults(newAcid);
            this.formAnhydrideLink(anhydrideSmiles, br1, br2);
        }
    }

    private void formAnhydrideLink(String anhydrideSmiles, BuildResults acidBr1, BuildResults acidBr2) throws StructureBuildingException {
        Atom oxygen1 = acidBr1.getFunctionalAtom(0);
        acidBr1.removeFunctionalAtom(0);
        Atom oxygen2 = acidBr2.getFunctionalAtom(0);
        acidBr2.removeFunctionalAtom(0);
        this.formAnhydrideLink(anhydrideSmiles, oxygen1, oxygen2);
    }

    private void formAnhydrideLink(String anhydrideSmiles, Atom oxygen1, Atom oxygen2) throws StructureBuildingException {
        if (oxygen1.getElement() != ChemEl.O || oxygen2.getElement() != ChemEl.O || oxygen1.getBondCount() != 1 || oxygen2.getBondCount() != 1) {
            throw new StructureBuildingException("Problem building anhydride");
        }
        Atom atomOnSecondAcidToConnectTo = oxygen2.getAtomNeighbours().get(0);
        this.state.fragManager.removeAtomAndAssociatedBonds(oxygen2);
        Fragment anhydride = this.state.fragManager.buildSMILES(anhydrideSmiles, "functionalClass", "none");
        Fragment acidFragment1 = oxygen1.getFrag();
        this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(oxygen1, anhydride.getFirstAtom());
        List<Atom> atomsInAnhydrideLinkage = anhydride.getAtomList();
        this.state.fragManager.createBond(atomsInAnhydrideLinkage.get(atomsInAnhydrideLinkage.size() - 1), atomOnSecondAcidToConnectTo, 1);
        this.state.fragManager.incorporateFragment(anhydride, acidFragment1);
    }

    private void buildAcidHalideOrPseudoHalide(List<Element> words) throws StructureBuildingException {
        if (!words.get(0).getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("Don't alter wordRules.xml without checking the consequences!");
        }
        StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(0));
        BuildResults acidBr = new BuildResults(words.get(0));
        int functionalAtomCount = acidBr.getFunctionalAtomCount();
        if (functionalAtomCount == 0) {
            throw new StructureBuildingException("No functionalAtoms detected!");
        }
        boolean monoMultiplierDetected = false;
        ArrayList<Fragment> functionalGroupFragments = new ArrayList<Fragment>();
        for (int i = 1; i < words.size(); ++i) {
            Element functionalGroupWord = words.get(i);
            List<Element> functionalGroups = OpsinTools.getDescendantElementsWithTagName(functionalGroupWord, "functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new StructureBuildingException("Expected exactly 1 functionalGroup. Found " + functionalGroups.size());
            }
            Fragment monoValentFunctionGroup = this.state.fragManager.buildSMILES(functionalGroups.get(0).getAttributeValue("value"), "functionalClass", "none");
            if (functionalGroups.get(0).getAttributeValue("type").equals("monoValentStandaloneGroup")) {
                Atom ideAtom = monoValentFunctionGroup.getDefaultInAtomOrFirstAtom();
                ideAtom.addChargeAndProtons(1, 1);
            }
            Element possibleMultiplier = OpsinTools.getPreviousSibling(functionalGroups.get(0));
            functionalGroupFragments.add(monoValentFunctionGroup);
            if (possibleMultiplier == null) continue;
            int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
            if (multiplierValue == 1) {
                monoMultiplierDetected = true;
            }
            for (int j = 1; j < multiplierValue; ++j) {
                functionalGroupFragments.add(this.state.fragManager.copyFragment(monoValentFunctionGroup));
            }
            possibleMultiplier.detach();
        }
        int halideCount = functionalGroupFragments.size();
        if (halideCount < functionalAtomCount && halideCount == 1 && !monoMultiplierDetected) {
            Fragment ideFrag = (Fragment)functionalGroupFragments.get(0);
            for (int i = halideCount; i < functionalAtomCount; ++i) {
                functionalGroupFragments.add(this.state.fragManager.copyFragment(ideFrag));
            }
            halideCount = functionalAtomCount;
        } else if (halideCount > functionalAtomCount || !monoMultiplierDetected && halideCount < functionalAtomCount) {
            throw new StructureBuildingException("Mismatch between number of halide/pseudo halide fragments and acidic oxygens");
        }
        for (int i = halideCount - 1; i >= 0; --i) {
            Fragment ideFrag = (Fragment)functionalGroupFragments.get(i);
            Atom ideAtom = ideFrag.getDefaultInAtomOrFirstAtom();
            Atom acidAtom = acidBr.getFunctionalAtom(i);
            if (acidAtom.getElement() != ChemEl.O) {
                throw new StructureBuildingException("Atom type expected to be oxygen but was: " + (Object)((Object)acidAtom.getElement()));
            }
            acidBr.removeFunctionalAtom(i);
            Fragment acidFragment = acidAtom.getFrag();
            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(acidAtom, ideAtom);
            this.state.fragManager.incorporateFragment(ideFrag, acidFragment);
        }
    }

    private void buildAdditionCompound(List<Element> words) throws StructureBuildingException {
        Element firstWord = words.get(0);
        if (!firstWord.getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("Don't alter wordRules.xml without checking the consequences!");
        }
        StructureBuildingMethods.resolveWordOrBracket(this.state, firstWord);
        Element elementaryAtomEl = StructureBuildingMethods.findRightMostGroupInBracket(firstWord);
        Fragment elementaryAtomFrag = elementaryAtomEl.getFrag();
        Atom elementaryAtom = elementaryAtomFrag.getFirstAtom();
        int charge = elementaryAtom.getCharge();
        ArrayList<Fragment> functionalGroupFragments = new ArrayList<Fragment>();
        for (int i = 1; i < words.size(); ++i) {
            int expectedValency;
            Element functionalGroupWord = words.get(i);
            List<Element> functionalGroups = OpsinTools.getDescendantElementsWithTagName(functionalGroupWord, "functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new StructureBuildingException("Expected exactly 1 functionalGroup. Found " + functionalGroups.size());
            }
            Element functionGroup = functionalGroups.get(0);
            Fragment monoValentFunctionGroup = this.state.fragManager.buildSMILES(functionGroup.getAttributeValue("value"), "functionalClass", "none");
            if (functionGroup.getAttributeValue("type").equals("monoValentStandaloneGroup")) {
                Atom ideAtom = monoValentFunctionGroup.getDefaultInAtomOrFirstAtom();
                ideAtom.addChargeAndProtons(1, 1);
            }
            Element possibleMultiplier = OpsinTools.getPreviousSibling(functionGroup);
            functionalGroupFragments.add(monoValentFunctionGroup);
            if (possibleMultiplier != null) {
                int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                for (int j = 1; j < multiplierValue; ++j) {
                    functionalGroupFragments.add(this.state.fragManager.copyFragment(monoValentFunctionGroup));
                }
                possibleMultiplier.detach();
                continue;
            }
            if (words.size() != 2) continue;
            int incomingBondOrder = elementaryAtom.getIncomingValency();
            if (charge > 0) {
                expectedValency = incomingBondOrder + charge;
            } else if (elementaryAtom.getProperty(Atom.OXIDATION_NUMBER) != null) {
                expectedValency = elementaryAtom.getProperty(Atom.OXIDATION_NUMBER);
            } else if (elementaryAtomEl.getAttribute("commonOxidationStatesAndMax") != null) {
                String[] typicalOxidationStates = elementaryAtomEl.getAttributeValue("commonOxidationStatesAndMax").split(":")[0].split(",");
                expectedValency = Integer.parseInt(typicalOxidationStates[0]);
            } else {
                expectedValency = ValencyChecker.getPossibleValencies(elementaryAtom.getElement(), charge)[0];
            }
            int implicitMultiplier = expectedValency - incomingBondOrder > 1 ? expectedValency - incomingBondOrder : 1;
            for (int j = 1; j < implicitMultiplier; ++j) {
                functionalGroupFragments.add(this.state.fragManager.copyFragment(monoValentFunctionGroup));
            }
        }
        if (charge > 0) {
            elementaryAtom.setCharge(charge - functionalGroupFragments.size());
        }
        this.applyAluminiumHydrideSpecialCase(firstWord, elementaryAtom, functionalGroupFragments);
        int halideCount = functionalGroupFragments.size();
        Integer maximumVal = ValencyChecker.getMaximumValency(elementaryAtom.getElement(), elementaryAtom.getCharge());
        if (maximumVal != null && halideCount > maximumVal) {
            throw new StructureBuildingException("Too many halides/psuedo halides addded to " + (Object)((Object)elementaryAtom.getElement()));
        }
        for (int i = halideCount - 1; i >= 0; --i) {
            Fragment ideFrag = (Fragment)functionalGroupFragments.get(i);
            Atom ideAtom = ideFrag.getDefaultInAtomOrFirstAtom();
            this.state.fragManager.incorporateFragment(ideFrag, ideAtom, elementaryAtomFrag, elementaryAtom, 1);
        }
    }

    private void applyAluminiumHydrideSpecialCase(Element firstWord, Atom elementaryAtom, List<Fragment> functionalGroupFragments) throws StructureBuildingException {
        if ((elementaryAtom.getElement() == ChemEl.Al || elementaryAtom.getElement() == ChemEl.B) && elementaryAtom.getCharge() == 0) {
            if (functionalGroupFragments.size() == 3) {
                ChemEl chemEl;
                Element group;
                Element root;
                Element word;
                Element counterCationWordRule;
                if (functionalGroupFragments.get(0).getDefaultInAtomOrFirstAtom().getElement() == ChemEl.H && functionalGroupFragments.get(1).getDefaultInAtomOrFirstAtom().getElement() == ChemEl.H && functionalGroupFragments.get(2).getDefaultInAtomOrFirstAtom().getElement() == ChemEl.H && (counterCationWordRule = OpsinTools.getPreviousSibling(firstWord.getParent())) != null && counterCationWordRule.getChildCount() == 1 && (word = counterCationWordRule.getFirstChildElement("word")) != null && word.getChildCount() == 1 && (root = word.getFirstChildElement("root")) != null && root.getChildCount() == 1 && (group = root.getFirstChildElement("group")) != null && "elementaryAtom".equals(group.getAttributeValue("type")) && ((chemEl = group.getFrag().getFirstAtom().getElement()) == ChemEl.Li || chemEl == ChemEl.Na || chemEl == ChemEl.K || chemEl == ChemEl.Rb || chemEl == ChemEl.Cs)) {
                    functionalGroupFragments.add(this.state.fragManager.copyFragment(functionalGroupFragments.get(0)));
                    elementaryAtom.setCharge(-1);
                }
            } else if (functionalGroupFragments.size() == 4 && functionalGroupFragments.get(0).getDefaultInAtomOrFirstAtom().getElement() == ChemEl.H && functionalGroupFragments.get(1).getDefaultInAtomOrFirstAtom().getElement() == ChemEl.H && functionalGroupFragments.get(2).getDefaultInAtomOrFirstAtom().getElement() == ChemEl.H && functionalGroupFragments.get(3).getDefaultInAtomOrFirstAtom().getElement() == ChemEl.H) {
                elementaryAtom.setCharge(-1);
            }
        }
    }

    private void buildGlycol(List<Element> words) throws StructureBuildingException {
        int wordIndice = 0;
        StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(wordIndice));
        Element finalGroup = this.findRightMostGroupInWordOrWordRule(words.get(wordIndice));
        Fragment theDiRadical = finalGroup.getFrag();
        if (theDiRadical.getOutAtomCount() != 2) {
            throw new StructureBuildingException("Glycol class names (e.g. ethylene glycol) expect two outAtoms. Found: " + theDiRadical.getOutAtomCount());
        }
        if (++wordIndice >= words.size() || !words.get(wordIndice).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            throw new StructureBuildingException("Glycol functionalTerm word expected");
        }
        List<Element> functionalClassEls = OpsinTools.getDescendantElementsWithTagName(words.get(wordIndice), "functionalClass");
        if (functionalClassEls.size() != 1) {
            throw new StructureBuildingException("Glycol functional class not found where expected");
        }
        OutAtom outAtom1 = theDiRadical.getOutAtom(0);
        Atom chosenAtom1 = outAtom1.isSetExplicitly() ? outAtom1.getAtom() : StructureBuildingMethods.findAtomForUnlocantedRadical(this.state, theDiRadical, outAtom1);
        Fragment functionalFrag = this.state.fragManager.buildSMILES(functionalClassEls.get(0).getAttributeValue("value"), "functionalClass", "none");
        if (outAtom1.getValency() != 1) {
            throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + outAtom1.getValency());
        }
        this.state.fragManager.createBond(chosenAtom1, functionalFrag.getFirstAtom(), 1);
        this.state.fragManager.incorporateFragment(functionalFrag, theDiRadical);
        OutAtom outAtom2 = theDiRadical.getOutAtom(1);
        Atom chosenAtom2 = outAtom2.isSetExplicitly() ? outAtom2.getAtom() : StructureBuildingMethods.findAtomForUnlocantedRadical(this.state, theDiRadical, outAtom2);
        Fragment hydroxy = this.state.fragManager.buildSMILES("O", "functionalClass", "none");
        if (outAtom2.getValency() != 1) {
            throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + outAtom2.getValency());
        }
        this.state.fragManager.createBond(chosenAtom2, hydroxy.getFirstAtom(), 1);
        this.state.fragManager.incorporateFragment(hydroxy, theDiRadical);
        theDiRadical.removeOutAtom(1);
        theDiRadical.removeOutAtom(0);
    }

    private void buildGlycolEther(List<Element> words) throws StructureBuildingException {
        ArrayList<Element> wordsToAttachToGlycol = new ArrayList<Element>();
        Element glycol = words.get(0);
        StructureBuildingMethods.resolveWordOrBracket(this.state, glycol);
        if (!glycol.getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("OPSIN Bug: Cannot find glycol word!");
        }
        for (int i = 1; i < words.size(); ++i) {
            Element wordOrWordRule = words.get(i);
            if (!wordOrWordRule.getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
                StructureBuildingMethods.resolveWordOrBracket(this.state, wordOrWordRule);
                wordsToAttachToGlycol.add(wordOrWordRule);
                continue;
            }
            if (wordOrWordRule.getAttributeValue("value").equalsIgnoreCase("ether")) continue;
            throw new StructureBuildingException("Unexpected word encountered when applying glycol ether word rule " + wordOrWordRule.getAttributeValue("value"));
        }
        int numOfEthers = wordsToAttachToGlycol.size();
        if (numOfEthers == 0) {
            throw new StructureBuildingException("OPSIN Bug: Unexpected number of substituents for glycol ether");
        }
        Element finalGroup = this.findRightMostGroupInWordOrWordRule(glycol);
        List<Atom> hydroxyAtoms = FragmentTools.findHydroxyGroups(finalGroup.getFrag());
        if (hydroxyAtoms.isEmpty()) {
            throw new StructureBuildingException("No hydroxy groups found in: " + finalGroup.getValue() + " to form ether");
        }
        if (hydroxyAtoms.size() < numOfEthers) {
            throw new StructureBuildingException("Insufficient hydroxy groups found in: " + finalGroup.getValue() + " to form required number of ethers");
        }
        for (int i = 0; i < numOfEthers; ++i) {
            BuildResults br = new BuildResults((Element)wordsToAttachToGlycol.get(i));
            if (br.getOutAtomCount() > 0) {
                this.state.fragManager.createBond(hydroxyAtoms.get(i), br.getOutAtom(0).getAtom(), 1);
                br.removeOutAtom(0);
                continue;
            }
            if (br.getFunctionalAtomCount() > 0) {
                Atom ateAtom = br.getFunctionalAtom(0);
                ateAtom.neutraliseCharge();
                this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(hydroxyAtoms.get(i), br.getFunctionalAtom(0));
                br.removeFunctionalAtom(0);
                continue;
            }
            throw new StructureBuildingException("Word had neither an outAtom or a functionalAtom! hence neither and ether or ester could be formed : " + ((Element)wordsToAttachToGlycol.get(i)).getAttributeValue("value"));
        }
    }

    private void buildAcetal(List<Element> words) throws StructureBuildingException {
        int bondsToForm;
        for (int i = 0; i < words.size() - 1; ++i) {
            StructureBuildingMethods.resolveWordOrBracket(this.state, words.get(i));
        }
        BuildResults substituentsBr = new BuildResults();
        for (int i = 1; i < words.size() - 1; ++i) {
            Element currentWord = words.get(i);
            BuildResults substituentBr = new BuildResults(currentWord);
            int outAtomCount = substituentBr.getOutAtomCount();
            if (outAtomCount == 1) {
                String locantForSubstituent = currentWord.getAttributeValue("locant");
                if (locantForSubstituent != null) {
                    substituentBr.getFirstOutAtom().setLocant(locantForSubstituent);
                }
            } else if (outAtomCount == 0) {
                throw new StructureBuildingException("Substituent was expected to have at least one outAtom");
            }
            substituentsBr.mergeBuildResults(substituentBr);
        }
        Element rightMostGroup = this.findRightMostGroupInWordOrWordRule(words.get(0));
        Fragment rootFragment = rightMostGroup.getFrag();
        List<Atom> carbonylOxygen = this.findCarbonylOxygens(rootFragment, new ArrayList<String>());
        Element functionalWord = words.get(words.size() - 1);
        List<Element> functionalClasses = OpsinTools.getDescendantElementsWithTagName(functionalWord, "functionalClass");
        if (functionalClasses.size() != 1) {
            throw new StructureBuildingException("OPSIN bug: unable to find acetal functionalClass");
        }
        Element functionalClassEl = functionalClasses.get(0);
        String functionalClass = functionalClassEl.getValue();
        Element beforeAcetal = OpsinTools.getPreviousSibling(functionalClassEl);
        int numberOfAcetals = 1;
        String[] elements = functionalClassEl.getAttributeValue("value").split(",");
        if (beforeAcetal != null) {
            if (beforeAcetal.getName().equals("multiplier")) {
                numberOfAcetals = Integer.parseInt(beforeAcetal.getAttributeValue("value"));
            } else {
                this.replaceChalcogensInAcetal(functionalClassEl, elements);
            }
        }
        if (carbonylOxygen.size() < numberOfAcetals) {
            throw new StructureBuildingException("Insufficient carbonyls to form " + numberOfAcetals + " " + functionalClass);
        }
        boolean hemiacetal = functionalClass.contains("hemi");
        ArrayList<Fragment> acetalFrags = new ArrayList<Fragment>();
        for (int i = 0; i < numberOfAcetals; ++i) {
            acetalFrags.add(this.formAcetal(carbonylOxygen, elements));
        }
        int n = bondsToForm = hemiacetal ? numberOfAcetals : 2 * numberOfAcetals;
        if (substituentsBr.getOutAtomCount() != bondsToForm) {
            throw new StructureBuildingException("incorrect number of susbtituents when forming " + functionalClass);
        }
        this.connectSubstituentsToAcetal(acetalFrags, substituentsBr, hemiacetal);
    }

    private void replaceChalcogensInAcetal(Element functionalClassEl, String[] elements) throws StructureBuildingException {
        Element currentEl = functionalClassEl.getParent().getChild(0);
        int multiplier = 1;
        if (currentEl.getName().equals("multiplier")) {
            multiplier = Integer.parseInt(currentEl.getAttributeValue("value"));
            if (multiplier > 2) {
                throw new StructureBuildingException(functionalClassEl.getValue() + " only has two oxygen!");
            }
            currentEl = OpsinTools.getNextSibling(currentEl);
        }
        int i = 0;
        while (currentEl != functionalClassEl) {
            if (currentEl.getName().equals("group")) {
                for (int j = 0; j < multiplier; ++j) {
                    if (i == 2) {
                        throw new StructureBuildingException(functionalClassEl.getValue() + " only has two oxygen!");
                    }
                    if (!elements[i].equals("O")) {
                        throw new StructureBuildingException("Replacement on " + functionalClassEl.getValue() + " can only be used to replace oxygen!");
                    }
                    elements[i++] = currentEl.getAttributeValue("value");
                }
            } else {
                throw new StructureBuildingException("Unexpected element before acetal");
            }
            currentEl = OpsinTools.getNextSibling(currentEl);
        }
    }

    private Fragment formAcetal(List<Atom> carbonylOxygen, String[] elements) throws StructureBuildingException {
        Atom neighbouringCarbon = carbonylOxygen.get(0).getAtomNeighbours().get(0);
        this.state.fragManager.removeAtomAndAssociatedBonds(carbonylOxygen.get(0));
        carbonylOxygen.remove(0);
        Fragment acetalFrag = this.state.fragManager.buildSMILES(StringTools.arrayToString(elements, "."), "", "none");
        FragmentTools.assignElementLocants(acetalFrag, new ArrayList<Fragment>());
        List<Atom> acetalAtomList = acetalFrag.getAtomList();
        Atom atom1 = acetalAtomList.get(0);
        this.state.fragManager.createBond(neighbouringCarbon, atom1, 1);
        Atom atom2 = acetalAtomList.get(1);
        this.state.fragManager.createBond(neighbouringCarbon, atom2, 1);
        this.state.fragManager.incorporateFragment(acetalFrag, neighbouringCarbon.getFrag());
        return acetalFrag;
    }

    private boolean buildAlcoholEster(List<Element> words, int numberOfWordRules) throws StructureBuildingException {
        int i;
        for (Element word : words) {
            if (!WordType.full.toString().equals(word.getAttributeValue("type"))) {
                throw new StructureBuildingException("Bug in word rule for potentialAlcoholEster");
            }
            StructureBuildingMethods.resolveWordOrBracket(this.state, word);
        }
        int ateWords = words.size() - 1;
        if (ateWords < 1) {
            throw new StructureBuildingException("Bug in word rule for potentialAlcoholEster");
        }
        Fragment potentialAlcoholFragment = this.findRightMostGroupInWordOrWordRule(words.get(0)).getFrag();
        List<Atom> hydroxyAtoms = FragmentTools.findHydroxyGroups(potentialAlcoholFragment);
        ArrayList<Atom> chosenHydroxyAtoms = new ArrayList<Atom>();
        ArrayList<BuildResults> ateBuildResults = new ArrayList<BuildResults>();
        for (i = 1; i < words.size(); ++i) {
            BuildResults wordBr;
            Element ateWord = words.get(i);
            if (this.isAppropriateAteGroupForAlcoholEster(ateWord, wordBr = new BuildResults(ateWord))) {
                Atom atomOnAlcoholFragment;
                String locant = ateWord.getAttributeValue("locant");
                if (locant != null) {
                    atomOnAlcoholFragment = potentialAlcoholFragment.getAtomByLocantOrThrow(locant);
                    if (!hydroxyAtoms.contains(atomOnAlcoholFragment) || chosenHydroxyAtoms.contains(atomOnAlcoholFragment)) {
                        atomOnAlcoholFragment = potentialAlcoholFragment.getAtomByLocantOrThrow("O" + locant);
                    }
                    if (!hydroxyAtoms.contains(atomOnAlcoholFragment) || chosenHydroxyAtoms.contains(atomOnAlcoholFragment)) {
                        throw new StructureBuildingException(locant + " did not point to a hydroxy group to be used for ester formation");
                    }
                    chosenHydroxyAtoms.add(atomOnAlcoholFragment);
                } else if (words.size() == 2 && hydroxyAtoms.contains(atomOnAlcoholFragment = potentialAlcoholFragment.getAtomByLocant("O5'"))) {
                    chosenHydroxyAtoms.add(atomOnAlcoholFragment);
                }
            } else {
                return false;
            }
            ateBuildResults.add(wordBr);
        }
        if (chosenHydroxyAtoms.size() < ateWords) {
            if (!chosenHydroxyAtoms.isEmpty()) {
                throw new RuntimeException("OPSIN Bug: Either all or none of the esters should be locanted in alcohol ester rule");
            }
            if (hydroxyAtoms.size() == ateWords || hydroxyAtoms.size() > ateWords && (AmbiguityChecker.allAtomsEquivalent(hydroxyAtoms) || potentialAlcoholFragment.getTokenEl().getValue().equals("glycerol"))) {
                for (i = 0; i < ateWords; ++i) {
                    chosenHydroxyAtoms.add(hydroxyAtoms.get(i));
                }
            } else {
                return false;
            }
        }
        for (i = 0; i < ateWords; ++i) {
            BuildResults br = (BuildResults)ateBuildResults.get(i);
            Element ateWord = words.get(i + 1);
            Element ateGroup = this.findRightMostGroupInWordOrWordRule(ateWord);
            if (ateGroup.getAttribute("numberOfFunctionalAtomsToRemove") == null && numberOfWordRules == 1) {
                for (int j = br.getFunctionalAtomCount() - 1; j >= 1; --j) {
                    Atom atomToDefunctionalise = br.getFunctionalAtom(j);
                    br.removeFunctionalAtom(j);
                    atomToDefunctionalise.neutraliseCharge();
                }
            }
            Atom functionalAtom = br.getFunctionalAtom(0);
            br.removeFunctionalAtom(0);
            functionalAtom.neutraliseCharge();
            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(functionalAtom, (Atom)chosenHydroxyAtoms.get(i));
        }
        return true;
    }

    private void buildAmineDiConjunctiveSuffix(List<Element> words) throws StructureBuildingException {
        for (Element word : words) {
            if (!WordType.full.toString().equals(word.getAttributeValue("type"))) {
                throw new StructureBuildingException("Bug in word rule for amineDiConjunctiveSuffix");
            }
            StructureBuildingMethods.resolveWordOrBracket(this.state, word);
        }
        if (words.size() != 3) {
            throw new StructureBuildingException("Unexpected number of words encountered when processing name of type amineDiConjunctiveSuffix, expected 3 but found: " + words.size());
        }
        Element aminoAcid = this.findRightMostGroupInWordOrWordRule(words.get(0));
        if (aminoAcid == null) {
            throw new RuntimeException("OPSIN Bug: failed to find amino acid");
        }
        Atom amineAtom = aminoAcid.getFrag().getDefaultInAtom();
        if (amineAtom == null) {
            throw new StructureBuildingException("OPSIN did not know where the amino acid amine was located");
        }
        for (int i = 1; i < words.size(); ++i) {
            Element word = words.get(i);
            Fragment suffixLikeGroup = this.findRightMostGroupInWordOrWordRule(word).getFrag();
            String locant = word.getAttributeValue("locant");
            if (locant != null && !locant.equals("N")) {
                throw new RuntimeException("OPSIN Bug: locant expected to be N but was: " + locant);
            }
            Atom atomToConnectToOnConjunctiveFrag = FragmentTools.lastNonSuffixCarbonWithSufficientValency(suffixLikeGroup);
            if (atomToConnectToOnConjunctiveFrag == null) {
                throw new StructureBuildingException("OPSIN Bug: Unable to find non suffix carbon with sufficient valency");
            }
            this.state.fragManager.createBond(atomToConnectToOnConjunctiveFrag, amineAtom, 1);
        }
    }

    private boolean isAppropriateAteGroupForAlcoholEster(Element ateWord, BuildResults wordBr) throws StructureBuildingException {
        if (wordBr.getFunctionalAtomCount() > 0) {
            if (ateWord.getAttributeValue("locant") != null) {
                return true;
            }
            if (wordBr.getFunctionalAtomCount() == 1) {
                return !matchCommonCarboxylicSalt.matcher(ateWord.getAttributeValue("value")).find();
            }
            String ateGroupText = this.findRightMostGroupInWordOrWordRule(ateWord).getValue();
            if (matchCommonEsterFormingInorganicSalt.matcher(ateGroupText).matches()) {
                return true;
            }
        }
        return false;
    }

    private void splitAlcoholEsterRuleIntoTwoSimpleWordRules(List<Element> words) {
        Element firstGroup = words.get(0);
        Element wordRule = firstGroup.getParent();
        wordRule.getAttribute("wordRule").setValue(WordRule.simple.toString());
        wordRule.getAttribute("value").setValue(firstGroup.getAttributeValue("value"));
        GroupingEl newWordRule = new GroupingEl("wordRule");
        newWordRule.addAttribute("type", WordType.full.toString());
        newWordRule.addAttribute("wordRule", WordRule.simple.toString());
        newWordRule.addAttribute("value", words.get(1).getAttributeValue("value"));
        OpsinTools.insertAfter(wordRule, newWordRule);
        for (int i = 1; i < words.size(); ++i) {
            Element word = words.get(i);
            word.detach();
            ((Element)newWordRule).addChild(word);
        }
    }

    private void connectSubstituentsToAcetal(List<Fragment> acetalFrags, BuildResults subBr, boolean hemiacetal) throws StructureBuildingException {
        HashMap<Fragment, Integer> usageMap = new HashMap<Fragment, Integer>();
        for (int i = subBr.getOutAtomCount() - 1; i >= 0; --i) {
            OutAtom out = subBr.getOutAtom(i);
            subBr.removeOutAtom(i);
            Atom atomToUse = null;
            if (out.getLocant() != null) {
                boolean numericLocant = OpsinTools.MATCH_NUMERIC_LOCANT.matcher(out.getLocant()).matches();
                for (Fragment possibleAcetalFrag : acetalFrags) {
                    if (numericLocant) {
                        Atom a = OpsinTools.depthFirstSearchForNonSuffixAtomWithLocant(possibleAcetalFrag.getFirstAtom(), out.getLocant());
                        if (a == null) continue;
                        List<Atom> atomList = possibleAcetalFrag.getAtomList();
                        if (atomList.get(0).getBondCount() == 1) {
                            atomToUse = atomList.get(0);
                            break;
                        }
                        if (atomList.get(1).getBondCount() != 1) continue;
                        atomToUse = atomList.get(1);
                        break;
                    }
                    if (!possibleAcetalFrag.hasLocant(out.getLocant())) continue;
                    atomToUse = possibleAcetalFrag.getAtomByLocantOrThrow(out.getLocant());
                    break;
                }
                if (atomToUse == null) {
                    throw new StructureBuildingException("Unable to find suitable acetalFrag");
                }
            } else {
                List<Atom> atomList = acetalFrags.get(0).getAtomList();
                if (atomList.get(0).getBondCount() == 1) {
                    atomToUse = atomList.get(0);
                } else if (atomList.get(1).getBondCount() == 1) {
                    atomToUse = atomList.get(1);
                } else {
                    throw new StructureBuildingException("OPSIN bug: unable to find acetal atom");
                }
            }
            Fragment acetalFrag = atomToUse.getFrag();
            int usage = usageMap.get(acetalFrag) != null ? (Integer)usageMap.get(acetalFrag) : 0;
            this.state.fragManager.createBond(out.getAtom(), atomToUse, out.getValency());
            if (++usage >= 2 || hemiacetal) {
                acetalFrags.remove(acetalFrag);
            }
            usageMap.put(acetalFrag, usage);
        }
    }

    private void buildCyclicPeptide(List<Element> words) throws StructureBuildingException {
        List<Element> aminoAcids;
        Atom outAtom;
        if (words.size() != 2) {
            throw new StructureBuildingException("OPSIN Bug: Expected 2 words in cyclic peptide name, found: " + words.size());
        }
        Element peptide = words.get(1);
        StructureBuildingMethods.resolveWordOrBracket(this.state, peptide);
        BuildResults peptideBr = new BuildResults(peptide);
        if (peptideBr.getOutAtomCount() == 1) {
            outAtom = this.getOutAtomTakingIntoAccountWhetherSetExplicitly(peptideBr, 0);
            aminoAcids = OpsinTools.getDescendantElementsWithTagNameAndAttribute(peptide, "group", "type", "aminoAcid");
            if (aminoAcids.size() < 2) {
                throw new StructureBuildingException("Cyclic peptide building failed: Requires at least two amino acids!");
            }
        } else {
            throw new StructureBuildingException("Cyclic peptide building failed: Expected 1 outAtoms, found: " + peptideBr.getOutAtomCount());
        }
        Atom inAtom = aminoAcids.get(0).getFrag().getDefaultInAtomOrFirstAtom();
        this.state.fragManager.createBond(outAtom, inAtom, peptideBr.getOutAtom(0).getValency());
        peptideBr.removeAllOutAtoms();
    }

    private void buildPolymer(List<Element> words) throws StructureBuildingException {
        if (words.size() != 2) {
            throw new StructureBuildingException("Currently unsupported polymer name type");
        }
        Element polymer = words.get(1);
        StructureBuildingMethods.resolveWordOrBracket(this.state, polymer);
        BuildResults polymerBr = new BuildResults(polymer);
        if (polymerBr.getOutAtomCount() != 2) {
            throw new StructureBuildingException("Polymer building failed: Two termini were not found; Expected 2 outAtoms, found: " + polymerBr.getOutAtomCount());
        }
        Atom inAtom = this.getOutAtomTakingIntoAccountWhetherSetExplicitly(polymerBr, 0);
        Atom outAtom = this.getOutAtomTakingIntoAccountWhetherSetExplicitly(polymerBr, 1);
        Atom rGroup1 = this.state.fragManager.buildSMILES("[" + outAtom.getElement().toString() + "|" + polymerBr.getOutAtom(0).getValency() + "]", "", "alpha").getFirstAtom();
        rGroup1.setProperty(Atom.ATOM_CLASS, 1);
        this.state.fragManager.createBond(inAtom, rGroup1, polymerBr.getOutAtom(0).getValency());
        Atom rGroup2 = this.state.fragManager.buildSMILES("[" + inAtom.getElement().toString() + "|" + polymerBr.getOutAtom(1).getValency() + "]", "", "omega").getFirstAtom();
        rGroup2.setProperty(Atom.ATOM_CLASS, 2);
        this.state.fragManager.createBond(outAtom, rGroup2, polymerBr.getOutAtom(1).getValency());
        this.polymerAttachmentPoints.add(rGroup1);
        this.polymerAttachmentPoints.add(rGroup2);
        polymerBr.removeAllOutAtoms();
    }

    private Atom determineFunctionalAtomToUse(String locant, BuildResults mainGroupBR) throws StructureBuildingException {
        block10: {
            block9: {
                Atom possibleAtom;
                int i;
                for (i = 0; i < mainGroupBR.getFunctionalAtomCount(); ++i) {
                    possibleAtom = mainGroupBR.getFunctionalAtom(i);
                    if (!possibleAtom.hasLocant(locant)) continue;
                    mainGroupBR.removeFunctionalAtom(i);
                    Set<Atom> degenerateAtoms = possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT);
                    if (degenerateAtoms != null) {
                        degenerateAtoms.remove(possibleAtom);
                    }
                    return possibleAtom;
                }
                if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) break block9;
                for (i = 0; i < mainGroupBR.getFunctionalAtomCount(); ++i) {
                    possibleAtom = mainGroupBR.getFunctionalAtom(i);
                    if (OpsinTools.depthFirstSearchForNonSuffixAtomWithLocant(possibleAtom, locant) == null) continue;
                    mainGroupBR.removeFunctionalAtom(i);
                    Set<Atom> degenerateAtoms = possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT);
                    if (degenerateAtoms != null) {
                        degenerateAtoms.remove(possibleAtom);
                    }
                    return possibleAtom;
                }
                break block10;
            }
            if (!OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(locant).matches()) break block10;
            boolean isElementSymbol = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(locant).matches();
            for (int i = 0; i < mainGroupBR.getFunctionalAtomCount(); ++i) {
                Atom possibleAtom = mainGroupBR.getFunctionalAtom(i);
                if (isElementSymbol && possibleAtom.getElement().toString().equals(locant)) {
                    mainGroupBR.removeFunctionalAtom(i);
                    return possibleAtom;
                }
                Set<Atom> degenerateAtoms = possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT);
                if (degenerateAtoms == null) continue;
                boolean foundAtom = false;
                for (Atom a : degenerateAtoms) {
                    if (!a.hasLocant(locant) && (!isElementSymbol || !a.getElement().toString().equals(locant))) continue;
                    ArrayList<String> tempLocants = new ArrayList<String>(a.getLocants());
                    ArrayList<String> tempLocants2 = new ArrayList<String>(possibleAtom.getLocants());
                    a.clearLocants();
                    possibleAtom.clearLocants();
                    for (String l : tempLocants) {
                        possibleAtom.addLocant(l);
                    }
                    for (String l : tempLocants2) {
                        a.addLocant(l);
                    }
                    ChemEl originalChemEl = possibleAtom.getElement();
                    possibleAtom.setElement(a.getElement());
                    a.setElement(originalChemEl);
                    mainGroupBR.removeFunctionalAtom(i);
                    foundAtom = true;
                    break;
                }
                if (!foundAtom) continue;
                degenerateAtoms.remove(possibleAtom);
                return possibleAtom;
            }
        }
        throw new StructureBuildingException("Cannot find functional atom with locant: " + locant + " to form an ester with");
    }

    private void manipulateStoichiometry(Element molecule, List<Element> wordRules) throws StructureBuildingException {
        int overallCharge;
        boolean saltExpected;
        boolean explicitStoichiometryPresent = this.applyExplicitStoichiometryIfProvided(wordRules);
        boolean chargedFractionalGroup = false;
        ArrayList<Element> wordRulesWithFractionalMultipliers = new ArrayList<Element>(0);
        for (Element wordRule : wordRules) {
            Element fractionalMultiplier = wordRule.getChild(0);
            while (fractionalMultiplier.getChildCount() != 0) {
                fractionalMultiplier = fractionalMultiplier.getChild(0);
            }
            if (!fractionalMultiplier.getName().equals("fractionalMultiplier")) continue;
            if (explicitStoichiometryPresent) {
                throw new StructureBuildingException("Fractional multipliers should not be used in conjunction with explicit stoichiometry");
            }
            String[] value = fractionalMultiplier.getAttributeValue("value").split("/");
            if (value.length != 2) {
                throw new RuntimeException("OPSIN Bug: malformed fractional multiplier: " + fractionalMultiplier.getAttributeValue("value"));
            }
            try {
                int numerator = Integer.parseInt(value[0]);
                int denominator = Integer.parseInt(value[1]);
                if (denominator != 2) {
                    throw new RuntimeException("Only fractions of a 1/2 currently supported");
                }
                for (int j = 1; j < numerator; ++j) {
                    Element clone = this.state.fragManager.cloneElement(this.state, wordRule);
                    OpsinTools.insertAfter(wordRule, clone);
                    wordRulesWithFractionalMultipliers.add(clone);
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("OPSIN Bug: malformed fractional multiplier: " + fractionalMultiplier.getAttributeValue("value"));
            }
            wordRulesWithFractionalMultipliers.add(wordRule);
            if (new BuildResults(wordRule).getCharge() == 0) continue;
            chargedFractionalGroup = true;
        }
        if (wordRulesWithFractionalMultipliers.size() > 0) {
            if (wordRules.size() == 1) {
                throw new StructureBuildingException("Unexpected fractional multiplier found at start of word");
            }
            if (chargedFractionalGroup) {
                for (Element wordRule : wordRules) {
                    if (wordRulesWithFractionalMultipliers.contains(wordRule)) continue;
                    Element clone = this.state.fragManager.cloneElement(this.state, wordRule);
                    OpsinTools.insertAfter(wordRule, clone);
                }
            }
        }
        boolean bl = saltExpected = molecule.getAttribute("isSalt") != null;
        if (saltExpected) {
            this.deprotonateAcidIfSaltWithMetal(molecule);
        }
        if ((overallCharge = this.state.fragManager.getOverallCharge()) != 0) {
            this.balanceChargeIfPossible(molecule, overallCharge, explicitStoichiometryPresent);
        }
        if (wordRulesWithFractionalMultipliers.size() > 0 && !chargedFractionalGroup) {
            for (Element wordRule : molecule.getChildElements("wordRule")) {
                if (wordRulesWithFractionalMultipliers.contains(wordRule)) continue;
                Element clone = this.state.fragManager.cloneElement(this.state, wordRule);
                OpsinTools.insertAfter(wordRule, clone);
            }
        }
    }

    private boolean applyExplicitStoichiometryIfProvided(List<Element> wordRules) throws StructureBuildingException {
        boolean explicitStoichiometryPresent = false;
        for (Element wordRule : wordRules) {
            if (wordRule.getAttribute("stoichiometry") == null) continue;
            int stoichiometry = Integer.parseInt(wordRule.getAttributeValue("stoichiometry"));
            wordRule.removeAttribute(wordRule.getAttribute("stoichiometry"));
            for (int j = 1; j < stoichiometry; ++j) {
                Element clone = this.state.fragManager.cloneElement(this.state, wordRule);
                OpsinTools.insertAfter(wordRule, clone);
            }
            explicitStoichiometryPresent = true;
        }
        return explicitStoichiometryPresent;
    }

    private void deprotonateAcidIfSaltWithMetal(Element molecule) {
        ArrayList<BuildResults> positivelyChargedComponents = new ArrayList<BuildResults>();
        ArrayList<BuildResults> negativelyChargedComponents = new ArrayList<BuildResults>();
        ArrayList<BuildResults> neutralComponents = new ArrayList<BuildResults>();
        List<Element> wordRules = molecule.getChildElements("wordRule");
        for (Element wordRule : wordRules) {
            BuildResults br = new BuildResults(wordRule);
            int charge = br.getCharge();
            if (charge > 0) {
                positivelyChargedComponents.add(br);
                continue;
            }
            if (charge < 0) {
                negativelyChargedComponents.add(br);
                continue;
            }
            neutralComponents.add(br);
        }
        if (negativelyChargedComponents.isEmpty() && (positivelyChargedComponents.size() > 0 || this.getMetalsThatCanBeImplicitlyCations(molecule).size() > 0)) {
            for (int i = neutralComponents.size() - 1; i >= 0; --i) {
                ArrayList<Atom> functionalAtoms = new ArrayList<Atom>();
                for (Fragment f : ((BuildResults)neutralComponents.get(i)).getFragments()) {
                    for (int j = 0; j < f.getFunctionalAtomCount(); ++j) {
                        functionalAtoms.add(f.getFunctionalAtom(j).getAtom());
                    }
                }
                for (Atom functionalAtom : functionalAtoms) {
                    if (functionalAtom.getCharge() != 0 || functionalAtom.getIncomingValency() != 1) continue;
                    functionalAtom.addChargeAndProtons(-1, -1);
                }
            }
        }
    }

    private void balanceChargeIfPossible(Element molecule, int overallCharge, boolean explicitStoichiometryPresent) throws StructureBuildingException {
        boolean success;
        List<Element> wordRules = molecule.getChildElements("wordRule");
        if (wordRules.size() == 1) {
            if (overallCharge == 1) {
                this.phosphoZwitterionSpecialCase(wordRules.get(0));
            }
            return;
        }
        ArrayList<Element> positivelyChargedComponents = new ArrayList<Element>();
        ArrayList<Element> negativelyChargedComponents = new ArrayList<Element>();
        HashMap<Element, Integer> componentToChargeMapping = new HashMap<Element, Integer>();
        HashMap<Element, BuildResults> componentToBR = new HashMap<Element, BuildResults>();
        List<Element> cationicElements = this.getMetalsThatCanBeImplicitlyCations(molecule);
        overallCharge = this.setCationicElementsToTypicalCharge(cationicElements, overallCharge);
        if (overallCharge == 0) {
            return;
        }
        if (overallCharge == -2 && this.triHalideSpecialCase(wordRules)) {
            return;
        }
        for (Element wordRule : wordRules) {
            BuildResults br = new BuildResults(wordRule);
            componentToBR.put(wordRule, br);
            int charge = br.getCharge();
            if (charge > 0) {
                positivelyChargedComponents.add(wordRule);
            } else if (charge < 0) {
                negativelyChargedComponents.add(wordRule);
            }
            componentToChargeMapping.put(wordRule, charge);
        }
        if (cationicElements.size() == 1 && overallCharge < 0) {
            boolean mustBeCommonOxidationState;
            boolean bl = mustBeCommonOxidationState = negativelyChargedComponents.size() == 1 && ((Element)negativelyChargedComponents.get(0)).getChildElements("word").size() == 1;
            if (this.setChargeOnCationicElementAppropriately(overallCharge, cationicElements.get(0), mustBeCommonOxidationState)) {
                return;
            }
        }
        if (!explicitStoichiometryPresent && (positivelyChargedComponents.size() == 1 && cationicElements.isEmpty() && negativelyChargedComponents.size() >= 1 || positivelyChargedComponents.size() >= 1 && negativelyChargedComponents.size() == 1) && (success = this.multiplyChargedComponents(negativelyChargedComponents, positivelyChargedComponents, componentToChargeMapping, overallCharge))) {
            return;
        }
        if (cationicElements.size() == 1 && (success = this.setChargeOnCationicElementAppropriately(overallCharge, cationicElements.get(0), false))) {
            return;
        }
        if (overallCharge < 0) {
            int i;
            int functionalAtomCount;
            if (overallCharge == -1 && this.acetylideSpecialCase(wordRules)) {
                return;
            }
            int chargeOnFunctionalAtoms = 0;
            for (Element wordRule : wordRules) {
                BuildResults br = (BuildResults)componentToBR.get(wordRule);
                functionalAtomCount = br.getFunctionalAtomCount();
                for (i = functionalAtomCount - 1; i >= 0; --i) {
                    chargeOnFunctionalAtoms += br.getFunctionalAtom(i).getCharge();
                }
            }
            if (chargeOnFunctionalAtoms <= overallCharge) {
                for (Element wordRule : wordRules) {
                    BuildResults br = (BuildResults)componentToBR.get(wordRule);
                    functionalAtomCount = br.getFunctionalAtomCount();
                    for (i = functionalAtomCount - 1; i >= 0; --i) {
                        if (overallCharge == 0) {
                            return;
                        }
                        overallCharge -= br.getFunctionalAtom(i).getCharge();
                        br.getFunctionalAtom(i).neutraliseCharge();
                        br.removeFunctionalAtom(i);
                    }
                }
            }
        }
    }

    private List<Element> getMetalsThatCanBeImplicitlyCations(Element molecule) {
        ArrayList<Element> cationicElements = new ArrayList<Element>();
        List<Element> elementaryAtoms = OpsinTools.getDescendantElementsWithTagNameAndAttribute(molecule, "group", "type", "elementaryAtom");
        for (Element elementaryAtom : elementaryAtoms) {
            String[] typicalOxidationStates;
            int typicalCharge;
            Atom metalAtom;
            if (elementaryAtom.getAttribute("commonOxidationStatesAndMax") == null || (metalAtom = elementaryAtom.getFrag().getFirstAtom()).getCharge() != 0 || metalAtom.getProperty(Atom.OXIDATION_NUMBER) != null || (typicalCharge = Integer.parseInt((typicalOxidationStates = elementaryAtom.getAttributeValue("commonOxidationStatesAndMax").split(":")[0].split(","))[typicalOxidationStates.length - 1])) <= metalAtom.getBondCount()) continue;
            cationicElements.add(elementaryAtom);
        }
        return cationicElements;
    }

    private int setCationicElementsToTypicalCharge(List<Element> cationicElements, int overallCharge) {
        block0: for (Element cationicElement : cationicElements) {
            Fragment cationicFrag = cationicElement.getFrag();
            String[] typicalOxidationStates = cationicElement.getAttributeValue("commonOxidationStatesAndMax").split(":")[0].split(",");
            int incomingValency = cationicFrag.getFirstAtom().getIncomingValency();
            for (String typicalOxidationState : typicalOxidationStates) {
                int charge = Integer.parseInt(typicalOxidationState);
                if (charge < incomingValency) continue;
                overallCharge += (charge -= incomingValency);
                cationicFrag.getFirstAtom().setCharge(charge);
                continue block0;
            }
        }
        return overallCharge;
    }

    private boolean triHalideSpecialCase(List<Element> wordRules) {
        for (Element wordRule : wordRules) {
            String value;
            if (wordRule.getChildCount() != 3 || !"tribromide".equals(value = wordRule.getAttributeValue("value")) && !"tribromid".equals(value) && !"triiodide".equals(value) && !"triiodid".equals(value)) continue;
            List<Element> groups1 = OpsinTools.getDescendantElementsWithTagName(wordRule.getChild(0), "group");
            List<Element> groups2 = OpsinTools.getDescendantElementsWithTagName(wordRule.getChild(1), "group");
            List<Element> groups3 = OpsinTools.getDescendantElementsWithTagName(wordRule.getChild(2), "group");
            if (groups1.size() != 1 || groups2.size() != 1 || groups3.size() != 1) {
                throw new RuntimeException("OPSIN Bug: Unexpected trihalide representation");
            }
            Atom centralAtom = groups1.get(0).getFrag().getFirstAtom();
            Atom otherAtom1 = groups2.get(0).getFrag().getFirstAtom();
            otherAtom1.setCharge(0);
            Atom otherAtom2 = groups3.get(0).getFrag().getFirstAtom();
            otherAtom2.setCharge(0);
            this.state.fragManager.createBond(centralAtom, otherAtom1, 1);
            this.state.fragManager.createBond(centralAtom, otherAtom2, 1);
            return true;
        }
        return false;
    }

    private boolean phosphoZwitterionSpecialCase(Element wordRule) {
        List<Element> groups = OpsinTools.getDescendantElementsWithTagName(wordRule, "group");
        ArrayList<Fragment> phosphoFrags = new ArrayList<Fragment>();
        for (Element group : groups) {
            if (!"phospho".equals(group.getAttributeValue("subType")) || !group.getValue().endsWith("phospho")) continue;
            phosphoFrags.add(group.getFrag());
        }
        if (phosphoFrags.size() == 1) {
            List<Atom> matches = FragmentTools.findHydroxyLikeTerminalAtoms(((Fragment)phosphoFrags.get(0)).getAtomList(), ChemEl.O);
            for (Atom atom : matches) {
                if (atom.getFirstBond().getOtherAtom(atom).getElement() != ChemEl.P) continue;
                atom.addChargeAndProtons(-1, -1);
                return true;
            }
        }
        return false;
    }

    private boolean acetylideSpecialCase(List<Element> wordRules) {
        for (Element wordRule : wordRules) {
            String value = wordRule.getAttributeValue("value");
            if (!"acetylide".equals(value) && !"acetylid".equals(value)) continue;
            List<Element> groups = OpsinTools.getDescendantElementsWithTagName(wordRule, "group");
            if (groups.size() != 1) {
                throw new RuntimeException("OPSIN Bug: Unexpected acetylide representation");
            }
            Fragment frag = groups.get(0).getFrag();
            Atom firstAtom = frag.getFirstAtom();
            if (frag.getCharge() != -2 || firstAtom.getCharge() != -1) continue;
            firstAtom.addChargeAndProtons(1, 1);
            return true;
        }
        return false;
    }

    private boolean multiplyChargedComponents(List<Element> negativelyChargedComponents, List<Element> positivelyChargedComponents, Map<Element, Integer> componentToChargeMapping, int overallCharge) throws StructureBuildingException {
        Element componentToMultiply;
        if (overallCharge > 0) {
            if (negativelyChargedComponents.size() > 1) {
                return false;
            }
            componentToMultiply = negativelyChargedComponents.get(0);
        } else {
            if (positivelyChargedComponents.size() > 1) {
                return false;
            }
            componentToMultiply = positivelyChargedComponents.get(0);
        }
        int charge = componentToChargeMapping.get(componentToMultiply);
        if (overallCharge % charge == 0) {
            if (!this.componentCanBeMultiplied(componentToMultiply)) {
                return false;
            }
            int timesToDuplicate = Math.abs(overallCharge / charge);
            for (int i = 0; i < timesToDuplicate; ++i) {
                OpsinTools.insertAfter(componentToMultiply, this.state.fragManager.cloneElement(this.state, componentToMultiply));
            }
        } else {
            int i;
            if (positivelyChargedComponents.size() > 1 || !this.componentCanBeMultiplied(positivelyChargedComponents.get(0))) {
                return false;
            }
            if (negativelyChargedComponents.size() > 1 || !this.componentCanBeMultiplied(negativelyChargedComponents.get(0))) {
                return false;
            }
            int positiveCharge = componentToChargeMapping.get(positivelyChargedComponents.get(0));
            int negativeCharge = Math.abs(componentToChargeMapping.get(negativelyChargedComponents.get(0)));
            int targetTotalAbsoluteCharge = positiveCharge * negativeCharge;
            for (i = targetTotalAbsoluteCharge / negativeCharge; i > 1; --i) {
                OpsinTools.insertAfter(negativelyChargedComponents.get(0), this.state.fragManager.cloneElement(this.state, negativelyChargedComponents.get(0)));
            }
            for (i = targetTotalAbsoluteCharge / positiveCharge; i > 1; --i) {
                OpsinTools.insertAfter(positivelyChargedComponents.get(0), this.state.fragManager.cloneElement(this.state, positivelyChargedComponents.get(0)));
            }
        }
        return true;
    }

    private boolean componentCanBeMultiplied(Element componentToMultiply) {
        if (componentToMultiply.getAttributeValue("wordRule").equals(WordRule.simple.toString()) && OpsinTools.getChildElementsWithTagNameAndAttribute(componentToMultiply, "word", "type", WordType.full.toString()).size() > 1) {
            return false;
        }
        Element firstChild = componentToMultiply.getChild(0);
        while (firstChild.getChildCount() != 0) {
            firstChild = firstChild.getChild(0);
        }
        return !firstChild.getName().equals("multiplier") && !firstChild.getName().equals("fractionalMultiplier");
    }

    private boolean setChargeOnCationicElementAppropriately(int overallCharge, Element cationicElement, boolean mustBeCommonOxidationState) {
        Atom cation = cationicElement.getFrag().getFirstAtom();
        int chargeOnCationNeeded = -(overallCharge - cation.getCharge());
        if (mustBeCommonOxidationState) {
            String[] typicalOxidationStates;
            for (String typicalOxidationState : typicalOxidationStates = cationicElement.getAttributeValue("commonOxidationStatesAndMax").split(":")[0].split(",")) {
                int charge = Integer.parseInt(typicalOxidationState);
                if (charge != chargeOnCationNeeded) continue;
                cation.setCharge(chargeOnCationNeeded);
                return true;
            }
        } else {
            int maximumCharge = Integer.parseInt(cationicElement.getAttributeValue("commonOxidationStatesAndMax").split(":")[1]);
            if (chargeOnCationNeeded >= 0 && chargeOnCationNeeded <= maximumCharge) {
                cation.setCharge(chargeOnCationNeeded);
                return true;
            }
        }
        return false;
    }

    private Element findRightMostGroupInWordOrWordRule(Element wordOrWordRule) throws StructureBuildingException {
        if (wordOrWordRule.getName().equals("wordRule")) {
            List<Element> words = OpsinTools.getDescendantElementsWithTagName(wordOrWordRule, "word");
            for (int i = words.size() - 1; i >= 0; --i) {
                if (!words.get(i).getAttributeValue("type").equals(WordType.functionalTerm.toString())) continue;
                words.remove(words.get(i));
            }
            if (words.isEmpty()) {
                throw new StructureBuildingException("OPSIN bug: word element not found where expected");
            }
            return StructureBuildingMethods.findRightMostGroupInBracket(words.get(words.size() - 1));
        }
        if (wordOrWordRule.getName().equals("word")) {
            return StructureBuildingMethods.findRightMostGroupInBracket(wordOrWordRule);
        }
        throw new StructureBuildingException("OPSIN bug: expected word or wordRule");
    }

    private void processSpecialCases(List<Element> groups) {
        for (Element group : groups) {
            String groupName;
            Fragment frag;
            Atom atom2;
            String subType = group.getAttributeValue("subType");
            if ("oxidoLike".equals(subType)) {
                Atom oxidoAtom = group.getFrag().getFirstAtom();
                if (oxidoAtom.getBondCount() != 1) continue;
                Atom connectedAtom = oxidoAtom.getFirstBond().getOtherAtom(oxidoAtom);
                ChemEl chemEl = connectedAtom.getElement();
                if (this.checkForConnectedOxo(connectedAtom)) continue;
                if ("elementaryAtom".equals(connectedAtom.getFrag().getType()) || (chemEl == ChemEl.S || chemEl == ChemEl.P) && connectedAtom.getCharge() == 0 && ValencyChecker.checkValencyAvailableForBond(connectedAtom, 1)) {
                    oxidoAtom.neutraliseCharge();
                    oxidoAtom.getFirstBond().setOrder(2);
                    continue;
                }
                if (chemEl != ChemEl.N || connectedAtom.getCharge() != 0) continue;
                int incomingValency = connectedAtom.getIncomingValency();
                if (incomingValency + connectedAtom.getOutValency() == 3 && connectedAtom.hasSpareValency()) {
                    connectedAtom.addChargeAndProtons(1, 1);
                    continue;
                }
                if (incomingValency + connectedAtom.getOutValency() != 4) continue;
                if (connectedAtom.getLambdaConventionValency() != null && connectedAtom.getLambdaConventionValency() == 5) {
                    oxidoAtom.setCharge(0);
                    oxidoAtom.setProtonsExplicitlyAddedOrRemoved(0);
                    oxidoAtom.getFirstBond().setOrder(2);
                    continue;
                }
                connectedAtom.addChargeAndProtons(1, 1);
                continue;
            }
            if ("aminoAcid".equals(group.getAttributeValue("type"))) {
                for (Atom atom2 : group.getFrag()) {
                    if (!atom2.getElement().isChalcogen() || atom2.getElement() == ChemEl.O || atom2.getBondCount() != 3 || atom2.getIncomingValency() != 3 || atom2.getCharge() != 0) continue;
                    atom2.addChargeAndProtons(1, 1);
                }
                continue;
            }
            if (!"biochemical".equals(subType) || (atom2 = (frag = group.getFrag()).getAtomByLocant("7")) == null || !(groupName = group.getValue()).equals("adenosin") && !groupName.equals("guanosin") && !groupName.equals("inosin") && !groupName.equals("thioinosin") && !groupName.equals("xanthosin") && !groupName.equals("nucleocidin") && !groupName.contains("adenylic") && !groupName.contains("guanylic") && !groupName.contains("inosinic") && !groupName.contains("xanthylic") && !groupName.endsWith("adenylyl") && !groupName.endsWith("adenosyl") && !groupName.endsWith("guanylyl") && !groupName.endsWith("guanosyl") && !groupName.endsWith("inosinylyl") && !groupName.endsWith("inosyl") && !groupName.endsWith("xanthylyl") && !groupName.endsWith("xanthosyl") || atom2.getElement() != ChemEl.N || !atom2.hasSpareValency() || atom2.getBondCount() != 3 || atom2.getIncomingValency() != 3 || atom2.getCharge() != 0) continue;
            atom2.addChargeAndProtons(1, 1);
        }
    }

    private boolean checkForConnectedOxo(Atom atom) {
        List<Bond> bonds = atom.getBonds();
        for (Bond bond : bonds) {
            Atom connectedAtom = bond.getFromAtom() == atom ? bond.getToAtom() : bond.getFromAtom();
            Element correspondingEl = connectedAtom.getFrag().getTokenEl();
            if (!correspondingEl.getValue().equals("oxo")) continue;
            return true;
        }
        return false;
    }

    private void processOxidationNumbers(List<Element> groups) throws StructureBuildingException {
        for (Element group : groups) {
            Atom atom;
            if (!"elementaryAtom".equals(group.getAttributeValue("type")) || (atom = group.getFrag().getFirstAtom()).getProperty(Atom.OXIDATION_NUMBER) == null) continue;
            List<Atom> neighbours = atom.getAtomNeighbours();
            int chargeThatWouldFormIfLigandsWereRemoved = 0;
            for (Atom neighbour : neighbours) {
                Element neighbourEl = neighbour.getFrag().getTokenEl();
                Bond b = atom.getBondToAtomOrThrow(neighbour);
                if (neighbourEl.getValue().equals("carbon") && "nonCarboxylicAcid".equals(neighbourEl.getAttributeValue("type")) || neighbourEl.getValue().equals("nitrosyl")) continue;
                chargeThatWouldFormIfLigandsWereRemoved += b.getOrder();
            }
            atom.setCharge(atom.getProperty(Atom.OXIDATION_NUMBER) - chargeThatWouldFormIfLigandsWereRemoved);
        }
    }

    private void processStereochemistry(Element molecule, Fragment uniFrag) throws StructureBuildingException {
        List<Element> stereoChemistryEls = this.findStereochemistryElsInProcessingOrder(molecule);
        List<Atom> atomList = uniFrag.getAtomList();
        ArrayList<Atom> atomsWithPreDefinedAtomParity = new ArrayList<Atom>();
        for (Atom atom : atomList) {
            if (atom.getAtomParity() == null) continue;
            atomsWithPreDefinedAtomParity.add(atom);
        }
        Set<Bond> bonds = uniFrag.getBondSet();
        ArrayList<Bond> bondsWithPreDefinedBondStereo = new ArrayList<Bond>();
        for (Bond bond : bonds) {
            if (bond.getBondStereo() == null) continue;
            bondsWithPreDefinedBondStereo.add(bond);
        }
        if (stereoChemistryEls.size() > 0 || atomsWithPreDefinedAtomParity.size() > 0 || bondsWithPreDefinedBondStereo.size() > 0) {
            StereoAnalyser stereoAnalyser = new StereoAnalyser(uniFrag);
            HashMap<Atom, StereoAnalyser.StereoCentre> atomStereoCentreMap = new HashMap<Atom, StereoAnalyser.StereoCentre>();
            List<StereoAnalyser.StereoCentre> stereoCentres = stereoAnalyser.findStereoCentres();
            for (StereoAnalyser.StereoCentre stereoCentre : stereoCentres) {
                atomStereoCentreMap.put(stereoCentre.getStereoAtom(), stereoCentre);
            }
            HashMap<Bond, StereoAnalyser.StereoBond> bondStereoBondMap = new HashMap<Bond, StereoAnalyser.StereoBond>();
            List<StereoAnalyser.StereoBond> stereoBonds = stereoAnalyser.findStereoBonds();
            for (StereoAnalyser.StereoBond stereoBond : stereoBonds) {
                Bond b = stereoBond.getBond();
                if (!FragmentTools.notIn6MemberOrSmallerRing(b)) continue;
                bondStereoBondMap.put(b, stereoBond);
            }
            StereochemistryHandler stereoChemistryHandler = new StereochemistryHandler(this.state, atomStereoCentreMap, bondStereoBondMap);
            stereoChemistryHandler.applyStereochemicalElements(stereoChemistryEls);
            stereoChemistryHandler.removeRedundantStereoCentres(atomsWithPreDefinedAtomParity, bondsWithPreDefinedBondStereo);
        }
    }

    private List<Element> findStereochemistryElsInProcessingOrder(Element parentEl) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        List<Element> children = parentEl.getChildElements();
        ArrayList<Element> stereochemistryElsAtThisLevel = new ArrayList<Element>();
        for (int i = children.size() - 1; i >= 0; --i) {
            Element child = children.get(i);
            if (child.getName().equals("stereoChemistry")) {
                stereochemistryElsAtThisLevel.add(child);
                continue;
            }
            matchingElements.addAll(this.findStereochemistryElsInProcessingOrder(child));
        }
        Collections.reverse(stereochemistryElsAtThisLevel);
        matchingElements.addAll(stereochemistryElsAtThisLevel);
        return matchingElements;
    }

    private void convertOutAtomsToAttachmentAtoms(Fragment uniFrag) throws StructureBuildingException {
        int outAtomCount = uniFrag.getOutAtomCount();
        for (int i = outAtomCount - 1; i >= 0; --i) {
            OutAtom outAtom = uniFrag.getOutAtom(i);
            uniFrag.removeOutAtom(i);
            Atom rGroup = this.state.fragManager.createAtom(ChemEl.R, uniFrag);
            this.state.fragManager.createBond(outAtom.getAtom(), rGroup, outAtom.getValency());
        }
    }

    private Atom getOutAtomTakingIntoAccountWhetherSetExplicitly(BuildResults buildResults, int i) throws StructureBuildingException {
        OutAtom outAtom = buildResults.getOutAtom(i);
        if (outAtom.isSetExplicitly()) {
            return outAtom.getAtom();
        }
        return StructureBuildingMethods.findAtomForUnlocantedRadical(this.state, outAtom.getAtom().getFrag(), outAtom);
    }
}

