/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.CipOrderingException;
import uk.ac.cam.ch.wwmm.opsin.CipSequenceRules;
import uk.ac.cam.ch.wwmm.opsin.Fragment;

class StereoAnalyser {
    private final Collection<Atom> atoms;
    private final Collection<Bond> bonds;
    private final Map<Atom, Integer> mappingToColour;
    private final Map<Atom, int[]> atomNeighbourColours;
    private final AtomNeighbouringColoursComparator atomNeighbouringColoursComparator = new AtomNeighbouringColoursComparator();
    private static final AtomicNumberThenAtomicMassComparator atomicNumberThenAtomicMassComparator = new AtomicNumberThenAtomicMassComparator();

    private static int compareAtomicNumberThenAtomicMass(Atom a, Atom b) {
        int atomicNumber1 = a.getElement().ATOMIC_NUM;
        int atomicNumber2 = b.getElement().ATOMIC_NUM;
        if (atomicNumber1 > atomicNumber2) {
            return 1;
        }
        if (atomicNumber1 < atomicNumber2) {
            return -1;
        }
        Integer atomicMass1 = a.getIsotope();
        Integer atomicMass2 = b.getIsotope();
        if (atomicMass1 != null && atomicMass2 == null) {
            return 1;
        }
        if (atomicMass1 == null && atomicMass2 != null) {
            return -1;
        }
        if (atomicMass1 != null && atomicMass2 != null) {
            if (atomicMass1 > atomicMass2) {
                return 1;
            }
            if (atomicMass1 < atomicMass2) {
                return -1;
            }
        }
        return 0;
    }

    StereoAnalyser(Fragment molecule) {
        this(molecule.getAtomList(), molecule.getBondSet());
    }

    StereoAnalyser(Collection<Atom> atoms, Collection<Bond> bonds) {
        this.atoms = atoms;
        this.bonds = bonds;
        List<Atom> ghostAtoms = this.addGhostAtoms();
        ArrayList<Atom> atomsToSort = new ArrayList<Atom>(atoms);
        atomsToSort.addAll(ghostAtoms);
        this.mappingToColour = new HashMap<Atom, Integer>(atomsToSort.size());
        this.atomNeighbourColours = new HashMap<Atom, int[]>(atomsToSort.size());
        Collections.sort(atomsToSort, atomicNumberThenAtomicMassComparator);
        List<List<Atom>> groupsByColour = this.populateColoursByAtomicNumberAndMass(atomsToSort);
        boolean changeFound = true;
        while (changeFound) {
            for (List<Atom> groupWithAColour : groupsByColour) {
                for (Atom atom : groupWithAColour) {
                    int[] neighbourColours = this.findColourOfNeighbours(atom);
                    this.atomNeighbourColours.put(atom, neighbourColours);
                }
            }
            ArrayList<List<Atom>> updatedGroupsByColour = new ArrayList<List<Atom>>();
            changeFound = this.populateColoursAndReportIfColoursWereChanged(groupsByColour, updatedGroupsByColour);
            groupsByColour = updatedGroupsByColour;
        }
        this.removeGhostAtoms(ghostAtoms);
    }

    private List<Atom> addGhostAtoms() {
        ArrayList<Atom> ghostAtoms = new ArrayList<Atom>();
        for (Bond bond : this.bonds) {
            int bondOrder;
            for (int i = bondOrder = bond.getOrder(); i > 1; --i) {
                Atom fromAtom = bond.getFromAtom();
                Atom toAtom = bond.getToAtom();
                Atom ghost1 = new Atom(fromAtom.getElement());
                Bond b1 = new Bond(ghost1, toAtom, 1);
                toAtom.addBond(b1);
                ghost1.addBond(b1);
                ghostAtoms.add(ghost1);
                Atom ghost2 = new Atom(toAtom.getElement());
                Bond b2 = new Bond(ghost2, fromAtom, 1);
                fromAtom.addBond(b2);
                ghost2.addBond(b2);
                ghostAtoms.add(ghost2);
            }
        }
        return ghostAtoms;
    }

    private void removeGhostAtoms(List<Atom> ghostAtoms) {
        for (Atom atom : ghostAtoms) {
            Bond b = atom.getFirstBond();
            b.getOtherAtom(atom).removeBond(b);
        }
    }

    private List<List<Atom>> populateColoursByAtomicNumberAndMass(List<Atom> atomList) {
        ArrayList<List<Atom>> groupsByColour = new ArrayList<List<Atom>>();
        Atom previousAtom = null;
        ArrayList<Atom> atomsOfThisColour = new ArrayList<Atom>();
        int atomsSeen = 0;
        for (Atom atom : atomList) {
            if (previousAtom != null && StereoAnalyser.compareAtomicNumberThenAtomicMass(previousAtom, atom) != 0) {
                for (Atom atomOfthisColour : atomsOfThisColour) {
                    this.mappingToColour.put(atomOfthisColour, atomsSeen);
                }
                groupsByColour.add(atomsOfThisColour);
                atomsOfThisColour = new ArrayList();
            }
            previousAtom = atom;
            atomsOfThisColour.add(atom);
            ++atomsSeen;
        }
        if (!atomsOfThisColour.isEmpty()) {
            for (Atom atomOfThisColour : atomsOfThisColour) {
                this.mappingToColour.put(atomOfThisColour, atomsSeen);
            }
            groupsByColour.add(atomsOfThisColour);
        }
        return groupsByColour;
    }

    private boolean populateColoursAndReportIfColoursWereChanged(List<List<Atom>> groupsByColour, List<List<Atom>> updatedGroupsByColour) {
        boolean changeFound = false;
        int atomsSeen = 0;
        for (List<Atom> groupWithAColour : groupsByColour) {
            Collections.sort(groupWithAColour, this.atomNeighbouringColoursComparator);
            Atom previousAtom = null;
            ArrayList<Atom> atomsOfThisColour = new ArrayList<Atom>();
            for (Atom atom : groupWithAColour) {
                if (previousAtom != null && this.atomNeighbouringColoursComparator.compare(previousAtom, atom) != 0) {
                    for (Atom atomOfThisColour : atomsOfThisColour) {
                        if (!changeFound && atomsSeen != this.mappingToColour.get(atomOfThisColour)) {
                            changeFound = true;
                        }
                        this.mappingToColour.put(atomOfThisColour, atomsSeen);
                    }
                    updatedGroupsByColour.add(atomsOfThisColour);
                    atomsOfThisColour = new ArrayList();
                }
                previousAtom = atom;
                atomsOfThisColour.add(atom);
                ++atomsSeen;
            }
            if (atomsOfThisColour.isEmpty()) continue;
            for (Atom atomOfThisColour : atomsOfThisColour) {
                if (!changeFound && atomsSeen != this.mappingToColour.get(atomOfThisColour)) {
                    changeFound = true;
                }
                this.mappingToColour.put(atomOfThisColour, atomsSeen);
            }
            updatedGroupsByColour.add(atomsOfThisColour);
        }
        return changeFound;
    }

    private int[] findColourOfNeighbours(Atom atom) {
        List<Bond> bonds = atom.getBonds();
        int bondCount = bonds.size();
        int[] colourOfAdjacentAtoms = new int[bondCount];
        for (int i = 0; i < bondCount; ++i) {
            Bond bond = bonds.get(i);
            Atom otherAtom = bond.getOtherAtom(atom);
            colourOfAdjacentAtoms[i] = this.mappingToColour.get(otherAtom);
        }
        Arrays.sort(colourOfAdjacentAtoms);
        return colourOfAdjacentAtoms;
    }

    List<StereoCentre> findStereoCentres() {
        List<Atom> potentialStereoAtoms = this.getPotentialStereoCentres();
        ArrayList<Atom> trueStereoCentres = new ArrayList<Atom>();
        for (Atom atom : potentialStereoAtoms) {
            if (!this.isTrueStereCentre(atom)) continue;
            trueStereoCentres.add(atom);
        }
        ArrayList<StereoCentre> stereoCentres = new ArrayList<StereoCentre>();
        for (Atom trueStereoCentreAtom : trueStereoCentres) {
            stereoCentres.add(new StereoCentre(trueStereoCentreAtom, true));
        }
        potentialStereoAtoms.removeAll(trueStereoCentres);
        List<Atom> list = this.findParaStereoCentres(potentialStereoAtoms, trueStereoCentres);
        for (Atom paraStereoCentreAtom : list) {
            stereoCentres.add(new StereoCentre(paraStereoCentreAtom, false));
        }
        return stereoCentres;
    }

    private List<Atom> getPotentialStereoCentres() {
        ArrayList<Atom> potentialStereoAtoms = new ArrayList<Atom>();
        for (Atom atom : this.atoms) {
            if (!StereoAnalyser.isPossiblyStereogenic(atom)) continue;
            potentialStereoAtoms.add(atom);
        }
        return potentialStereoAtoms;
    }

    private boolean isTrueStereCentre(Atom potentialStereoAtom) {
        List<Atom> neighbours = potentialStereoAtom.getAtomNeighbours();
        if (neighbours.size() != 3 && neighbours.size() != 4) {
            return false;
        }
        int[] colours = new int[4];
        for (int i = neighbours.size() - 1; i >= 0; --i) {
            colours[i] = this.mappingToColour.get(neighbours.get(i));
        }
        boolean foundIdenticalNeighbour = false;
        block1: for (int i = 0; i < 4; ++i) {
            int cl = colours[i];
            for (int j = i + 1; j < 4; ++j) {
                if (cl != colours[j]) continue;
                foundIdenticalNeighbour = true;
                continue block1;
            }
        }
        return !foundIdenticalNeighbour;
    }

    private List<Atom> findParaStereoCentres(List<Atom> potentialStereoAtoms, List<Atom> trueStereoCentres) {
        ArrayList<Atom> paraStereoCentres = new ArrayList<Atom>();
        for (Atom potentialStereoAtom : potentialStereoAtoms) {
            List<Atom> neighbours = potentialStereoAtom.getAtomNeighbours();
            if (neighbours.size() != 4) continue;
            int[] colours = new int[4];
            for (int i = neighbours.size() - 1; i >= 0; --i) {
                colours[i] = this.mappingToColour.get(neighbours.get(i));
            }
            HashMap<Integer, Integer> foundPairs = new HashMap<Integer, Integer>();
            block2: for (int i = 0; i < 4; ++i) {
                int cl = colours[i];
                for (int j = i + 1; j < 4; ++j) {
                    if (cl != colours[j]) continue;
                    foundPairs.put(i, j);
                    continue block2;
                }
            }
            int pairs = foundPairs.keySet().size();
            if (pairs != 1 && pairs != 2) continue;
            boolean hasTrueStereoCentreInAllBranches = true;
            for (Map.Entry entry : foundPairs.entrySet()) {
                if (this.branchesHaveTrueStereocentre(neighbours.get((Integer)entry.getKey()), neighbours.get((Integer)entry.getValue()), potentialStereoAtom, trueStereoCentres)) continue;
                hasTrueStereoCentreInAllBranches = false;
                break;
            }
            if (!hasTrueStereoCentreInAllBranches) continue;
            paraStereoCentres.add(potentialStereoAtom);
        }
        return paraStereoCentres;
    }

    private boolean branchesHaveTrueStereocentre(Atom branchAtom1, Atom branchAtom2, Atom potentialStereoAtom, List<Atom> trueStereoCentres) {
        ArrayList<Atom> atomsToVisit = new ArrayList<Atom>();
        HashSet<Atom> visitedAtoms = new HashSet<Atom>();
        visitedAtoms.add(potentialStereoAtom);
        atomsToVisit.add(branchAtom1);
        atomsToVisit.add(branchAtom2);
        while (!atomsToVisit.isEmpty()) {
            ArrayList<Atom> newAtomsToVisit = new ArrayList<Atom>();
            while (!atomsToVisit.isEmpty()) {
                Atom atom = (Atom)atomsToVisit.remove(0);
                if (trueStereoCentres.contains(atom)) {
                    return true;
                }
                if (atomsToVisit.contains(atom)) {
                    do {
                        atomsToVisit.remove(atom);
                    } while (atomsToVisit.contains(atom));
                    continue;
                }
                List<Atom> neighbours = atom.getAtomNeighbours();
                for (Atom neighbour : neighbours) {
                    if (visitedAtoms.contains(neighbour)) continue;
                    newAtomsToVisit.add(neighbour);
                }
                visitedAtoms.add(atom);
            }
            atomsToVisit = newAtomsToVisit;
        }
        return false;
    }

    static boolean isPossiblyStereogenic(Atom atom) {
        return StereoAnalyser.isKnownPotentiallyStereogenic(atom) && !StereoAnalyser.isAchiralDueToResonanceOrTautomerism(atom);
    }

    static boolean isKnownPotentiallyStereogenic(Atom atom) {
        List<Atom> neighbours = atom.getAtomNeighbours();
        ChemEl chemEl = atom.getElement();
        if (neighbours.size() == 4) {
            if (chemEl == ChemEl.B || chemEl == ChemEl.C || chemEl == ChemEl.Si || chemEl == ChemEl.Ge || chemEl == ChemEl.Sn || chemEl == ChemEl.N || chemEl == ChemEl.P || chemEl == ChemEl.As || chemEl == ChemEl.S || chemEl == ChemEl.Se) {
                return true;
            }
        } else if (neighbours.size() == 3) {
            if ((chemEl == ChemEl.S || chemEl == ChemEl.Se) && (atom.getIncomingValency() == 4 || atom.getCharge() == 1 && atom.getIncomingValency() == 3)) {
                return true;
            }
            if (chemEl == ChemEl.N && atom.getCharge() == 0 && atom.getIncomingValency() == 3 && StereoAnalyser.atomsContainABondBetweenThemselves(neighbours)) {
                return true;
            }
            if ((chemEl == ChemEl.P || chemEl == ChemEl.As) && atom.getIncomingValency() == 3) {
                return true;
            }
        }
        return false;
    }

    private static boolean atomsContainABondBetweenThemselves(List<Atom> atoms) {
        for (Atom atom : atoms) {
            for (Atom neighbour : atom.getAtomNeighbours()) {
                if (!atoms.contains(neighbour)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isAchiralDueToResonanceOrTautomerism(Atom atom) {
        ChemEl chemEl = atom.getElement();
        if (chemEl == ChemEl.N || chemEl == ChemEl.P || chemEl == ChemEl.As || chemEl == ChemEl.S || chemEl == ChemEl.Se) {
            List<Atom> neighbours = atom.getAtomNeighbours();
            HashSet<String> resonanceAndTautomerismAtomicElementPlusIsotopes = new HashSet<String>();
            for (Atom neighbour : neighbours) {
                ChemEl neighbourChemEl = neighbour.getElement();
                if ((neighbourChemEl.isChalcogen() || neighbourChemEl == ChemEl.N) && StereoAnalyser.isOnlyBondedToHydrogensOtherThanGivenAtom(neighbour, atom)) {
                    if (resonanceAndTautomerismAtomicElementPlusIsotopes.contains(neighbourChemEl.toString() + atom.getIsotope())) {
                        return true;
                    }
                    resonanceAndTautomerismAtomicElementPlusIsotopes.add(neighbourChemEl.toString() + atom.getIsotope());
                }
                if (neighbourChemEl != ChemEl.H || neighbour.getBondCount() != 1) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isOnlyBondedToHydrogensOtherThanGivenAtom(Atom atom, Atom attachedNonHydrogen) {
        for (Atom neighbour : atom.getAtomNeighbours()) {
            if (neighbour.equals(attachedNonHydrogen) || neighbour.getElement() == ChemEl.H) continue;
            return false;
        }
        return true;
    }

    List<StereoBond> findStereoBonds() {
        ArrayList<StereoBond> stereoBonds = new ArrayList<StereoBond>();
        for (Bond bond : this.bonds) {
            if (bond.getOrder() != 2) continue;
            Atom a1 = bond.getFromAtom();
            List<Atom> neighbours1 = a1.getAtomNeighbours();
            neighbours1.remove(bond.getToAtom());
            if (neighbours1.size() != 2 && (neighbours1.size() != 1 || a1.getElement() != ChemEl.N || a1.getIncomingValency() != 3 || a1.getCharge() != 0) || neighbours1.size() == 2 && this.mappingToColour.get(neighbours1.get(0)).equals(this.mappingToColour.get(neighbours1.get(1)))) continue;
            Atom a2 = bond.getToAtom();
            List<Atom> neighbours2 = a2.getAtomNeighbours();
            neighbours2.remove(bond.getFromAtom());
            if (neighbours2.size() != 2 && (neighbours2.size() != 1 || a2.getElement() != ChemEl.N || a2.getIncomingValency() != 3 || a2.getCharge() != 0) || neighbours2.size() == 2 && this.mappingToColour.get(neighbours2.get(0)).equals(this.mappingToColour.get(neighbours2.get(1)))) continue;
            stereoBonds.add(new StereoBond(bond));
        }
        return stereoBonds;
    }

    Integer getAtomEnvironmentNumber(Atom a) {
        return this.mappingToColour.get(a);
    }

    private class AtomNeighbouringColoursComparator
    implements Comparator<Atom> {
        private AtomNeighbouringColoursComparator() {
        }

        @Override
        public int compare(Atom a, Atom b) {
            int[] colours1 = (int[])StereoAnalyser.this.atomNeighbourColours.get(a);
            int[] colours2 = (int[])StereoAnalyser.this.atomNeighbourColours.get(b);
            int colours1Size = colours1.length;
            int colours2Size = colours2.length;
            int maxCommonColourSize = Math.min(colours1Size, colours2Size);
            for (int i = 1; i <= maxCommonColourSize; ++i) {
                int difference = colours1[colours1Size - i] - colours2[colours2Size - i];
                if (difference > 0) {
                    return 1;
                }
                if (difference >= 0) continue;
                return -1;
            }
            int differenceInSize = colours1Size - colours2Size;
            if (differenceInSize > 0) {
                return 1;
            }
            if (differenceInSize < 0) {
                return -1;
            }
            return 0;
        }
    }

    private static class AtomicNumberThenAtomicMassComparator
    implements Comparator<Atom> {
        private AtomicNumberThenAtomicMassComparator() {
        }

        @Override
        public int compare(Atom a, Atom b) {
            return StereoAnalyser.compareAtomicNumberThenAtomicMass(a, b);
        }
    }

    class StereoBond {
        private final Bond bond;

        StereoBond(Bond bond) {
            this.bond = bond;
        }

        Bond getBond() {
            return this.bond;
        }

        List<Atom> getOrderedStereoAtoms() throws CipOrderingException {
            Atom a1 = this.bond.getFromAtom();
            Atom a2 = this.bond.getToAtom();
            List<Atom> cipOrdered1 = new CipSequenceRules(a1).getNeighbouringAtomsInCipOrderIgnoringGivenNeighbour(a2);
            List<Atom> cipOrdered2 = new CipSequenceRules(a2).getNeighbouringAtomsInCipOrderIgnoringGivenNeighbour(a1);
            ArrayList<Atom> stereoAtoms = new ArrayList<Atom>();
            stereoAtoms.add(cipOrdered1.get(cipOrdered1.size() - 1));
            stereoAtoms.add(a1);
            stereoAtoms.add(a2);
            stereoAtoms.add(cipOrdered2.get(cipOrdered2.size() - 1));
            return stereoAtoms;
        }
    }

    class StereoCentre {
        private final Atom stereoAtom;
        private final boolean trueStereoCentre;

        StereoCentre(Atom stereoAtom, Boolean isTrueStereoCentre) {
            this.stereoAtom = stereoAtom;
            this.trueStereoCentre = isTrueStereoCentre;
        }

        Atom getStereoAtom() {
            return this.stereoAtom;
        }

        boolean isTrueStereoCentre() {
            return this.trueStereoCentre;
        }

        List<Atom> getCipOrderedAtoms() throws CipOrderingException {
            List<Atom> cipOrderedAtoms = new CipSequenceRules(this.stereoAtom).getNeighbouringAtomsInCipOrder();
            if (cipOrderedAtoms.size() == 3) {
                cipOrderedAtoms.add(0, this.stereoAtom);
            }
            return cipOrderedAtoms;
        }
    }
}

