/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.Ring;

class SSSRFinder {
    SSSRFinder() {
    }

    static List<Ring> getSetOfSmallestRings(Fragment frag) {
        List<Atom> atomSet = frag.getAtomList();
        List<Ring> ringList = SSSRFinder.getRings(atomSet);
        if (ringList.size() > 1) {
            boolean change = true;
            while (change) {
                for (int i = 0; i < ringList.size(); ++i) {
                    Ring ring = ringList.get(i);
                    change = SSSRFinder.reduceRingSizes(ring, ringList);
                }
            }
        }
        return ringList;
    }

    private static List<Ring> getRings(List<Atom> atomSet) {
        ArrayList<Ring> ringList = new ArrayList<Ring>();
        HashSet<Atom> usedAtoms = new HashSet<Atom>();
        Atom root = atomSet.get(0);
        Atom parentAtom = null;
        HashMap<Atom, Atom> atomToParentMap = new HashMap<Atom, Atom>();
        LinkedHashSet<Bond> linkBondSet = new LinkedHashSet<Bond>();
        SSSRFinder.expand(root, parentAtom, usedAtoms, atomToParentMap, linkBondSet);
        for (Bond bond : linkBondSet) {
            Ring ring = SSSRFinder.getRing(bond, atomToParentMap);
            ringList.add(ring);
        }
        return ringList;
    }

    private static Ring getRing(Bond bond, Map<Atom, Atom> atomToParentMap) {
        Atom atomFrom = bond.getFromAtom();
        Atom atomTo = bond.getToAtom();
        List<Bond> bondSet0 = SSSRFinder.getAncestors1(atomFrom, atomToParentMap);
        List<Bond> bondSet1 = SSSRFinder.getAncestors1(atomTo, atomToParentMap);
        List<Bond> mergedBondSet = SSSRFinder.symmetricDifference(bondSet0, bondSet1);
        mergedBondSet.add(bond);
        return new Ring(mergedBondSet);
    }

    private static List<Bond> getAncestors1(Atom atom, Map<Atom, Atom> atomToParentMap) {
        Bond bond;
        Atom atom1;
        ArrayList<Bond> newBondSet = new ArrayList<Bond>();
        while ((atom1 = atomToParentMap.get(atom)) != null && !newBondSet.contains(bond = atom.getBondToAtom(atom1))) {
            newBondSet.add(bond);
            atom = atom1;
        }
        return newBondSet;
    }

    private static void expand(Atom atom, Atom parentAtom, Set<Atom> usedAtoms, Map<Atom, Atom> atomToParentMap, Set<Bond> linkBondSet) {
        usedAtoms.add(atom);
        atomToParentMap.put(atom, parentAtom);
        List<Atom> ligandAtomList = atom.getAtomNeighbours();
        for (Atom ligandAtom : ligandAtomList) {
            if (ligandAtom.equals(parentAtom)) continue;
            if (usedAtoms.contains(ligandAtom)) {
                Bond linkBond = atom.getBondToAtom(ligandAtom);
                linkBondSet.add(linkBond);
                continue;
            }
            SSSRFinder.expand(ligandAtom, atom, usedAtoms, atomToParentMap, linkBondSet);
        }
    }

    private static boolean reduceRingSizes(Ring ring, List<Ring> newList) {
        boolean change = false;
        for (int i = 0; i < newList.size(); ++i) {
            List<Bond> newBondSet;
            Ring target = newList.get(i);
            if (target == ring || (newBondSet = SSSRFinder.symmetricDifference(target.getBondList(), ring.getBondList())).size() >= target.size()) continue;
            Ring newRing = new Ring(newBondSet);
            newList.set(i, newRing);
            change = true;
        }
        return change;
    }

    private static List<Bond> symmetricDifference(List<Bond> bondSet1, List<Bond> bondSet2) {
        ArrayList<Bond> newBondSet = new ArrayList<Bond>();
        for (Bond bond1 : bondSet1) {
            if (bondSet2.contains(bond1)) continue;
            newBondSet.add(bond1);
        }
        for (Bond bond2 : bondSet2) {
            if (bondSet1.contains(bond2)) continue;
            newBondSet.add(bond2);
        }
        return newBondSet;
    }
}

