/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.StereoGroup;
import uk.ac.cam.ch.wwmm.opsin.StereoGroupType;
import uk.ac.cam.ch.wwmm.opsin.StereochemistryHandler;
import uk.ac.cam.ch.wwmm.opsin.StringTools;

class SMILESWriter {
    private static final Map<ChemEl, Integer[]> organicAtomsToStandardValencies;
    private static final List<String> closureSymbols;
    private final Deque<String> availableClosureSymbols = new ArrayDeque<String>(closureSymbols);
    private final HashMap<Bond, String> bondToClosureSymbolMap = new HashMap();
    private final HashMap<Bond, Atom> bondToNextAtomMap = new LinkedHashMap<Bond, Atom>();
    private final Fragment structure;
    private final StringBuilder smilesBuilder = new StringBuilder();
    private int options;
    private List<Atom> smilesOutputOrder;
    private static final TraversalState startBranch;
    private static final TraversalState endBranch;

    private SMILESWriter(Fragment structure, int options) {
        this.structure = structure;
        this.options = options;
    }

    static String generateSmiles(Fragment structure, int options) {
        return new SMILESWriter(structure, options).writeSmiles();
    }

    static String generateSmiles(Fragment structure) {
        return new SMILESWriter(structure, 0).writeSmiles();
    }

    static String generateExtendedSmiles(Fragment structure) {
        return new SMILESWriter(structure, 15).writeSmiles();
    }

    String writeSmiles() {
        this.assignSmilesOrder();
        this.assignDoubleBondStereochemistrySlashes();
        List<Atom> atomList = this.structure.getAtomList();
        this.smilesOutputOrder = new ArrayList<Atom>(atomList.size());
        boolean isEmpty = true;
        for (Atom currentAtom : atomList) {
            Integer visitedDepth = currentAtom.getProperty(Atom.VISITED);
            if (visitedDepth == null || visitedDepth != 0) continue;
            if (!isEmpty) {
                this.smilesBuilder.append('.');
            }
            this.traverseSmiles(currentAtom);
            isEmpty = false;
        }
        if ((this.options & 0xF) != 0) {
            this.writeExtendedSmilesLayer(this.options);
        }
        return this.smilesBuilder.toString();
    }

    private void writeExtendedSmilesLayer(int options) {
        ArrayList<String> extendedSmiles;
        boolean isPolymer;
        ArrayList<String> positionVariationBonds;
        block35: {
            HashMap<StereoGroup, ArrayList<Integer>> enhancedStereo;
            block36: {
                block37: {
                    ArrayList<String> atomLabels = new ArrayList<String>();
                    ArrayList<String> atomLocants = new ArrayList<String>();
                    positionVariationBonds = new ArrayList<String>();
                    Integer lastLabel = null;
                    Integer lastLocant = null;
                    int attachmentPointCounter = 1;
                    enhancedStereo = null;
                    HashSet<Integer> seenAttachmentpoints = new HashSet<Integer>();
                    List<Atom> polymerAttachPoints = this.structure.getPolymerAttachmentPoints();
                    isPolymer = polymerAttachPoints != null && polymerAttachPoints.size() > 0;
                    int l = this.smilesOutputOrder.size();
                    for (int i = 0; i < l; ++i) {
                        ArrayList<Integer> grps;
                        StereoGroup stereoGroup;
                        Atom a = this.smilesOutputOrder.get(i);
                        String homologyGroup = a.getProperty(Atom.HOMOLOGY_GROUP);
                        if (homologyGroup != null) {
                            if ((homologyGroup = this.escapeExtendedSmilesLabel(homologyGroup)).startsWith("_")) {
                                atomLabels.add(homologyGroup);
                            } else {
                                atomLabels.add(homologyGroup + "_p");
                            }
                            lastLabel = i;
                        } else if (a.getElement() == ChemEl.R) {
                            if (isPolymer) {
                                atomLabels.add("star_e");
                            } else {
                                Integer atomClass = a.getProperty(Atom.ATOM_CLASS);
                                if (atomClass != null) {
                                    seenAttachmentpoints.add(atomClass);
                                } else {
                                    while (seenAttachmentpoints.contains(atomClass = Integer.valueOf(attachmentPointCounter++))) {
                                    }
                                }
                                atomLabels.add("_AP" + String.valueOf(atomClass));
                            }
                            lastLabel = i;
                        } else {
                            atomLabels.add("");
                        }
                        String firstLocant = a.getFirstLocant();
                        if (firstLocant != null) {
                            atomLocants.add(firstLocant);
                            lastLocant = i;
                        } else {
                            atomLocants.add("");
                        }
                        List<Atom> atomsInPositionVariationBond = a.getProperty(Atom.POSITION_VARIATION_BOND);
                        if (atomsInPositionVariationBond != null) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(i);
                            for (int j = 0; j < atomsInPositionVariationBond.size(); ++j) {
                                stringBuilder.append(j == 0 ? (char)':' : '.');
                                Atom referencedAtom = atomsInPositionVariationBond.get(j);
                                int referencedAtomIndex = this.smilesOutputOrder.indexOf(referencedAtom);
                                if (referencedAtomIndex == -1) {
                                    throw new RuntimeException("OPSIN Bug: Failed to resolve position variation bond atom");
                                }
                                stringBuilder.append(referencedAtomIndex);
                            }
                            positionVariationBonds.add(stringBuilder.toString());
                        }
                        if ((stereoGroup = a.getStereoGroup()).getType() == StereoGroupType.Unk) continue;
                        if (enhancedStereo == null) {
                            enhancedStereo = new HashMap<StereoGroup, ArrayList<Integer>>();
                        }
                        if ((grps = (ArrayList<Integer>)enhancedStereo.get(stereoGroup)) == null) {
                            grps = new ArrayList<Integer>();
                            enhancedStereo.put(stereoGroup, grps);
                        }
                        grps.add(this.smilesOutputOrder.indexOf(a));
                    }
                    extendedSmiles = new ArrayList<String>(2);
                    if (lastLabel != null && (options & 1) != 0) {
                        extendedSmiles.add("$" + StringTools.stringListToString(atomLabels.subList(0, lastLabel + 1), ";") + "$");
                    }
                    if (lastLocant != null && (options & 2) != 0) {
                        extendedSmiles.add("$_AV:" + StringTools.stringListToString(atomLocants.subList(0, lastLocant + 1), ";") + "$");
                    }
                    if (enhancedStereo == null || (options & 8) == 0) break block35;
                    if (enhancedStereo.size() != 1) break block36;
                    if (enhancedStereo.get(new StereoGroup(StereoGroupType.Rac, 1)) == null && enhancedStereo.get(new StereoGroup(StereoGroupType.Rac, 2)) == null) break block37;
                    extendedSmiles.add("r");
                    break block35;
                }
                if (enhancedStereo.get(new StereoGroup(StereoGroupType.Rel, 1)) == null) break block35;
                List idxs = (List)enhancedStereo.get(new StereoGroup(StereoGroupType.Rel, 1));
                StringBuilder sb = new StringBuilder();
                sb.append("o1:");
                sb.append(idxs.get(0));
                for (int i = 1; i < idxs.size(); ++i) {
                    sb.append(',').append(idxs.get(i));
                }
                extendedSmiles.add(sb.toString());
                break block35;
            }
            StringBuilder sb = new StringBuilder();
            int numRac = 1;
            int numRel = 1;
            ArrayList entries = new ArrayList(enhancedStereo.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<StereoGroup, List<Integer>>>(){

                @Override
                public int compare(Map.Entry<StereoGroup, List<Integer>> a, Map.Entry<StereoGroup, List<Integer>> b) {
                    Collections.sort(a.getValue());
                    Collections.sort(b.getValue());
                    int len = Math.min(a.getValue().size(), b.getValue().size());
                    for (int i = 0; i < len; ++i) {
                        int cmp = a.getValue().get(i).compareTo(b.getValue().get(i));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    int cmp = Integer.compare(a.getValue().size(), b.getValue().size());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return a.getKey().compareTo(b.getKey());
                }
            });
            block10: for (Map.Entry entry : entries) {
                sb.setLength(0);
                StereoGroup key = (StereoGroup)entry.getKey();
                switch (key.getType()) {
                    case Abs: {
                        continue block10;
                    }
                    case Rel: {
                        sb.append("o").append(numRac++).append(":");
                        break;
                    }
                    case Rac: {
                        sb.append("&").append(numRel++).append(":");
                        break;
                    }
                    case Unk: {
                        continue block10;
                    }
                }
                List idxs = (List)entry.getValue();
                sb.append(idxs.get(0));
                for (int i = 1; i < idxs.size(); ++i) {
                    sb.append(',').append(idxs.get(i));
                }
                extendedSmiles.add(sb.toString());
            }
        }
        if (positionVariationBonds.size() > 0) {
            extendedSmiles.add("m:" + StringTools.stringListToString(positionVariationBonds, ","));
        }
        if (isPolymer && (options & 4) != 0) {
            StringBuilder sruContents = new StringBuilder();
            sruContents.append("Sg:n:");
            boolean appendDelimiter = false;
            int l = this.smilesOutputOrder.size();
            for (int i = 0; i < l; ++i) {
                if (this.smilesOutputOrder.get(i).getElement() == ChemEl.R) continue;
                if (appendDelimiter) {
                    sruContents.append(',');
                }
                sruContents.append(i);
                appendDelimiter = true;
            }
            sruContents.append("::ht");
            extendedSmiles.add(sruContents.toString());
        }
        if (extendedSmiles.size() > 0) {
            this.smilesBuilder.append(" |");
            this.smilesBuilder.append(StringTools.stringListToString(extendedSmiles, ","));
            this.smilesBuilder.append('|');
        }
    }

    private String escapeExtendedSmilesLabel(String str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            sb.append("&#");
            sb.append(String.valueOf((int)ch));
            sb.append(';');
        }
        return sb.toString();
    }

    private void assignSmilesOrder() {
        List<Atom> atomList = this.structure.getAtomList();
        for (Atom atom : atomList) {
            atom.setProperty(Atom.VISITED, null);
        }
        for (Atom a : atomList) {
            if (a.getProperty(Atom.VISITED) != null || this.isSmilesImplicitProton(a)) continue;
            this.traverseMolecule(a);
        }
    }

    private void traverseMolecule(Atom startingAtom) {
        ArrayDeque<TraversalState> stack = new ArrayDeque<TraversalState>();
        stack.add(new TraversalState(startingAtom, null, 0));
        while (!stack.isEmpty()) {
            TraversalState currentstate = (TraversalState)stack.removeLast();
            Atom currentAtom = currentstate.atom;
            Bond bondtaken = currentstate.bondTaken;
            if (bondtaken != null) {
                this.bondToNextAtomMap.put(bondtaken, currentAtom);
            }
            if (currentAtom.getProperty(Atom.VISITED) != null) continue;
            int depth = currentstate.depth;
            currentAtom.setProperty(Atom.VISITED, depth);
            List<Bond> bonds = currentAtom.getBonds();
            for (int i = bonds.size() - 1; i >= 0; --i) {
                Atom neighbour;
                Bond bond = bonds.get(i);
                if (bond.equals(bondtaken) || this.isSmilesImplicitProton(neighbour = bond.getOtherAtom(currentAtom))) continue;
                stack.add(new TraversalState(neighbour, bond, depth + 1));
            }
        }
    }

    private boolean isSmilesImplicitProton(Atom atom) {
        List<Bond> bondsFromNitrogen;
        if (atom.getElement() != ChemEl.H) {
            return false;
        }
        if (atom.getIsotope() != null && atom.getIsotope() != 1) {
            return false;
        }
        List<Atom> neighbours = atom.getAtomNeighbours();
        int neighbourCount = neighbours.size();
        if (neighbourCount > 1) {
            return false;
        }
        if (neighbourCount == 0) {
            return false;
        }
        Atom neighbour = neighbours.get(0);
        ChemEl chemEl = neighbour.getElement();
        if (chemEl == ChemEl.H || chemEl == ChemEl.R) {
            return false;
        }
        if (chemEl == ChemEl.N && (bondsFromNitrogen = neighbour.getBonds()).size() == 2) {
            for (Bond bond : bondsFromNitrogen) {
                if (bond.getBondStereo() == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasStereo(Atom atom) {
        AtomParity parity = atom.getAtomParity();
        if (parity == null) {
            return false;
        }
        if ((this.options & 8) != 0) {
            return true;
        }
        StereoGroupType stereoGroupType = parity.getStereoGroup().getType();
        return stereoGroupType != StereoGroupType.Rac && stereoGroupType != StereoGroupType.Rel || this.countStereoGroup(atom) != 1;
    }

    private int countStereoGroup(Atom atom) {
        StereoGroup refGroup = atom.getAtomParity().getStereoGroup();
        int count = 0;
        for (Atom a : atom.getFrag()) {
            AtomParity atomParity = a.getAtomParity();
            if (atomParity == null || !atomParity.getStereoGroup().equals(refGroup)) continue;
            ++count;
        }
        return count;
    }

    private void assignDoubleBondStereochemistrySlashes() {
        Set<Bond> bonds = this.bondToNextAtomMap.keySet();
        for (Bond bond : bonds) {
            bond.setSmilesStereochemistry(null);
        }
        for (Bond bond : bonds) {
            BondStereo bondStereo = bond.getBondStereo();
            if (bondStereo == null) continue;
            Atom[] atomRefs4 = bondStereo.getAtomRefs4();
            Bond bond1 = atomRefs4[0].getBondToAtom(atomRefs4[1]);
            Bond bond2 = atomRefs4[2].getBondToAtom(atomRefs4[3]);
            if (bond1 == null || bond2 == null) {
                throw new RuntimeException("OPSIN Bug: Bondstereo described atoms that are not bonded");
            }
            Atom bond1ToAtom = this.bondToNextAtomMap.get(bond1);
            Atom bond2ToAtom = this.bondToNextAtomMap.get(bond2);
            Bond.SMILES_BOND_DIRECTION bond1Slash = bond1.getSmilesStereochemistry();
            Bond.SMILES_BOND_DIRECTION bond2Slash = bond2.getSmilesStereochemistry();
            Bond.SMILES_BOND_DIRECTION bond1Direction = Bond.SMILES_BOND_DIRECTION.LSLASH;
            Bond.SMILES_BOND_DIRECTION bond2Direction = Bond.SMILES_BOND_DIRECTION.LSLASH;
            if (bondStereo.getBondStereoValue().equals((Object)BondStereo.BondStereoValue.CIS)) {
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            }
            if (!bond1ToAtom.equals(atomRefs4[1])) {
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            }
            if (!bond2ToAtom.equals(atomRefs4[3])) {
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            }
            if (bond1Slash != null && !bond1Slash.equals((Object)bond1Direction)) {
                bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            } else if (bond2Slash != null && !bond2Slash.equals((Object)bond2Direction)) {
                bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            }
            Bond bond1Other = null;
            Bond bond2Other = null;
            Bond.SMILES_BOND_DIRECTION bond1OtherDirection = null;
            Bond.SMILES_BOND_DIRECTION bond2OtherDirection = null;
            ArrayList<Bond> bondsFrom2ndAtom = new ArrayList<Bond>(atomRefs4[1].getBonds());
            bondsFrom2ndAtom.remove(bond1);
            bondsFrom2ndAtom.remove(bond);
            if (bondsFrom2ndAtom.size() == 1 && this.bondToNextAtomMap.containsKey(bondsFrom2ndAtom.get(0))) {
                bond1Other = (Bond)bondsFrom2ndAtom.get(0);
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond1OtherDirection = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                if (!bond1ToAtom.equals(atomRefs4[1])) {
                    Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION2 = bond1OtherDirection = bond1OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
                if (!this.bondToNextAtomMap.get(bond1Other).equals(atomRefs4[1])) {
                    bond1OtherDirection = bond1OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
            }
            ArrayList<Bond> bondsFrom3rdAtom = new ArrayList<Bond>(atomRefs4[2].getBonds());
            bondsFrom3rdAtom.remove(bond2);
            bondsFrom3rdAtom.remove(bond);
            if (bondsFrom3rdAtom.size() == 1 && this.bondToNextAtomMap.containsKey(bondsFrom3rdAtom.get(0))) {
                bond2Other = (Bond)bondsFrom3rdAtom.get(0);
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond2OtherDirection = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                if (!bond2ToAtom.equals(atomRefs4[3])) {
                    Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION3 = bond2OtherDirection = bond2OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
                if (!this.bondToNextAtomMap.get(bond2Other).equals(bond2Other.getOtherAtom(atomRefs4[2]))) {
                    Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION4 = bond2OtherDirection = bond2OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
            }
            if (bond1Other != null && bond1Other.getSmilesStereochemistry() != null && !bond1Other.getSmilesStereochemistry().equals((Object)bond1OtherDirection)) {
                bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond1OtherDirection = bond1OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                if (bond2Other != null) {
                    bond2OtherDirection = bond2OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
            } else if (bond2Other != null && bond2Other.getSmilesStereochemistry() != null && !bond2Other.getSmilesStereochemistry().equals((Object)bond2OtherDirection)) {
                bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond2OtherDirection = bond2OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                if (bond1Other != null) {
                    bond1OtherDirection = bond1OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
            }
            bond1.setSmilesStereochemistry(bond1Direction);
            bond2.setSmilesStereochemistry(bond2Direction);
            if (bond1Other != null) {
                bond1Other.setSmilesStereochemistry(bond1OtherDirection);
            }
            if (bond2Other == null) continue;
            bond2Other.setSmilesStereochemistry(bond2OtherDirection);
        }
    }

    private void traverseSmiles(Atom startingAtom) {
        ArrayDeque<TraversalState> stack = new ArrayDeque<TraversalState>();
        stack.add(new TraversalState(startingAtom, null, 0));
        while (!stack.isEmpty()) {
            String closure;
            Atom neighbour;
            Integer nDepth;
            TraversalState currentstate = (TraversalState)stack.removeLast();
            if (currentstate == startBranch) {
                this.smilesBuilder.append('(');
                continue;
            }
            if (currentstate == endBranch) {
                this.smilesBuilder.append(')');
                continue;
            }
            Atom currentAtom = currentstate.atom;
            Bond bondtaken = currentstate.bondTaken;
            if (bondtaken != null) {
                this.smilesBuilder.append(this.bondToSmiles(bondtaken));
            }
            int depth = currentstate.depth;
            this.smilesBuilder.append(this.atomToSmiles(currentAtom, depth, bondtaken));
            this.smilesOutputOrder.add(currentAtom);
            List<Bond> bonds = currentAtom.getBonds();
            ArrayList<String> newlyAvailableClosureSymbols = null;
            for (Bond bond : bonds) {
                if (bond.equals(bondtaken) || (nDepth = (neighbour = bond.getOtherAtom(currentAtom)).getProperty(Atom.VISITED)) == null || nDepth > depth) continue;
                closure = this.bondToClosureSymbolMap.get(bond);
                this.smilesBuilder.append(closure);
                if (newlyAvailableClosureSymbols == null) {
                    newlyAvailableClosureSymbols = new ArrayList<String>();
                }
                newlyAvailableClosureSymbols.add(closure);
            }
            for (Bond bond : bonds) {
                neighbour = bond.getOtherAtom(currentAtom);
                nDepth = neighbour.getProperty(Atom.VISITED);
                if (nDepth == null || nDepth <= depth + 1) continue;
                closure = this.availableClosureSymbols.removeFirst();
                this.bondToClosureSymbolMap.put(bond, closure);
                this.smilesBuilder.append(this.bondToSmiles(bond));
                this.smilesBuilder.append(closure);
            }
            if (newlyAvailableClosureSymbols != null) {
                for (int i = newlyAvailableClosureSymbols.size() - 1; i >= 0; --i) {
                    this.availableClosureSymbols.addFirst((String)newlyAvailableClosureSymbols.get(i));
                }
            }
            boolean seenFirstBranch = false;
            for (int i = bonds.size() - 1; i >= 0; --i) {
                Bond bond = bonds.get(i);
                Atom neighbour2 = bond.getOtherAtom(currentAtom);
                Integer nDepth2 = neighbour2.getProperty(Atom.VISITED);
                if (nDepth2 == null || nDepth2 != depth + 1) continue;
                if (!seenFirstBranch) {
                    stack.add(new TraversalState(neighbour2, bond, depth + 1));
                    seenFirstBranch = true;
                    continue;
                }
                stack.add(endBranch);
                stack.add(new TraversalState(neighbour2, bond, depth + 1));
                stack.add(startBranch);
            }
        }
    }

    private String atomToSmiles(Atom atom, int depth, Bond bondtaken) {
        int charge;
        ChemEl chemEl;
        StringBuilder atomSmiles = new StringBuilder();
        int hydrogenCount = this.calculateNumberOfBondedExplicitHydrogen(atom);
        boolean needsSquareBrackets = this.determineWhetherAtomNeedsSquareBrackets(atom, hydrogenCount);
        if (needsSquareBrackets) {
            atomSmiles.append('[');
        }
        if (atom.getIsotope() != null) {
            atomSmiles.append(atom.getIsotope());
        }
        if ((chemEl = atom.getElement()) == ChemEl.R) {
            atomSmiles.append('*');
        } else if (atom.hasSpareValency()) {
            atomSmiles.append(chemEl.toString().toLowerCase(Locale.ROOT));
        } else {
            atomSmiles.append(chemEl.toString());
        }
        if (this.hasStereo(atom)) {
            atomSmiles.append(this.atomParityToSmiles(atom, depth, bondtaken));
        }
        if (hydrogenCount != 0 && needsSquareBrackets && chemEl != ChemEl.H) {
            atomSmiles.append('H');
            if (hydrogenCount != 1) {
                atomSmiles.append(String.valueOf(hydrogenCount));
            }
        }
        if ((charge = atom.getCharge()) != 0) {
            if (charge == 1) {
                atomSmiles.append('+');
            } else if (charge == -1) {
                atomSmiles.append('-');
            } else {
                if (charge > 0) {
                    atomSmiles.append('+');
                }
                atomSmiles.append(charge);
            }
        }
        if (needsSquareBrackets) {
            Integer atomClass = atom.getProperty(Atom.ATOM_CLASS);
            if (atomClass != null) {
                atomSmiles.append(':');
                atomSmiles.append(String.valueOf(atomClass));
            }
            atomSmiles.append(']');
        }
        return atomSmiles.toString();
    }

    private int calculateNumberOfBondedExplicitHydrogen(Atom atom) {
        List<Atom> neighbours = atom.getAtomNeighbours();
        int count = 0;
        for (Atom neighbour : neighbours) {
            if (neighbour.getProperty(Atom.VISITED) != null) continue;
            ++count;
        }
        return count;
    }

    private boolean determineWhetherAtomNeedsSquareBrackets(Atom atom, int hydrogenCount) {
        int nonHydrogenValency;
        Object[] expectedValencies = organicAtomsToStandardValencies.get((Object)atom.getElement());
        if (expectedValencies == null) {
            return true;
        }
        if (atom.getCharge() != 0) {
            return true;
        }
        if (atom.getIsotope() != null) {
            return true;
        }
        if (this.hasStereo(atom)) {
            return true;
        }
        int valency = atom.getIncomingValency();
        boolean valencyCanBeDescribedImplicitly = Arrays.binarySearch(expectedValencies, (Object)valency) >= 0;
        int targetImplicitValency = valency;
        if (valency > (Integer)expectedValencies[expectedValencies.length - 1]) {
            valencyCanBeDescribedImplicitly = true;
        }
        if (!valencyCanBeDescribedImplicitly) {
            return true;
        }
        int implicitValencyThatWouldBeGenerated = nonHydrogenValency = valency - hydrogenCount;
        for (int i = expectedValencies.length - 1; i >= 0; --i) {
            if ((Integer)expectedValencies[i] < nonHydrogenValency) continue;
            implicitValencyThatWouldBeGenerated = (Integer)expectedValencies[i];
        }
        if (targetImplicitValency != implicitValencyThatWouldBeGenerated) {
            return true;
        }
        return atom.getProperty(Atom.ATOM_CLASS) != null;
    }

    private String atomParityToSmiles(Atom currentAtom, int depth, Bond bondtaken) {
        int i;
        Atom neighbour;
        AtomParity atomParity = currentAtom.getAtomParity();
        Atom[] atomRefs4 = (Atom[])atomParity.getAtomRefs4().clone();
        ArrayList<Atom> atomrefs4Current = new ArrayList<Atom>();
        if (bondtaken != null) {
            Atom atom = bondtaken.getOtherAtom(currentAtom);
            atomrefs4Current.add(atom);
        }
        for (Atom atom : atomRefs4) {
            if (!atom.equals(currentAtom)) continue;
            atomrefs4Current.add(currentAtom);
        }
        List<Bond> list = currentAtom.getBonds();
        for (Bond bond : list) {
            neighbour = bond.getOtherAtom(currentAtom);
            if (neighbour.getProperty(Atom.VISITED) != null) continue;
            atomrefs4Current.add(currentAtom);
        }
        for (Bond bond : list) {
            if (bond.equals(bondtaken) || (neighbour = bond.getOtherAtom(currentAtom)).getProperty(Atom.VISITED) == null || neighbour.getProperty(Atom.VISITED) > depth) continue;
            atomrefs4Current.add(neighbour);
        }
        for (Bond bond : list) {
            neighbour = bond.getOtherAtom(currentAtom);
            if (neighbour.getProperty(Atom.VISITED) == null || neighbour.getProperty(Atom.VISITED) <= depth + 1) continue;
            atomrefs4Current.add(neighbour);
        }
        for (Bond bond : list) {
            neighbour = bond.getOtherAtom(currentAtom);
            if (neighbour.getProperty(Atom.VISITED) == null || neighbour.getProperty(Atom.VISITED) != depth + 1) continue;
            atomrefs4Current.add(neighbour);
        }
        Atom[] atomrefs4CurrentArr = new Atom[4];
        for (i = 0; i < atomrefs4Current.size(); ++i) {
            atomrefs4CurrentArr[i] = (Atom)atomrefs4Current.get(i);
        }
        for (i = 0; i < atomRefs4.length; ++i) {
            if (atomRefs4[i].getProperty(Atom.VISITED) != null) continue;
            atomRefs4[i] = currentAtom;
        }
        boolean equivalent = StereochemistryHandler.checkEquivalencyOfAtomsRefs4AndParity(atomRefs4, atomParity.getParity(), atomrefs4CurrentArr, 1);
        if (equivalent) {
            return "@@";
        }
        return "@";
    }

    private String bondToSmiles(Bond bond) {
        String bondSmiles = "";
        int bondOrder = bond.getOrder();
        if (bondOrder == 2) {
            bondSmiles = "=";
        } else if (bondOrder == 3) {
            bondSmiles = "#";
        } else if (bond.getSmilesStereochemistry() != null) {
            bondSmiles = bond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.RSLASH ? "/" : "\\";
        }
        return bondSmiles;
    }

    static {
        int i;
        organicAtomsToStandardValencies = new EnumMap<ChemEl, Integer[]>(ChemEl.class);
        closureSymbols = new ArrayList<String>();
        organicAtomsToStandardValencies.put(ChemEl.B, new Integer[]{3});
        organicAtomsToStandardValencies.put(ChemEl.C, new Integer[]{4});
        organicAtomsToStandardValencies.put(ChemEl.N, new Integer[]{3, 5});
        organicAtomsToStandardValencies.put(ChemEl.O, new Integer[]{2});
        organicAtomsToStandardValencies.put(ChemEl.P, new Integer[]{3, 5});
        organicAtomsToStandardValencies.put(ChemEl.S, new Integer[]{2, 4, 6});
        organicAtomsToStandardValencies.put(ChemEl.F, new Integer[]{1});
        organicAtomsToStandardValencies.put(ChemEl.Cl, new Integer[]{1});
        organicAtomsToStandardValencies.put(ChemEl.Br, new Integer[]{1});
        organicAtomsToStandardValencies.put(ChemEl.I, new Integer[]{1});
        organicAtomsToStandardValencies.put(ChemEl.R, new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        for (i = 1; i <= 9; ++i) {
            closureSymbols.add(String.valueOf(i));
        }
        for (i = 10; i <= 99; ++i) {
            closureSymbols.add("%" + i);
        }
        closureSymbols.add("0");
        startBranch = new TraversalState(null, null, -1);
        endBranch = new TraversalState(null, null, -1);
    }

    private static class TraversalState {
        private final Atom atom;
        private final Bond bondTaken;
        private final int depth;

        private TraversalState(Atom atom, Bond bondTaken, int depth) {
            this.atom = atom;
            this.bondTaken = bondTaken;
            this.depth = depth;
        }
    }
}

