/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.IDManager;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;

class SMILESFragmentBuilder {
    private static final Atom ringOpeningDummyAtom = new Atom(ChemEl.R);
    private static final Set<String> organicAtoms = new HashSet<String>();
    private static final Set<String> aromaticAtoms = new HashSet<String>();
    private final IDManager idManager;

    SMILESFragmentBuilder(IDManager idManager) {
        this.idManager = idManager;
    }

    Fragment build(String smiles) throws StructureBuildingException {
        return this.build(smiles, "", "none");
    }

    Fragment build(String smiles, String type, String labelMapping) throws StructureBuildingException {
        return this.build(smiles, new Fragment(type), labelMapping);
    }

    Fragment build(String smiles, Element tokenEl, String labelMapping) throws StructureBuildingException {
        if (tokenEl == null) {
            throw new IllegalArgumentException("tokenEl is null. FragmentManager's DUMMY_TOKEN should be used instead");
        }
        return this.build(smiles, new Fragment(tokenEl), labelMapping);
    }

    private Fragment build(String smiles, Fragment fragment, String labelMapping) throws StructureBuildingException {
        if (smiles == null) {
            throw new IllegalArgumentException("SMILES specified is null");
        }
        if (labelMapping == null) {
            throw new IllegalArgumentException("labelMapping is null use \"none\" if you do not want any numbering or \"numeric\" if you would like default numbering");
        }
        if (smiles.isEmpty()) {
            return fragment;
        }
        ParserInstance instance = new ParserInstance(smiles, fragment);
        instance.parseSmiles();
        List<Atom> atomList = fragment.getAtomList();
        this.processLabelling(labelMapping, atomList);
        this.verifyAndTakeIntoAccountLonePairsInAtomParities(atomList);
        this.addBondStereoElements(fragment);
        for (Atom atom : atomList) {
            if (atom.getProperty(Atom.SMILES_HYDROGEN_COUNT) == null || atom.getLambdaConventionValency() != null) continue;
            this.setupAtomValency(atom);
        }
        CycleDetector.assignWhetherAtomsAreInCycles(fragment);
        return fragment;
    }

    private void processLabelling(String labelMapping, List<Atom> atomList) throws StructureBuildingException {
        if (labelMapping.equals("none") || labelMapping.length() == 0) {
            return;
        }
        if (labelMapping.equals("numeric")) {
            int atomNumber = 1;
            for (Atom atom : atomList) {
                atom.addLocant(Integer.toString(atomNumber++));
            }
        } else if (labelMapping.equals("fusedRing")) {
            FragmentTools.relabelLocantsAsFusedRingSystem(atomList);
        } else {
            int numOfAtoms;
            String[] labelMap = labelMapping.split("/", -1);
            if (labelMap.length != (numOfAtoms = atomList.size())) {
                throw new StructureBuildingException("Group numbering has been invalidly defined in resource file: labels: " + labelMap.length + ", atoms: " + numOfAtoms);
            }
            for (int i = 0; i < numOfAtoms; ++i) {
                String[] labels;
                for (String label : labels = labelMap[i].split(",")) {
                    if (label.length() <= 0) continue;
                    atomList.get(i).addLocant(label);
                }
            }
        }
    }

    private void verifyAndTakeIntoAccountLonePairsInAtomParities(List<Atom> atomList) throws StructureBuildingException {
        for (Atom atom : atomList) {
            AtomParity atomParity = atom.getAtomParity();
            if (atomParity == null) continue;
            Atom[] atomRefs4 = atomParity.getAtomRefs4();
            int nullAtoms = 0;
            int hydrogen = 0;
            for (Atom atomRefs4Atom : atomRefs4) {
                if (atomRefs4Atom == null) {
                    ++nullAtoms;
                    continue;
                }
                if (!atomRefs4Atom.equals(AtomParity.hydrogen)) continue;
                ++hydrogen;
            }
            if (nullAtoms == 0) continue;
            if (nullAtoms == 1 && hydrogen == 0 && (atom.getElement() == ChemEl.N || atom.getElement() == ChemEl.S || atom.getElement() == ChemEl.Se)) {
                if (atomList.indexOf(atomRefs4[0]) < atomList.indexOf(atom)) {
                    atomRefs4[3] = atomRefs4[2];
                    atomRefs4[2] = atomRefs4[1];
                    atomRefs4[1] = atom;
                    continue;
                }
                atomRefs4[3] = atomRefs4[2];
                atomRefs4[2] = atomRefs4[1];
                atomRefs4[1] = atomRefs4[0];
                atomRefs4[0] = atom;
                continue;
            }
            throw new StructureBuildingException("SMILES is malformed. Tetrahedral stereochemistry defined on a non tetrahedral centre");
        }
    }

    private void addBondStereoElements(Fragment currentFrag) throws StructureBuildingException {
        Set<Bond> bonds = currentFrag.getBondSet();
        for (Bond centralBond : bonds) {
            if (centralBond.getOrder() != 2) continue;
            List<Bond> fromAtomBonds = centralBond.getFromAtom().getBonds();
            for (Bond preceedingBond : fromAtomBonds) {
                if (preceedingBond.getSmilesStereochemistry() == null) continue;
                List<Bond> toAtomBonds = centralBond.getToAtom().getBonds();
                for (Bond followingBond : toAtomBonds) {
                    Atom[] atomRefs4;
                    BondStereo.BondStereoValue cisTrans;
                    boolean upSecond;
                    boolean upFirst;
                    if (followingBond.getSmilesStereochemistry() == null) continue;
                    Atom atom2 = centralBond.getFromAtom();
                    Atom atom3 = centralBond.getToAtom();
                    Atom atom1 = preceedingBond.getOtherAtom(atom2);
                    Atom atom4 = followingBond.getOtherAtom(atom3);
                    if (preceedingBond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.LSLASH) {
                        upFirst = preceedingBond.getToAtom() == atom2;
                    } else if (preceedingBond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.RSLASH) {
                        upFirst = preceedingBond.getToAtom() != atom2;
                    } else {
                        throw new StructureBuildingException((Object)((Object)preceedingBond.getSmilesStereochemistry()) + " is not a slash!");
                    }
                    if (followingBond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.LSLASH) {
                        upSecond = followingBond.getFromAtom() != atom3;
                    } else if (followingBond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.RSLASH) {
                        upSecond = followingBond.getFromAtom() == atom3;
                    } else {
                        throw new StructureBuildingException((Object)((Object)followingBond.getSmilesStereochemistry()) + " is not a slash!");
                    }
                    BondStereo.BondStereoValue bondStereoValue = cisTrans = upFirst == upSecond ? BondStereo.BondStereoValue.CIS : BondStereo.BondStereoValue.TRANS;
                    if (centralBond.getBondStereo() != null) {
                        atomRefs4 = centralBond.getBondStereo().getAtomRefs4();
                        if (!(atomRefs4[0].equals(atom1) || atomRefs4[3].equals(atom4) ? centralBond.getBondStereo().getBondStereoValue().equals((Object)cisTrans) : !centralBond.getBondStereo().getBondStereoValue().equals((Object)cisTrans))) continue;
                        throw new StructureBuildingException("Contradictory double bond stereoconfiguration");
                    }
                    atomRefs4 = new Atom[]{atom1, atom2, atom3, atom4};
                    centralBond.setBondStereoElement(atomRefs4, cisTrans);
                }
            }
        }
        for (Bond bond : bonds) {
            bond.setSmilesStereochemistry(null);
        }
    }

    private void setupAtomValency(Atom atom) throws StructureBuildingException {
        block12: {
            int hydrogenCount;
            block11: {
                ChemEl chemEl;
                int charge;
                int incomingValency;
                block13: {
                    Integer defaultVal;
                    hydrogenCount = atom.getProperty(Atom.SMILES_HYDROGEN_COUNT);
                    incomingValency = atom.getIncomingValency() + hydrogenCount + atom.getOutValency();
                    charge = atom.getCharge();
                    int absoluteCharge = Math.abs(charge);
                    chemEl = atom.getElement();
                    if (atom.hasSpareValency()) {
                        Integer hwValency = ValencyChecker.getHWValency(chemEl);
                        if (hwValency == null || absoluteCharge > 1) {
                            throw new StructureBuildingException((Object)((Object)chemEl) + " is not expected to be aromatic!");
                        }
                        if (absoluteCharge != 0) {
                            Integer[] possibleVal = ValencyChecker.getPossibleValencies(chemEl, charge);
                            if (possibleVal != null && possibleVal.length > 0) {
                                hwValency = possibleVal[0];
                            } else {
                                throw new StructureBuildingException((Object)((Object)chemEl) + " with charge " + charge + " is not expected to be aromatic!");
                            }
                        }
                        if (incomingValency < hwValency) {
                            ++incomingValency;
                        }
                    }
                    if ((defaultVal = ValencyChecker.getDefaultValency(chemEl)) == null) break block11;
                    if (defaultVal == incomingValency && charge == 0) break block12;
                    if (Math.abs(incomingValency - defaultVal) != absoluteCharge) break block13;
                    atom.setProtonsExplicitlyAddedOrRemoved(incomingValency - defaultVal);
                    break block12;
                }
                Integer[] unchargedStableValencies = ValencyChecker.getPossibleValencies(chemEl, 0);
                boolean hasPlausibleValency = false;
                for (Integer unchargedStableValency : unchargedStableValencies) {
                    if (Math.abs(incomingValency - unchargedStableValency) != Math.abs(charge)) continue;
                    atom.setProtonsExplicitlyAddedOrRemoved(incomingValency - unchargedStableValency);
                    if (charge != 0) {
                        atom.setLambdaConventionValency(unchargedStableValency);
                    } else {
                        atom.setMinimumValency(incomingValency);
                    }
                    hasPlausibleValency = true;
                    break;
                }
                if (hasPlausibleValency) break block12;
                atom.setMinimumValency(incomingValency);
                break block12;
            }
            if (hydrogenCount > 0) {
                Fragment frag = atom.getFrag();
                for (int i = 0; i < hydrogenCount; ++i) {
                    Atom hydrogen = this.createAtom(ChemEl.H, frag);
                    this.createBond(atom, hydrogen, 1);
                }
            }
        }
    }

    private Atom createAtom(String elementSymbol, Fragment frag) {
        return this.createAtom(ChemEl.valueOf(elementSymbol), frag);
    }

    private Atom createAtom(ChemEl chemEl, Fragment frag) {
        Atom a = new Atom(this.idManager.getNextID(), chemEl, frag);
        frag.addAtom(a);
        return a;
    }

    private Bond createBond(Atom fromAtom, Atom toAtom, int bondOrder) {
        Bond b = new Bond(fromAtom, toAtom, bondOrder);
        fromAtom.addBond(b);
        toAtom.addBond(b);
        fromAtom.getFrag().addBond(b);
        return b;
    }

    private boolean is_A_to_Z(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    private boolean is_a_to_z(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    private boolean is_0_to_9(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static {
        organicAtoms.add("B");
        organicAtoms.add("C");
        organicAtoms.add("N");
        organicAtoms.add("O");
        organicAtoms.add("P");
        organicAtoms.add("S");
        organicAtoms.add("F");
        organicAtoms.add("Cl");
        organicAtoms.add("Br");
        organicAtoms.add("I");
        aromaticAtoms.add("c");
        aromaticAtoms.add("n");
        aromaticAtoms.add("o");
        aromaticAtoms.add("p");
        aromaticAtoms.add("s");
        aromaticAtoms.add("si");
        aromaticAtoms.add("as");
        aromaticAtoms.add("se");
        aromaticAtoms.add("sb");
        aromaticAtoms.add("te");
    }

    private class ParserInstance {
        private final Deque<StackFrame> stack = new ArrayDeque<StackFrame>();
        private final Map<String, StackFrame> ringClosures = new HashMap<String, StackFrame>();
        private final String smiles;
        private final int endOfSmiles;
        private final Fragment fragment;
        private final int firstAtomOutValency;
        private final int lastAtomOutValency;
        private int i;

        ParserInstance(String smiles, Fragment fragment) {
            this.smiles = smiles;
            this.fragment = fragment;
            int lastIndex = smiles.length();
            char firstChar = smiles.charAt(0);
            if (firstChar == '-') {
                this.firstAtomOutValency = 1;
                this.i = 1;
            } else if (firstChar == '=') {
                this.firstAtomOutValency = 2;
                this.i = 1;
            } else if (firstChar == '#') {
                this.firstAtomOutValency = 3;
                this.i = 1;
            } else {
                this.firstAtomOutValency = -1;
                this.i = 0;
            }
            char lastChar = smiles.charAt(lastIndex - 1);
            if (lastChar == '-') {
                this.lastAtomOutValency = 1;
                this.endOfSmiles = lastIndex - 1;
            } else if (lastChar == '=') {
                this.lastAtomOutValency = 2;
                this.endOfSmiles = lastIndex - 1;
            } else if (lastChar == '#') {
                this.lastAtomOutValency = 3;
                this.endOfSmiles = lastIndex - 1;
            } else {
                this.lastAtomOutValency = -1;
                this.endOfSmiles = lastIndex;
            }
        }

        void parseSmiles() throws StructureBuildingException {
            this.stack.add(new StackFrame(null, 1));
            while (this.i < this.endOfSmiles) {
                char ch = this.smiles.charAt(this.i);
                switch (ch) {
                    case '(': {
                        this.stack.add(new StackFrame(this.stack.getLast()));
                        break;
                    }
                    case ')': {
                        this.stack.removeLast();
                        break;
                    }
                    case '-': {
                        this.stack.getLast().bondOrder = 1;
                        break;
                    }
                    case '=': {
                        if (this.stack.getLast().bondOrder != 1) {
                            throw new StructureBuildingException("= in unexpected position: bond order already defined!");
                        }
                        this.stack.getLast().bondOrder = 2;
                        break;
                    }
                    case '#': {
                        if (this.stack.getLast().bondOrder != 1) {
                            throw new StructureBuildingException("# in unexpected position: bond order already defined!");
                        }
                        this.stack.getLast().bondOrder = 3;
                        break;
                    }
                    case '/': {
                        if (this.stack.getLast().slash != null) {
                            throw new StructureBuildingException("/ in unexpected position: bond configuration already defined!");
                        }
                        this.stack.getLast().slash = Bond.SMILES_BOND_DIRECTION.RSLASH;
                        break;
                    }
                    case '\\': {
                        if (this.stack.getLast().slash != null) {
                            throw new StructureBuildingException("\\ in unexpected position: bond configuration already defined!");
                        }
                        this.stack.getLast().slash = Bond.SMILES_BOND_DIRECTION.LSLASH;
                        break;
                    }
                    case '.': {
                        this.stack.getLast().atom = null;
                        break;
                    }
                    case '*': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.processOrganicAtom(ch);
                        break;
                    }
                    case '[': {
                        this.processBracketedAtom();
                        break;
                    }
                    case '%': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.processRingOpeningOrClosure(ch);
                        break;
                    }
                    default: {
                        throw new StructureBuildingException(ch + " is in an unexpected position. Check this is not a mistake and that this feature of SMILES is supported by OPSIN's SMILES parser");
                    }
                }
                ++this.i;
            }
            if (!this.ringClosures.isEmpty()) {
                throw new StructureBuildingException("Unmatched ring opening");
            }
            if (this.firstAtomOutValency > 0) {
                this.fragment.addOutAtom(this.fragment.getFirstAtom(), this.firstAtomOutValency, (Boolean)true);
            }
            if (this.lastAtomOutValency > 0) {
                this.fragment.addOutAtom(this.getInscopeAtom(), this.lastAtomOutValency, (Boolean)true);
            }
        }

        private void processOrganicAtom(char ch) throws StructureBuildingException {
            String elementType = String.valueOf(ch);
            boolean spareValency = false;
            if (SMILESFragmentBuilder.this.is_A_to_Z(ch)) {
                if (this.i + 1 < this.endOfSmiles && SMILESFragmentBuilder.this.is_a_to_z(this.smiles.charAt(this.i + 1)) && organicAtoms.contains(this.smiles.substring(this.i, this.i + 2))) {
                    elementType = this.smiles.substring(this.i, this.i + 2);
                    ++this.i;
                } else if (!organicAtoms.contains(elementType)) {
                    throw new StructureBuildingException(elementType + " is not an organic Element. If it is actually an element it should be in square brackets");
                }
            } else if (SMILESFragmentBuilder.this.is_a_to_z(ch)) {
                if (!aromaticAtoms.contains(elementType)) {
                    throw new StructureBuildingException(elementType + " is not an aromatic Element. If it is actually an element it should not be in lower case");
                }
                elementType = String.valueOf((char)(ch - 32));
                spareValency = true;
            } else if (ch == '*') {
                elementType = "R";
            }
            Atom atom = SMILESFragmentBuilder.this.createAtom(elementType, this.fragment);
            atom.setSpareValency(spareValency);
            this.fragment.addAtom(atom);
            StackFrame currentFrame = this.stack.getLast();
            if (currentFrame.atom != null) {
                Bond b = SMILESFragmentBuilder.this.createBond(currentFrame.atom, atom, currentFrame.bondOrder);
                if (currentFrame.slash != null) {
                    b.setSmilesStereochemistry(currentFrame.slash);
                    currentFrame.slash = null;
                }
                if (currentFrame.atom.getAtomParity() != null) {
                    this.addAtomToAtomParity(currentFrame.atom.getAtomParity(), atom);
                }
            }
            currentFrame.atom = atom;
            currentFrame.bondOrder = 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processBracketedAtom() throws StructureBuildingException {
            ++this.i;
            int indexOfRightSquareBracket = this.smiles.indexOf(93, this.i);
            if (indexOfRightSquareBracket == -1) {
                throw new StructureBuildingException("[ without matching \"]\"");
            }
            String isotope = "";
            while (SMILESFragmentBuilder.this.is_0_to_9(this.smiles.charAt(this.i))) {
                isotope = isotope + this.smiles.charAt(this.i);
                ++this.i;
            }
            if (this.i >= indexOfRightSquareBracket) throw new StructureBuildingException("No element found in square brackets");
            char ch = this.smiles.charAt(this.i);
            ++this.i;
            String elementType = String.valueOf(ch);
            boolean spareValency = false;
            if (SMILESFragmentBuilder.this.is_A_to_Z(ch)) {
                if (SMILESFragmentBuilder.this.is_a_to_z(this.smiles.charAt(this.i))) {
                    elementType = elementType + this.smiles.charAt(this.i);
                    ++this.i;
                }
            } else if (SMILESFragmentBuilder.this.is_a_to_z(ch)) {
                if (SMILESFragmentBuilder.this.is_a_to_z(this.smiles.charAt(this.i))) {
                    if (!aromaticAtoms.contains(elementType + this.smiles.charAt(this.i))) throw new StructureBuildingException(elementType + this.smiles.charAt(this.i) + " is not an aromatic Element. If it is actually an element it should not be in lower case");
                    elementType = String.valueOf((char)(ch - 32)) + this.smiles.charAt(this.i);
                    ++this.i;
                } else {
                    if (!aromaticAtoms.contains(elementType)) {
                        throw new StructureBuildingException(elementType + " is not an aromatic Element.");
                    }
                    elementType = String.valueOf((char)(ch - 32));
                }
                spareValency = true;
            } else {
                if (!elementType.equals("*")) throw new StructureBuildingException(elementType + " is not a valid element type!");
                elementType = "R";
            }
            Atom atom = SMILESFragmentBuilder.this.createAtom(elementType, this.fragment);
            atom.setSpareValency(spareValency);
            if (isotope.length() > 0) {
                atom.setIsotope(Integer.parseInt(isotope));
            }
            this.fragment.addAtom(atom);
            StackFrame currentFrame = this.stack.getLast();
            if (currentFrame.atom != null) {
                Bond b = SMILESFragmentBuilder.this.createBond(currentFrame.atom, atom, currentFrame.bondOrder);
                if (currentFrame.slash != null) {
                    b.setSmilesStereochemistry(currentFrame.slash);
                    currentFrame.slash = null;
                }
                if (currentFrame.atom.getAtomParity() != null) {
                    this.addAtomToAtomParity(currentFrame.atom.getAtomParity(), atom);
                }
            }
            Atom previousAtom = currentFrame.atom;
            currentFrame.atom = atom;
            currentFrame.bondOrder = 1;
            Integer hydrogenCount = 0;
            int charge = 0;
            Boolean chiralitySet = false;
            while (this.i < indexOfRightSquareBracket) {
                ch = this.smiles.charAt(this.i);
                if (ch == '@') {
                    if (chiralitySet.booleanValue()) {
                        throw new StructureBuildingException("Atom parity appeared to be specified twice for an atom in a square bracket!");
                    }
                    this.processTetrahedralStereochemistry(atom, previousAtom, this.fragment.getAtomCount() == 1);
                    chiralitySet = true;
                } else if (ch == 'H') {
                    if (hydrogenCount == null || hydrogenCount != 0) {
                        throw new StructureBuildingException("Hydrogen count appeared to be specified twice for an atom in a square bracket!");
                    }
                    if (this.smiles.charAt(this.i + 1) == '?') {
                        ++this.i;
                        hydrogenCount = null;
                    } else {
                        String hydrogenCountString = "";
                        while (SMILESFragmentBuilder.this.is_0_to_9(this.smiles.charAt(this.i + 1))) {
                            hydrogenCountString = hydrogenCountString + this.smiles.charAt(this.i + 1);
                            ++this.i;
                        }
                        hydrogenCount = hydrogenCountString.length() == 0 ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(hydrogenCountString));
                        if (atom.hasSpareValency() && (!elementType.equals("C") && !elementType.equals("Si") || hydrogenCount >= 2)) {
                            this.fragment.addIndicatedHydrogen(atom);
                        }
                    }
                } else if (ch == '+' || ch == '-') {
                    if (charge != 0) {
                        throw new StructureBuildingException("Charge appeared to be specified twice for an atom in a square bracket!");
                    }
                    charge = ch == '+' ? 1 : -1;
                    String changeChargeStr = "";
                    int changeCharge = 1;
                    while (SMILESFragmentBuilder.this.is_0_to_9(this.smiles.charAt(this.i + 1))) {
                        changeChargeStr = changeChargeStr + this.smiles.charAt(this.i + 1);
                        ++this.i;
                    }
                    if (changeChargeStr.length() == 0) {
                        while (this.i + 1 < indexOfRightSquareBracket) {
                            ch = this.smiles.charAt(this.i + 1);
                            if (ch == '+') {
                                if (charge != 1) {
                                    throw new StructureBuildingException("Atom has both positive and negative charges specified!");
                                }
                            } else {
                                if (ch != '-') break;
                                if (charge != -1) {
                                    throw new StructureBuildingException("Atom has both negative and positive charges specified!");
                                }
                            }
                            ++changeCharge;
                            ++this.i;
                        }
                    }
                    changeCharge = changeChargeStr.length() == 0 ? changeCharge : Integer.parseInt(changeChargeStr);
                    atom.setCharge(charge * changeCharge);
                } else {
                    if (ch != '|') throw new StructureBuildingException("Unexpected character found in square bracket");
                    StringBuilder lambda = new StringBuilder();
                    while (this.i < this.endOfSmiles && SMILESFragmentBuilder.this.is_0_to_9(this.smiles.charAt(this.i + 1))) {
                        lambda.append(this.smiles.charAt(this.i + 1));
                        ++this.i;
                    }
                    atom.setLambdaConventionValency(Integer.parseInt(lambda.toString()));
                }
                ++this.i;
            }
            atom.setProperty(Atom.SMILES_HYDROGEN_COUNT, hydrogenCount);
        }

        private void processTetrahedralStereochemistry(Atom atom, Atom previousAtom, boolean isFirstAtom) {
            Boolean chiralityClockwise = false;
            if (this.smiles.charAt(this.i + 1) == '@') {
                chiralityClockwise = true;
                ++this.i;
            }
            Atom[] atomRefs4 = new Atom[4];
            AtomParity atomParity = new AtomParity(atomRefs4, chiralityClockwise != false ? 1 : -1);
            int index = 0;
            if (previousAtom != null) {
                atomRefs4[index] = previousAtom;
                ++index;
            } else if (isFirstAtom && this.firstAtomOutValency == 1) {
                atomRefs4[index] = AtomParity.deoxyHydrogen;
                ++index;
            }
            if (this.smiles.charAt(this.i + 1) == 'H') {
                atomRefs4[index] = AtomParity.hydrogen;
            }
            atom.setAtomParity(atomParity);
        }

        private void processRingOpeningOrClosure(char ch) throws StructureBuildingException {
            String closure = String.valueOf(ch);
            if (ch == '%') {
                if (this.i + 2 < this.endOfSmiles && SMILESFragmentBuilder.this.is_0_to_9(this.smiles.charAt(this.i + 1)) && SMILESFragmentBuilder.this.is_0_to_9(this.smiles.charAt(this.i + 2))) {
                    closure = this.smiles.substring(this.i + 1, this.i + 3);
                    this.i += 2;
                } else {
                    throw new StructureBuildingException("A ring opening indice after a % must be two digits long");
                }
            }
            if (this.ringClosures.containsKey(closure)) {
                this.processRingClosure(closure);
            } else {
                if (this.getInscopeAtom() == null) {
                    throw new StructureBuildingException("A ring opening has appeared before any atom!");
                }
                this.processRingOpening(closure);
            }
        }

        private void processRingOpening(String closure) throws StructureBuildingException {
            AtomParity atomParity;
            StackFrame currentFrame = this.stack.getLast();
            StackFrame sf = new StackFrame(currentFrame);
            if (currentFrame.slash != null) {
                sf.slash = currentFrame.slash;
                currentFrame.slash = null;
            }
            if ((atomParity = sf.atom.getAtomParity()) != null) {
                sf.indexOfDummyAtom = this.addAtomToAtomParity(atomParity, ringOpeningDummyAtom);
            }
            this.ringClosures.put(closure, sf);
            currentFrame.bondOrder = 1;
        }

        private void processRingClosure(String closure) throws StructureBuildingException {
            AtomParity closureAtomParity;
            StackFrame sf = this.ringClosures.remove(closure);
            StackFrame currentFrame = this.stack.getLast();
            int bondOrder = 1;
            if (sf.bondOrder > 1) {
                if (currentFrame.bondOrder > 1 && sf.bondOrder != currentFrame.bondOrder) {
                    throw new StructureBuildingException("ring closure has two different bond orders specified!");
                }
                bondOrder = sf.bondOrder;
            } else if (currentFrame.bondOrder > 1) {
                bondOrder = currentFrame.bondOrder;
            }
            if (currentFrame.slash != null) {
                Bond b = SMILESFragmentBuilder.this.createBond(currentFrame.atom, sf.atom, bondOrder);
                b.setSmilesStereochemistry(currentFrame.slash);
                if (sf.slash != null && sf.slash.equals((Object)currentFrame.slash)) {
                    throw new StructureBuildingException("Contradictory double bond stereoconfiguration");
                }
                currentFrame.slash = null;
            } else {
                Bond b = SMILESFragmentBuilder.this.createBond(sf.atom, currentFrame.atom, bondOrder);
                if (sf.slash != null) {
                    b.setSmilesStereochemistry(sf.slash);
                }
            }
            AtomParity currentAtomParity = currentFrame.atom.getAtomParity();
            if (currentAtomParity != null) {
                this.addAtomToAtomParity(currentAtomParity, sf.atom);
            }
            if ((closureAtomParity = sf.atom.getAtomParity()) != null) {
                Atom[] atomRefs4 = closureAtomParity.getAtomRefs4();
                if (sf.indexOfDummyAtom == null) {
                    throw new RuntimeException("OPSIN Bug: Index of dummy atom representing ring closure atom not set");
                }
                atomRefs4[sf.indexOfDummyAtom.intValue()] = currentFrame.atom;
            }
            currentFrame.bondOrder = 1;
        }

        private int addAtomToAtomParity(AtomParity atomParity, Atom atom) throws StructureBuildingException {
            int i;
            Atom[] atomRefs4 = atomParity.getAtomRefs4();
            boolean setAtom = false;
            for (i = 0; i < atomRefs4.length; ++i) {
                if (atomRefs4[i] != null) continue;
                atomRefs4[i] = atom;
                setAtom = true;
                break;
            }
            if (!setAtom) {
                throw new StructureBuildingException("Tetrahedral stereocentre specified in SMILES appears to involve more than 4 atoms");
            }
            return i;
        }

        Atom getInscopeAtom() {
            return this.stack.getLast().atom;
        }
    }

    private static class StackFrame {
        Atom atom;
        int bondOrder;
        Bond.SMILES_BOND_DIRECTION slash = null;
        Integer indexOfDummyAtom = null;

        StackFrame(Atom a, int bondOrderVal) {
            this.atom = a;
            this.bondOrder = bondOrderVal;
        }

        StackFrame(StackFrame sf) {
            this.atom = sf.atom;
            this.bondOrder = sf.bondOrder;
        }
    }
}

