/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;

class Ring {
    private final List<Atom> atomList = new ArrayList<Atom>();
    private final List<Bond> bondList;
    private final Map<Bond, Ring> bondToNeighbourRings = new LinkedHashMap<Bond, Ring>();
    private List<Atom> cyclicAtomList;
    private List<Bond> cyclicBondList;

    Ring(List<Bond> bondList) {
        if (bondList == null || bondList.isEmpty()) {
            throw new IllegalArgumentException("Bond list is empty");
        }
        this.bondList = bondList;
        for (Bond bond : bondList) {
            Atom atom2;
            Atom atom1 = bond.getFromAtom();
            if (!this.atomList.contains(atom1)) {
                this.atomList.add(atom1);
            }
            if (this.atomList.contains(atom2 = bond.getToAtom())) continue;
            this.atomList.add(atom2);
        }
        if (this.atomList.size() != bondList.size()) {
            throw new RuntimeException("atomList and bondList different sizes. Ring(bond)");
        }
    }

    List<Bond> getBondList() {
        return this.bondList;
    }

    List<Atom> getAtomList() {
        return this.atomList;
    }

    int size() {
        return this.atomList.size();
    }

    int getNumberOfFusedBonds() {
        return this.bondToNeighbourRings.size();
    }

    List<Bond> getFusedBonds() {
        return new ArrayList<Bond>(this.bondToNeighbourRings.keySet());
    }

    int getBondIndex(Bond bond) {
        return this.cyclicBondList.indexOf(bond);
    }

    List<Bond> getCyclicBondList() {
        return this.cyclicBondList;
    }

    List<Atom> getCyclicAtomList() {
        return this.cyclicAtomList;
    }

    List<Ring> getNeighbours() {
        return new ArrayList<Ring>(this.bondToNeighbourRings.values());
    }

    Ring getNeighbourOfFusedBond(Bond fusedBond) {
        return this.bondToNeighbourRings.get(fusedBond);
    }

    void addNeighbour(Bond bond, Ring ring) {
        if (this == ring) {
            throw new IllegalArgumentException("Ring can't be a neighbour of itself");
        }
        this.bondToNeighbourRings.put(bond, ring);
    }

    void makeCyclicLists(Bond stBond, Atom stAtom) {
        if (this.cyclicBondList == null) {
            this.cyclicBondList = new ArrayList<Bond>();
            this.cyclicAtomList = new ArrayList<Atom>();
            Atom atom = stAtom;
            this.cyclicBondList.add(stBond);
            this.cyclicAtomList.add(atom);
            for (int i = 0; i < this.size() - 1; ++i) {
                for (Bond bond2 : this.bondList) {
                    if (this.cyclicBondList.contains(bond2)) continue;
                    if (bond2.getFromAtom() == atom) {
                        this.cyclicBondList.add(bond2);
                        atom = bond2.getToAtom();
                        this.cyclicAtomList.add(atom);
                        continue;
                    }
                    if (bond2.getToAtom() != atom) continue;
                    this.cyclicBondList.add(bond2);
                    atom = bond2.getFromAtom();
                    this.cyclicAtomList.add(atom);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Atom atom : this.atomList) {
            sb.append(atom.getID());
            sb.append(" ");
        }
        return sb.toString();
    }
}

