/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;

class ResourceGetter {
    private static final XMLInputFactory xmlInputFactory = new WstxInputFactory();
    private final String resourcePath;
    private final String workingDirectory;

    ResourceGetter(String resourcePath) {
        String workingDirectory;
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        this.resourcePath = resourcePath;
        try {
            workingDirectory = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            workingDirectory = null;
        }
        this.workingDirectory = workingDirectory;
    }

    String getResourcePath() {
        return this.resourcePath;
    }

    XMLStreamReader getXMLStreamReader(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Input to function was null");
        }
        try {
            File f;
            if (this.workingDirectory != null && (f = this.getFile(name)) != null) {
                return xmlInputFactory.createXMLStreamReader(new FileInputStream(f));
            }
            ClassLoader l = this.getClass().getClassLoader();
            URL url = l.getResource(this.resourcePath + name);
            if (url == null) {
                throw new IOException("URL for resource: " + this.resourcePath + name + " is invalid");
            }
            return xmlInputFactory.createXMLStreamReader(url.openStream());
        }
        catch (XMLStreamException e) {
            throw new IOException("Validity exception occurred while reading the XML file with name:" + name, e);
        }
    }

    private File getFile(String name) {
        File f = new File(this.getResDir(), name);
        if (f.isFile()) {
            return f;
        }
        return null;
    }

    private File getResDir() {
        File resourcesTop = new File(this.workingDirectory, "resources");
        return new File(resourcesTop, this.resourcePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getFileContentsAsString(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Input to function was null");
        }
        try (InputStreamReader is = new InputStreamReader(this.getInputstreamFromFileName(name), StandardCharsets.UTF_8);){
            String string = IOUtils.toString(is);
            return string;
        }
        catch (IOException e) {
            return "";
        }
    }

    InputStream getInputstreamFromFileName(String name) throws IOException {
        File f;
        if (name == null) {
            throw new IllegalArgumentException("Input to function was null");
        }
        if (this.workingDirectory != null && (f = this.getFile(name)) != null) {
            return new FileInputStream(f);
        }
        ClassLoader l = this.getClass().getClassLoader();
        URL url = l.getResource(this.resourcePath + name);
        if (url == null) {
            throw new IOException("URL for resource: " + this.resourcePath + name + " is invalid");
        }
        return url.openStream();
    }

    OutputStream getOutputStream(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Input to function was null");
        }
        File f = this.getFileForWriting(name);
        return new FileOutputStream(f);
    }

    private File getFileForWriting(String name) throws IOException {
        File resourcesTop = new File(this.workingDirectory, "resources");
        File resDir = new File(resourcesTop, this.resourcePath);
        if (!resDir.exists() && !resDir.mkdirs()) {
            throw new IOException("Failed to generate requested directories to create: " + name);
        }
        return new File(resDir, name);
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("org.codehaus.stax2.closeInputSource", true);
    }
}

