/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import uk.ac.cam.ch.wwmm.opsin.PreProcessingException;
import uk.ac.cam.ch.wwmm.opsin.StringTools;

class PreProcessor {
    private static final Map<String, String> DOTENCLOSED_TO_DESIRED = new HashMap<String, String>();
    private static final Map<String, String> XMLENTITY_TO_DESIRED = new HashMap<String, String>();

    PreProcessor() {
    }

    static String preProcess(String chemicalName) throws PreProcessingException {
        if ((chemicalName = chemicalName.trim()).length() == 0) {
            throw new PreProcessingException("Input chemical name was blank!");
        }
        chemicalName = PreProcessor.performMultiCharacterReplacements(chemicalName);
        chemicalName = StringTools.convertNonAsciiAndNormaliseRepresentation(chemicalName);
        return chemicalName;
    }

    private static String performMultiCharacterReplacements(String chemicalName) {
        StringBuilder sb = new StringBuilder(chemicalName.length());
        int nameLength = chemicalName.length();
        block6: for (int i = 0; i < nameLength; ++i) {
            char ch = chemicalName.charAt(i);
            switch (ch) {
                case '$': {
                    char letter;
                    String replacement;
                    if (i + 1 < nameLength && (replacement = PreProcessor.getReplacementForDollarGreek(letter = chemicalName.charAt(i + 1))) != null) {
                        sb.append(replacement);
                        ++i;
                        continue block6;
                    }
                    sb.append(ch);
                    continue block6;
                }
                case '.': {
                    String dotEnclosedString = PreProcessor.getLowerCasedDotEnclosedString(chemicalName, i);
                    String dotEnclosedReplacement = DOTENCLOSED_TO_DESIRED.get(dotEnclosedString);
                    if (dotEnclosedReplacement != null) {
                        sb.append(dotEnclosedReplacement);
                        i = i + dotEnclosedString.length() + 1;
                        continue block6;
                    }
                    sb.append(ch);
                    continue block6;
                }
                case '&': {
                    String xmlEntityString = PreProcessor.getLowerCasedXmlEntityString(chemicalName, i);
                    String xmlEntityReplacement = XMLENTITY_TO_DESIRED.get(xmlEntityString);
                    if (xmlEntityReplacement != null) {
                        sb.append(xmlEntityReplacement);
                        i = i + xmlEntityReplacement.length() + 1;
                        continue block6;
                    }
                    sb.append(ch);
                    continue block6;
                }
                case 'S': 
                case 's': {
                    if (chemicalName.regionMatches(true, i + 1, "ulph", 0, 4)) {
                        sb.append("sulf");
                        i += 4;
                        continue block6;
                    }
                    sb.append(ch);
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String getLowerCasedDotEnclosedString(String chemicalName, int indexOfFirstDot) {
        int end = -1;
        int limit = Math.min(indexOfFirstDot + 9, chemicalName.length());
        for (int j = indexOfFirstDot + 1; j < limit; ++j) {
            if (chemicalName.charAt(j) != '.') continue;
            end = j;
            break;
        }
        if (end > 0) {
            return chemicalName.substring(indexOfFirstDot + 1, end).toLowerCase(Locale.ROOT);
        }
        return null;
    }

    private static String getLowerCasedXmlEntityString(String chemicalName, int indexOfAmpersand) {
        int end = -1;
        int limit = Math.min(indexOfAmpersand + 9, chemicalName.length());
        for (int j = indexOfAmpersand + 1; j < limit; ++j) {
            if (chemicalName.charAt(j) != ';') continue;
            end = j;
            break;
        }
        if (end > 0) {
            return chemicalName.substring(indexOfAmpersand + 1, end).toLowerCase(Locale.ROOT);
        }
        return null;
    }

    private static String getReplacementForDollarGreek(char ch) {
        switch (ch) {
            case 'a': {
                return "alpha";
            }
            case 'b': {
                return "beta";
            }
            case 'g': {
                return "gamma";
            }
            case 'd': {
                return "delta";
            }
            case 'e': {
                return "epsilon";
            }
            case 'l': {
                return "lambda";
            }
        }
        return null;
    }

    static {
        DOTENCLOSED_TO_DESIRED.put("a", "alpha");
        DOTENCLOSED_TO_DESIRED.put("b", "beta");
        DOTENCLOSED_TO_DESIRED.put("g", "gamma");
        DOTENCLOSED_TO_DESIRED.put("d", "delta");
        DOTENCLOSED_TO_DESIRED.put("e", "epsilon");
        DOTENCLOSED_TO_DESIRED.put("l", "lambda");
        DOTENCLOSED_TO_DESIRED.put("x", "xi");
        DOTENCLOSED_TO_DESIRED.put("alpha", "alpha");
        DOTENCLOSED_TO_DESIRED.put("beta", "beta");
        DOTENCLOSED_TO_DESIRED.put("gamma", "gamma");
        DOTENCLOSED_TO_DESIRED.put("delta", "delta");
        DOTENCLOSED_TO_DESIRED.put("epsilon", "epsilon");
        DOTENCLOSED_TO_DESIRED.put("zeta", "zeta");
        DOTENCLOSED_TO_DESIRED.put("eta", "eta");
        DOTENCLOSED_TO_DESIRED.put("lambda", "lambda");
        DOTENCLOSED_TO_DESIRED.put("xi", "xi");
        DOTENCLOSED_TO_DESIRED.put("omega", "omega");
        DOTENCLOSED_TO_DESIRED.put("fwdarw", "->");
        XMLENTITY_TO_DESIRED.put("alpha", "alpha");
        XMLENTITY_TO_DESIRED.put("beta", "beta");
        XMLENTITY_TO_DESIRED.put("gamma", "gamma");
        XMLENTITY_TO_DESIRED.put("delta", "delta");
        XMLENTITY_TO_DESIRED.put("epsilon", "epsilon");
        XMLENTITY_TO_DESIRED.put("zeta", "zeta");
        XMLENTITY_TO_DESIRED.put("eta", "eta");
        XMLENTITY_TO_DESIRED.put("lambda", "lambda");
        XMLENTITY_TO_DESIRED.put("xi", "xi");
        XMLENTITY_TO_DESIRED.put("omega", "omega");
    }
}

