/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParseTokens {
    private final List<String> tokens;
    private final List<Character> annotations;

    ParseTokens(List<String> tokens, List<Character> annotations) {
        if (tokens.size() != annotations.size()) {
            throw new IllegalArgumentException("OPSIN bug: mismatch between the sizes of tokens list and annotation list");
        }
        this.tokens = Collections.unmodifiableList(new ArrayList<String>(tokens));
        this.annotations = Collections.unmodifiableList(new ArrayList<Character>(annotations));
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public List<Character> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "[" + this.tokens + ", " + this.annotations + "]";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ParseTokens) {
            ParseTokens otherPT = (ParseTokens)other;
            return this.tokens.equals(otherPT.tokens) && this.annotations.equals(otherPT.annotations);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.tokens.hashCode() * (7 * this.annotations.hashCode());
    }
}

