/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import dk.brics.automaton.RunAutomaton;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.AnnotatorState;
import uk.ac.cam.ch.wwmm.opsin.OpsinRadixTrie;
import uk.ac.cam.ch.wwmm.opsin.ParseRulesResults;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceManager;
import uk.ac.cam.ch.wwmm.opsin.StringTools;

public class ParseRules {
    private final RunAutomaton chemAutomaton;
    private final char[] stateSymbols;
    private final OpsinRadixTrie[] symbolTokenNamesDict;
    private final RunAutomaton[] symbolRegexAutomataDict;
    private final Pattern[] symbolRegexesDict;
    private final AnnotatorState initialState;

    ParseRules(ResourceManager resourceManager) {
        this.chemAutomaton = resourceManager.getChemicalAutomaton();
        this.symbolTokenNamesDict = resourceManager.getSymbolTokenNamesDict();
        this.symbolRegexAutomataDict = resourceManager.getSymbolRegexAutomataDict();
        this.symbolRegexesDict = resourceManager.getSymbolRegexesDict();
        this.stateSymbols = this.chemAutomaton.getCharIntervals();
        this.initialState = new AnnotatorState(this.chemAutomaton.getInitialState(), '\u0000', 0, true, null);
    }

    public ParseRulesResults getParses(String chemicalWord) throws ParsingException {
        String chemicalWordLowerCase = StringTools.lowerCaseAsciiString(chemicalWord);
        ArrayDeque<AnnotatorState> asStack = new ArrayDeque<AnnotatorState>();
        asStack.add(this.initialState);
        int posInNameOfLastSuccessfulAnnotations = 0;
        ArrayList<AnnotatorState> successfulAnnotations = new ArrayList<AnnotatorState>();
        AnnotatorState longestAnnotation = this.initialState;
        int stateSymbolsSize = this.stateSymbols.length;
        while (!asStack.isEmpty()) {
            AnnotatorState as = (AnnotatorState)asStack.removeLast();
            int posInName = as.getPosInName();
            if (this.chemAutomaton.isAccept(as.getState()) && posInName >= posInNameOfLastSuccessfulAnnotations) {
                if (posInName > posInNameOfLastSuccessfulAnnotations) {
                    successfulAnnotations.clear();
                    posInNameOfLastSuccessfulAnnotations = posInName;
                } else if (successfulAnnotations.size() > 128) {
                    throw new ParsingException("Ambiguity in OPSIN's chemical grammar has produced more than 128 annotations. Parsing has been aborted. Please report this as a bug");
                }
                successfulAnnotations.add(as);
            }
            if (posInName > longestAnnotation.getPosInName()) {
                longestAnnotation = as;
            }
            for (int i = 0; i < stateSymbolsSize; ++i) {
                Pattern possibleRegex;
                int matchLength;
                RunAutomaton possibleAutomata;
                AnnotatorState newAs;
                List<Integer> possibleTokenisations;
                char annotationCharacter = this.stateSymbols[i];
                int potentialNextState = this.chemAutomaton.step(as.getState(), annotationCharacter);
                if (potentialNextState == -1) continue;
                OpsinRadixTrie possibleTokenisationsTrie = this.symbolTokenNamesDict[i];
                if (possibleTokenisationsTrie != null && (possibleTokenisations = possibleTokenisationsTrie.findMatches(chemicalWordLowerCase, posInName)) != null) {
                    int l = possibleTokenisations.size();
                    for (int j = 0; j < l; ++j) {
                        int tokenizationIndex = possibleTokenisations.get(j);
                        newAs = new AnnotatorState(potentialNextState, annotationCharacter, tokenizationIndex, false, as);
                        asStack.add(newAs);
                    }
                }
                if ((possibleAutomata = this.symbolRegexAutomataDict[i]) != null && (matchLength = possibleAutomata.run(chemicalWord, posInName)) != -1) {
                    int tokenizationIndex = posInName + matchLength;
                    AnnotatorState newAs2 = new AnnotatorState(potentialNextState, annotationCharacter, tokenizationIndex, true, as);
                    asStack.add(newAs2);
                }
                if ((possibleRegex = this.symbolRegexesDict[i]) == null) continue;
                Matcher mat = possibleRegex.matcher(chemicalWord).region(posInName, chemicalWord.length());
                mat.useTransparentBounds(true);
                if (!mat.lookingAt()) continue;
                int tokenizationIndex = posInName + mat.group(0).length();
                newAs = new AnnotatorState(potentialNextState, annotationCharacter, tokenizationIndex, true, as);
                asStack.add(newAs);
            }
        }
        ArrayList<ParseTokens> outputList = new ArrayList<ParseTokens>();
        String uninterpretableName = chemicalWord;
        String unparseableName = chemicalWord.substring(longestAnnotation.getPosInName());
        if (successfulAnnotations.size() > 0) {
            int bestAcceptPosInName = -1;
            for (AnnotatorState as : successfulAnnotations) {
                outputList.add(this.convertAnnotationStateToParseTokens(as, chemicalWord, chemicalWordLowerCase));
                bestAcceptPosInName = as.getPosInName();
            }
            uninterpretableName = chemicalWord.substring(bestAcceptPosInName);
        }
        return new ParseRulesResults(outputList, uninterpretableName, unparseableName);
    }

    private ParseTokens convertAnnotationStateToParseTokens(AnnotatorState as, String chemicalWord, String chemicalWordLowerCase) {
        AnnotatorState previousAs;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Character> annotations = new ArrayList<Character>();
        while ((previousAs = as.getPreviousAs()) != null) {
            if (as.isCaseSensitive()) {
                tokens.add(chemicalWord.substring(previousAs.getPosInName(), as.getPosInName()));
            } else {
                tokens.add(chemicalWordLowerCase.substring(previousAs.getPosInName(), as.getPosInName()));
            }
            annotations.add(Character.valueOf(as.getAnnot()));
            as = previousAs;
        }
        Collections.reverse(tokens);
        Collections.reverse(annotations);
        return new ParseTokens(tokens, annotations);
    }
}

