/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

class OpsinTrieNode {
    private boolean isEndPoint;
    private String key;
    private OpsinTrieNode[] children = new OpsinTrieNode[128];

    OpsinTrieNode(String key, boolean isEndPoint) {
        this.isEndPoint = isEndPoint;
        this.key = key;
    }

    String getValue() {
        return this.key;
    }

    boolean isEndPoint() {
        return this.isEndPoint;
    }

    void setIsEndPoint(boolean isEndPoint) {
        this.isEndPoint = isEndPoint;
    }

    private void setChildren(OpsinTrieNode[] children) {
        this.children = children;
    }

    OpsinTrieNode add(String remaingStr, int charsMatched) {
        if (charsMatched < this.key.length()) {
            OpsinTrieNode newNode = new OpsinTrieNode(this.key.substring(charsMatched), this.isEndPoint);
            newNode.setChildren(this.children);
            this.children = new OpsinTrieNode[128];
            this.children[this.key.charAt((int)charsMatched)] = newNode;
            this.key = this.key.substring(0, charsMatched);
            this.isEndPoint = false;
        }
        if (remaingStr.length() != 0) {
            char charValue = remaingStr.charAt(0);
            if (this.children[charValue] == null) {
                this.children[charValue] = new OpsinTrieNode(remaingStr, false);
            }
            return this.children[charValue];
        }
        return this;
    }

    int getNumberOfMatchingCharacters(String chemicalName, int posInName) {
        int maxLength = Math.min(this.key.length(), chemicalName.length() - posInName);
        for (int i = 0; i < maxLength; ++i) {
            if (this.key.charAt(i) == chemicalName.charAt(posInName + i)) continue;
            return i;
        }
        return maxLength;
    }

    int getNumberOfMatchingCharactersInReverse(String chemicalName, int posInName) {
        int maxLength = Math.min(this.key.length(), posInName + 1);
        for (int i = 0; i < maxLength; ++i) {
            if (this.key.charAt(i) == chemicalName.charAt(posInName - i)) continue;
            return i;
        }
        return maxLength;
    }

    OpsinTrieNode getChild(char c) {
        return this.children[c];
    }
}

