/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class OpsinTools {
    static final Pattern MATCH_DIGITS = Pattern.compile("\\d+");
    static final Pattern MATCH_COLONORSEMICOLON = Pattern.compile("[:;]");
    static final Pattern MATCH_AMINOACID_STYLE_LOCANT = Pattern.compile("([A-Z][a-z]?)('*)((\\d+[a-z]?|alpha|beta|gamma|delta|epsilon|zeta|eta|omega)'*)");
    static final Pattern MATCH_ELEMENT_SYMBOL = Pattern.compile("[A-Z][a-z]?");
    static final Pattern MATCH_ELEMENT_SYMBOL_LOCANT = Pattern.compile("[A-Z][a-z]?'*");
    static final Pattern MATCH_NUMERIC_LOCANT = Pattern.compile("(\\d+)[a-z]?'*");
    static final char END_OF_SUBSTITUENT = '\u00e9';
    static final char END_OF_MAINGROUP = '\u00e2';
    static final char END_OF_FUNCTIONALTERM = '\u00fb';
    static final String NEWLINE = System.getProperty("line.separator");

    OpsinTools() {
    }

    static boolean isBiochemical(String type, String subType) {
        return "biochemical".equals(subType) || "carbohydrate".equals(type) || "aminoAcid".equals(type);
    }

    static Element getNextNonChargeSuffix(Element currentEl) {
        Element next = OpsinTools.getNextSibling(currentEl);
        while (next != null) {
            if (next.getName().equals("suffix") && !"charge".equals(next.getAttributeValue("type"))) {
                return next;
            }
            next = OpsinTools.getNextSibling(next);
        }
        return null;
    }

    static List<Element> combineElementLists(List<Element> list1, List<Element> list2) {
        ArrayList<Element> elementList = new ArrayList<Element>(list1.size() + list2.size());
        elementList.addAll(list1);
        elementList.addAll(list2);
        return elementList;
    }

    static String fixLocantCapitalisation(String locant) {
        char lastChar;
        int len = locant.length();
        if (len >= 2 && (lastChar = locant.charAt(len - 1)) >= 'A' && lastChar <= 'G' && MATCH_DIGITS.matcher(locant).region(0, len - 1).matches()) {
            locant = locant.toLowerCase(Locale.ROOT);
        }
        return locant;
    }

    static Element getPreviousGroup(Element current) {
        Element parent;
        if (current.getName().equals("group")) {
            current = current.getParent();
        }
        if ((parent = current.getParent()) == null || parent.getName().equals("wordRule")) {
            return null;
        }
        int index = parent.indexOf(current);
        if (index == 0) {
            return OpsinTools.getPreviousGroup(parent);
        }
        Element previous = parent.getChild(index - 1);
        while (previous.getChildCount() != 0) {
            previous = previous.getChild(previous.getChildCount() - 1);
        }
        List<Element> groups = previous.getParent().getChildElements("group");
        if (groups.isEmpty()) {
            return OpsinTools.getPreviousGroup(previous);
        }
        return groups.get(groups.size() - 1);
    }

    static Element getNextGroup(Element current) {
        Element parent;
        if (current.getName().equals("group")) {
            current = current.getParent();
        }
        if ((parent = current.getParent()) == null || parent.getName().equals("molecule")) {
            return null;
        }
        int index = parent.indexOf(current);
        if (index == parent.getChildCount() - 1) {
            return OpsinTools.getNextGroup(parent);
        }
        Element next = parent.getChild(index + 1);
        while (next.getChildCount() != 0) {
            next = next.getChild(0);
        }
        List<Element> groups = next.getParent().getChildElements("group");
        if (groups.isEmpty()) {
            return OpsinTools.getNextGroup(next);
        }
        return groups.get(0);
    }

    static Element getParentWordRule(Element el) {
        Element parent;
        for (parent = el.getParent(); parent != null && !parent.getName().equals("wordRule"); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new RuntimeException("Cannot find enclosing wordRule element");
        }
        return parent;
    }

    static Atom depthFirstSearchForNonSuffixAtomWithLocant(Atom startingAtom, String targetLocant) {
        ArrayDeque<Atom> stack = new ArrayDeque<Atom>();
        stack.add(startingAtom);
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        while (stack.size() > 0) {
            Atom currentAtom = (Atom)stack.removeLast();
            atomsVisited.add(currentAtom);
            List<Atom> neighbours = currentAtom.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                if (atomsVisited.contains(neighbour)) continue;
                ArrayList<String> locants = new ArrayList<String>(neighbour.getLocants());
                locants.removeAll(neighbour.getElementSymbolLocants());
                if (locants.size() > 0 && !neighbour.getType().equals("suffix")) {
                    if (!locants.contains(targetLocant)) continue;
                    return neighbour;
                }
                stack.add(neighbour);
            }
        }
        return null;
    }

    static Atom depthFirstSearchForAtomWithNumericLocant(Atom startingAtom) {
        ArrayDeque<Atom> stack = new ArrayDeque<Atom>();
        stack.add(startingAtom);
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        while (stack.size() > 0) {
            Atom currentAtom = (Atom)stack.removeLast();
            atomsVisited.add(currentAtom);
            List<Atom> neighbours = currentAtom.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                if (atomsVisited.contains(neighbour)) continue;
                List<String> locants = neighbour.getLocants();
                for (String neighbourLocant : locants) {
                    if (!MATCH_NUMERIC_LOCANT.matcher(neighbourLocant).matches()) continue;
                    return neighbour;
                }
                stack.add(neighbour);
            }
        }
        return null;
    }

    static WordType determineWordType(List<Character> annotations) throws ParsingException {
        char finalAnnotation = annotations.get(annotations.size() - 1).charValue();
        if (finalAnnotation == '\u00e2') {
            return WordType.full;
        }
        if (finalAnnotation == '\u00e9') {
            return WordType.substituent;
        }
        if (finalAnnotation == '\u00fb') {
            return WordType.functionalTerm;
        }
        throw new ParsingException("OPSIN bug: Unable to determine word type!");
    }

    static Element getNextSibling(Element element) {
        Element parent = element.getParent();
        int i = parent.indexOf(element);
        if (i + 1 >= parent.getChildCount()) {
            return null;
        }
        return parent.getChild(i + 1);
    }

    static Element getNextSibling(Element current, String elName) {
        Element next = OpsinTools.getNextSibling(current);
        while (next != null) {
            if (next.getName().equals(elName)) {
                return next;
            }
            next = OpsinTools.getNextSibling(next);
        }
        return null;
    }

    static Element getPreviousSibling(Element element) {
        Element parent = element.getParent();
        int i = parent.indexOf(element);
        if (i == 0) {
            return null;
        }
        return parent.getChild(i - 1);
    }

    static Element getPreviousSibling(Element current, String elName) {
        Element prev = OpsinTools.getPreviousSibling(current);
        while (prev != null) {
            if (prev.getName().equals(elName)) {
                return prev;
            }
            prev = OpsinTools.getPreviousSibling(prev);
        }
        return null;
    }

    static void insertBefore(Element element, Element newElement) {
        Element parent = element.getParent();
        int i = parent.indexOf(element);
        parent.insertChild(newElement, i);
    }

    static void insertAfter(Element element, Element neweElement) {
        Element parent = element.getParent();
        int i = parent.indexOf(element);
        parent.insertChild(neweElement, i + 1);
    }

    static Element getNext(Element element) {
        return OpsinTools.getNext(element, true);
    }

    static Element getNext(Element element, boolean withinConnectedComponent) {
        Element parent = element.getParent();
        if (parent == null || withinConnectedComponent && parent.getName().equals("molecule")) {
            return null;
        }
        int index = parent.indexOf(element);
        if (index + 1 >= parent.getChildCount()) {
            return OpsinTools.getNext(parent, withinConnectedComponent);
        }
        Element next = parent.getChild(index + 1);
        while (next.getChildCount() > 0) {
            next = next.getChild(0);
        }
        return next;
    }

    static Element getPrevious(Element element) {
        return OpsinTools.getPrevious(element, true);
    }

    static Element getPrevious(Element element, boolean withinConnectedComponent) {
        Element parent = element.getParent();
        if (parent == null || withinConnectedComponent && parent.getName().equals("molecule")) {
            return null;
        }
        int index = parent.indexOf(element);
        if (index == 0) {
            return OpsinTools.getPrevious(parent, withinConnectedComponent);
        }
        Element previous = parent.getChild(index - 1);
        while (previous.getChildCount() > 0) {
            previous = previous.getChild(previous.getChildCount() - 1);
        }
        return previous;
    }

    static List<Element> getNextSiblingsOfType(Element currentElem, String elName) {
        ArrayList<Element> laterSiblingElementsOfType = new ArrayList<Element>();
        Element parent = currentElem.getParent();
        if (parent == null) {
            return laterSiblingElementsOfType;
        }
        int indexOfCurrentElem = parent.indexOf(currentElem);
        for (int i = indexOfCurrentElem + 1; i < parent.getChildCount(); ++i) {
            Element child = parent.getChild(i);
            if (!child.getName().equals(elName)) continue;
            laterSiblingElementsOfType.add(child);
        }
        return laterSiblingElementsOfType;
    }

    static List<Element> getNextAdjacentSiblingsOfType(Element currentElem, String elName) {
        ArrayList<Element> siblingElementsOfType = new ArrayList<Element>();
        Element parent = currentElem.getParent();
        if (parent == null) {
            return siblingElementsOfType;
        }
        Element nextSibling = OpsinTools.getNextSibling(currentElem);
        while (nextSibling != null && nextSibling.getName().equals(elName)) {
            siblingElementsOfType.add(nextSibling);
            nextSibling = OpsinTools.getNextSibling(nextSibling);
        }
        return siblingElementsOfType;
    }

    static List<Element> getNextSiblingsOfTypes(Element currentElem, String[] elNames) {
        ArrayList<Element> laterSiblingElementsOfTypes = new ArrayList<Element>();
        currentElem = OpsinTools.getNextSibling(currentElem);
        while (currentElem != null) {
            String name = currentElem.getName();
            for (String elName : elNames) {
                if (!name.equals(elName)) continue;
                laterSiblingElementsOfTypes.add(currentElem);
                break;
            }
            currentElem = OpsinTools.getNextSibling(currentElem);
        }
        return laterSiblingElementsOfTypes;
    }

    static List<Element> getPreviousSiblingsOfType(Element currentElem, String elName) {
        ArrayList<Element> earlierSiblingElementsOfType = new ArrayList<Element>();
        Element parent = currentElem.getParent();
        if (parent == null) {
            return earlierSiblingElementsOfType;
        }
        int indexOfCurrentElem = parent.indexOf(currentElem);
        for (int i = 0; i < indexOfCurrentElem; ++i) {
            Element child = parent.getChild(i);
            if (!child.getName().equals(elName)) continue;
            earlierSiblingElementsOfType.add(child);
        }
        return earlierSiblingElementsOfType;
    }

    static Element getNextSiblingIgnoringCertainElements(Element startingEl, String[] elNamesToIgnore) {
        Element parent = startingEl.getParent();
        if (parent == null) {
            return null;
        }
        int i = parent.indexOf(startingEl);
        if (i + 1 >= parent.getChildCount()) {
            return null;
        }
        Element next = parent.getChild(i + 1);
        String elName = next.getName();
        for (String namesToIgnore : elNamesToIgnore) {
            if (!elName.equals(namesToIgnore)) continue;
            return OpsinTools.getNextSiblingIgnoringCertainElements(next, elNamesToIgnore);
        }
        return next;
    }

    static Element getPreviousSiblingIgnoringCertainElements(Element startingEl, String[] elNamesToIgnore) {
        Element parent = startingEl.getParent();
        if (parent == null) {
            return null;
        }
        int i = parent.indexOf(startingEl);
        if (i == 0) {
            return null;
        }
        Element previous = parent.getChild(i - 1);
        String elName = previous.getName();
        for (String namesToIgnore : elNamesToIgnore) {
            if (!elName.equals(namesToIgnore)) continue;
            return OpsinTools.getPreviousSiblingIgnoringCertainElements(previous, elNamesToIgnore);
        }
        return previous;
    }

    static List<Element> getDescendantElementsWithTagName(Element startingElement, String elementName) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        for (int i = startingElement.getChildCount() - 1; i >= 0; --i) {
            stack.add(startingElement.getChild(i));
        }
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            if (currentElement.getName().equals(elementName)) {
                matchingElements.add(currentElement);
            }
            for (int i = currentElement.getChildCount() - 1; i >= 0; --i) {
                stack.add(currentElement.getChild(i));
            }
        }
        return matchingElements;
    }

    static List<Element> getDescendantElementsWithTagNames(Element startingElement, String[] elementNames) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        for (int i = startingElement.getChildCount() - 1; i >= 0; --i) {
            stack.add(startingElement.getChild(i));
        }
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            String currentElName = currentElement.getName();
            for (String targetTagName : elementNames) {
                if (!currentElName.equals(targetTagName)) continue;
                matchingElements.add(currentElement);
                break;
            }
            for (int i = currentElement.getChildCount() - 1; i >= 0; --i) {
                stack.add(currentElement.getChild(i));
            }
        }
        return matchingElements;
    }

    static List<Element> getChildElementsWithTagNames(Element startingElement, String[] elementNames) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        int l = startingElement.getChildCount();
        block0: for (int i = 0; i < l; ++i) {
            Element child = startingElement.getChild(i);
            String currentElName = child.getName();
            for (String targetTagName : elementNames) {
                if (!currentElName.equals(targetTagName)) continue;
                matchingElements.add(child);
                continue block0;
            }
        }
        return matchingElements;
    }

    static List<Element> getDescendantElementsWithTagNameAndAttribute(Element startingElement, String elementName, String attributeName, String attributeValue) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        for (int i = startingElement.getChildCount() - 1; i >= 0; --i) {
            stack.add(startingElement.getChild(i));
        }
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            if (currentElement.getName().equals(elementName) && attributeValue.equals(currentElement.getAttributeValue(attributeName))) {
                matchingElements.add(currentElement);
            }
            for (int i = currentElement.getChildCount() - 1; i >= 0; --i) {
                stack.add(currentElement.getChild(i));
            }
        }
        return matchingElements;
    }

    static List<Element> getChildElementsWithTagNameAndAttribute(Element startingElement, String elementName, String attributeName, String attributeValue) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        int l = startingElement.getChildCount();
        for (int i = 0; i < l; ++i) {
            Element child = startingElement.getChild(i);
            if (!child.getName().equals(elementName) || !attributeValue.equals(child.getAttributeValue(attributeName))) continue;
            matchingElements.add(child);
        }
        return matchingElements;
    }

    static int[] countNumberOfElementsAndNumberOfChildLessElements(Element startingElement) {
        int[] counts = new int[2];
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        stack.add(startingElement);
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            int childCount = currentElement.getChildCount();
            if (childCount == 0) {
                counts[1] = counts[1] + 1;
                continue;
            }
            stack.addAll(currentElement.getChildElements());
            counts[0] = counts[0] + childCount;
        }
        return counts;
    }

    static List<Element> getSiblingsUpToElementWithTagName(Element startingEl, String elName) {
        ArrayList<Element> laterSiblings = new ArrayList<Element>();
        Element nextEl = OpsinTools.getNextSibling(startingEl);
        while (nextEl != null && !nextEl.getName().equals(elName)) {
            laterSiblings.add(nextEl);
            nextEl = OpsinTools.getNextSibling(nextEl);
        }
        return laterSiblings;
    }

    static String xmlEncode(String str) {
        StringBuilder result = new StringBuilder();
        int len = str.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\t': {
                    result.append("&#x09;");
                    continue block9;
                }
                case '\n': {
                    result.append("&#x0A;");
                    continue block9;
                }
                case '\r': {
                    result.append("&#x0D;");
                    continue block9;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block9;
                }
                case '&': {
                    result.append("&amp;");
                    continue block9;
                }
                case '<': {
                    result.append("&lt;");
                    continue block9;
                }
                case '>': {
                    result.append("&gt;");
                    continue block9;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

