/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerator;
import uk.ac.cam.ch.wwmm.opsin.ComponentProcessor;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureConfig;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureException;
import uk.ac.cam.ch.wwmm.opsin.OpsinResult;
import uk.ac.cam.ch.wwmm.opsin.OpsinWarning;
import uk.ac.cam.ch.wwmm.opsin.ParseRules;
import uk.ac.cam.ch.wwmm.opsin.Parser;
import uk.ac.cam.ch.wwmm.opsin.PreProcessor;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.ResourceManager;
import uk.ac.cam.ch.wwmm.opsin.SortParses;
import uk.ac.cam.ch.wwmm.opsin.StructureBuilder;
import uk.ac.cam.ch.wwmm.opsin.SuffixApplier;
import uk.ac.cam.ch.wwmm.opsin.SuffixRules;
import uk.ac.cam.ch.wwmm.opsin.Tokeniser;
import uk.ac.cam.ch.wwmm.opsin.WordRules;

public class NameToStructure {
    private static final Logger LOG = LogManager.getLogger(NameToStructure.class);
    private ParseRules parseRules;
    private Parser parser;
    private SuffixRules suffixRules;
    private static NameToStructure NTS_INSTANCE;

    public static synchronized NameToStructure getInstance() {
        if (NTS_INSTANCE == null) {
            NTS_INSTANCE = new NameToStructure();
        }
        return NTS_INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream is = NameToStructure.class.getResourceAsStream("opsinbuild.props");){
            Properties props = new Properties();
            props.load(is);
            String string = props.getProperty("version");
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private NameToStructure() {
        LOG.debug("Initialising OPSIN... ");
        try {
            ResourceGetter resourceGetter = new ResourceGetter("uk/ac/cam/ch/wwmm/opsin/resources/");
            ResourceManager resourceManager = new ResourceManager(resourceGetter);
            WordRules wordRules = new WordRules(resourceGetter);
            this.parseRules = new ParseRules(resourceManager);
            Tokeniser tokeniser = new Tokeniser(this.parseRules);
            this.parser = new Parser(wordRules, tokeniser, resourceManager);
            this.suffixRules = new SuffixRules(resourceGetter);
        }
        catch (Exception e) {
            throw new NameToStructureException(e.getMessage(), e);
        }
        LOG.debug("OPSIN initialised");
    }

    public String parseToCML(String name) {
        OpsinResult result = this.parseChemicalName(name);
        String cml = result.getCml();
        if (cml != null && LOG.isDebugEnabled()) {
            LOG.debug(cml);
        }
        return cml;
    }

    public String parseToSmiles(String name) {
        OpsinResult result = this.parseChemicalName(name);
        String smiles = result.getSmiles();
        LOG.debug(smiles);
        return smiles;
    }

    public OpsinResult parseChemicalName(String name) {
        NameToStructureConfig n2sConfig = NameToStructureConfig.getDefaultConfigInstance();
        return this.parseChemicalName(name, n2sConfig);
    }

    public OpsinResult parseChemicalName(String name, NameToStructureConfig n2sConfig) {
        List<Element> parses;
        if (name == null) {
            throw new IllegalArgumentException("String given for name was null");
        }
        n2sConfig = n2sConfig.clone();
        try {
            LOG.debug(name);
            String modifiedName = PreProcessor.preProcess(name);
            parses = this.parser.parse(n2sConfig, modifiedName);
            Collections.sort(parses, new SortParses());
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            String message = e.getMessage() != null ? e.getMessage() : "exception with null message";
            return new OpsinResult(null, OpsinResult.OPSIN_RESULT_STATUS.FAILURE, message, name);
        }
        String reasonForFailure = "";
        Fragment fragGeneratedWithWarning = null;
        List<OpsinWarning> warnings = Collections.emptyList();
        for (Element parse : parses) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(parse.toXML());
                }
                BuildState state = new BuildState(n2sConfig);
                new ComponentGenerator(state).processParse(parse);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(parse.toXML());
                }
                new ComponentProcessor(state, new SuffixApplier(state, this.suffixRules)).processParse(parse);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(parse.toXML());
                }
                Fragment frag = new StructureBuilder(state).buildFragment(parse);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(parse.toXML());
                }
                if (state.getWarnings().isEmpty()) {
                    return new OpsinResult(frag, OpsinResult.OPSIN_RESULT_STATUS.SUCCESS, "", name);
                }
                if (fragGeneratedWithWarning != null) continue;
                fragGeneratedWithWarning = frag;
                warnings = state.getWarnings();
            }
            catch (Exception e) {
                if (reasonForFailure.length() == 0) {
                    String string = reasonForFailure = e.getMessage() != null ? e.getMessage() : "exception with null message";
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (fragGeneratedWithWarning != null) {
            return new OpsinResult(fragGeneratedWithWarning, OpsinResult.OPSIN_RESULT_STATUS.WARNING, warnings, name);
        }
        return new OpsinResult(null, OpsinResult.OPSIN_RESULT_STATUS.FAILURE, reasonForFailure, name);
    }

    public static ParseRules getOpsinParser() {
        NameToStructure n2s = NameToStructure.getInstance();
        return n2s.parseRules;
    }
}

