/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.util.StreamWriterDelegate;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.StringTools;

class IndentingXMLStreamWriter
extends StreamWriterDelegate {
    private final int indentSize;
    private int depth = 0;
    private boolean atStartOfNewline = false;

    IndentingXMLStreamWriter(XMLStreamWriter writer, int indentSize) {
        super(writer);
        this.indentSize = indentSize;
    }

    @Override
    public void writeStartElement(String arg0) throws XMLStreamException {
        if (!this.atStartOfNewline) {
            super.writeCharacters(OpsinTools.NEWLINE);
        }
        super.writeCharacters(StringTools.multiplyString(" ", this.depth * this.indentSize));
        super.writeStartElement(arg0);
        this.atStartOfNewline = false;
        ++this.depth;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.depth;
        if (this.atStartOfNewline) {
            super.writeCharacters(StringTools.multiplyString(" ", this.depth * this.indentSize));
        }
        super.writeEndElement();
        super.writeCharacters(OpsinTools.NEWLINE);
        this.atStartOfNewline = true;
    }

    @Override
    public void writeCharacters(String arg0) throws XMLStreamException {
        super.writeCharacters(arg0);
        this.atStartOfNewline = false;
    }
}

