/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.Ring;
import uk.ac.cam.ch.wwmm.opsin.SSSRFinder;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;

class FusedRingNumberer {
    private static final Logger LOG = LogManager.getLogger(FusedRingNumberer.class);
    private static final Map<ChemEl, Integer> heteroAtomValues = new EnumMap<ChemEl, Integer>(ChemEl.class);

    FusedRingNumberer() {
    }

    static void numberFusedRing(Fragment fusedRing) throws StructureBuildingException {
        List<Ring> rings = SSSRFinder.getSetOfSmallestRings(fusedRing);
        if (rings.size() < 2) {
            throw new StructureBuildingException("Ring perception system found less than 2 rings within input fragment!");
        }
        List<Atom> atomList = fusedRing.getAtomList();
        FusedRingNumberer.setupAdjacentFusedRingProperties(rings);
        if (!FusedRingNumberer.checkRingApplicability(rings)) {
            for (Atom atom : atomList) {
                atom.clearLocants();
            }
            return;
        }
        List<List<Atom>> atomSequences = FusedRingNumberer.determinePossiblePeripheryAtomOrders(rings, atomList.size());
        if (atomSequences.isEmpty()) {
            for (Atom atom : atomList) {
                atom.clearLocants();
            }
            return;
        }
        for (List<Atom> path : atomSequences) {
            for (Atom atom : atomList) {
                if (path.contains(atom)) continue;
                path.add(atom);
            }
        }
        Collections.sort(atomSequences, new SortAtomSequences());
        FragmentTools.relabelLocantsAsFusedRingSystem(atomSequences.get(0));
        fusedRing.reorderAtomCollection(atomSequences.get(0));
    }

    static void setupAdjacentFusedRingProperties(List<Ring> rings) {
        int l = rings.size();
        for (int i = 0; i < l; ++i) {
            Ring curRing = rings.get(i);
            block1: for (Bond bond : curRing.getBondList()) {
                for (int j = i + 1; j < l; ++j) {
                    Ring otherRing = rings.get(j);
                    if (!otherRing.getBondList().contains(bond)) continue;
                    otherRing.addNeighbour(bond, curRing);
                    curRing.addNeighbour(bond, otherRing);
                    continue block1;
                }
            }
        }
    }

    private static boolean checkRingApplicability(List<Ring> rings) {
        for (Ring ring : rings) {
            if (ring.size() <= 2) {
                throw new RuntimeException("Invalid ring size: " + ring.size());
            }
            if (ring.size() <= 8 || ring.getNumberOfFusedBonds() <= 2) continue;
            return false;
        }
        return true;
    }

    private static List<List<Atom>> determinePossiblePeripheryAtomOrders(List<Ring> rings, int atomCountOfFusedRingSystem) throws StructureBuildingException {
        List<Ring> tRings = FusedRingNumberer.findTerminalRings(rings);
        if (tRings.size() < 1) {
            throw new RuntimeException("OPSIN bug: Unable to find a terminal ring in fused ring system");
        }
        Ring tRing = tRings.get(0);
        Bond b1 = FusedRingNumberer.getStartingNonFusedBond(tRing);
        if (b1 == null) {
            throw new RuntimeException("OPSIN Bug: Non-fused bond from terminal ring not found");
        }
        ArrayList<RingConnectivityTable> cts = new ArrayList<RingConnectivityTable>();
        RingConnectivityTable startingCT = new RingConnectivityTable();
        cts.add(startingCT);
        FusedRingNumberer.buildRingConnectionTables(tRing, null, 0, b1, b1.getFromAtom(), startingCT, cts);
        FusedRingNumberer.removeCTsWithDistortedRingShapes(cts);
        Map<RingConnectivityTable, List<Integer>> horizonalRowDirections = FusedRingNumberer.findLongestChainDirections(cts);
        List<Ring[][]> ringMaps = FusedRingNumberer.createRingMapsAlignedAlongGivenhorizonalRowDirections(horizonalRowDirections);
        return FusedRingNumberer.findPossiblePaths(ringMaps, atomCountOfFusedRingSystem);
    }

    private static List<Ring> findTerminalRings(List<Ring> rings) {
        ArrayList<Ring> tRings = new ArrayList<Ring>();
        int minFusedBonds = Integer.MAX_VALUE;
        for (Ring ring : rings) {
            if (ring.getNumberOfFusedBonds() >= minFusedBonds) continue;
            minFusedBonds = ring.getNumberOfFusedBonds();
        }
        for (Ring ring : rings) {
            if (ring.getNumberOfFusedBonds() != minFusedBonds) continue;
            tRings.add(ring);
        }
        return tRings;
    }

    private static List<RingConnectivityTable> buildRingConnectionTables(Ring currentRing, Ring previousRing, int previousDir, Bond previousBond, Atom atom, RingConnectivityTable ct, List<RingConnectivityTable> cts) {
        currentRing.makeCyclicLists(previousBond, atom);
        ArrayList<RingConnectivityTable> generatedCts = new ArrayList<RingConnectivityTable>();
        List<FusionRingShape> allowedShapes = FusedRingNumberer.getAllowedShapesForRing(currentRing, previousBond);
        if (allowedShapes.isEmpty()) {
            throw new RuntimeException("OPSIN limitation, unsupported ring size in fused ring numbering");
        }
        ct.usedRings.add(currentRing);
        for (int i = allowedShapes.size() - 1; i >= 0; --i) {
            RingConnectivityTable currentCT;
            FusionRingShape fusionRingShape = allowedShapes.get(i);
            if (i == 0) {
                currentCT = ct;
            } else {
                currentCT = ct.copy();
                cts.add(currentCT);
                generatedCts.add(currentCT);
            }
            RingShape ringShape = new RingShape(currentRing, fusionRingShape);
            ArrayList<RingConnectivityTable> ctsToExpand = new ArrayList<RingConnectivityTable>();
            ctsToExpand.add(currentCT);
            for (Ring neighbourRing : currentRing.getNeighbours()) {
                Bond currentBond = FusedRingNumberer.findFusionBond(currentRing, neighbourRing);
                int dir = 0;
                dir = neighbourRing == previousRing ? FusedRingNumberer.getOppositeDirection(previousDir) : FusedRingNumberer.calculateRingDirection(ringShape, previousBond, currentBond, previousDir);
                for (RingConnectivityTable ctToExpand : ctsToExpand) {
                    ctToExpand.ringShapes.add(ringShape);
                    ctToExpand.neighbouringRings.add(neighbourRing);
                    ctToExpand.directionFromRingToNeighbouringRing.add(dir);
                }
                if (currentCT.usedRings.contains(neighbourRing)) continue;
                ArrayList<RingConnectivityTable> newCts = new ArrayList<RingConnectivityTable>();
                for (RingConnectivityTable ctToExpand : ctsToExpand) {
                    Atom a = FusedRingNumberer.getAtomFromBond(currentRing, currentBond);
                    List<RingConnectivityTable> generatedDownStreamCts = FusedRingNumberer.buildRingConnectionTables(neighbourRing, currentRing, dir, currentBond, a, ctToExpand, cts);
                    newCts.addAll(generatedDownStreamCts);
                }
                ctsToExpand.addAll(newCts);
                generatedCts.addAll(newCts);
            }
        }
        return generatedCts;
    }

    private static List<FusionRingShape> getAllowedShapesForRing(Ring ring, Bond startingBond) {
        List<FusionRingShape> allowedRingShapes = new ArrayList<FusionRingShape>();
        int size = ring.size();
        if (size == 5) {
            List<Bond> fusedBonds = ring.getFusedBonds();
            int fusedBondCount = fusedBonds.size();
            if (fusedBondCount == 1) {
                allowedRingShapes.add(FusionRingShape.enterFromLeftHouse);
            } else if (fusedBondCount == 2 || fusedBondCount == 3 || fusedBondCount == 4) {
                ArrayList<Integer> distances = new ArrayList<Integer>();
                for (Bond fusedBond : fusedBonds) {
                    distances.add(FusedRingNumberer.calculateDistanceBetweenBonds(startingBond, fusedBond, ring));
                }
                if (!distances.contains(1)) {
                    allowedRingShapes.add(FusionRingShape.enterFromLeftHouse);
                }
                if (!distances.contains(4)) {
                    allowedRingShapes.add(FusionRingShape.enterFromRightHouse);
                }
                if (!distances.contains(2)) {
                    allowedRingShapes.add(FusionRingShape.enterFromTopLeftHouse);
                } else if (!distances.contains(3)) {
                    allowedRingShapes.add(FusionRingShape.enterFromTopRightHouse);
                }
                allowedRingShapes = FusedRingNumberer.removeDegenerateRingShapes(allowedRingShapes, distances, 5);
            } else if (fusedBondCount == 5) {
                allowedRingShapes.add(FusionRingShape.enterFromLeftHouse);
                allowedRingShapes.add(FusionRingShape.enterFromRightHouse);
                allowedRingShapes.add(FusionRingShape.enterFromTopLeftHouse);
            }
        } else if (size == 7) {
            List<Bond> fusedBonds = ring.getFusedBonds();
            int fusedBondCount = fusedBonds.size();
            if (fusedBondCount == 1) {
                allowedRingShapes.add(FusionRingShape.enterFromLeftSevenMembered);
            } else {
                ArrayList<Integer> distances = new ArrayList<Integer>();
                for (Bond fusedBond : fusedBonds) {
                    distances.add(FusedRingNumberer.calculateDistanceBetweenBonds(startingBond, fusedBond, ring));
                }
                if (!distances.contains(4) && !distances.contains(6)) {
                    allowedRingShapes.add(FusionRingShape.enterFromLeftSevenMembered);
                }
                if (!distances.contains(1) && !distances.contains(6)) {
                    allowedRingShapes.add(FusionRingShape.enterFromTopSevenMembered);
                }
                if (!distances.contains(1) && !distances.contains(3)) {
                    allowedRingShapes.add(FusionRingShape.enterFromRightSevenMembered);
                }
                if (!distances.contains(2) && !distances.contains(4)) {
                    allowedRingShapes.add(FusionRingShape.enterFromBottomRightSevenMembered);
                }
                if (!distances.contains(3) && !distances.contains(5)) {
                    allowedRingShapes.add(FusionRingShape.enterFromBottomLeftSevenMembered);
                }
                allowedRingShapes = FusedRingNumberer.removeDegenerateRingShapes(allowedRingShapes, distances, 7);
            }
        } else {
            allowedRingShapes.add(FusionRingShape.standard);
        }
        return allowedRingShapes;
    }

    private static List<FusionRingShape> removeDegenerateRingShapes(List<FusionRingShape> allowedRingShapes, List<Integer> distances, int ringSize) {
        distances = new ArrayList<Integer>(distances);
        distances.remove((Object)0);
        block0: for (int i = allowedRingShapes.size() - 1; i >= 0; --i) {
            FusionRingShape shapeToConsiderRemoving = allowedRingShapes.get(i);
            for (int j = i - 1; j >= 0; --j) {
                FusionRingShape shapeToCompareWith = allowedRingShapes.get(j);
                boolean foundDifference = false;
                for (Integer distance : distances) {
                    if (FusedRingNumberer.getDirectionFromDist(shapeToConsiderRemoving, ringSize, distance) == FusedRingNumberer.getDirectionFromDist(shapeToCompareWith, ringSize, distance)) continue;
                    foundDifference = true;
                    break;
                }
                if (foundDifference) continue;
                allowedRingShapes.remove(i);
                continue block0;
            }
        }
        return allowedRingShapes;
    }

    private static int calculateRingDirection(RingShape ringShape, Bond previousBond, Bond currentBond, int previousDir) {
        Ring ring = ringShape.getRing();
        if (ring.getCyclicBondList() == null) {
            throw new RuntimeException("OPSIN bug: cyclic bond set should have already been populated");
        }
        int dist = FusedRingNumberer.calculateDistanceBetweenBonds(previousBond, currentBond, ring);
        if (dist == 0) {
            throw new RuntimeException("OPSIN bug: Distance between bonds is equal to 0");
        }
        int relativeDir = FusedRingNumberer.getDirectionFromDist(ringShape.getShape(), ring.size(), dist);
        return FusedRingNumberer.determineAbsoluteDirectionUsingPreviousDirection(ringShape.getShape(), ring.size(), relativeDir, previousDir);
    }

    private static int calculateDistanceBetweenBonds(Bond bond1, Bond bond2, Ring ring) {
        List<Bond> cyclicBondList = ring.getCyclicBondList();
        int previousBondIndice = cyclicBondList.indexOf(bond1);
        int currentBondIndice = cyclicBondList.indexOf(bond2);
        if (previousBondIndice == -1 || currentBondIndice == -1) {
            throw new RuntimeException("OPSIN bug: previous and current bond were not present in the cyclic bond list of the current ring");
        }
        int ringSize = ring.size();
        int dist = (ringSize + currentBondIndice - previousBondIndice) % ringSize;
        return dist;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getDirectionFromDist(FusionRingShape fusionRingShape, int ringSize, int dist) {
        int dir = 0;
        if (ringSize == 3) {
            if (dist == 1) {
                return -1;
            }
            if (dist != 2) throw new RuntimeException("Impossible distance between bonds for a 3 membered ring");
            return 1;
        }
        if (ringSize == 4) {
            if (dist == 1) {
                return -2;
            }
            if (dist == 2) {
                return 0;
            }
            if (dist != 3) throw new RuntimeException("Impossible distance between bonds for a 4 membered ring");
            return 2;
        }
        if (ringSize == 5) {
            switch (fusionRingShape) {
                case enterFromLeftHouse: {
                    if (dist == 1) {
                        return -2;
                    }
                    if (dist == 2) {
                        return 0;
                    }
                    if (dist == 3) {
                        return 1;
                    }
                    if (dist != 4) throw new RuntimeException("Impossible distance between bonds for a 5 membered ring");
                    return 3;
                }
                case enterFromTopLeftHouse: {
                    if (dist == 1) {
                        return -3;
                    }
                    if (dist == 2) {
                        return -1;
                    }
                    if (dist == 3) {
                        return 1;
                    }
                    if (dist != 4) throw new RuntimeException("Impossible distance between bonds for a 5 membered ring");
                    return 3;
                }
                case enterFromTopRightHouse: {
                    if (dist == 1) {
                        return -3;
                    }
                    if (dist == 2) {
                        return -1;
                    }
                    if (dist == 3) {
                        return 1;
                    }
                    if (dist != 4) throw new RuntimeException("Impossible distance between bonds for a 5 membered ring");
                    return 3;
                }
                case enterFromRightHouse: {
                    if (dist == 1) {
                        return -3;
                    }
                    if (dist == 2) {
                        return -1;
                    }
                    if (dist == 3) {
                        return 0;
                    }
                    if (dist != 4) throw new RuntimeException("Impossible distance between bonds for a 5 membered ring");
                    return 2;
                }
                default: {
                    throw new RuntimeException("OPSIN Bug: Unrecognised fusion ring shape for 5 membered ring");
                }
            }
        }
        if (ringSize == 7) {
            switch (fusionRingShape) {
                case enterFromLeftSevenMembered: {
                    if (dist == 1) {
                        return -3;
                    }
                    if (dist == 2) {
                        return -1;
                    }
                    if (dist == 3) {
                        return 0;
                    }
                    if (dist == 4) {
                        return 1;
                    }
                    if (dist == 5) {
                        return 2;
                    }
                    if (dist != 6) throw new RuntimeException("Impossible distance between bonds for a 7 membered ring");
                    return 3;
                }
                case enterFromTopSevenMembered: {
                    if (dist == 1) {
                        return -3;
                    }
                    if (dist == 2) {
                        return -2;
                    }
                    if (dist == 3) {
                        return -1;
                    }
                    if (dist == 4) {
                        return 1;
                    }
                    if (dist == 5) {
                        return 2;
                    }
                    if (dist != 6) throw new RuntimeException("Impossible distance between bonds for a 7 membered ring");
                    return 3;
                }
                case enterFromRightSevenMembered: {
                    if (dist == 1) {
                        return -3;
                    }
                    if (dist == 2) {
                        return -2;
                    }
                    if (dist == 3) {
                        return -1;
                    }
                    if (dist == 4) {
                        return 0;
                    }
                    if (dist == 5) {
                        return 1;
                    }
                    if (dist != 6) throw new RuntimeException("Impossible distance between bonds for a 7 membered ring");
                    return 3;
                }
                case enterFromBottomRightSevenMembered: {
                    if (dist == 1) {
                        return -3;
                    }
                    if (dist == 2) {
                        return -2;
                    }
                    if (dist == 3) {
                        return -1;
                    }
                    if (dist == 4) {
                        return 0;
                    }
                    if (dist == 5) {
                        return 1;
                    }
                    if (dist != 6) throw new RuntimeException("Impossible distance between bonds for a 7 membered ring");
                    return 3;
                }
                case enterFromBottomLeftSevenMembered: {
                    if (dist == 1) {
                        return -3;
                    }
                    if (dist == 2) {
                        return -1;
                    }
                    if (dist == 3) {
                        return 0;
                    }
                    if (dist == 4) {
                        return 1;
                    }
                    if (dist == 5) {
                        return 2;
                    }
                    if (dist != 6) throw new RuntimeException("Impossible distance between bonds for a 7 membered ring");
                    return 3;
                }
                default: {
                    throw new RuntimeException("OPSIN Bug: Unrecognised fusion ring shape for 7 membered ring");
                }
            }
        }
        if (ringSize % 2 == 0) {
            if (dist == 1) {
                return -3;
            }
            if (dist == ringSize - 1) {
                return 3;
            }
            dir = dist - ringSize / 2;
            if (Math.abs(dir) <= 2) return dir;
            if (ringSize < 8) return dir;
            return -2 * Integer.signum(dir);
        }
        if (dist == 1) {
            return -3;
        }
        if (dist == ringSize / 2) return 0;
        if (dist == ringSize / 2 + 1) {
            return 0;
        }
        if (dist == ringSize - 1) {
            return 3;
        }
        if (dist < ringSize / 2) {
            return -2;
        }
        if (dist <= ringSize / 2 + 1) throw new RuntimeException("OPSIN Bug: Unable to determine direction between odd number of atoms ring and next ring");
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private static void removeCTsWithDistortedRingShapes(List<RingConnectivityTable> cts) {
        void var3_7;
        HashMap ctToDistortedRings = new HashMap();
        for (RingConnectivityTable ringConnectivityTable : cts) {
            List<Integer> distortedRingSizes = new ArrayList();
            ctToDistortedRings.put(ringConnectivityTable, distortedRingSizes);
            List<RingShape> ringShapes = ringConnectivityTable.ringShapes;
            for (int i = 0; i < ringShapes.size(); ++i) {
                Ring r1 = ringShapes.get(i).getRing();
                Ring r2 = ringConnectivityTable.neighbouringRings.get(i);
                for (int j = i + 1; j < ringShapes.size(); ++j) {
                    int expectedDir;
                    if (!ringShapes.get(j).getRing().equals(r2) || !ringConnectivityTable.neighbouringRings.get(j).equals(r1) || (expectedDir = FusedRingNumberer.getOppositeDirection(ringConnectivityTable.directionFromRingToNeighbouringRing.get(i))) == ringConnectivityTable.directionFromRingToNeighbouringRing.get(j)) continue;
                    distortedRingSizes.add(r2.size());
                }
            }
        }
        int minDistortedRings = Integer.MAX_VALUE;
        for (List<Integer> distortedRingSizes : ctToDistortedRings.values()) {
            if (distortedRingSizes.size() >= minDistortedRings) continue;
            minDistortedRings = distortedRingSizes.size();
        }
        int n = cts.size() - 1;
        while (var3_7 >= 0) {
            if (((List)ctToDistortedRings.get(cts.get((int)var3_7))).size() > minDistortedRings) {
                cts.remove((int)var3_7);
            }
            --var3_7;
        }
    }

    private static Map<RingConnectivityTable, List<Integer>> findLongestChainDirections(List<RingConnectivityTable> cts) {
        LinkedHashMap<RingConnectivityTable, List<Integer>> horizonalRowDirections = new LinkedHashMap<RingConnectivityTable, List<Integer>>();
        int maxChain = 0;
        for (RingConnectivityTable ct : cts) {
            if (ct.ringShapes.size() != ct.neighbouringRings.size() || ct.neighbouringRings.size() != ct.directionFromRingToNeighbouringRing.size()) {
                throw new RuntimeException("OPSIN Bug: Sizes of arrays in fused ring numbering connection table are not equal");
            }
            int ctEntriesSize = ct.ringShapes.size();
            ArrayList<Integer> directions = new ArrayList<Integer>();
            horizonalRowDirections.put(ct, directions);
            for (int i = 0; i < ctEntriesSize; ++i) {
                Ring neighbour = ct.neighbouringRings.get(i);
                int curChain = 1;
                int curDir = ct.directionFromRingToNeighbouringRing.get(i);
                for (int k = 0; k <= ct.usedRings.size(); ++k) {
                    int j;
                    block10: {
                        int indexOfNeighbour = FusedRingNumberer.indexOfCorrespondingRingshape(ct.ringShapes, neighbour);
                        if (indexOfNeighbour >= 0) {
                            for (j = indexOfNeighbour; j < ctEntriesSize; ++j) {
                                if (ct.ringShapes.get(j).getRing() != neighbour || ct.directionFromRingToNeighbouringRing.get(j) != curDir) continue;
                                ++curChain;
                                break block10;
                            }
                        } else {
                            throw new RuntimeException("OPSIN bug: fused ring numbering: Ring missing from connection table");
                        }
                        if (curChain < maxChain) break;
                        int oDir = FusedRingNumberer.getOppositeDirection(curDir);
                        if (curChain > maxChain) {
                            for (List previousDirections : horizonalRowDirections.values()) {
                                previousDirections.clear();
                            }
                        }
                        if (curChain > maxChain || !directions.contains(curDir) && !directions.contains(oDir)) {
                            directions.add(curDir);
                        }
                        maxChain = curChain;
                        break;
                    }
                    neighbour = ct.neighbouringRings.get(j);
                }
                if (maxChain <= ct.usedRings.size()) continue;
                throw new RuntimeException("OPSIN bug: fused ring layout contained a loop: more rings in a chain than there were rings!");
            }
        }
        return horizonalRowDirections;
    }

    private static int indexOfCorrespondingRingshape(List<RingShape> ringShapes, Ring ring) {
        for (int i = 0; i < ringShapes.size(); ++i) {
            if (!ringShapes.get(i).getRing().equals(ring)) continue;
            return i;
        }
        return -1;
    }

    private static List<Ring[][]> createRingMapsAlignedAlongGivenhorizonalRowDirections(Map<RingConnectivityTable, List<Integer>> horizonalRowDirectionsMap) throws StructureBuildingException {
        ArrayList<Ring[][]> ringMaps = new ArrayList<Ring[][]>();
        for (Map.Entry<RingConnectivityTable, List<Integer>> entry : horizonalRowDirectionsMap.entrySet()) {
            RingConnectivityTable ct = entry.getKey();
            if (ct.ringShapes.size() != ct.neighbouringRings.size() || ct.neighbouringRings.size() != ct.directionFromRingToNeighbouringRing.size() || ct.ringShapes.size() <= 0) {
                throw new RuntimeException("OPSIN Bug: Sizes of arrays in fused ring numbering connection table are not equal");
            }
            int ctEntriesSize = ct.ringShapes.size();
            for (Integer horizonalRowDirection : entry.getValue()) {
                int[] directionFromRingToNeighbouringRing = new int[ctEntriesSize];
                for (int i = 0; i < ctEntriesSize; ++i) {
                    RingShape ringShape = ct.ringShapes.get(i);
                    directionFromRingToNeighbouringRing[i] = FusedRingNumberer.determineAbsoluteDirectionUsingPreviousDirection(ringShape.getShape(), ringShape.getRing().size(), ct.directionFromRingToNeighbouringRing.get(i), -horizonalRowDirection.intValue());
                }
                Ring[][] ringMap = FusedRingNumberer.generateRingMap(ct, directionFromRingToNeighbouringRing);
                if (ringMap == null) continue;
                ringMaps.add(ringMap);
            }
        }
        if (ringMaps.isEmpty()) {
            throw new StructureBuildingException("Fused ring systems with overlapping rings such as in helices cannot currently be numbered");
        }
        return ringMaps;
    }

    private static List<List<Atom>> findPossiblePaths(List<Ring[][]> ringMaps, int atomCountOfFusedRingSystem) {
        ArrayList<Double[]> chainQs = new ArrayList<Double[]>();
        ArrayList<Ring[][]> correspondingRingMap = new ArrayList<Ring[][]>();
        for (Ring[][] ringMap : ringMaps) {
            List<Chain> chains = FusedRingNumberer.findChainsOfMaximumLengthInHorizontalDir(ringMap);
            for (Chain chain : chains) {
                int midChainXcoord = chain.getLength() + chain.getStartingX() - 1;
                Double[] qs = FusedRingNumberer.countQuadrants(ringMap, midChainXcoord, chain.getY());
                chainQs.add(qs);
                correspondingRingMap.add(ringMap);
            }
        }
        List<List<Integer>> allowedUpperRightQuadrantsForEachChain = FusedRingNumberer.rulesBCD(chainQs);
        ArrayList<List<Atom>> paths = new ArrayList<List<Atom>>();
        for (int c = 0; c < chainQs.size(); ++c) {
            Ring[][] ringMap = (Ring[][])correspondingRingMap.get(c);
            List<Integer> allowedUpperRightQuadrants = allowedUpperRightQuadrantsForEachChain.get(c);
            for (Integer upperRightQuadrant : allowedUpperRightQuadrants) {
                Ring[][] qRingMap = FusedRingNumberer.transformQuadrantToUpperRightOfRingMap(ringMap, upperRightQuadrant);
                if (LOG.isTraceEnabled()) {
                    FusedRingNumberer.debugRingMap(qRingMap);
                }
                boolean inverseAtoms = upperRightQuadrant == 2 || upperRightQuadrant == 0;
                List<Atom> peripheralAtomPath = FusedRingNumberer.orderAtoms(qRingMap, inverseAtoms, atomCountOfFusedRingSystem);
                paths.add(peripheralAtomPath);
            }
        }
        return paths;
    }

    private static Ring[][] generateRingMap(RingConnectivityTable ct, int[] directionFromRingToNeighbouringRing) {
        int ctEntriesSize = ct.ringShapes.size();
        int nRings = ct.usedRings.size();
        int[][] coordinates = new int[nRings][];
        Object[] takenRings = new Ring[nRings];
        int takenRingsCnt = 0;
        int maxX = 0;
        int minX = 0;
        int maxY = 0;
        int minY = 0;
        takenRings[takenRingsCnt++] = ct.ringShapes.get(0).getRing();
        coordinates[0] = new int[]{0, 0};
        for (int tr = 0; tr < nRings - 1; ++tr) {
            Ring currentRing = takenRings[tr];
            if (currentRing == null) {
                throw new RuntimeException("OPSIN bug: Unexpected null ring in fused ring numbering");
            }
            int indexOfCurrentRing = FusedRingNumberer.indexOfCorrespondingRingshape(ct.ringShapes, currentRing);
            int[] xy = coordinates[tr];
            if (indexOfCurrentRing >= 0) {
                for (int j = indexOfCurrentRing; j < ctEntriesSize; ++j) {
                    Ring neighbour;
                    if (ct.ringShapes.get(j).getRing() != currentRing || FusedRingNumberer.arrayContains(takenRings, neighbour = ct.neighbouringRings.get(j))) continue;
                    int[] newXY = new int[]{xy[0] + Math.round(2.0f * FusedRingNumberer.countDX(directionFromRingToNeighbouringRing[j])), xy[1] + FusedRingNumberer.countDY(directionFromRingToNeighbouringRing[j])};
                    if (takenRingsCnt > takenRings.length) {
                        throw new RuntimeException("OPSIN Bug: Fused ring numbering bug");
                    }
                    takenRings[takenRingsCnt] = neighbour;
                    coordinates[takenRingsCnt] = newXY;
                    ++takenRingsCnt;
                    if (newXY[0] > maxX) {
                        maxX = newXY[0];
                    } else if (newXY[0] < minX) {
                        minX = newXY[0];
                    }
                    if (newXY[1] > maxY) {
                        maxY = newXY[1];
                        continue;
                    }
                    if (newXY[1] >= minY) continue;
                    minY = newXY[1];
                }
                continue;
            }
            throw new RuntimeException("OPSIN bug: fused ring numbering: Ring missing from connection table");
        }
        int h = maxY - minY + 1;
        int w = maxX - minX + 1;
        Ring[][] ringMap = new Ring[w][h];
        int ix = -minX;
        int iy = -minY;
        if (ix >= w || iy >= h) {
            throw new RuntimeException("OPSIN Bug: Fused ring numbering bug, Coordinates have been calculated wrongly");
        }
        int curX = 0;
        int curY = 0;
        for (int ti = 0; ti < takenRings.length; ++ti) {
            int[] xy = coordinates[ti];
            curX = xy[0] - minX;
            curY = xy[1] - minY;
            if (curX < 0 || curX > w || curY < 0 || curY > h) {
                throw new RuntimeException("OPSIN Bug: Fused ring numbering bug, Coordinates have been calculated wrongly");
            }
            if (ringMap[curX][curY] != null) {
                return null;
            }
            ringMap[curX][curY] = takenRings[ti];
        }
        return ringMap;
    }

    private static List<Chain> findChainsOfMaximumLengthInHorizontalDir(Ring[][] ringMap) {
        int w = ringMap.length;
        int h = ringMap[0].length;
        ArrayList<Chain> chains = new ArrayList<Chain>();
        int maxChain = 0;
        int chain = 0;
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (ringMap[i][j] == null) continue;
                chain = 1;
                while (i + 2 * chain < w && ringMap[i + 2 * chain][j] != null) {
                    ++chain;
                }
                if (chain > maxChain) {
                    chains.clear();
                    maxChain = chain;
                }
                if (chain >= maxChain) {
                    chains.add(new Chain(chain, i, j));
                }
                i += 2 * chain;
            }
        }
        return chains;
    }

    private static Double[] countQuadrants(Ring[][] ringMap, int midChainXcoord, int yChain) {
        Double[] qs = new Double[]{0.0, 0.0, 0.0, 0.0};
        int w = ringMap.length;
        int h = ringMap[0].length;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                Double d;
                Double d2;
                Double[] doubleArray;
                if (ringMap[x][y] == null) continue;
                if (x == midChainXcoord || y == yChain) {
                    if (x == midChainXcoord && y > yChain) {
                        doubleArray = qs;
                        Double.valueOf(doubleArray[0] + 0.5);
                        doubleArray = qs;
                        Double.valueOf(doubleArray[1] + 0.5);
                    } else if (x == midChainXcoord && y < yChain) {
                        doubleArray = qs;
                        Double.valueOf(doubleArray[2] + 0.5);
                        doubleArray = qs;
                        Double.valueOf(doubleArray[3] + 0.5);
                    } else if (x < midChainXcoord && y == yChain) {
                        doubleArray = qs;
                        Double.valueOf(doubleArray[1] + 0.5);
                        doubleArray = qs;
                        Double.valueOf(doubleArray[2] + 0.5);
                    } else if (x > midChainXcoord && y == yChain) {
                        doubleArray = qs;
                        Double.valueOf(doubleArray[0] + 0.5);
                        doubleArray = qs;
                        Double.valueOf(doubleArray[3] + 0.5);
                    }
                    if (x != midChainXcoord || y != yChain) continue;
                    doubleArray = qs;
                    Double.valueOf(doubleArray[0] + 0.25);
                    doubleArray = qs;
                    Double.valueOf(doubleArray[1] + 0.25);
                    doubleArray = qs;
                    Double.valueOf(doubleArray[2] + 0.25);
                    doubleArray = qs;
                    Double.valueOf(doubleArray[3] + 0.25);
                    continue;
                }
                if (x > midChainXcoord && y > yChain) {
                    doubleArray = qs;
                    d2 = doubleArray[0];
                    d = doubleArray[0] = Double.valueOf(doubleArray[0] + 1.0);
                    continue;
                }
                if (x < midChainXcoord && y > yChain) {
                    doubleArray = qs;
                    d2 = doubleArray[1];
                    d = doubleArray[1] = Double.valueOf(doubleArray[1] + 1.0);
                    continue;
                }
                if (x < midChainXcoord && y < yChain) {
                    doubleArray = qs;
                    d2 = doubleArray[2];
                    d = doubleArray[2] = Double.valueOf(doubleArray[2] + 1.0);
                    continue;
                }
                if (x <= midChainXcoord || y >= yChain) continue;
                doubleArray = qs;
                d2 = doubleArray[3];
                d = doubleArray[3] = Double.valueOf(doubleArray[3] + 1.0);
            }
        }
        return qs;
    }

    private static List<List<Integer>> rulesBCD(List<Double[]> chainQs) {
        List possibleUpperRightQuadrant;
        int c;
        int c2;
        ArrayList<List<Integer>> possibleUpperRightQuadrantsForEachChain = new ArrayList<List<Integer>>();
        int nChains = chainQs.size();
        if (nChains == 0) {
            throw new RuntimeException("OPSIN Bug: Fused ring numbering, no chains found?");
        }
        double qmax = 0.0;
        for (Double[] chainQ : chainQs) {
            for (int j = 0; j < 4; ++j) {
                Double q = chainQ[j];
                if (!(q > qmax)) continue;
                qmax = q;
            }
        }
        for (Double[] chainQ : chainQs) {
            ArrayList<Integer> allowedUpperRightQuadrants = new ArrayList<Integer>();
            for (int j = 0; j < 4; ++j) {
                if (chainQ[j] != qmax) continue;
                allowedUpperRightQuadrants.add(j);
            }
            possibleUpperRightQuadrantsForEachChain.add(allowedUpperRightQuadrants);
        }
        double qmin = Double.MAX_VALUE;
        for (c2 = 0; c2 < nChains; ++c2) {
            List possibleUpperRightQuadrant2 = (List)possibleUpperRightQuadrantsForEachChain.get(c2);
            for (Object upperRightQuad : possibleUpperRightQuadrant2) {
                int qdiagonal = ((Integer)upperRightQuad + 2) % 4;
                if (!(chainQs.get(c2)[qdiagonal] < qmin)) continue;
                qmin = chainQs.get(c2)[qdiagonal];
            }
        }
        for (c2 = 0; c2 < nChains; ++c2) {
            List possibleUpperRightQuadrant3 = (List)possibleUpperRightQuadrantsForEachChain.get(c2);
            ArrayList<Integer> allowedUpperRightQuadrants = new ArrayList<Integer>();
            for (Integer upperRightQuad : possibleUpperRightQuadrant3) {
                int qdiagonal = (upperRightQuad + 2) % 4;
                if (chainQs.get(c2)[qdiagonal] != qmin) continue;
                allowedUpperRightQuadrants.add(upperRightQuad);
            }
            possibleUpperRightQuadrantsForEachChain.set(c2, allowedUpperRightQuadrants);
        }
        double rMax = 0.0;
        for (c = 0; c < nChains; ++c) {
            possibleUpperRightQuadrant = (List)possibleUpperRightQuadrantsForEachChain.get(c);
            for (Integer upperRightQuad : possibleUpperRightQuadrant) {
                int upperLeftQuad = upperRightQuad % 2 == 0 ? upperRightQuad + 1 : upperRightQuad - 1;
                if (!(chainQs.get(c)[upperLeftQuad] + chainQs.get(c)[upperRightQuad] > rMax)) continue;
                rMax = chainQs.get(c)[upperLeftQuad] + chainQs.get(c)[upperRightQuad];
            }
        }
        for (c = 0; c < nChains; ++c) {
            possibleUpperRightQuadrant = (List)possibleUpperRightQuadrantsForEachChain.get(c);
            ArrayList<Integer> allowedUpperRightQuadrants = new ArrayList<Integer>();
            for (Integer upperRightQuad : possibleUpperRightQuadrant) {
                int upperLeftQuad = upperRightQuad % 2 == 0 ? upperRightQuad + 1 : upperRightQuad - 1;
                if (chainQs.get(c)[upperLeftQuad] + chainQs.get(c)[upperRightQuad] != rMax) continue;
                allowedUpperRightQuadrants.add(upperRightQuad);
            }
            possibleUpperRightQuadrantsForEachChain.set(c, allowedUpperRightQuadrants);
        }
        return possibleUpperRightQuadrantsForEachChain;
    }

    private static List<Atom> orderAtoms(Ring[][] ringMap, boolean inverseAtoms, int atomCountOfFusedRingSystem) {
        int count;
        int w = ringMap.length;
        int h = ringMap[0].length;
        Ring upperRightRing = null;
        for (int i = w - 1; i >= 0; --i) {
            if (ringMap[i][h - 1] == null) continue;
            upperRightRing = ringMap[i][h - 1];
            break;
        }
        if (upperRightRing == null) {
            throw new RuntimeException("OPSIN Bug: Upper right ring not found when performing fused ring numbering");
        }
        ArrayList<Ring> visitedRings = new ArrayList<Ring>();
        visitedRings.add(upperRightRing);
        while (FusedRingNumberer.isEntirelyFusionAtoms(upperRightRing)) {
            if ((upperRightRing = FusedRingNumberer.findClockwiseRingFromUpperRightRing(ringMap, upperRightRing, visitedRings)) == null) {
                throw new RuntimeException("OPSIN Bug: Unabled to find clockwise ring without fusion atoms");
            }
            visitedRings.add(upperRightRing);
        }
        Ring prevRing = FusedRingNumberer.findUpperLeftNeighbourOfUpperRightRing(ringMap, upperRightRing);
        Bond prevBond = FusedRingNumberer.findFusionBond(upperRightRing, prevRing);
        Bond nextBond = null;
        Ring currentRing = upperRightRing;
        Ring nextRing = null;
        ArrayList<Atom> atomPath = new ArrayList<Atom>();
        block2: for (count = 0; count <= atomCountOfFusedRingSystem; ++count) {
            Atom atom;
            int j;
            Bond bond;
            int i;
            int bondIndex;
            int ringSize = currentRing.size();
            int startingBondIndex = currentRing.getBondIndex(prevBond);
            List<Bond> cyclicBonds = currentRing.getCyclicBondList();
            List<Bond> fusedBonds = currentRing.getFusedBonds();
            if (!inverseAtoms) {
                for (bondIndex = 0; bondIndex < ringSize; ++bondIndex) {
                    i = (startingBondIndex + bondIndex + 1) % ringSize;
                    bond = cyclicBonds.get(i);
                    if (!fusedBonds.contains(bond)) continue;
                    nextBond = bond;
                    break;
                }
            } else {
                for (bondIndex = 0; bondIndex < ringSize; ++bondIndex) {
                    i = (startingBondIndex - bondIndex - 1 + ringSize) % ringSize;
                    bond = cyclicBonds.get(i);
                    if (!fusedBonds.contains(bond)) continue;
                    nextBond = bond;
                    break;
                }
            }
            if (nextBond == null) {
                throw new RuntimeException("OPSIN Bug: None of the bonds from this ring were fused, but this is not possible ");
            }
            nextRing = currentRing.getNeighbourOfFusedBond(nextBond);
            int endNumber = currentRing.getBondIndex(nextBond);
            if (!inverseAtoms) {
                if ((endNumber - startingBondIndex + ringSize) % ringSize != 1) {
                    if ((startingBondIndex = (startingBondIndex + 1) % ringSize) > (endNumber = (endNumber - 1 + ringSize) % ringSize)) {
                        endNumber += ringSize;
                    }
                    for (j = startingBondIndex; j <= endNumber; ++j) {
                        atom = currentRing.getCyclicAtomList().get(j % ringSize);
                        if (atomPath.contains(atom)) break block2;
                        atomPath.add(atom);
                    }
                }
            } else if ((startingBondIndex - endNumber + ringSize) % ringSize != 1) {
                if ((startingBondIndex = (startingBondIndex - 2 + ringSize) % ringSize) < (endNumber %= ringSize)) {
                    startingBondIndex += ringSize;
                }
                for (j = startingBondIndex; j >= endNumber; --j) {
                    atom = currentRing.getCyclicAtomList().get(j % ringSize);
                    if (atomPath.contains(atom)) break block2;
                    atomPath.add(atom);
                }
            }
            prevBond = nextBond;
            prevRing = currentRing;
            currentRing = nextRing;
        }
        if (count == atomCountOfFusedRingSystem) {
            throw new RuntimeException("OPSIN Bug: Fused ring numbering may have been stuck in an infinite loop while enumerating peripheral numbering");
        }
        return atomPath;
    }

    private static boolean isEntirelyFusionAtoms(Ring upperRightRing) {
        List<Atom> atomList = upperRightRing.getAtomList();
        for (Atom atom : atomList) {
            if (atom.getBondCount() >= 3) continue;
            return false;
        }
        return true;
    }

    private static Ring findClockwiseRingFromUpperRightRing(Ring[][] ringMap, Ring upperRightRing, List<Ring> visitedRings) {
        Ring clockwiseRing = null;
        int maxX = 0;
        int maxY = 0;
        for (Ring ring : upperRightRing.getNeighbours()) {
            if (visitedRings.contains(ring)) continue;
            int[] xy = FusedRingNumberer.findRingPosition(ringMap, ring);
            if (xy == null) {
                throw new RuntimeException("OPSIN Bug: Ring not found in ringMap when performing fused ring numbering");
            }
            if (xy[0] <= maxX && (xy[0] != maxX || xy[1] <= maxY)) continue;
            maxX = xy[0];
            maxY = xy[1];
            clockwiseRing = ring;
        }
        return clockwiseRing;
    }

    private static Ring findUpperLeftNeighbourOfUpperRightRing(Ring[][] ringMap, Ring upperRightRing) {
        Ring nRing = null;
        int minX = Integer.MAX_VALUE;
        int maxY = 0;
        for (Ring ring : upperRightRing.getNeighbours()) {
            int[] xy = FusedRingNumberer.findRingPosition(ringMap, ring);
            if (xy == null) {
                throw new RuntimeException("OPSIN Bug: Ring not found in ringMap when performing fused ring numbering");
            }
            if (xy[1] <= maxY && (xy[1] != maxY || xy[0] >= minX)) continue;
            minX = xy[0];
            maxY = xy[1];
            nRing = ring;
        }
        return nRing;
    }

    private static int[] findRingPosition(Ring[][] ringMap, Ring ring) {
        int w = ringMap.length;
        int h = ringMap[0].length;
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                if (ringMap[i][j] != ring) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private static Ring[][] transformQuadrantToUpperRightOfRingMap(Ring[][] ringMap, int upperRightQuadrant) {
        int w = ringMap.length;
        int h = ringMap[0].length;
        Ring[][] rearrangedMap = new Ring[w][h];
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                if (upperRightQuadrant == 0) {
                    rearrangedMap[i][j] = ringMap[i][j];
                }
                if (upperRightQuadrant == 1) {
                    rearrangedMap[w - i - 1][j] = ringMap[i][j];
                    continue;
                }
                if (upperRightQuadrant == 2) {
                    rearrangedMap[w - i - 1][h - j - 1] = ringMap[i][j];
                    continue;
                }
                if (upperRightQuadrant != 3) continue;
                rearrangedMap[i][h - j - 1] = ringMap[i][j];
            }
        }
        return rearrangedMap;
    }

    private static boolean arrayContains(Object[] array, Object obj) {
        for (Object arrObj : array) {
            if (arrObj != obj) continue;
            return true;
        }
        return false;
    }

    private static Bond getStartingNonFusedBond(Ring tRing) {
        ArrayList<Bond> allBonds = new ArrayList<Bond>(tRing.getBondList());
        for (Bond fusedBond : tRing.getFusedBonds()) {
            List<Bond> neighbouringBonds = fusedBond.getFromAtom().getBonds();
            for (Bond bond : neighbouringBonds) {
                allBonds.remove(bond);
            }
            neighbouringBonds = fusedBond.getToAtom().getBonds();
            for (Bond bond : neighbouringBonds) {
                allBonds.remove(bond);
            }
        }
        if (allBonds.size() > 0) {
            return (Bond)allBonds.get(0);
        }
        for (Bond bond : tRing.getBondList()) {
            if (tRing.getNeighbourOfFusedBond(bond) != null) continue;
            return bond;
        }
        return null;
    }

    static int getOppositeDirection(int prevDir) {
        int dir = prevDir == 0 ? 4 : (Math.abs(prevDir) == 4 ? 0 : (Math.abs(prevDir) == 2 ? -2 * Integer.signum(prevDir) : (Math.abs(prevDir) == 1 ? -3 * Integer.signum(prevDir) : -1 * Integer.signum(prevDir))));
        return dir;
    }

    private static Atom getAtomFromBond(Ring ring, Bond curBond) {
        if (ring.getCyclicBondList() == null) {
            throw new RuntimeException("The cyclic bond list should already have been generated");
        }
        int bondIndice = ring.getCyclicBondList().indexOf(curBond);
        int atomIndice = (bondIndice - 1 + ring.size()) % ring.size();
        return ring.getCyclicAtomList().get(atomIndice);
    }

    private static Bond findFusionBond(Ring r1, Ring r2) {
        List<Bond> b2 = r2.getBondList();
        for (Bond bond : r1.getBondList()) {
            if (!b2.contains(bond)) continue;
            return bond;
        }
        return null;
    }

    private static float countDX(int val) {
        float dX = 0.0f;
        if (Math.abs(val) == 1) {
            dX += 0.5f;
        } else if (Math.abs(val) == 3) {
            dX -= 0.5f;
        } else if (Math.abs(val) == 0) {
            dX += 1.0f;
        } else if (Math.abs(val) == 4) {
            dX -= 1.0f;
        }
        return dX;
    }

    private static int countDY(int val) {
        int dY = 0;
        if (Math.abs(val) != 4) {
            if (val > 0) {
                dY = 1;
            }
            if (val < 0) {
                dY = -1;
            }
        }
        return dY;
    }

    static int determineAbsoluteDirectionUsingPreviousDirection(FusionRingShape fusionRingShape, int ringSize, int relativeDirection, int previousDir) {
        int interimDirection = Math.abs(previousDir) == 4 ? (relativeDirection == 0 ? 4 : relativeDirection + -4 * Integer.signum(relativeDirection)) : relativeDirection + previousDir;
        if (Math.abs(interimDirection) > 4) {
            interimDirection = (8 - Math.abs(interimDirection)) * Integer.signum(interimDirection) * -1;
        }
        if (Math.abs(interimDirection) == 2 && (ringSize % 2 == 0 || ringSize == 5 || ringSize == 7)) {
            if (Math.abs(relativeDirection) == 1 && Math.abs(previousDir) == 3 || Math.abs(relativeDirection) == 3 && Math.abs(previousDir) == 1) {
                interimDirection = 1 * Integer.signum(interimDirection);
            } else if (Math.abs(relativeDirection) == 1 && Math.abs(previousDir) == 1) {
                interimDirection = 3 * Integer.signum(interimDirection);
            } else if (Math.abs(relativeDirection) == 3 && Math.abs(previousDir) == 3) {
                interimDirection = 3 * Integer.signum(interimDirection);
            }
        }
        if (interimDirection == -4) {
            interimDirection = 4;
        }
        return interimDirection;
    }

    private static void debugRingMap(Ring[][] ringMap) {
        Ring[][] yxOrdered = new Ring[ringMap[0].length][ringMap.length];
        for (int x = 0; x < ringMap.length; ++x) {
            Ring[] yRings = ringMap[x];
            for (int y = 0; y < yRings.length; ++y) {
                yxOrdered[y][x] = yRings[y];
            }
        }
        for (int y = yxOrdered.length - 1; y >= 0; --y) {
            Ring[] xRings = yxOrdered[y];
            StringBuilder sb = new StringBuilder();
            for (Ring ring : xRings) {
                if (ring != null) {
                    int size = ring.size();
                    if (size > 9) {
                        if (size == 10) {
                            sb.append("0");
                            continue;
                        }
                        if (size % 2 == 0) {
                            sb.append("2");
                            continue;
                        }
                        sb.append("1");
                        continue;
                    }
                    sb.append(size);
                    continue;
                }
                sb.append(" ");
            }
            LOG.trace(sb.toString());
        }
        LOG.trace("#########");
    }

    static {
        heteroAtomValues.put(ChemEl.Hg, 2);
        heteroAtomValues.put(ChemEl.Tl, 3);
        heteroAtomValues.put(ChemEl.In, 4);
        heteroAtomValues.put(ChemEl.Ga, 5);
        heteroAtomValues.put(ChemEl.Al, 6);
        heteroAtomValues.put(ChemEl.B, 7);
        heteroAtomValues.put(ChemEl.Pb, 8);
        heteroAtomValues.put(ChemEl.Sn, 9);
        heteroAtomValues.put(ChemEl.Ge, 10);
        heteroAtomValues.put(ChemEl.Si, 11);
        heteroAtomValues.put(ChemEl.Bi, 12);
        heteroAtomValues.put(ChemEl.Sb, 13);
        heteroAtomValues.put(ChemEl.As, 14);
        heteroAtomValues.put(ChemEl.P, 15);
        heteroAtomValues.put(ChemEl.N, 16);
        heteroAtomValues.put(ChemEl.Te, 17);
        heteroAtomValues.put(ChemEl.Se, 18);
        heteroAtomValues.put(ChemEl.S, 19);
        heteroAtomValues.put(ChemEl.O, 20);
        heteroAtomValues.put(ChemEl.I, 21);
        heteroAtomValues.put(ChemEl.Br, 22);
        heteroAtomValues.put(ChemEl.Cl, 23);
        heteroAtomValues.put(ChemEl.F, 24);
    }

    private static class SortAtomSequences
    implements Comparator<List<Atom>> {
        private SortAtomSequences() {
        }

        @Override
        public int compare(List<Atom> sequenceA, List<Atom> sequenceB) {
            Atom atomA;
            if (sequenceA.size() != sequenceB.size()) {
                return 0;
            }
            int i = 0;
            int j = 0;
            while (i < sequenceA.size()) {
                boolean isBaHeteroatom;
                boolean isAaHeteroatom;
                atomA = sequenceA.get(i);
                boolean bl = isAaHeteroatom = atomA.getElement() != ChemEl.C;
                if (!isAaHeteroatom && atomA.getBondCount() >= 3) {
                    ++i;
                    continue;
                }
                Atom atomB = sequenceB.get(j);
                boolean bl2 = isBaHeteroatom = atomB.getElement() != ChemEl.C;
                if (!isBaHeteroatom && atomB.getBondCount() >= 3) {
                    ++j;
                    continue;
                }
                if (isAaHeteroatom && !isBaHeteroatom) {
                    return -1;
                }
                if (isBaHeteroatom && !isAaHeteroatom) {
                    return 1;
                }
                ++i;
                ++j;
            }
            i = 0;
            j = 0;
            while (i < sequenceA.size()) {
                int atomBElementValue;
                atomA = sequenceA.get(i);
                if (atomA.getElement() == ChemEl.C && atomA.getBondCount() >= 3) {
                    ++i;
                    continue;
                }
                Atom atomB = sequenceB.get(j);
                if (atomB.getElement() == ChemEl.C && atomB.getBondCount() >= 3) {
                    ++j;
                    continue;
                }
                Integer heteroAtomPriorityA = (Integer)heteroAtomValues.get((Object)atomA.getElement());
                int atomAElementValue = heteroAtomPriorityA != null ? heteroAtomPriorityA : 0;
                Integer heteroAtomPriorityB = (Integer)heteroAtomValues.get((Object)atomB.getElement());
                int n = atomBElementValue = heteroAtomPriorityB != null ? heteroAtomPriorityB : 0;
                if (atomAElementValue > atomBElementValue) {
                    return -1;
                }
                if (atomAElementValue < atomBElementValue) {
                    return 1;
                }
                ++i;
                ++j;
            }
            for (i = 0; i < sequenceA.size(); ++i) {
                atomA = sequenceA.get(i);
                Atom atomB = sequenceB.get(i);
                if (atomA.getBondCount() >= 3 && atomA.getElement() == ChemEl.C && (atomB.getBondCount() < 3 || atomB.getElement() != ChemEl.C)) {
                    return -1;
                }
                if (atomB.getBondCount() < 3 || atomB.getElement() != ChemEl.C || atomA.getBondCount() >= 3 && atomA.getElement() == ChemEl.C) continue;
                return 1;
            }
            for (i = 0; i < sequenceA.size(); ++i) {
                atomA = sequenceA.get(i);
                Atom atomB = sequenceB.get(i);
                if (atomA.getBondCount() >= 3 && atomB.getBondCount() < 3) {
                    return -1;
                }
                if (atomB.getBondCount() < 3 || atomA.getBondCount() >= 3) continue;
                return 1;
            }
            return 0;
        }
    }

    private static class Chain {
        private final int length;
        private final int startingX;
        private final int y;

        Chain(int length, int startingX, int y) {
            this.length = length;
            this.startingX = startingX;
            this.y = y;
        }

        int getLength() {
            return this.length;
        }

        int getStartingX() {
            return this.startingX;
        }

        int getY() {
            return this.y;
        }
    }

    static enum FusionRingShape {
        enterFromLeftHouse,
        enterFromTopLeftHouse,
        enterFromTopRightHouse,
        enterFromRightHouse,
        enterFromLeftSevenMembered,
        enterFromTopSevenMembered,
        enterFromRightSevenMembered,
        enterFromBottomRightSevenMembered,
        enterFromBottomLeftSevenMembered,
        standard;

    }

    private static class RingShape {
        private final Ring ring;
        private final FusionRingShape shape;

        public RingShape(Ring ring, FusionRingShape shape) {
            this.ring = ring;
            this.shape = shape;
        }

        Ring getRing() {
            return this.ring;
        }

        FusionRingShape getShape() {
            return this.shape;
        }
    }

    private static class RingConnectivityTable {
        final List<RingShape> ringShapes = new ArrayList<RingShape>();
        final List<Ring> neighbouringRings = new ArrayList<Ring>();
        final List<Integer> directionFromRingToNeighbouringRing = new ArrayList<Integer>();
        final List<Ring> usedRings = new ArrayList<Ring>();

        private RingConnectivityTable() {
        }

        RingConnectivityTable copy() {
            RingConnectivityTable copy = new RingConnectivityTable();
            copy.ringShapes.addAll(this.ringShapes);
            copy.neighbouringRings.addAll(this.neighbouringRings);
            copy.directionFromRingToNeighbouringRing.addAll(this.directionFromRingToNeighbouringRing);
            copy.usedRings.addAll(this.usedRings);
            return copy;
        }
    }
}

