/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.ComponentProcessor;
import uk.ac.cam.ch.wwmm.opsin.CyclicAtomList;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FusedRingNumberer;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;

class FusedRingBuilder {
    private final BuildState state;
    private final List<Element> groupsInFusedRing;
    private final Element lastGroup;
    private final Fragment parentRing;
    private final Map<Integer, Fragment> fragmentInScopeForEachFusionLevel = new HashMap<Integer, Fragment>();
    private final Map<Atom, Atom> atomsToRemoveToReplacementAtom = new HashMap<Atom, Atom>();

    private FusedRingBuilder(BuildState state, List<Element> groupsInFusedRing) {
        this.state = state;
        this.groupsInFusedRing = groupsInFusedRing;
        this.lastGroup = groupsInFusedRing.get(groupsInFusedRing.size() - 1);
        this.parentRing = this.lastGroup.getFrag();
        this.fragmentInScopeForEachFusionLevel.put(0, this.parentRing);
    }

    static void processFusedRings(BuildState state, Element subOrRoot) throws StructureBuildingException {
        List<Element> groups = subOrRoot.getChildElements("group");
        if (groups.size() < 2) {
            return;
        }
        ArrayList<Element> groupsInFusedRing = new ArrayList<Element>();
        for (int i = groups.size() - 1; i >= 0; --i) {
            Element beforeBenzo;
            Element group = groups.get(i);
            groupsInFusedRing.add(0, group);
            if (i == 0) continue;
            Element startingEl = group;
            if ((group.getValue().equals("benz") || group.getValue().equals("benzo")) && "fusionRing".equals(group.getAttributeValue("subType")) && (beforeBenzo = OpsinTools.getPreviousSibling(group)) != null && beforeBenzo.getName().equals("locant")) {
                startingEl = beforeBenzo;
            }
            Element possibleGroup = OpsinTools.getPreviousSiblingIgnoringCertainElements(startingEl, new String[]{"multiplier", "fusion"});
            if (groups.get(i - 1).equals(possibleGroup)) continue;
            if (groupsInFusedRing.size() >= 2) {
                new FusedRingBuilder(state, groupsInFusedRing).buildFusedRing();
            }
            groupsInFusedRing.clear();
        }
        if (groupsInFusedRing.size() >= 2) {
            new FusedRingBuilder(state, groupsInFusedRing).buildFusedRing();
        }
    }

    void buildFusedRing() throws StructureBuildingException {
        int ncIndice;
        this.processRingNumberingAndIrregularities();
        this.processBenzoFusions();
        List<Element> nameComponents = this.formNameComponentList();
        nameComponents.remove(this.lastGroup);
        ArrayList<Fragment> componentFragments = new ArrayList<Fragment>();
        ArrayList<Fragment> parentFragments = new ArrayList<Fragment>();
        parentFragments.add(this.parentRing);
        int numberOfParents = 1;
        Element possibleMultiplier = OpsinTools.getPreviousSibling(this.lastGroup);
        if (nameComponents.size() > 0 && possibleMultiplier != null && possibleMultiplier.getName().equals("multiplier")) {
            numberOfParents = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
            possibleMultiplier.detach();
            for (int j = 1; j < numberOfParents; ++j) {
                Fragment copyOfParentRing = this.state.fragManager.copyFragment(this.parentRing);
                parentFragments.add(copyOfParentRing);
                componentFragments.add(copyOfParentRing);
            }
        }
        int fusionLevel = (nameComponents.size() - 1 - ncIndice) / 2;
        for (ncIndice = this.processMultiParentSystem(parentFragments, nameComponents, componentFragments); ncIndice >= 0; --ncIndice) {
            int j;
            Object fusion = null;
            if (nameComponents.get(ncIndice).getName().equals("fusion")) {
                fusion = nameComponents.get(ncIndice--);
            }
            if (ncIndice < 0 || !nameComponents.get(ncIndice).getName().equals("group")) {
                throw new StructureBuildingException("Group not found where group expected. This is probably a bug");
            }
            Fragment fragment = nameComponents.get(ncIndice).getFrag();
            int multiplier = 1;
            Element possibleMultiplierEl = OpsinTools.getPreviousSibling(nameComponents.get(ncIndice));
            if (possibleMultiplierEl != null && possibleMultiplierEl.getName().equals("multiplier")) {
                multiplier = Integer.parseInt(possibleMultiplierEl.getAttributeValue("value"));
            }
            String[] fusionDescriptors = null;
            if (fusion != null) {
                String fusionDescriptorString = ((Element)fusion).getValue().toLowerCase(Locale.ROOT).substring(1, ((Element)fusion).getValue().length() - 1);
                if (multiplier == 1) {
                    fusionDescriptors = new String[]{fusionDescriptorString};
                } else if (fusionDescriptorString.split(";").length > 1) {
                    fusionDescriptors = fusionDescriptorString.split(";");
                } else if (fusionDescriptorString.split(":").length > 1) {
                    fusionDescriptors = fusionDescriptorString.split(":");
                } else if (fusionDescriptorString.split(",").length > 1) {
                    fusionDescriptors = fusionDescriptorString.split(",");
                } else {
                    if (ncIndice != 0) {
                        throw new StructureBuildingException("Unexpected multiplier: " + possibleMultiplierEl.getValue() + " or incorrect fusion descriptor: " + fusionDescriptorString);
                    }
                    multiplier = 1;
                    fusionDescriptors = new String[]{fusionDescriptorString};
                }
            }
            if (multiplier > 1) {
                possibleMultiplierEl.detach();
            }
            Fragment[] fusionComponents = new Fragment[multiplier];
            for (j = 0; j < multiplier; ++j) {
                fusionComponents[j] = j > 0 ? this.state.fragManager.copyAndRelabelFragment(fragment, j) : fragment;
            }
            for (j = 0; j < multiplier; ++j) {
                Fragment component = fusionComponents[j];
                componentFragments.add(component);
                if (fusion != null) {
                    int numberOfPrimes;
                    if (fusionDescriptors[j].split(":").length == 1) {
                        if (fusionDescriptors[j].split("-").length == 1 && fusionDescriptors[j].split(",").length > 1 && FragmentTools.allAtomsInRingAreIdentical(component) && StringTools.countTerminalPrimes(fusionDescriptors[j].split(",")[0]) != fusionLevel) {
                            numberOfPrimes = StringTools.countTerminalPrimes(fusionDescriptors[j].split(",")[0]);
                            if (numberOfPrimes + 1 != fusionLevel) {
                                if (numberOfPrimes + 2 == fusionLevel) {
                                    --fusionLevel;
                                } else {
                                    throw new StructureBuildingException("Incorrect number of primes in fusion bracket: " + fusionDescriptors[j]);
                                }
                            }
                            this.relabelAccordingToFusionLevel(component, fusionLevel);
                            List<String> numericalLocantsOfParent = Arrays.asList(fusionDescriptors[j].split(","));
                            List<String> numericalLocantsOfChild = this.findPossibleNumericalLocants(component, this.determineAtomsToFuse(this.fragmentInScopeForEachFusionLevel.get(fusionLevel), numericalLocantsOfParent, null).size() - 1);
                            this.processHigherOrderFusionDescriptors(component, this.fragmentInScopeForEachFusionLevel.get(fusionLevel), numericalLocantsOfChild, numericalLocantsOfParent);
                            continue;
                        }
                        fusionLevel = 0;
                        this.relabelAccordingToFusionLevel(component, fusionLevel);
                        String fusionDescriptor = fusionDescriptors[j];
                        String[] fusionArray = this.determineNumericalAndLetterComponents(fusionDescriptor);
                        int numberOfPrimes2 = 0;
                        if (!fusionArray[1].equals("")) {
                            numberOfPrimes2 = StringTools.countTerminalPrimes(fusionArray[1]);
                            fusionDescriptor = fusionArray[0].equals("") ? fusionArray[1].replaceAll("'", "") : fusionArray[0] + "-" + fusionArray[1].replaceAll("'", "");
                            if (numberOfPrimes2 >= parentFragments.size()) {
                                throw new StructureBuildingException("Unexpected prime in fusion descriptor");
                            }
                        }
                        this.performSimpleFusion(fusionDescriptor, component, (Fragment)parentFragments.get(numberOfPrimes2));
                        continue;
                    }
                    numberOfPrimes = -j + StringTools.countTerminalPrimes(fusionDescriptors[j].split(",")[0]);
                    if (numberOfPrimes != fusionLevel) {
                        if (fusionLevel == numberOfPrimes + 1) {
                            --fusionLevel;
                        } else {
                            throw new StructureBuildingException("Incorrect number of primes in fusion bracket: " + fusionDescriptors[j]);
                        }
                    }
                    this.relabelAccordingToFusionLevel(component, fusionLevel);
                    this.performHigherOrderFusion(fusionDescriptors[j], component, this.fragmentInScopeForEachFusionLevel.get(fusionLevel));
                    continue;
                }
                this.relabelAccordingToFusionLevel(component, fusionLevel);
                this.performSimpleFusion(null, component, this.fragmentInScopeForEachFusionLevel.get(fusionLevel));
            }
            ++fusionLevel;
            if (multiplier != 1) continue;
            this.fragmentInScopeForEachFusionLevel.put(fusionLevel, fusionComponents[0]);
        }
        for (Fragment fragment : componentFragments) {
            this.state.fragManager.incorporateFragment(fragment, this.parentRing);
        }
        this.removeMergedAtoms();
        FusedRingNumberer.numberFusedRing(this.parentRing);
        StringBuilder fusedRingName = new StringBuilder();
        for (Element element : nameComponents) {
            fusedRingName.append(element.getValue());
        }
        fusedRingName.append(this.lastGroup.getValue());
        Element element = this.lastGroup;
        element.getAttribute("value").setValue(fusedRingName.toString());
        element.getAttribute("type").setValue("ring");
        element.setValue(fusedRingName.toString());
        for (Element element2 : nameComponents) {
            element2.detach();
        }
    }

    private void removeMergedAtoms() {
        for (Atom a : this.atomsToRemoveToReplacementAtom.keySet()) {
            this.state.fragManager.removeAtomAndAssociatedBonds(a);
        }
        this.atomsToRemoveToReplacementAtom.clear();
    }

    private List<Element> formNameComponentList() {
        ArrayList<Element> nameComponents = new ArrayList<Element>();
        Element currentEl = this.groupsInFusedRing.get(0);
        while (currentEl != this.lastGroup) {
            if (currentEl.getName().equals("group") || currentEl.getName().equals("fusion")) {
                nameComponents.add(currentEl);
            }
            currentEl = OpsinTools.getNextSibling(currentEl);
        }
        return nameComponents;
    }

    private void processRingNumberingAndIrregularities() throws StructureBuildingException {
        for (Element group : this.groupsInFusedRing) {
            Fragment ring = group.getFrag();
            if ("alkaneStem".equals(group.getAttributeValue("subType"))) {
                this.aromatiseCyclicAlkane(group);
            }
            this.processPartiallyUnsaturatedHWSystems(group, ring);
            if (group == this.lastGroup) {
                List<Atom> atomList = ring.getAtomList();
                for (Atom atom : atomList) {
                    if (atom.getAtomIsInACycle()) continue;
                    throw new StructureBuildingException("Inappropriate group used in fusion nomenclature. Only groups composed entirely of atoms in cycles may be used. i.e. not: " + group.getValue());
                }
                if (group.getAttribute("fusedRingNumbering") != null) {
                    String[] standardNumbering = group.getAttributeValue("fusedRingNumbering").split("/", -1);
                    for (int j = 0; j < standardNumbering.length; ++j) {
                        atomList.get(j).replaceLocants(standardNumbering[j]);
                    }
                } else {
                    ring.sortAtomListByLocant();
                }
                for (Atom atom : atomList) {
                    atom.clearLocants();
                }
                continue;
            }
            if (group.getAttribute("fusedRingNumbering") != null) continue;
            ring.sortAtomListByLocant();
        }
    }

    private void processPartiallyUnsaturatedHWSystems(Element group, Fragment ring) {
        Element unsaturator;
        List<Element> unsaturators;
        if ("hantzschWidman".equals(group.getAttributeValue("subType")) && group.getAttribute("addBond") != null && (unsaturators = OpsinTools.getNextAdjacentSiblingsOfType(group, "unsaturator")).size() > 0 && (unsaturator = unsaturators.get(0)).getAttribute("locant") == null && unsaturator.getAttributeValue("value").equals("2")) {
            unsaturator.detach();
            List<Bond> bondsToUnsaturate = StructureBuildingMethods.findBondsToUnSaturate(ring, 2, true);
            if (bondsToUnsaturate.isEmpty()) {
                throw new RuntimeException("Failed to find bond to unsaturate on partially saturated HW ring");
            }
            Bond b = bondsToUnsaturate.get(0);
            b.getFromAtom().setSpareValency(true);
            b.getToAtom().setSpareValency(true);
        }
    }

    private void aromatiseCyclicAlkane(Element cyclicAlkaneGroup) {
        Element next = OpsinTools.getNextSibling(cyclicAlkaneGroup);
        ArrayList<Element> unsaturators = new ArrayList<Element>();
        while (next != null && next.getName().equals("unsaturator")) {
            unsaturators.add(next);
            next = OpsinTools.getNextSibling(next);
        }
        boolean conjugate = true;
        if (unsaturators.size() == 1) {
            int value = Integer.parseInt(((Element)unsaturators.get(0)).getAttributeValue("value"));
            if (value != 2) {
                conjugate = false;
            } else if (((Element)unsaturators.get(0)).getAttribute("locant") != null) {
                conjugate = false;
            }
        } else if (unsaturators.size() == 2) {
            int value1 = Integer.parseInt(((Element)unsaturators.get(0)).getAttributeValue("value"));
            if (value1 != 1) {
                conjugate = false;
            } else {
                int value2 = Integer.parseInt(((Element)unsaturators.get(1)).getAttributeValue("value"));
                if (value2 != 2 || ((Element)unsaturators.get(1)).getAttribute("locant") != null) {
                    conjugate = false;
                }
            }
        } else if (unsaturators.size() > 2) {
            conjugate = false;
        }
        if (conjugate) {
            for (Element unsaturator : unsaturators) {
                unsaturator.detach();
            }
            List<Atom> atomList = cyclicAlkaneGroup.getFrag().getAtomList();
            for (Atom atom : atomList) {
                atom.setSpareValency(true);
            }
        }
    }

    private int processMultiParentSystem(List<Fragment> parentFragments, List<Element> nameComponents, List<Fragment> componentFragments) throws StructureBuildingException {
        int i;
        int fusionLevel = 0;
        if (i >= 0 && parentFragments.size() > 1) {
            List<Fragment> previousFusionLevelFragments = parentFragments;
            for (i = nameComponents.size() - 1; i >= 0; --i) {
                if (previousFusionLevelFragments.size() == 1) {
                    this.fragmentInScopeForEachFusionLevel.put(fusionLevel, previousFusionLevelFragments.get(0));
                    break;
                }
                Element fusion = null;
                if (!nameComponents.get(i).getName().equals("fusion")) {
                    throw new StructureBuildingException("Fusion bracket not found where fusion bracket expected");
                }
                fusion = nameComponents.get(i--);
                if (i < 0 || !nameComponents.get(i).getName().equals("group")) {
                    throw new StructureBuildingException("Group not found where group expected. This is probably a bug");
                }
                Fragment nextComponent = nameComponents.get(i).getFrag();
                this.relabelAccordingToFusionLevel(nextComponent, fusionLevel);
                int multiplier = 1;
                Element possibleMultiplierEl = OpsinTools.getPreviousSibling(nameComponents.get(i));
                if (possibleMultiplierEl != null && possibleMultiplierEl.getName().equals("multiplier")) {
                    multiplier = Integer.parseInt(possibleMultiplierEl.getAttributeValue("value"));
                    possibleMultiplierEl.detach();
                }
                ArrayList<Fragment> fusionComponents = new ArrayList<Fragment>();
                for (int j = 0; j < multiplier; ++j) {
                    if (j > 0) {
                        Fragment clonedFrag = this.state.fragManager.copyFragment(nextComponent);
                        this.relabelAccordingToFusionLevel(clonedFrag, j);
                        fusionComponents.add(clonedFrag);
                        continue;
                    }
                    fusionComponents.add(nextComponent);
                }
                fusionLevel += multiplier;
                if (multiplier > 1 && multiplier != previousFusionLevelFragments.size()) {
                    throw new StructureBuildingException("Mismatch between number of components and number of parents in fused ring system");
                }
                String fusionDescriptorString = fusion.getValue().toLowerCase(Locale.ROOT).substring(1, fusion.getValue().length() - 1);
                String[] fusionDescriptors = null;
                if (fusionDescriptorString.split(";").length > 1) {
                    fusionDescriptors = fusionDescriptorString.split(";");
                } else if (fusionDescriptorString.split(":").length > 1) {
                    fusionDescriptors = fusionDescriptorString.split(":");
                } else if (fusionDescriptorString.split(",").length > 1) {
                    fusionDescriptors = fusionDescriptorString.split(",");
                } else {
                    throw new StructureBuildingException("Invalid fusion descriptor: " + fusionDescriptorString);
                }
                if (fusionDescriptors.length != previousFusionLevelFragments.size()) {
                    throw new StructureBuildingException("Invalid fusion descriptor: " + fusionDescriptorString + "(Number of locants disagrees with number of parents)");
                }
                for (int j = 0; j < fusionDescriptors.length; ++j) {
                    boolean simpleFusion;
                    String fusionDescriptor = fusionDescriptors[j];
                    Fragment component = multiplier > 1 ? (Fragment)fusionComponents.get(j) : nextComponent;
                    Fragment parentToUse = previousFusionLevelFragments.get(j);
                    boolean bl = simpleFusion = fusionDescriptor.split(":").length <= 1;
                    if (simpleFusion) {
                        String[] fusionArray = this.determineNumericalAndLetterComponents(fusionDescriptor);
                        if (fusionArray[1].length() != 0) {
                            int numberOfPrimes = StringTools.countTerminalPrimes(fusionArray[1]);
                            fusionDescriptor = fusionArray[0].length() == 0 ? fusionArray[1].replaceAll("'", "") : fusionArray[0] + "-" + fusionArray[1].replaceAll("'", "");
                            if (numberOfPrimes != j) {
                                throw new StructureBuildingException("Incorrect number of primes in fusion descriptor: " + fusionDescriptor);
                            }
                        }
                        this.performSimpleFusion(fusionDescriptor, component, parentToUse);
                        continue;
                    }
                    this.performHigherOrderFusion(fusionDescriptor, component, parentToUse);
                }
                previousFusionLevelFragments = fusionComponents;
                componentFragments.addAll(fusionComponents);
            }
            if (previousFusionLevelFragments.size() != 1) {
                throw new StructureBuildingException("Invalid fused ring system. Incomplete multiparent system");
            }
        }
        return i;
    }

    private String[] determineNumericalAndLetterComponents(String fusionDescriptor) {
        String[] fusionArray = fusionDescriptor.split("-");
        if (fusionArray.length == 2) {
            return fusionArray;
        }
        String[] components = new String[2];
        if (fusionArray[0].contains(",")) {
            components[0] = fusionArray[0];
            components[1] = "";
        } else {
            components[0] = "";
            components[1] = fusionArray[0];
        }
        return components;
    }

    private void processBenzoFusions() throws StructureBuildingException {
        for (int i = this.groupsInFusedRing.size() - 2; i >= 0; --i) {
            Element possibleMultiplier;
            Element possibleFusionbracket;
            Element group = this.groupsInFusedRing.get(i);
            if (!group.getValue().equals("benz") && !group.getValue().equals("benzo") || (possibleFusionbracket = OpsinTools.getNextSibling(group)).getName().equals("fusion") || (possibleMultiplier = OpsinTools.getPreviousSibling(group)) != null && possibleMultiplier.getName().equals("multiplier") && !possibleMultiplier.getAttributeValue("type").equals("group")) continue;
            this.benzoSpecificFusion(group, this.groupsInFusedRing.get(i + 1));
            group.detach();
            this.groupsInFusedRing.remove(i);
        }
    }

    private void relabelAccordingToFusionLevel(Fragment component, int fusionLevel) {
        if (fusionLevel > 0) {
            FragmentTools.relabelNumericLocants(component.getAtomList(), StringTools.multiplyString("'", fusionLevel));
        }
    }

    private void performSimpleFusion(String fusionDescriptor, Fragment childRing, Fragment parentRing) throws StructureBuildingException {
        List<String> numericalLocantsOfChild = null;
        List<String> letterLocantsOfParent = null;
        if (fusionDescriptor != null) {
            String[] fusionArray = fusionDescriptor.split("-");
            if (fusionArray.length == 2) {
                numericalLocantsOfChild = Arrays.asList(fusionArray[0].split(","));
                char[] tempLetterLocantsOfParent = fusionArray[1].toCharArray();
                letterLocantsOfParent = new ArrayList<String>();
                for (char letterLocantOfParent : tempLetterLocantsOfParent) {
                    letterLocantsOfParent.add(String.valueOf(letterLocantOfParent));
                }
            } else if (fusionArray[0].contains(",")) {
                String[] numericalLocantsOfChildTemp = fusionArray[0].split(",");
                numericalLocantsOfChild = Arrays.asList(numericalLocantsOfChildTemp);
            } else {
                char[] tempLetterLocantsOfParentCharArray = fusionArray[0].toCharArray();
                letterLocantsOfParent = new ArrayList<String>();
                for (char letterLocantOfParentCharArray : tempLetterLocantsOfParentCharArray) {
                    letterLocantsOfParent.add(String.valueOf(letterLocantOfParentCharArray));
                }
            }
        }
        int edgeLength = 1;
        if (numericalLocantsOfChild != null) {
            if (numericalLocantsOfChild.size() <= 1) {
                throw new StructureBuildingException("At least two numerical locants must be provided to perform fusion!");
            }
            edgeLength = numericalLocantsOfChild.size() - 1;
        } else if (letterLocantsOfParent != null) {
            edgeLength = letterLocantsOfParent.size();
        }
        if (numericalLocantsOfChild == null) {
            numericalLocantsOfChild = this.findPossibleNumericalLocants(childRing, edgeLength);
        }
        if (letterLocantsOfParent == null) {
            letterLocantsOfParent = this.findPossibleLetterLocants(parentRing, edgeLength);
        }
        if (numericalLocantsOfChild == null || letterLocantsOfParent == null) {
            throw new StructureBuildingException("Unable to find bond to form fused ring system. Some information for forming fused ring system was only supplyed implicitly");
        }
        this.processFirstOrderFusionDescriptors(childRing, parentRing, numericalLocantsOfChild, letterLocantsOfParent);
    }

    private List<String> findPossibleLetterLocants(Fragment ring, int edgeLength) {
        ArrayList<Integer> carbonAtomIndexes = new ArrayList<Integer>();
        int numberOfAtoms = ring.getAtomCount();
        CyclicAtomList cyclicAtomList = new CyclicAtomList(ring.getAtomList());
        for (int i = 0; i <= numberOfAtoms; ++i) {
            Atom atom = cyclicAtomList.previous();
            if (atom.getElement() == ChemEl.C && atom.getBondCount() == 2 && (carbonAtomIndexes.isEmpty() || atom.getAtomNeighbours().contains(cyclicAtomList.peekNext()))) {
                carbonAtomIndexes.add(cyclicAtomList.getIndex());
                if (carbonAtomIndexes.size() != edgeLength + 1) continue;
                Collections.reverse(carbonAtomIndexes);
                ArrayList<String> letterLocantsOfParent = new ArrayList<String>();
                for (int j = 0; j < edgeLength; ++j) {
                    letterLocantsOfParent.add(String.valueOf((char)(97 + (Integer)carbonAtomIndexes.get(j))));
                }
                return letterLocantsOfParent;
            }
            carbonAtomIndexes.clear();
        }
        return null;
    }

    private List<String> findPossibleNumericalLocants(Fragment ring, int edgeLength) {
        ArrayList<String> carbonLocants = new ArrayList<String>();
        int numberOfAtoms = ring.getAtomCount();
        CyclicAtomList cyclicAtomList = new CyclicAtomList(ring.getAtomList());
        for (int i = 0; i <= numberOfAtoms; ++i) {
            Atom atom = cyclicAtomList.next();
            if (atom.getElement() == ChemEl.C && atom.getBondCount() == 2 && (carbonLocants.isEmpty() || atom.getAtomNeighbours().contains(cyclicAtomList.peekPrevious()))) {
                carbonLocants.add(atom.getFirstLocant());
                if (carbonLocants.size() != edgeLength + 1) continue;
                ArrayList<String> numericalLocantsOfChild = new ArrayList<String>();
                for (String locant : carbonLocants) {
                    numericalLocantsOfChild.add(locant);
                }
                return numericalLocantsOfChild;
            }
            carbonLocants.clear();
        }
        return null;
    }

    private void processFirstOrderFusionDescriptors(Fragment childRing, Fragment parentRing, List<String> numericalLocantsOfChild, List<String> letterLocantsOfParent) throws StructureBuildingException {
        List<Atom> childAtoms = this.determineAtomsToFuse(childRing, numericalLocantsOfChild, letterLocantsOfParent.size() + 1);
        if (childAtoms == null) {
            throw new StructureBuildingException("Malformed fusion bracket!");
        }
        ArrayList<Atom> parentAtoms = new ArrayList<Atom>();
        List<Atom> parentPeripheralAtomList = this.getPeripheralAtoms(parentRing.getAtomList());
        CyclicAtomList cyclicListAtomsOnSurfaceOfParent = new CyclicAtomList(parentPeripheralAtomList, letterLocantsOfParent.get(0).charAt(0) - 97);
        parentAtoms.add(cyclicListAtomsOnSurfaceOfParent.getCurrent());
        for (int i = 0; i < letterLocantsOfParent.size(); ++i) {
            parentAtoms.add(cyclicListAtomsOnSurfaceOfParent.next());
        }
        this.fuseRings(childAtoms, parentAtoms);
    }

    private List<Atom> getPeripheralAtoms(List<Atom> atomList) {
        List<Atom> neighbours = atomList.get(0).getAtomNeighbours();
        int indice = Integer.MAX_VALUE;
        for (Atom atom : neighbours) {
            int indexOfAtom = atomList.indexOf(atom);
            if (indexOfAtom == 1 || indexOfAtom == -1 || atomList.indexOf(atom) >= indice) continue;
            indice = indexOfAtom;
        }
        return atomList.subList(0, indice + 1);
    }

    private void performHigherOrderFusion(String fusionDescriptor, Fragment nextComponent, Fragment fusedRing) throws StructureBuildingException {
        List<String> numericalLocantsOfChild = null;
        List<String> numericalLocantsOfParent = null;
        String[] fusionArray = fusionDescriptor.split(":");
        if (fusionArray.length != 2) {
            throw new StructureBuildingException("Malformed fusion bracket: This is an OPSIN bug, check regexTokens.xml");
        }
        numericalLocantsOfChild = Arrays.asList(fusionArray[0].split(","));
        numericalLocantsOfParent = Arrays.asList(fusionArray[1].split(","));
        this.processHigherOrderFusionDescriptors(nextComponent, fusedRing, numericalLocantsOfChild, numericalLocantsOfParent);
    }

    private void processHigherOrderFusionDescriptors(Fragment childRing, Fragment parentRing, List<String> numericalLocantsOfChild, List<String> numericalLocantsOfParent) throws StructureBuildingException {
        List<Atom> childAtoms = this.determineAtomsToFuse(childRing, numericalLocantsOfChild, null);
        if (childAtoms == null) {
            throw new StructureBuildingException("Malformed fusion bracket!");
        }
        List<Atom> parentAtoms = this.determineAtomsToFuse(parentRing, numericalLocantsOfParent, childAtoms.size());
        if (parentAtoms == null) {
            throw new StructureBuildingException("Malformed fusion bracket!");
        }
        this.fuseRings(childAtoms, parentAtoms);
    }

    private List<Atom> determineAtomsToFuse(Fragment ring, List<String> numericalLocantsOnRing, Integer expectedNumberOfAtomsToBeUsedForFusion) throws StructureBuildingException {
        List<Atom> parentPeripheralAtomList = this.getPeripheralAtoms(ring.getAtomList());
        String firstLocant = numericalLocantsOnRing.get(0);
        String lastLocant = numericalLocantsOnRing.get(numericalLocantsOnRing.size() - 1);
        int indexfirst = parentPeripheralAtomList.indexOf(ring.getAtomByLocantOrThrow(firstLocant));
        if (indexfirst == -1) {
            throw new StructureBuildingException(firstLocant + " refers to an atom that is not a peripheral atom!");
        }
        int indexfinal = parentPeripheralAtomList.indexOf(ring.getAtomByLocantOrThrow(lastLocant));
        if (indexfinal == -1) {
            throw new StructureBuildingException(lastLocant + " refers to an atom that is not a peripheral atom!");
        }
        CyclicAtomList cyclicRingAtomList = new CyclicAtomList(parentPeripheralAtomList, indexfirst);
        ArrayList<Atom> fusionAtoms = null;
        ArrayList<Atom> potentialFusionAtomsAscending = new ArrayList<Atom>();
        potentialFusionAtomsAscending.add(cyclicRingAtomList.getCurrent());
        while (cyclicRingAtomList.getIndex() != indexfinal) {
            potentialFusionAtomsAscending.add(cyclicRingAtomList.next());
        }
        if (expectedNumberOfAtomsToBeUsedForFusion == null || expectedNumberOfAtomsToBeUsedForFusion.intValue() == potentialFusionAtomsAscending.size()) {
            boolean notInPotentialParentAtoms = false;
            for (int i = 1; i < numericalLocantsOnRing.size() - 1; ++i) {
                if (potentialFusionAtomsAscending.contains(ring.getAtomByLocantOrThrow(numericalLocantsOnRing.get(i)))) continue;
                notInPotentialParentAtoms = true;
            }
            if (!notInPotentialParentAtoms) {
                fusionAtoms = potentialFusionAtomsAscending;
            }
        }
        if (fusionAtoms == null || expectedNumberOfAtomsToBeUsedForFusion == null) {
            cyclicRingAtomList.setIndex(indexfirst);
            ArrayList<Atom> potentialFusionAtomsDescending = new ArrayList<Atom>();
            potentialFusionAtomsDescending.add(cyclicRingAtomList.getCurrent());
            while (cyclicRingAtomList.getIndex() != indexfinal) {
                potentialFusionAtomsDescending.add(cyclicRingAtomList.previous());
            }
            if (expectedNumberOfAtomsToBeUsedForFusion == null || expectedNumberOfAtomsToBeUsedForFusion.intValue() == potentialFusionAtomsDescending.size()) {
                boolean notInPotentialParentAtoms = false;
                for (int i = 1; i < numericalLocantsOnRing.size() - 1; ++i) {
                    if (potentialFusionAtomsDescending.contains(ring.getAtomByLocantOrThrow(numericalLocantsOnRing.get(i)))) continue;
                    notInPotentialParentAtoms = true;
                }
                if (!notInPotentialParentAtoms) {
                    if (fusionAtoms != null && expectedNumberOfAtomsToBeUsedForFusion == null) {
                        if (potentialFusionAtomsDescending.size() < fusionAtoms.size()) {
                            fusionAtoms = potentialFusionAtomsDescending;
                        }
                    } else {
                        fusionAtoms = potentialFusionAtomsDescending;
                    }
                }
            }
        }
        return fusionAtoms;
    }

    /*
     * WARNING - void declaration
     */
    private void fuseRings(List<Atom> childAtoms, List<Atom> parentAtoms) throws StructureBuildingException {
        Atom to;
        int i;
        if (parentAtoms.size() != childAtoms.size()) {
            throw new StructureBuildingException("Problem with fusion descriptors: Parent atoms specified: " + parentAtoms.size() + " Child atoms specified: " + childAtoms.size() + " These should have been identical!");
        }
        for (i = parentAtoms.size() - 1; i >= 0; --i) {
            if (this.atomsToRemoveToReplacementAtom.get(parentAtoms.get(i)) != null) {
                parentAtoms.set(i, this.atomsToRemoveToReplacementAtom.get(parentAtoms.get(i)));
            }
            if (this.atomsToRemoveToReplacementAtom.get(childAtoms.get(i)) == null) continue;
            childAtoms.set(i, this.atomsToRemoveToReplacementAtom.get(childAtoms.get(i)));
        }
        for (i = 0; i < childAtoms.size(); ++i) {
            Atom parentAtom = parentAtoms.get(i);
            Atom childAtom = childAtoms.get(i);
            if (childAtom.hasSpareValency()) {
                parentAtom.setSpareValency(true);
            }
            if (parentAtom.getElement() != childAtom.getElement()) {
                throw new StructureBuildingException("Invalid fusion descriptor: Heteroatom placement is ambiguous as it is not present in both components of the fusion");
            }
            this.atomsToRemoveToReplacementAtom.put(childAtom, parentAtom);
        }
        HashSet<Bond> fusionEdgeBonds = new HashSet<Bond>();
        for (int i2 = 0; i2 < childAtoms.size() - 1; ++i2) {
            fusionEdgeBonds.add(childAtoms.get(i2).getBondToAtomOrThrow(childAtoms.get(i2 + 1)));
            fusionEdgeBonds.add(parentAtoms.get(i2).getBondToAtomOrThrow(parentAtoms.get(i2 + 1)));
        }
        LinkedHashSet<Bond> bondsToAddToParentAtoms = new LinkedHashSet<Bond>();
        for (Atom childAtom : childAtoms) {
            for (Bond bond : childAtom.getBonds()) {
                if (fusionEdgeBonds.contains(bond)) continue;
                bondsToAddToParentAtoms.add(bond);
            }
        }
        LinkedHashSet<Bond> bondsToAddToChildAtoms = new LinkedHashSet<Bond>();
        for (Atom atom : parentAtoms) {
            for (Bond b : atom.getBonds()) {
                if (fusionEdgeBonds.contains(b)) continue;
                bondsToAddToChildAtoms.add(b);
            }
        }
        for (Bond bond : bondsToAddToParentAtoms) {
            void var8_23;
            Atom atom = bond.getFromAtom();
            int indiceInChildAtoms = childAtoms.indexOf(atom);
            if (indiceInChildAtoms != -1) {
                Atom atom2 = parentAtoms.get(indiceInChildAtoms);
            }
            if ((indiceInChildAtoms = childAtoms.indexOf(to = bond.getToAtom())) != -1) {
                to = parentAtoms.get(indiceInChildAtoms);
            }
            this.state.fragManager.createBond((Atom)var8_23, to, 1);
        }
        for (Bond bond : bondsToAddToChildAtoms) {
            void var8_27;
            Atom atom = bond.getFromAtom();
            int indiceInParentAtoms = parentAtoms.indexOf(atom);
            if (indiceInParentAtoms != -1) {
                Atom atom3 = childAtoms.get(indiceInParentAtoms);
            }
            if ((indiceInParentAtoms = parentAtoms.indexOf(to = bond.getToAtom())) != -1) {
                to = childAtoms.get(indiceInParentAtoms);
            }
            Bond newBond = new Bond((Atom)var8_27, to, 1);
            if (childAtoms.contains(var8_27)) {
                var8_27.addBond(newBond);
                continue;
            }
            to.addBond(newBond);
        }
    }

    private void benzoSpecificFusion(Element benzoEl, Element parentEl) throws StructureBuildingException {
        Fragment benzoRing = benzoEl.getFrag();
        Fragment parentRing = parentEl.getFrag();
        this.performSimpleFusion(null, benzoRing, parentRing);
        this.state.fragManager.incorporateFragment(benzoRing, parentRing);
        this.removeMergedAtoms();
        FusedRingNumberer.numberFusedRing(parentRing);
        Fragment fusedRing = parentRing;
        this.setBenzoHeteroatomPositioning(benzoEl, fusedRing);
    }

    private void setBenzoHeteroatomPositioning(Element benzoEl, Fragment fusedRing) throws StructureBuildingException {
        String[] locants;
        Element locantEl = OpsinTools.getPreviousSibling(benzoEl);
        if (locantEl != null && locantEl.getName().equals("locant") && this.locantsCouldApplyToHeteroatomPositions(locants = locantEl.getValue().split(","), benzoEl)) {
            List<Atom> atomList = fusedRing.getAtomList();
            ArrayList<Atom> heteroatoms = new ArrayList<Atom>();
            ArrayList<ChemEl> elementOfHeteroAtom = new ArrayList<ChemEl>();
            for (Atom atom : atomList) {
                if (atom.getElement() == ChemEl.C) continue;
                heteroatoms.add(atom);
                elementOfHeteroAtom.add(atom.getElement());
            }
            if (locants.length == heteroatoms.size()) {
                if (locants.length != 1 || OpsinTools.getPreviousSibling(locantEl) != null || !ComponentProcessor.checkLocantPresentOnPotentialRoot(this.state, benzoEl.getParent(), locants[0])) {
                    for (Atom atom : heteroatoms) {
                        atom.setElement(ChemEl.C);
                    }
                    for (int i = 0; i < heteroatoms.size(); ++i) {
                        fusedRing.getAtomByLocantOrThrow(locants[i]).setElement((ChemEl)((Object)elementOfHeteroAtom.get(i)));
                    }
                    locantEl.detach();
                }
            } else if (locants.length > 1) {
                throw new StructureBuildingException("Unable to assign all locants to benzo-fused ring or multiplier was mising");
            }
        }
    }

    private boolean locantsCouldApplyToHeteroatomPositions(String[] locants, Element benzoEl) {
        if (!this.locantsAreAllNumeric(locants)) {
            return false;
        }
        List<Element> suffixes = benzoEl.getParent().getChildElements("suffix");
        int suffixesWithoutLocants = 0;
        for (Element suffix : suffixes) {
            if (suffix.getAttribute("locant") != null) continue;
            ++suffixesWithoutLocants;
        }
        return locants.length != suffixesWithoutLocants;
    }

    private boolean locantsAreAllNumeric(String[] locants) {
        for (String locant : locants) {
            if (OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) continue;
            return false;
        }
        return true;
    }
}

