/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.AtomProperties;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.CyclicAtomList;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.SortAtomsForElementSymbols;
import uk.ac.cam.ch.wwmm.opsin.SortAtomsForMainGroupElementSymbols;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;

class FragmentTools {
    FragmentTools() {
    }

    static void assignElementLocants(Fragment suffixableFragment, List<Fragment> suffixFragments) throws StructureBuildingException {
        HashMap<String, Integer> elementCount = new HashMap<String, Integer>();
        HashSet<Atom> atomsToIgnore = new HashSet<Atom>();
        ArrayList<Fragment> allFragments = new ArrayList<Fragment>(suffixFragments);
        allFragments.add(suffixableFragment);
        for (Fragment fragment : allFragments) {
            List<Atom> atomList = fragment.getAtomList();
            for (Atom atom : atomList) {
                List<String> elementSymbolLocants = atom.getElementSymbolLocants();
                for (String locant : elementSymbolLocants) {
                    int primeCount = StringTools.countTerminalPrimes(locant);
                    String element = locant.substring(0, locant.length() - primeCount);
                    Integer seenCount = (Integer)elementCount.get(element);
                    if (seenCount == null || seenCount < primeCount + 1) {
                        elementCount.put(element, primeCount + 1);
                    }
                    atomsToIgnore.add(atom);
                }
            }
        }
        Set elementsToIgnore = elementCount.keySet();
        for (Fragment fragment : allFragments) {
            List<Atom> atomList = fragment.getAtomList();
            for (Atom atom : atomList) {
                if (!elementsToIgnore.contains(atom.getElement().toString())) continue;
                atomsToIgnore.add(atom);
            }
        }
        String fragType = suffixableFragment.getType();
        if (fragType.equals("nonCarboxylicAcid") || fragType.equals("chalcogenAcidStem")) {
            if (suffixFragments.size() != 0) {
                throw new StructureBuildingException("No suffix fragments were expected to be present on non carboxylic acid");
            }
            FragmentTools.processNonCarboxylicAcidLabelling(suffixableFragment, elementCount, atomsToIgnore);
        } else {
            if (suffixFragments.size() > 0) {
                FragmentTools.processSuffixLabelling(suffixFragments, elementCount, atomsToIgnore);
                Integer n = (Integer)elementCount.get("N");
                if (n != null && n > 1) {
                    FragmentTools.detectAndCorrectHydrazoneDerivativeViolation(suffixFragments);
                }
            }
            FragmentTools.processMainGroupLabelling(suffixableFragment, elementCount, atomsToIgnore);
        }
    }

    private static void detectAndCorrectHydrazoneDerivativeViolation(List<Fragment> suffixFragments) {
        block0: for (Fragment suffixFrag : suffixFragments) {
            List<Atom> atomList = suffixFrag.getAtomList();
            for (Atom atom : atomList) {
                List<String> locants;
                if (atom.getElement() != ChemEl.N || atom.getIncomingValency() != 3 || (locants = atom.getLocants()).size() != 1 || !OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(locants.get(0)).matches()) continue;
                List<Atom> neighbours = atom.getAtomNeighbours();
                for (Atom neighbour : neighbours) {
                    if (neighbour.getElement() != ChemEl.N || neighbour.getIncomingValency() != 1) continue;
                    String locantToAdd = locants.get(0);
                    atom.clearLocants();
                    neighbour.addLocant(locantToAdd);
                    continue block0;
                }
            }
        }
    }

    private static void processMainGroupLabelling(Fragment suffixableFragment, Map<String, Integer> elementCount, Set<Atom> atomsToIgnore) {
        HashSet<String> elementToIgnore = new HashSet<String>(elementCount.keySet());
        List<Atom> atomList = suffixableFragment.getAtomList();
        Collections.sort(atomList, new SortAtomsForMainGroupElementSymbols());
        Atom atomToAddCLabelTo = null;
        boolean seenMoreThanOneC = false;
        for (Atom atom : atomList) {
            ChemEl chemEl;
            if (atomsToIgnore.contains(atom) || elementToIgnore.contains((chemEl = atom.getElement()).toString())) continue;
            if (chemEl == ChemEl.C) {
                if (seenMoreThanOneC) continue;
                if (atomToAddCLabelTo != null) {
                    atomToAddCLabelTo = null;
                    seenMoreThanOneC = true;
                    continue;
                }
                atomToAddCLabelTo = atom;
                continue;
            }
            FragmentTools.assignLocant(atom, elementCount);
        }
        if (atomToAddCLabelTo != null) {
            atomToAddCLabelTo.addLocant("C");
        }
    }

    private static void processSuffixLabelling(List<Fragment> suffixFragments, Map<String, Integer> elementCount, Set<Atom> atomsToIgnore) {
        ArrayList<Atom> startingAtoms = new ArrayList<Atom>();
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        for (Fragment fragment : suffixFragments) {
            Atom rAtom = fragment.getFirstAtom();
            List<Atom> nextAtoms = FragmentTools.getIntraFragmentNeighboursAndSetVisitedBondOrder(rAtom);
            atomsVisited.addAll(nextAtoms);
            startingAtoms.addAll(nextAtoms);
        }
        Collections.sort(startingAtoms, new SortAtomsForElementSymbols());
        ArrayDeque<Atom> atomsToConsider = new ArrayDeque<Atom>(startingAtoms);
        while (atomsToConsider.size() > 0) {
            FragmentTools.assignLocantsAndExploreNeighbours(elementCount, atomsToIgnore, atomsVisited, atomsToConsider);
        }
    }

    private static void processNonCarboxylicAcidLabelling(Fragment suffixableFragment, Map<String, Integer> elementCount, Set<Atom> atomsToIgnore) {
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        Atom firstAtom = suffixableFragment.getFirstAtom();
        List<Atom> startingAtoms = FragmentTools.getIntraFragmentNeighboursAndSetVisitedBondOrder(firstAtom);
        Collections.sort(startingAtoms, new SortAtomsForElementSymbols());
        atomsVisited.add(firstAtom);
        ArrayDeque<Atom> atomsToConsider = new ArrayDeque<Atom>(startingAtoms);
        while (atomsToConsider.size() > 0) {
            FragmentTools.assignLocantsAndExploreNeighbours(elementCount, atomsToIgnore, atomsVisited, atomsToConsider);
        }
        if (!atomsToIgnore.contains(firstAtom) && firstAtom.determineValency(true) > firstAtom.getIncomingValency()) {
            FragmentTools.assignLocant(firstAtom, elementCount);
        }
    }

    private static void assignLocantsAndExploreNeighbours(Map<String, Integer> elementCount, Set<Atom> atomsToIgnore, Set<Atom> atomsVisited, Deque<Atom> atomsToConsider) {
        Atom atom = atomsToConsider.removeFirst();
        atomsVisited.add(atom);
        if (!atomsToIgnore.contains(atom)) {
            FragmentTools.assignLocant(atom, elementCount);
        }
        List<Atom> atomsToExplore = FragmentTools.getIntraFragmentNeighboursAndSetVisitedBondOrder(atom);
        atomsToExplore.removeAll(atomsVisited);
        Collections.sort(atomsToExplore, new SortAtomsForElementSymbols());
        for (int i = atomsToExplore.size() - 1; i >= 0; --i) {
            atomsToConsider.addFirst(atomsToExplore.get(i));
        }
    }

    private static List<Atom> getIntraFragmentNeighboursAndSetVisitedBondOrder(Atom atom) {
        ArrayList<Atom> atomsToExplore = new ArrayList<Atom>();
        List<Bond> bonds = atom.getBonds();
        for (Bond bond : bonds) {
            Atom neighbour = bond.getOtherAtom(atom);
            if (!neighbour.getFrag().equals(atom.getFrag())) continue;
            atomsToExplore.add(neighbour);
            neighbour.setProperty(Atom.VISITED, bond.getOrder());
        }
        return atomsToExplore;
    }

    private static void assignLocant(Atom atom, Map<String, Integer> elementCount) {
        String element = atom.getElement().toString();
        Integer count = elementCount.get(element);
        if (count == null) {
            atom.addLocant(element);
            elementCount.put(element, 1);
        } else {
            atom.addLocant(element + StringTools.multiplyString("'", count));
            elementCount.put(element, count + 1);
        }
    }

    static Bond unsaturate(Atom fromAtom, int bondOrder, Fragment fragment) throws StructureBuildingException {
        Integer locant;
        Atom toAtom;
        block8: {
            toAtom = null;
            locant = null;
            try {
                String primes = "";
                String locantStr = fromAtom.getFirstLocant();
                int numberOfPrimes = StringTools.countTerminalPrimes(locantStr);
                locant = Integer.parseInt(locantStr.substring(0, locantStr.length() - numberOfPrimes));
                primes = StringTools.multiplyString("'", numberOfPrimes);
                Atom possibleToAtom = fragment.getAtomByLocant(String.valueOf(locant + 1) + primes);
                if (possibleToAtom != null && fromAtom.getBondToAtom(possibleToAtom) != null) {
                    toAtom = possibleToAtom;
                } else if (possibleToAtom == null && fromAtom.getAtomIsInACycle() && (possibleToAtom = fragment.getAtomByLocant("1" + primes)) != null && fromAtom.getBondToAtom(possibleToAtom) != null) {
                    toAtom = possibleToAtom;
                }
            }
            catch (Exception e) {
                List<Atom> atomList = fragment.getAtomList();
                int initialIndice = atomList.indexOf(fromAtom);
                if (initialIndice + 1 >= atomList.size() || fromAtom.getBondToAtom(atomList.get(initialIndice + 1)) == null) break block8;
                toAtom = atomList.get(initialIndice + 1);
            }
        }
        if (toAtom == null) {
            if (locant != null) {
                throw new StructureBuildingException("Could not find bond to unsaturate starting from the atom with locant: " + locant);
            }
            throw new StructureBuildingException("Could not find bond to unsaturate");
        }
        Bond b = fromAtom.getBondToAtomOrThrow(toAtom);
        if (b.getOrder() != 1) {
            throw new StructureBuildingException("Bond indicated to be unsaturated was already unsaturated");
        }
        b.setOrder(bondOrder);
        return b;
    }

    static void unsaturate(Atom fromAtom, String locantTo, int bondOrder, Fragment fragment) throws StructureBuildingException {
        Atom toAtom = fragment.getAtomByLocantOrThrow(locantTo);
        Bond b = fromAtom.getBondToAtomOrThrow(toAtom);
        if (b.getOrder() != 1) {
            throw new StructureBuildingException("Bond indicated to be unsaturated was already unsaturated");
        }
        b.setOrder(bondOrder);
    }

    static void relabelLocantsAsFusedRingSystem(List<Atom> atomList) {
        int locantVal = 0;
        char locantLetter = 'a';
        for (Atom atom : atomList) {
            atom.clearLocants();
        }
        for (Atom atom : atomList) {
            if (atom.getElement() != ChemEl.C || atom.getBondCount() < 3) {
                locantLetter = 'a';
                atom.addLocant(Integer.toString(++locantVal));
                continue;
            }
            atom.addLocant(Integer.toString(locantVal) + locantLetter);
            locantLetter = (char)(locantLetter + '\u0001');
        }
    }

    static void relabelLocants(List<Atom> atomList, String stringToAdd) {
        for (Atom atom : atomList) {
            ArrayList<String> locants = new ArrayList<String>(atom.getLocants());
            atom.clearLocants();
            for (String locant : locants) {
                atom.addLocant(locant + stringToAdd);
            }
        }
    }

    static void relabelNumericLocants(List<Atom> atomList, String stringToAdd) {
        for (Atom atom : atomList) {
            ArrayList<String> locants = new ArrayList<String>(atom.getLocants());
            for (String locant : locants) {
                if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) continue;
                atom.removeLocant(locant);
                atom.addLocant(locant + stringToAdd);
            }
        }
    }

    static void splitOutAtomIntoValency1OutAtoms(OutAtom outAtom) {
        Fragment frag = outAtom.getAtom().getFrag();
        for (int i = 1; i < outAtom.getValency(); ++i) {
            frag.addOutAtom(outAtom.getAtom(), 1, (Boolean)outAtom.isSetExplicitly());
        }
        outAtom.setValency(1);
    }

    static Atom detectSimpleNitrogenTautomer(Atom nitrogen) {
        if (nitrogen.getElement() == ChemEl.N && nitrogen.getAtomIsInACycle()) {
            for (Atom neighbour : nitrogen.getAtomNeighbours()) {
                if (!neighbour.hasSpareValency() || neighbour.getElement() != ChemEl.C || !neighbour.getAtomIsInACycle()) continue;
                List<Atom> distance2Neighbours = neighbour.getAtomNeighbours();
                distance2Neighbours.remove(nitrogen);
                for (Atom distance2Neighbour : distance2Neighbours) {
                    if (!distance2Neighbour.hasSpareValency() || distance2Neighbour.getElement() != ChemEl.N || !distance2Neighbour.getAtomIsInACycle() || distance2Neighbour.getCharge() != 0) continue;
                    return distance2Neighbour;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static void convertSpareValenciesToDoubleBonds(Fragment frag) throws StructureBuildingException {
        void var5_12;
        void var5_10;
        List<Atom> atomCollection = frag.getAtomList();
        for (Atom a : atomCollection) {
            a.ensureSVIsConsistantWithValency(true);
        }
        block1: for (Atom a : atomCollection) {
            if (!a.hasSpareValency()) continue;
            for (Atom atom : frag.getIntraFragmentAtomNeighbours(a)) {
                if (!atom.hasSpareValency()) continue;
                continue block1;
            }
            a.setSpareValency(false);
        }
        Atom atomToReduceValencyAt = null;
        List<Atom> originalIndicatedHydrogen = frag.getIndicatedHydrogen();
        ArrayList<Atom> indicatedHydrogen = new ArrayList<Atom>(originalIndicatedHydrogen.size());
        for (Atom atom : frag.getIndicatedHydrogen()) {
            if (!atom.hasSpareValency() || atom.getCharge() != 0) continue;
            indicatedHydrogen.add(atom);
        }
        if (indicatedHydrogen.size() > 0) {
            if (indicatedHydrogen.size() > 1) {
                for (Atom atom : indicatedHydrogen) {
                    boolean couldBeInvolvedInSimpleNitrogenTautomerism = false;
                    if (atom.getElement() == ChemEl.N && atom.getAtomIsInACycle()) {
                        block5: for (Atom neighbour : atom.getAtomNeighbours()) {
                            if (neighbour.getElement() != ChemEl.C || !neighbour.getAtomIsInACycle()) continue;
                            List<Atom> distance2Neighbours = neighbour.getAtomNeighbours();
                            distance2Neighbours.remove(atom);
                            for (Atom distance2Neighbour : distance2Neighbours) {
                                if (distance2Neighbour.getElement() != ChemEl.N || !distance2Neighbour.getAtomIsInACycle() || originalIndicatedHydrogen.contains(distance2Neighbour)) continue;
                                couldBeInvolvedInSimpleNitrogenTautomerism = true;
                                break block5;
                            }
                        }
                    }
                    if (couldBeInvolvedInSimpleNitrogenTautomerism && FragmentTools.detectSimpleNitrogenTautomer(atom) == null) continue;
                    atom.setSpareValency(false);
                }
            } else {
                atomToReduceValencyAt = (Atom)indicatedHydrogen.get(0);
            }
        }
        boolean bl = false;
        for (Atom a : atomCollection) {
            var5_10 += a.hasSpareValency();
        }
        if ((var5_10 & 1) == 1) {
            void var5_11;
            if (atomToReduceValencyAt == null) {
                atomToReduceValencyAt = FragmentTools.findBestAtomToRemoveSpareValencyFrom(frag, atomCollection);
            }
            atomToReduceValencyAt.setSpareValency(false);
            --var5_11;
        }
        while (var5_12 > 0) {
            boolean bl2;
            boolean bl3 = false;
            boolean foundNonBridgeHeadFlag = false;
            boolean foundBridgeHeadFlag = false;
            block9: for (Atom a : atomCollection) {
                if (!a.hasSpareValency()) continue;
                int count = 0;
                for (Atom aa : frag.getIntraFragmentAtomNeighbours(a)) {
                    if (!aa.hasSpareValency()) continue;
                    ++count;
                }
                if (count != true) continue;
                for (Atom aa : frag.getIntraFragmentAtomNeighbours(a)) {
                    if (!aa.hasSpareValency()) continue;
                    bl2 = true;
                    a.setSpareValency(false);
                    aa.setSpareValency(false);
                    a.getBondToAtomOrThrow(aa).addOrder(1);
                    var5_12 -= 2;
                    continue block9;
                }
            }
            if (bl2) continue;
            for (Atom a : atomCollection) {
                List<Atom> neighbours = frag.getIntraFragmentAtomNeighbours(a);
                if (a.hasSpareValency() && neighbours.size() < 3) {
                    for (Atom aa : neighbours) {
                        if (!aa.hasSpareValency()) continue;
                        foundNonBridgeHeadFlag = true;
                        a.setSpareValency(false);
                        aa.setSpareValency(false);
                        a.getBondToAtomOrThrow(aa).addOrder(1);
                        var5_12 -= 2;
                        break;
                    }
                }
                if (!foundNonBridgeHeadFlag) continue;
                break;
            }
            if (foundNonBridgeHeadFlag) continue;
            for (Atom a : atomCollection) {
                List<Atom> neighbours = frag.getIntraFragmentAtomNeighbours(a);
                if (a.hasSpareValency()) {
                    for (Atom aa : neighbours) {
                        if (!aa.hasSpareValency()) continue;
                        foundBridgeHeadFlag = true;
                        a.setSpareValency(false);
                        aa.setSpareValency(false);
                        a.getBondToAtomOrThrow(aa).addOrder(1);
                        var5_12 -= 2;
                        break;
                    }
                }
                if (!foundBridgeHeadFlag) continue;
                break;
            }
            if (foundBridgeHeadFlag) continue;
            throw new StructureBuildingException("Failed to assign all double bonds! (Check that indicated hydrogens have been appropriately specified)");
        }
    }

    private static Atom findBestAtomToRemoveSpareValencyFrom(Fragment frag, List<Atom> atomCollection) {
        for (Atom a : atomCollection) {
            if (!a.hasSpareValency()) continue;
            int atomsWithSV = 0;
            for (Atom aa : frag.getIntraFragmentAtomNeighbours(a)) {
                if (!aa.hasSpareValency()) continue;
                ++atomsWithSV;
            }
            if (atomsWithSV != true) continue;
            return a;
        }
        block2: for (Atom a : atomCollection) {
            List<Atom> neighbours;
            if (!a.hasSpareValency() || (neighbours = frag.getIntraFragmentAtomNeighbours(a)).size() != 2) continue;
            for (Atom aa : neighbours) {
                if (frag.getIntraFragmentAtomNeighbours(aa).size() >= 3) continue;
                continue block2;
            }
            return a;
        }
        Atom firstAtomWithSpareValency = null;
        Atom firstHeteroAtomWithSpareValency = null;
        for (Atom a : atomCollection) {
            if (!a.hasSpareValency()) continue;
            if (a.getElement() != ChemEl.C) {
                if (a.getCharge() == 0) {
                    return a;
                }
                if (firstHeteroAtomWithSpareValency == null) {
                    firstHeteroAtomWithSpareValency = a;
                }
            }
            if (firstAtomWithSpareValency != null) continue;
            firstAtomWithSpareValency = a;
        }
        if (firstAtomWithSpareValency == null) {
            throw new IllegalArgumentException("OPSIN Bug: No atom had spare valency!");
        }
        return firstHeteroAtomWithSpareValency != null ? firstHeteroAtomWithSpareValency : firstAtomWithSpareValency;
    }

    static Atom getAtomByAminoAcidStyleLocant(Atom backboneAtom, String elementSymbol, String primes) {
        ArrayList<Atom> startingAtoms = new ArrayList<Atom>();
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        List<Atom> neighbours = FragmentTools.getIntraFragmentNeighboursAndSetVisitedBondOrder(backboneAtom);
        block0: for (Atom neighbour : neighbours) {
            atomsVisited.add(neighbour);
            if (!neighbour.getType().equals("suffix")) {
                for (String neighbourLocant : neighbour.getLocants()) {
                    if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(neighbourLocant).matches()) continue;
                    continue block0;
                }
            }
            startingAtoms.add(neighbour);
        }
        Collections.sort(startingAtoms, new SortAtomsForElementSymbols());
        HashMap<String, Integer> elementCount = new HashMap<String, Integer>();
        ArrayDeque<Atom> atomsToConsider = new ArrayDeque<Atom>(startingAtoms);
        boolean hydrazoneSpecialCase = false;
        while (atomsToConsider.size() > 0) {
            int i;
            Atom atom = (Atom)atomsToConsider.removeFirst();
            atomsVisited.add(atom);
            int primesOnPossibleAtom = 0;
            String element = atom.getElement().toString();
            if (elementCount.get(element) == null) {
                elementCount.put(element, 1);
            } else {
                int count;
                primesOnPossibleAtom = count = ((Integer)elementCount.get(element)).intValue();
                elementCount.put(element, count + 1);
            }
            if (hydrazoneSpecialCase) {
                if (element.equals(elementSymbol) && primes.length() == primesOnPossibleAtom - 1) {
                    return atom;
                }
                hydrazoneSpecialCase = false;
            }
            List<Atom> atomNeighbours = FragmentTools.getIntraFragmentNeighboursAndSetVisitedBondOrder(atom);
            atomNeighbours.removeAll(atomsVisited);
            block3: for (i = atomNeighbours.size() - 1; i >= 0; --i) {
                Atom neighbour = atomNeighbours.get(i);
                if (neighbour.getType().equals("suffix")) continue;
                for (String neighbourLocant : neighbour.getLocants()) {
                    if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(neighbourLocant).matches()) continue;
                    atomNeighbours.remove(i);
                    continue block3;
                }
            }
            if (atom.getElement() == ChemEl.N && atom.getIncomingValency() == 3 && atom.getCharge() == 0 && atomNeighbours.size() == 1 && atomNeighbours.get(0).getElement() == ChemEl.N) {
                hydrazoneSpecialCase = true;
            } else if (element.equals(elementSymbol) && primes.length() == primesOnPossibleAtom) {
                return atom;
            }
            Collections.sort(atomNeighbours, new SortAtomsForElementSymbols());
            for (i = atomNeighbours.size() - 1; i >= 0; --i) {
                atomsToConsider.addFirst(atomNeighbours.get(i));
            }
        }
        if (primes.equals("") && backboneAtom.getElement().toString().equals(elementSymbol)) {
            return backboneAtom;
        }
        return null;
    }

    static boolean isCovalent(ChemEl chemEl1, ChemEl chemEl2) {
        Double atom1Electrongegativity = AtomProperties.getPaulingElectronegativity(chemEl1);
        Double atom2Electrongegativity = AtomProperties.getPaulingElectronegativity(chemEl2);
        if (atom1Electrongegativity != null && atom2Electrongegativity != null) {
            double halfSum = (atom1Electrongegativity + atom2Electrongegativity) / 2.0;
            double difference = Math.abs(atom1Electrongegativity - atom2Electrongegativity);
            if (halfSum < 1.6) {
                return false;
            }
            if (difference < 1.76 * halfSum - 3.03) {
                return true;
            }
        }
        return false;
    }

    static boolean isCharacteristicAtom(Atom atom) {
        if (atom.getType().equals("suffix") || atom.getElement().isChalcogen() && !"heteroStem".equals(atom.getFrag().getSubType()) && atom.getIncomingValency() == 1 && atom.getOutValency() == 0 && atom.getCharge() == 0) {
            return true;
        }
        return FragmentTools.isFunctionalAtomOrAldehyde(atom);
    }

    static boolean isFunctionalAtomOrAldehyde(Atom atom) {
        if (Boolean.TRUE.equals(atom.getProperty(Atom.ISALDEHYDE))) {
            return true;
        }
        return FragmentTools.isFunctionalAtom(atom);
    }

    static boolean isFunctionalAtom(Atom atom) {
        ChemEl chemEl = atom.getElement();
        if (chemEl.isChalcogen()) {
            Fragment frag = atom.getFrag();
            int l = frag.getFunctionalAtomCount();
            for (int i = 0; i < l; ++i) {
                if (!atom.equals(frag.getFunctionalAtom(i).getAtom())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean allAtomsInRingAreIdentical(Fragment ring) {
        List<Atom> atomList = ring.getAtomList();
        Atom firstAtom = atomList.get(0);
        ChemEl chemEl = firstAtom.getElement();
        int valency = firstAtom.getIncomingValency();
        boolean spareValency = firstAtom.hasSpareValency();
        for (Atom atom : atomList) {
            if (atom.getElement() != chemEl) {
                return false;
            }
            if (atom.getIncomingValency() != valency) {
                return false;
            }
            if (atom.hasSpareValency() == spareValency) continue;
            return false;
        }
        return true;
    }

    static void removeTerminalAtom(BuildState state, Atom atomToRemove) {
        AtomParity atomParity = atomToRemove.getAtomNeighbours().get(0).getAtomParity();
        if (atomParity != null) {
            Atom[] atomRefs4 = atomParity.getAtomRefs4();
            for (int i = 0; i < atomRefs4.length; ++i) {
                if (atomRefs4[i] != atomToRemove) continue;
                atomRefs4[i] = AtomParity.deoxyHydrogen;
                break;
            }
        }
        state.fragManager.removeAtomAndAssociatedBonds(atomToRemove);
    }

    static void removeTerminalOxygen(BuildState state, Atom atom, int desiredBondOrder) throws StructureBuildingException {
        List<Atom> neighbours = atom.getAtomNeighbours();
        for (Atom neighbour : neighbours) {
            if (neighbour.getElement() != ChemEl.O || neighbour.getBondCount() != 1) continue;
            Bond b = atom.getBondToAtomOrThrow(neighbour);
            if (b.getOrder() == desiredBondOrder && neighbour.getCharge() == 0) {
                FragmentTools.removeTerminalAtom(state, neighbour);
                if (atom.getLambdaConventionValency() != null) {
                    atom.setLambdaConventionValency(atom.getLambdaConventionValency() - desiredBondOrder);
                }
                if (atom.getMinimumValency() != null) {
                    atom.setMinimumValency(atom.getMinimumValency() - desiredBondOrder);
                }
                return;
            }
            if (neighbour.getCharge() != -1 || b.getOrder() != 1 || desiredBondOrder != 2 || atom.getCharge() != 1 || atom.getElement() != ChemEl.N) continue;
            FragmentTools.removeTerminalAtom(state, neighbour);
            atom.neutraliseCharge();
            return;
        }
        if (desiredBondOrder == 2) {
            throw new StructureBuildingException("Double bonded oxygen not found at suffix attachment position. Perhaps a suffix has been used inappropriately");
        }
        if (desiredBondOrder == 1) {
            throw new StructureBuildingException("Hydroxy oxygen not found at suffix attachment position. Perhaps a suffix has been used inappropriately");
        }
        throw new StructureBuildingException("Suitable oxygen not found at suffix attachment position Perhaps a suffix has been used inappropriately");
    }

    static List<Atom> findHydroxyLikeTerminalAtoms(List<Atom> atoms, ChemEl chemEl) {
        ArrayList<Atom> matches = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            if (atom.getElement() != chemEl || atom.getIncomingValency() != 1 || atom.getOutValency() != 0 || atom.getCharge() != 0) continue;
            matches.add(atom);
        }
        return matches;
    }

    static boolean notIn6MemberOrSmallerRing(Bond bond) {
        Atom fromAtom = bond.getFromAtom();
        Atom toAtom = bond.getToAtom();
        if (fromAtom.getAtomIsInACycle() && toAtom.getAtomIsInACycle()) {
            ArrayList<Atom> visitedAtoms = new ArrayList<Atom>();
            ArrayDeque<Atom> atomsToInvestigate = new ArrayDeque<Atom>();
            List<Atom> neighbours = fromAtom.getAtomNeighbours();
            neighbours.remove(toAtom);
            for (Atom neighbour : neighbours) {
                atomsToInvestigate.add(neighbour);
            }
            visitedAtoms.add(fromAtom);
            for (int i = 0; i < 5 && !atomsToInvestigate.isEmpty(); ++i) {
                ArrayDeque<Atom> atomsToInvestigateNext = new ArrayDeque<Atom>();
                while (!atomsToInvestigate.isEmpty()) {
                    Atom currentAtom = (Atom)atomsToInvestigate.removeFirst();
                    if (currentAtom == toAtom) {
                        return false;
                    }
                    visitedAtoms.add(currentAtom);
                    neighbours = currentAtom.getAtomNeighbours();
                    for (Atom neighbour : neighbours) {
                        if (visitedAtoms.contains(neighbour) || !neighbour.getAtomIsInACycle()) continue;
                        atomsToInvestigateNext.add(neighbour);
                    }
                }
                atomsToInvestigate = atomsToInvestigateNext;
            }
        }
        return true;
    }

    static List<Atom> findHydroxyGroups(Fragment frag) throws StructureBuildingException {
        ArrayList<Atom> hydroxyAtoms = new ArrayList<Atom>();
        List<Atom> atoms = frag.getAtomList();
        for (Atom atom : atoms) {
            if (atom.getElement() != ChemEl.O || atom.getIncomingValency() != 1 || atom.getOutValency() != 0 || atom.getCharge() != 0) continue;
            Atom adjacentAtom = atom.getAtomNeighbours().get(0);
            List<Atom> neighbours = adjacentAtom.getAtomNeighbours();
            if (adjacentAtom.getElement() != ChemEl.C) continue;
            neighbours.remove(atom);
            if (neighbours.size() >= 1 && neighbours.get(0).getElement() == ChemEl.O && adjacentAtom.getBondToAtomOrThrow(neighbours.get(0)).getOrder() == 2 || neighbours.size() >= 2 && neighbours.get(1).getElement() == ChemEl.O && adjacentAtom.getBondToAtomOrThrow(neighbours.get(1)).getOrder() == 2) continue;
            hydroxyAtoms.add(atom);
        }
        return hydroxyAtoms;
    }

    static List<Atom> findnAtomsForSubstitution(List<Atom> atomList, Atom preferredAtom, int numberOfSubstitutionsRequired, int bondOrder, boolean takeIntoAccountOutValency, boolean preserveValency) {
        int j;
        int i;
        int j2;
        int timesAtomCanBeSubstituted;
        int usedValency;
        int currentExpectedValency;
        int startingIndex;
        int atomCount = atomList.size();
        int n = startingIndex = preferredAtom != null ? atomList.indexOf(preferredAtom) : 0;
        if (startingIndex < 0) {
            throw new IllegalArgumentException("OPSIN Bug: preferredAtom should be part of the list of atoms to search through");
        }
        CyclicAtomList atoms = new CyclicAtomList(atomList, startingIndex - 1);
        ArrayList<Atom> substitutableAtoms = new ArrayList<Atom>();
        if (atomCount == 1 && "elementaryAtom".equals(atomList.get(0).getFrag().getType())) {
            Atom atom = atomList.get(0);
            int timesAtomCanBeSubstituted2 = FragmentTools.getTimesElementaryAtomCanBeSubstituted(atom);
            for (int j3 = 1; j3 <= timesAtomCanBeSubstituted2; ++j3) {
                substitutableAtoms.add(atom);
            }
        } else {
            for (int i2 = 0; i2 < atomCount; ++i2) {
                Atom atom = atoms.next();
                if (FragmentTools.isCharacteristicAtom(atom) && (numberOfSubstitutionsRequired != 1 || atom != preferredAtom)) continue;
                currentExpectedValency = atom.determineValency(takeIntoAccountOutValency);
                usedValency = atom.getIncomingValency() + (atom.hasSpareValency() ? 1 : 0) + (takeIntoAccountOutValency ? atom.getOutValency() : 0);
                timesAtomCanBeSubstituted = (currentExpectedValency - usedValency) / bondOrder;
                for (j2 = 1; j2 <= timesAtomCanBeSubstituted; ++j2) {
                    substitutableAtoms.add(atom);
                }
            }
        }
        if (substitutableAtoms.size() >= numberOfSubstitutionsRequired) {
            return substitutableAtoms;
        }
        substitutableAtoms.clear();
        for (i = 0; i < atomCount; ++i) {
            Atom atom = atoms.next();
            if (FragmentTools.isFunctionalAtomOrAldehyde(atom) && (numberOfSubstitutionsRequired != 1 || atom != preferredAtom)) continue;
            currentExpectedValency = atom.determineValency(takeIntoAccountOutValency);
            usedValency = atom.getIncomingValency() + (atom.hasSpareValency() ? 1 : 0) + (takeIntoAccountOutValency ? atom.getOutValency() : 0);
            timesAtomCanBeSubstituted = (currentExpectedValency - usedValency) / bondOrder;
            for (j2 = 1; j2 <= timesAtomCanBeSubstituted; ++j2) {
                substitutableAtoms.add(atom);
            }
        }
        if (substitutableAtoms.size() >= numberOfSubstitutionsRequired) {
            return substitutableAtoms;
        }
        if (preserveValency) {
            return null;
        }
        substitutableAtoms.clear();
        for (i = 0; i < atomCount; ++i) {
            Atom atom = atoms.next();
            Integer maximumValency = ValencyChecker.getMaximumValency(atom);
            if (maximumValency != null) {
                usedValency = atom.getIncomingValency() + (atom.hasSpareValency() ? 1 : 0) + (takeIntoAccountOutValency ? atom.getOutValency() : 0);
                timesAtomCanBeSubstituted = (maximumValency - usedValency) / bondOrder;
                for (j2 = 1; j2 <= timesAtomCanBeSubstituted; ++j2) {
                    substitutableAtoms.add(atom);
                }
                continue;
            }
            for (j = 0; j < numberOfSubstitutionsRequired; ++j) {
                substitutableAtoms.add(atom);
            }
        }
        if (substitutableAtoms.size() >= numberOfSubstitutionsRequired) {
            return substitutableAtoms;
        }
        substitutableAtoms.clear();
        for (i = 0; i < atomCount; ++i) {
            Atom atom = atoms.next();
            Integer maximumValency = ValencyChecker.getMaximumValency(atom);
            if (maximumValency != null) {
                usedValency = atom.getIncomingValency() + (takeIntoAccountOutValency ? atom.getOutValency() : 0);
                timesAtomCanBeSubstituted = (maximumValency - usedValency) / bondOrder;
                for (j2 = 1; j2 <= timesAtomCanBeSubstituted; ++j2) {
                    substitutableAtoms.add(atom);
                }
                continue;
            }
            for (j = 0; j < numberOfSubstitutionsRequired; ++j) {
                substitutableAtoms.add(atom);
            }
        }
        if (substitutableAtoms.size() >= numberOfSubstitutionsRequired) {
            return substitutableAtoms;
        }
        return null;
    }

    private static int getTimesElementaryAtomCanBeSubstituted(Atom atom) {
        Integer oxidationNumber = atom.getProperty(Atom.OXIDATION_NUMBER);
        if (oxidationNumber == null) {
            String oxidationStates = atom.getFrag().getTokenEl().getAttributeValue("commonOxidationStatesAndMax");
            if (oxidationStates != null) {
                String[] commonOxidationStates = oxidationStates.split(":")[0].split(",");
                oxidationNumber = Integer.parseInt(commonOxidationStates[commonOxidationStates.length - 1]);
            } else {
                oxidationNumber = 0;
            }
        }
        int usedValency = atom.getIncomingValency();
        return oxidationNumber > usedValency ? oxidationNumber - usedValency : 0;
    }

    static List<Atom> findnAtomsForSubstitution(List<Atom> atomList, Atom preferredAtom, int numberOfSubstitutionsRequired, int bondOrder, boolean takeIntoAccountOutValency) {
        return FragmentTools.findnAtomsForSubstitution(atomList, preferredAtom, numberOfSubstitutionsRequired, bondOrder, takeIntoAccountOutValency, false);
    }

    static List<Atom> findnAtomsForSubstitution(Fragment frag, Atom preferredAtom, int numberOfSubstitutionsRequired, int bondOrder, boolean takeIntoAccountOutValency) {
        return FragmentTools.findnAtomsForSubstitution(frag.getAtomList(), preferredAtom, numberOfSubstitutionsRequired, bondOrder, takeIntoAccountOutValency);
    }

    static List<Atom> findnAtomsForSubstitution(Fragment frag, int numberOfSubstitutionsRequired, int bondOrder) {
        return FragmentTools.findnAtomsForSubstitution(frag.getAtomList(), frag.getDefaultInAtom(), numberOfSubstitutionsRequired, bondOrder, true);
    }

    static List<Atom> findSubstituableAtoms(Fragment frag, int bondOrder) {
        List<Atom> potentialAtoms = FragmentTools.findnAtomsForSubstitution(frag, 1, bondOrder);
        if (potentialAtoms == null) {
            return Collections.emptyList();
        }
        return potentialAtoms;
    }

    static Atom lastNonSuffixCarbonWithSufficientValency(Fragment conjunctiveFragment) {
        List<Atom> atomList = conjunctiveFragment.getAtomList();
        for (int i = atomList.size() - 1; i >= 0; --i) {
            Atom a = atomList.get(i);
            if (a.getType().equals("suffix") || a.getElement() != ChemEl.C || !ValencyChecker.checkValencyAvailableForBond(a, 1)) continue;
            return a;
        }
        return null;
    }

    static class SortByLocants
    implements Comparator<Atom> {
        static final Pattern locantSegmenter = Pattern.compile("(\\d+)([a-z]?)('*)");

        SortByLocants() {
        }

        @Override
        public int compare(Atom atoma, Atom atomb) {
            String locantbLetter;
            int locantbNumber;
            String locantbPrimes;
            if (atoma.getType().equals("suffix") && !atomb.getType().equals("suffix")) {
                return 1;
            }
            if (atomb.getType().equals("suffix") && !atoma.getType().equals("suffix")) {
                return -1;
            }
            String locanta = atoma.getFirstLocant();
            String locantb = atomb.getFirstLocant();
            if (locanta == null || locantb == null) {
                return 0;
            }
            Matcher m1 = locantSegmenter.matcher(locanta);
            Matcher m2 = locantSegmenter.matcher(locantb);
            if (!m1.matches() || !m2.matches()) {
                return 0;
            }
            String locantaPrimes = m1.group(3);
            if (locantaPrimes.compareTo(locantbPrimes = m2.group(3)) >= 1) {
                return 1;
            }
            if (locantbPrimes.compareTo(locantaPrimes) >= 1) {
                return -1;
            }
            int locantaNumber = Integer.parseInt(m1.group(1));
            if (locantaNumber > (locantbNumber = Integer.parseInt(m2.group(1)))) {
                return 1;
            }
            if (locantbNumber > locantaNumber) {
                return -1;
            }
            String locantaLetter = m1.group(2);
            if (locantaLetter.compareTo(locantbLetter = m2.group(2)) >= 1) {
                return 1;
            }
            if (locantbLetter.compareTo(locantaLetter) >= 1) {
                return -1;
            }
            return 0;
        }
    }
}

