/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.CipOrderingException;
import uk.ac.cam.ch.wwmm.opsin.CipSequenceRules;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.IDManager;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.SMILESFragmentBuilder;
import uk.ac.cam.ch.wwmm.opsin.StereoAnalyser;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.TokenEl;

class FragmentManager {
    private final Map<Fragment, Set<Bond>> fragToInterFragmentBond = new LinkedHashMap<Fragment, Set<Bond>>();
    private final Set<Fragment> fragments = this.fragToInterFragmentBond.keySet();
    private final SMILESFragmentBuilder sBuilder;
    private final IDManager idManager;

    FragmentManager(SMILESFragmentBuilder sBuilder, IDManager idManager) {
        if (sBuilder == null || idManager == null) {
            throw new IllegalArgumentException("FragmentManager was parsed a null object in its constructor!");
        }
        this.sBuilder = sBuilder;
        this.idManager = idManager;
    }

    Fragment buildSMILES(String smiles) throws StructureBuildingException {
        return this.buildSMILES(smiles, "", "none");
    }

    Fragment buildSMILES(String smiles, String type, String labelMapping) throws StructureBuildingException {
        Fragment newFrag = this.sBuilder.build(smiles, type, labelMapping);
        this.addFragment(newFrag);
        return newFrag;
    }

    Fragment buildSMILES(String smiles, Element tokenEl, String labelMapping) throws StructureBuildingException {
        Fragment newFrag = this.sBuilder.build(smiles, tokenEl, labelMapping);
        this.addFragment(newFrag);
        return newFrag;
    }

    Fragment getUnifiedFragment() {
        Fragment uniFrag = new Fragment("");
        for (Map.Entry<Fragment, Set<Bond>> entry : this.fragToInterFragmentBond.entrySet()) {
            Fragment f = entry.getKey();
            Set<Bond> interFragmentBonds = entry.getValue();
            for (Atom atom : f) {
                uniFrag.addAtom(atom);
            }
            for (Bond bond : f.getBondSet()) {
                uniFrag.addBond(bond);
            }
            uniFrag.incorporateOutAtoms(f);
            uniFrag.incorporateFunctionalAtoms(f);
            for (Bond interFragmentBond : interFragmentBonds) {
                uniFrag.addBond(interFragmentBond);
            }
        }
        this.addFragment(uniFrag);
        return uniFrag;
    }

    void incorporateFragment(Fragment childFrag, Fragment parentFrag) throws StructureBuildingException {
        for (Atom atom : childFrag) {
            parentFrag.addAtom(atom);
        }
        for (Bond bond : childFrag.getBondSet()) {
            parentFrag.addBond(bond);
        }
        parentFrag.incorporateOutAtoms(childFrag);
        parentFrag.incorporateFunctionalAtoms(childFrag);
        Set<Bond> interFragmentBonds = this.fragToInterFragmentBond.get(childFrag);
        if (interFragmentBonds == null) {
            throw new StructureBuildingException("Fragment not registered with this FragmentManager!");
        }
        for (Bond bond : interFragmentBonds) {
            if (bond.getFromAtom().getFrag() == parentFrag && bond.getToAtom().getFrag() == parentFrag) {
                parentFrag.addBond(bond);
                this.fragToInterFragmentBond.get(parentFrag).remove(bond);
                continue;
            }
            this.addInterFragmentBond(bond);
        }
        this.fragToInterFragmentBond.remove(childFrag);
    }

    void incorporateFragment(Fragment childFrag, Atom fromAtom, Fragment parentFrag, Atom toAtom, int bondOrder) throws StructureBuildingException {
        if (!fromAtom.getFrag().equals(childFrag)) {
            throw new StructureBuildingException("OPSIN Bug: fromAtom was not associated with childFrag!");
        }
        if (!toAtom.getFrag().equals(parentFrag)) {
            throw new StructureBuildingException("OPSIN Bug: toAtom was not associated with parentFrag!");
        }
        this.incorporateFragment(childFrag, parentFrag);
        this.createBond(fromAtom, toAtom, bondOrder);
    }

    void replaceAtomWithSmiles(Atom a, String smiles) throws StructureBuildingException {
        this.replaceAtomWithAtom(a, this.getHeteroatom(smiles), false);
    }

    Atom getHeteroatom(String smiles) throws StructureBuildingException {
        Fragment heteroAtomFrag = this.sBuilder.build(smiles);
        if (heteroAtomFrag.getAtomCount() != 1) {
            throw new StructureBuildingException("Heteroatom smiles described a fragment with multiple SMILES!");
        }
        return heteroAtomFrag.getFirstAtom();
    }

    void replaceAtomWithAtom(Atom a, Atom heteroAtom, boolean assignLocant) throws StructureBuildingException {
        ChemEl chemEl = heteroAtom.getElement();
        int replacementCharge = heteroAtom.getCharge();
        if (replacementCharge != 0) {
            if (a.getCharge() == 0) {
                a.addChargeAndProtons(replacementCharge, heteroAtom.getProtonsExplicitlyAddedOrRemoved());
            } else if (a.getCharge() == replacementCharge) {
                a.setProtonsExplicitlyAddedOrRemoved(heteroAtom.getProtonsExplicitlyAddedOrRemoved());
            } else {
                throw new StructureBuildingException("Charge conflict between replacement term and atom to be replaced");
            }
        }
        a.setElement(chemEl);
        a.removeElementSymbolLocants();
        if (assignLocant) {
            String primes = "";
            while (a.getFrag().getAtomByLocant(chemEl.toString() + primes) != null) {
                primes = primes + "'";
            }
            a.addLocant(chemEl.toString() + primes);
        }
    }

    Atom getAtomByID(int id) {
        for (Fragment f : this.fragments) {
            Atom a = f.getAtomByID(id);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    Atom getAtomByIDOrThrow(int id) throws StructureBuildingException {
        Atom a = this.getAtomByID(id);
        if (a == null) {
            throw new StructureBuildingException("Couldn't get atom by id");
        }
        return a;
    }

    void convertSpareValenciesToDoubleBonds() throws StructureBuildingException {
        for (Fragment f : this.fragments) {
            FragmentTools.convertSpareValenciesToDoubleBonds(f);
        }
    }

    void checkValencies() throws StructureBuildingException {
        for (Fragment f : this.fragments) {
            f.checkValencies();
        }
    }

    Set<Fragment> getFragments() {
        return Collections.unmodifiableSet(this.fragments);
    }

    private void addFragment(Fragment frag) {
        this.fragToInterFragmentBond.put(frag, new LinkedHashSet());
    }

    void removeFragment(Fragment frag) throws StructureBuildingException {
        Set<Bond> interFragmentBondsInvolvingFragmentSet = this.fragToInterFragmentBond.get(frag);
        if (interFragmentBondsInvolvingFragmentSet == null) {
            throw new StructureBuildingException("Fragment not registered with this FragmentManager!");
        }
        ArrayList<Bond> interFragmentBondsInvolvingFragment = new ArrayList<Bond>(interFragmentBondsInvolvingFragmentSet);
        for (Bond bond : interFragmentBondsInvolvingFragment) {
            if (bond.getFromAtom().getFrag() == frag) {
                this.fragToInterFragmentBond.get(bond.getToAtom().getFrag()).remove(bond);
                continue;
            }
            this.fragToInterFragmentBond.get(bond.getFromAtom().getFrag()).remove(bond);
        }
        this.fragToInterFragmentBond.remove(frag);
    }

    int getOverallCharge() {
        int totalCharge = 0;
        for (Fragment frag : this.fragments) {
            totalCharge += frag.getCharge();
        }
        return totalCharge;
    }

    Fragment copyFragment(Fragment originalFragment) throws StructureBuildingException {
        return this.copyAndRelabelFragment(originalFragment, 0);
    }

    Fragment copyAndRelabelFragment(Fragment originalFragment, int primesToAdd) {
        int i;
        TokenEl tokenEl = new TokenEl("");
        tokenEl.addAttribute("type", originalFragment.getType());
        tokenEl.addAttribute("subType", originalFragment.getSubType());
        Fragment newFragment = new Fragment(tokenEl);
        HashMap<Atom, Atom> oldToNewAtomMap = new HashMap<Atom, Atom>();
        List<Atom> atomList = originalFragment.getAtomList();
        for (Atom atom : atomList) {
            int id = this.idManager.getNextID();
            ArrayList<String> newLocants = new ArrayList<String>(atom.getLocants());
            if (primesToAdd != 0) {
                for (int i2 = 0; i2 < newLocants.size(); ++i2) {
                    String currentLocant = newLocants.get(i2);
                    int currentPrimes = StringTools.countTerminalPrimes(currentLocant);
                    String locantSansPrimes = currentLocant.substring(0, currentLocant.length() - currentPrimes);
                    int highestNumberOfPrimesWithThisLocant = currentPrimes;
                    while (originalFragment.getAtomByLocant(locantSansPrimes + StringTools.multiplyString("'", highestNumberOfPrimesWithThisLocant + 1)) != null) {
                        ++highestNumberOfPrimesWithThisLocant;
                    }
                    newLocants.set(i2, locantSansPrimes + StringTools.multiplyString("'", (highestNumberOfPrimesWithThisLocant + 1) * primesToAdd + currentPrimes));
                }
            }
            Atom newAtom = new Atom(id, atom.getElement(), newFragment);
            for (String newLocant : newLocants) {
                newAtom.addLocant(newLocant);
            }
            newAtom.setCharge(atom.getCharge());
            newAtom.setIsotope(atom.getIsotope());
            newAtom.setSpareValency(atom.hasSpareValency());
            newAtom.setProtonsExplicitlyAddedOrRemoved(atom.getProtonsExplicitlyAddedOrRemoved());
            newAtom.setLambdaConventionValency(atom.getLambdaConventionValency());
            newAtom.setAtomIsInACycle(atom.getAtomIsInACycle());
            newAtom.setType(atom.getType());
            newAtom.setMinimumValency(atom.getMinimumValency());
            newAtom.setImplicitHydrogenAllowed(atom.getImplicitHydrogenAllowed());
            newFragment.addAtom(newAtom);
            oldToNewAtomMap.put(atom, newAtom);
        }
        for (Atom atom : atomList) {
            List<Atom> oldPositionVariationAtoms;
            String homologyGroup;
            Integer atomClass;
            Boolean isAnomeric;
            Boolean isAldehyde;
            Integer oxidationNumber;
            Integer smilesHydrogenCount;
            Set<Atom> oldAmbiguousElementAssignmentAtoms;
            if (atom.getAtomParity() != null) {
                Atom[] oldAtomRefs4 = atom.getAtomParity().getAtomRefs4();
                Atom[] newAtomRefs4 = new Atom[4];
                for (int i3 = 0; i3 < oldAtomRefs4.length; ++i3) {
                    Atom oldAtom = oldAtomRefs4[i3];
                    newAtomRefs4[i3] = oldAtom.equals(AtomParity.hydrogen) ? AtomParity.hydrogen : (oldAtom.equals(AtomParity.deoxyHydrogen) ? AtomParity.deoxyHydrogen : (Atom)oldToNewAtomMap.get(oldAtom));
                }
                AtomParity newAtomParity = new AtomParity(newAtomRefs4, atom.getAtomParity().getParity());
                newAtomParity.setStereoGroup(atom.getAtomParity().getStereoGroup());
                ((Atom)oldToNewAtomMap.get(atom)).setAtomParity(newAtomParity);
            }
            if ((oldAmbiguousElementAssignmentAtoms = atom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT)) != null) {
                LinkedHashSet newAtoms = new LinkedHashSet();
                for (Atom oldAtom : oldAmbiguousElementAssignmentAtoms) {
                    newAtoms.add(oldToNewAtomMap.get(oldAtom));
                }
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT, newAtoms);
            }
            if ((smilesHydrogenCount = atom.getProperty(Atom.SMILES_HYDROGEN_COUNT)) != null) {
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.SMILES_HYDROGEN_COUNT, smilesHydrogenCount);
            }
            if ((oxidationNumber = atom.getProperty(Atom.OXIDATION_NUMBER)) != null) {
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.OXIDATION_NUMBER, oxidationNumber);
            }
            if ((isAldehyde = atom.getProperty(Atom.ISALDEHYDE)) != null) {
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.ISALDEHYDE, isAldehyde);
            }
            if ((isAnomeric = atom.getProperty(Atom.ISANOMERIC)) != null) {
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.ISANOMERIC, isAnomeric);
            }
            if ((atomClass = atom.getProperty(Atom.ATOM_CLASS)) != null) {
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.ATOM_CLASS, atomClass);
            }
            if ((homologyGroup = atom.getProperty(Atom.HOMOLOGY_GROUP)) != null) {
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.HOMOLOGY_GROUP, homologyGroup);
            }
            if ((oldPositionVariationAtoms = atom.getProperty(Atom.POSITION_VARIATION_BOND)) == null) continue;
            ArrayList newAtoms = new ArrayList();
            for (Atom oldAtom : oldPositionVariationAtoms) {
                newAtoms.add(oldToNewAtomMap.get(oldAtom));
            }
            ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.POSITION_VARIATION_BOND, newAtoms);
        }
        int l = originalFragment.getOutAtomCount();
        for (i = 0; i < l; ++i) {
            OutAtom outAtom = originalFragment.getOutAtom(i);
            newFragment.addOutAtom((Atom)oldToNewAtomMap.get(outAtom.getAtom()), outAtom.getValency(), (Boolean)outAtom.isSetExplicitly());
            if (outAtom.getLocant() == null) continue;
            newFragment.getOutAtom(newFragment.getOutAtomCount() - 1).setLocant(outAtom.getLocant() + StringTools.multiplyString("'", primesToAdd));
        }
        l = originalFragment.getFunctionalAtomCount();
        for (i = 0; i < l; ++i) {
            FunctionalAtom functionalAtom = originalFragment.getFunctionalAtom(i);
            newFragment.addFunctionalAtom((Atom)oldToNewAtomMap.get(functionalAtom.getAtom()));
        }
        if (originalFragment.getDefaultInAtom() != null) {
            newFragment.setDefaultInAtom((Atom)oldToNewAtomMap.get(originalFragment.getDefaultInAtom()));
        }
        Set<Bond> bondSet = originalFragment.getBondSet();
        for (Bond bond : bondSet) {
            Bond newBond = this.createBond((Atom)oldToNewAtomMap.get(bond.getFromAtom()), (Atom)oldToNewAtomMap.get(bond.getToAtom()), bond.getOrder());
            newBond.setSmilesStereochemistry(bond.getSmilesStereochemistry());
            if (bond.getBondStereo() == null) continue;
            Atom[] oldAtomRefs4 = bond.getBondStereo().getAtomRefs4();
            Atom[] newAtomRefs4 = new Atom[4];
            for (int i4 = 0; i4 < oldAtomRefs4.length; ++i4) {
                newAtomRefs4[i4] = (Atom)oldToNewAtomMap.get(oldAtomRefs4[i4]);
            }
            newBond.setBondStereoElement(newAtomRefs4, bond.getBondStereo().getBondStereoValue());
        }
        List<Atom> indicatedHydrogenAtoms = originalFragment.getIndicatedHydrogen();
        for (Atom atom : indicatedHydrogenAtoms) {
            newFragment.addIndicatedHydrogen((Atom)oldToNewAtomMap.get(atom));
        }
        this.addFragment(newFragment);
        return newFragment;
    }

    Element cloneElement(BuildState state, Element elementToBeCloned) throws StructureBuildingException {
        return this.cloneElement(state, elementToBeCloned, 0);
    }

    Element cloneElement(BuildState state, Element elementToBeCloned, int primesToAdd) throws StructureBuildingException {
        Element clone = elementToBeCloned.copy();
        List<Element> originalGroups = OpsinTools.getDescendantElementsWithTagName(elementToBeCloned, "group");
        List<Element> clonedGroups = OpsinTools.getDescendantElementsWithTagName(clone, "group");
        LinkedHashMap<Fragment, Fragment> oldNewFragmentMapping = new LinkedHashMap<Fragment, Fragment>();
        for (int i = 0; i < originalGroups.size(); ++i) {
            Fragment originalFragment = originalGroups.get(i).getFrag();
            Fragment newFragment = this.copyAndRelabelFragment(originalFragment, primesToAdd);
            oldNewFragmentMapping.put(originalFragment, newFragment);
            newFragment.setTokenEl(clonedGroups.get(i));
            clonedGroups.get(i).setFrag(newFragment);
            List<Fragment> originalSuffixes = state.xmlSuffixMap.get(originalGroups.get(i));
            ArrayList<Fragment> newSuffixFragments = new ArrayList<Fragment>();
            Iterator iterator = originalSuffixes.iterator();
            while (iterator.hasNext()) {
                Fragment suffix = (Fragment)iterator.next();
                newSuffixFragments.add(this.copyFragment(suffix));
            }
            state.xmlSuffixMap.put(clonedGroups.get(i), newSuffixFragments);
        }
        LinkedHashSet<Bond> interFragmentBondsToClone = new LinkedHashSet<Bond>();
        for (Fragment originalFragment : ((HashMap)oldNewFragmentMapping).keySet()) {
            for (Bond bond : this.fragToInterFragmentBond.get(originalFragment)) {
                interFragmentBondsToClone.add(bond);
            }
        }
        for (Bond bond : interFragmentBondsToClone) {
            Atom originalFromAtom = bond.getFromAtom();
            Atom originalToAtom = bond.getToAtom();
            Fragment originalFragment1 = originalFromAtom.getFrag();
            Fragment originalFragment2 = originalToAtom.getFrag();
            if (!oldNewFragmentMapping.containsKey(originalFragment1) || !oldNewFragmentMapping.containsKey(originalFragment2)) {
                throw new StructureBuildingException("An element that was a clone contained a bond that went outside the scope of the cloning");
            }
            Fragment newFragment1 = (Fragment)((HashMap)oldNewFragmentMapping).get(originalFragment1);
            Fragment newFragment2 = (Fragment)((HashMap)oldNewFragmentMapping).get(originalFragment2);
            Atom fromAtom = newFragment1.getAtomList().get(originalFragment1.getAtomList().indexOf(originalFromAtom));
            Atom toAtom = newFragment2.getAtomList().get(originalFragment2.getAtomList().indexOf(originalToAtom));
            this.createBond(fromAtom, toAtom, bond.getOrder());
        }
        return clone;
    }

    void replaceAtomWithAnotherAtomPreservingConnectivity(Atom atomToBeReplaced, Atom replacementAtom) {
        atomToBeReplaced.removeElementSymbolLocants();
        ArrayList<String> locants = new ArrayList<String>(atomToBeReplaced.getLocants());
        for (String locant : locants) {
            atomToBeReplaced.removeLocant(locant);
            replacementAtom.addLocant(locant);
        }
        List<Bond> bonds = atomToBeReplaced.getBonds();
        for (Bond bond : bonds) {
            int i;
            Atom[] atomRefs4;
            Atom connectedAtom = bond.getOtherAtom(atomToBeReplaced);
            if (connectedAtom.getAtomParity() != null) {
                atomRefs4 = connectedAtom.getAtomParity().getAtomRefs4();
                for (i = 0; i < 4; ++i) {
                    if (atomRefs4[i] != atomToBeReplaced) continue;
                    atomRefs4[i] = replacementAtom;
                    break;
                }
            }
            if (bond.getBondStereo() != null) {
                atomRefs4 = bond.getBondStereo().getAtomRefs4();
                for (i = 0; i < 4; ++i) {
                    if (atomRefs4[i] != atomToBeReplaced) continue;
                    atomRefs4[i] = replacementAtom;
                    break;
                }
            }
            this.createBond(replacementAtom, bond.getOtherAtom(atomToBeReplaced), bond.getOrder());
        }
        this.removeAtomAndAssociatedBonds(atomToBeReplaced);
    }

    private void removeInterFragmentBondIfPresent(Bond bond) {
        this.fragToInterFragmentBond.get(bond.getFromAtom().getFrag()).remove(bond);
        this.fragToInterFragmentBond.get(bond.getToAtom().getFrag()).remove(bond);
    }

    private void addInterFragmentBond(Bond bond) {
        this.fragToInterFragmentBond.get(bond.getFromAtom().getFrag()).add(bond);
        this.fragToInterFragmentBond.get(bond.getToAtom().getFrag()).add(bond);
    }

    Set<Bond> getInterFragmentBonds(Fragment frag) {
        Set<Bond> interFragmentBonds = this.fragToInterFragmentBond.get(frag);
        if (interFragmentBonds == null) {
            throw new IllegalArgumentException("Fragment not registered with this FragmentManager!");
        }
        return Collections.unmodifiableSet(interFragmentBonds);
    }

    Atom createAtom(ChemEl chemEl, Fragment frag) {
        Atom a = new Atom(this.idManager.getNextID(), chemEl, frag);
        frag.addAtom(a);
        return a;
    }

    Bond createBond(Atom fromAtom, Atom toAtom, int bondOrder) {
        Bond b = new Bond(fromAtom, toAtom, bondOrder);
        fromAtom.addBond(b);
        toAtom.addBond(b);
        if (fromAtom.getFrag() == toAtom.getFrag()) {
            fromAtom.getFrag().addBond(b);
        } else {
            this.addInterFragmentBond(b);
        }
        return b;
    }

    void removeAtomAndAssociatedBonds(Atom atom) {
        ArrayList<Bond> bondsToBeRemoved = new ArrayList<Bond>(atom.getBonds());
        for (Bond bond : bondsToBeRemoved) {
            this.removeBond(bond);
        }
        atom.getFrag().removeAtom(atom);
        Set<Atom> ambiguousElementAssignment = atom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT);
        if (ambiguousElementAssignment != null) {
            ambiguousElementAssignment.remove(atom);
            if (ambiguousElementAssignment.size() == 1) {
                ambiguousElementAssignment.iterator().next().setProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT, null);
            }
        }
    }

    void removeBond(Bond bond) {
        bond.getFromAtom().getFrag().removeBond(bond);
        bond.getFromAtom().removeBond(bond);
        bond.getToAtom().removeBond(bond);
        this.removeInterFragmentBondIfPresent(bond);
    }

    void makeHydrogensExplicit() throws StructureBuildingException {
        for (Fragment fragment : this.fragments) {
            List<Atom> atomList = fragment.getAtomList();
            for (Atom parentAtom : atomList) {
                int explicitHydrogensToAdd = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(parentAtom);
                for (int i = 0; i < explicitHydrogensToAdd; ++i) {
                    Atom hydrogen = this.createAtom(ChemEl.H, fragment);
                    this.createBond(parentAtom, hydrogen, 1);
                }
                if (parentAtom.getAtomParity() == null) continue;
                if (explicitHydrogensToAdd > 1) {
                    parentAtom.setAtomParity(null);
                    continue;
                }
                this.modifyAtomParityToTakeIntoAccountExplicitHydrogen(parentAtom);
            }
        }
    }

    private void modifyAtomParityToTakeIntoAccountExplicitHydrogen(Atom atom) throws StructureBuildingException {
        block17: {
            AtomParity atomParity = atom.getAtomParity();
            if (!StereoAnalyser.isPossiblyStereogenic(atom)) {
                atom.setAtomParity(null);
            } else {
                Atom[] atomRefs4 = atomParity.getAtomRefs4();
                Integer positionOfImplicitHydrogen = null;
                Integer positionOfDeoxyHydrogen = null;
                for (int i = 0; i < atomRefs4.length; ++i) {
                    Atom[] a = atomRefs4[i];
                    if (a.equals(AtomParity.hydrogen)) {
                        positionOfImplicitHydrogen = i;
                        continue;
                    }
                    if (!a.equals(AtomParity.deoxyHydrogen)) continue;
                    positionOfDeoxyHydrogen = i;
                }
                if (positionOfImplicitHydrogen != null || positionOfDeoxyHydrogen != null) {
                    List<Atom> neighbours = atom.getAtomNeighbours();
                    for (Atom atomRef : atomRefs4) {
                        neighbours.remove(atomRef);
                    }
                    if (neighbours.isEmpty()) {
                        throw new StructureBuildingException("OPSIN Bug: Unable to determine which atom has substituted a hydrogen at stereocentre");
                    }
                    if (neighbours.size() == 1 && positionOfDeoxyHydrogen != null) {
                        atomRefs4[positionOfDeoxyHydrogen.intValue()] = neighbours.get(0);
                        if (positionOfImplicitHydrogen != null) {
                            throw new StructureBuildingException("OPSIN Bug: Unable to determine which atom has substituted a hydrogen at stereocentre");
                        }
                    } else if (neighbours.size() == 1 && positionOfImplicitHydrogen != null) {
                        atomRefs4[positionOfImplicitHydrogen.intValue()] = neighbours.get(0);
                    } else if (neighbours.size() == 2 && positionOfDeoxyHydrogen != null && positionOfImplicitHydrogen != null) {
                        try {
                            List<Atom> cipOrderedAtoms = new CipSequenceRules(atom).getNeighbouringAtomsInCipOrder();
                            if (cipOrderedAtoms.indexOf(neighbours.get(0)) > cipOrderedAtoms.indexOf(neighbours.get(1))) {
                                atomRefs4[positionOfDeoxyHydrogen.intValue()] = neighbours.get(0);
                                atomRefs4[positionOfImplicitHydrogen.intValue()] = neighbours.get(1);
                                break block17;
                            }
                            atomRefs4[positionOfDeoxyHydrogen.intValue()] = neighbours.get(1);
                            atomRefs4[positionOfImplicitHydrogen.intValue()] = neighbours.get(0);
                        }
                        catch (CipOrderingException e) {
                            atomRefs4[positionOfDeoxyHydrogen.intValue()] = neighbours.get(0);
                            atomRefs4[positionOfImplicitHydrogen.intValue()] = neighbours.get(1);
                        }
                    } else {
                        throw new StructureBuildingException("OPSIN Bug: Unable to determine which atom has substituted a hydrogen at stereocentre");
                    }
                }
            }
        }
    }
}

