/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;

abstract class Element {
    protected String name;
    protected Element parent = null;
    protected final List<Attribute> attributes = new ArrayList<Attribute>();

    Element(String name) {
        this.name = name;
    }

    void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    void addAttribute(String atrName, String atrValue) {
        this.attributes.add(new Attribute(atrName, atrValue));
    }

    abstract void addChild(Element var1);

    abstract Element copy();

    void detach() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    Attribute getAttribute(int index) {
        return this.attributes.get(index);
    }

    Attribute getAttribute(String name) {
        int len = this.attributes.size();
        for (int i = 0; i < len; ++i) {
            Attribute a = this.attributes.get(i);
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    int getAttributeCount() {
        return this.attributes.size();
    }

    String getAttributeValue(String name) {
        Attribute attribute = this.getAttribute(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    abstract Element getChild(int var1);

    abstract int getChildCount();

    abstract List<Element> getChildElements();

    abstract List<Element> getChildElements(String var1);

    abstract Element getFirstChildElement(String var1);

    Fragment getFrag() {
        throw new UnsupportedOperationException("Only tokens can have associated fragments");
    }

    String getName() {
        return this.name;
    }

    Element getParent() {
        return this.parent;
    }

    abstract String getValue();

    abstract int indexOf(Element var1);

    abstract void insertChild(Element var1, int var2);

    boolean removeAttribute(Attribute attribute) {
        return this.attributes.remove(attribute);
    }

    abstract boolean removeChild(Element var1);

    abstract Element removeChild(int var1);

    abstract void replaceChild(Element var1, Element var2);

    void setFrag(Fragment frag) {
        throw new UnsupportedOperationException("Only tokens can have associated fragments");
    }

    void setName(String name) {
        this.name = name;
    }

    void setParent(Element newParentEl) {
        this.parent = newParentEl;
    }

    abstract void setValue(String var1);

    public String toString() {
        return this.toXML();
    }

    String toXML() {
        return this.toXML(0).toString();
    }

    private StringBuilder toXML(int indent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            result.append("  ");
        }
        result.append('<');
        result.append(this.name);
        for (Attribute atr : this.attributes) {
            result.append(' ');
            result.append(atr.toXML());
        }
        result.append('>');
        if (this.getChildCount() > 0) {
            for (Element child : this.getChildElements()) {
                result.append(OpsinTools.NEWLINE);
                result.append((CharSequence)child.toXML(indent + 1));
            }
            result.append(OpsinTools.NEWLINE);
            for (int i = 0; i < indent; ++i) {
                result.append("  ");
            }
        } else {
            result.append(OpsinTools.xmlEncode(this.getValue()));
        }
        result.append("</");
        result.append(this.name);
        result.append('>');
        return result;
    }
}

