/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.Atom;

class CyclicAtomList {
    private int index = -1;
    private final List<Atom> atomList;

    CyclicAtomList(List<Atom> atomList) {
        this.atomList = atomList;
    }

    CyclicAtomList(List<Atom> atomList, int index) {
        this.atomList = atomList;
        this.setIndex(index);
    }

    int size() {
        return this.atomList.size();
    }

    Atom get(int index) throws IndexOutOfBoundsException {
        return this.atomList.get(index);
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        if (index >= this.atomList.size()) {
            throw new IllegalArgumentException("Specified index is not within ringAtom list");
        }
        this.index = index;
    }

    Atom next() {
        int tempIndex = this.index + 1;
        if (tempIndex >= this.atomList.size()) {
            tempIndex = 0;
        }
        this.index = tempIndex;
        return this.atomList.get(this.index);
    }

    Atom previous() {
        int tempIndex = this.index - 1;
        if (tempIndex < 0) {
            tempIndex = this.atomList.size() - 1;
        }
        this.index = tempIndex;
        return this.atomList.get(this.index);
    }

    Atom peekNext() {
        int tempIndex = this.index + 1;
        if (tempIndex >= this.atomList.size()) {
            tempIndex = 0;
        }
        return this.atomList.get(tempIndex);
    }

    Atom peekPrevious() {
        int tempIndex = this.index - 1;
        if (tempIndex < 0) {
            tempIndex = this.atomList.size() - 1;
        }
        return this.atomList.get(tempIndex);
    }

    Atom getCurrent() {
        return this.atomList.get(this.index);
    }
}

